/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.xml;

import com.sos.commons.util.SOSString;
import com.sos.commons.xml.SOSXML;
import com.sos.commons.xml.exception.SOSXMLDoctypeException;
import com.sos.commons.xml.exception.SOSXMLException;
import com.sos.commons.xml.exception.SOSXMLXSDValidatorException;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SOSXMLXSDValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSXMLXSDValidator.class);

    public static void validate(URL schema, String xml) throws Exception {
        if (schema == null) {
            throw new SOSXMLException("missing schema");
        }
        SOSXMLXSDValidator.validate(new StreamSource(schema.toExternalForm()), xml);
    }

    public static void validate(Path schema, String xml) throws Exception {
        if (schema == null) {
            throw new SOSXMLException("missing schema");
        }
        if (!Files.exists(schema, new LinkOption[0]) || !Files.isReadable(schema)) {
            throw new Exception(String.format("[%s]schema not found or not readable", schema.toString()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[schema][path]%s", schema));
        }
        SOSXMLXSDValidator.validate(new StreamSource(schema.toFile()), xml);
    }

    public static void validate(Source schema, String xml) throws SOSXMLException, SOSXMLXSDValidatorException {
        if (schema == null) {
            throw new SOSXMLException("missing schema");
        }
        if (SOSString.isEmpty((String)xml)) {
            SAXParseException cause = new SAXParseException("Missing XML content", "publicId", "systemId", 1, 1);
            throw new SOSXMLXSDValidatorException(cause, "XML", "1", 1, true);
        }
        try {
            SOSXML.parse(xml);
        }
        catch (SOSXMLDoctypeException e) {
            throw e;
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setSchema(schemaFactory.newSchema(schema));
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)new SOSXMLXSDValidator().new Handler());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new SOSXMLException(e);
        }
    }

    private class Handler
    extends DefaultHandler {
        private final String PATH_DELIMITER = "-";
        private final String REF_DELIMITER = ";";
        private final boolean isDebugEnabled;
        private final boolean isTraceEnabled;
        private int currentDepth;
        private int lastDepth;
        private String rootElement;
        private Stack<String> currentElement = new Stack();
        private String currentElementValue;
        private SAXParseException error;
        private Map<Integer, Integer> currentDepths = new LinkedHashMap<Integer, Integer>();
        private Map<String, String> refElements = new HashMap<String, String>();

        protected Handler() {
            this.isDebugEnabled = LOGGER.isDebugEnabled();
            this.isTraceEnabled = LOGGER.isTraceEnabled();
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes attr) {
            String ref;
            this.currentElement.push(qname);
            this.currentElementValue = null;
            ++this.currentDepth;
            if (this.currentDepth < this.lastDepth) {
                List toReset = this.currentDepths.keySet().stream().filter(x -> x > this.currentDepth).collect(Collectors.toList());
                for (Integer depthKey : toReset) {
                    this.currentDepths.remove(depthKey);
                }
            } else if (this.currentDepth == 1) {
                this.rootElement = qname;
            }
            if (this.currentDepths.containsKey(this.currentDepth)) {
                this.currentDepths.put(this.currentDepth, this.currentDepths.get(this.currentDepth) + 1);
            } else {
                this.currentDepths.put(this.currentDepth, 1);
            }
            this.lastDepth = this.currentDepth;
            if (this.isDebugEnabled) {
                LOGGER.debug(String.format("[startElement][depth=%s][%s][localName=%s][uri=%s]", this.currentDepth, this.currentElement, localName, uri));
            }
            if (qname.endsWith("Ref") && attr != null && (ref = attr.getValue("ref")) != null) {
                this.refElements.put(ref, qname + ";" + this.getCurrentElementPosition());
            }
            this.handleError();
        }

        @Override
        public void endElement(String uri, String localName, String qname) {
            this.handleError();
            if (this.isTraceEnabled) {
                LOGGER.trace(String.format("[endElement][depth=%s][%s][localName=%s][uri=%s]", this.currentDepth, this.currentElement, localName, uri));
            }
            this.currentElement.pop();
            --this.currentDepth;
        }

        @Override
        public void endDocument() throws SAXException {
            this.handleError();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String val;
            if (this.currentElementValue == null && (val = new String(ch, start, length).trim()).length() > 0) {
                this.currentElementValue = val;
            }
        }

        @Override
        public void warning(SAXParseException e) {
            LOGGER.warn(e.toString(), (Throwable)e);
        }

        @Override
        public void error(SAXParseException e) throws SAXParseException {
            if (this.error == null) {
                this.error = e;
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SOSXMLXSDValidatorException {
            this.error = e;
            this.handleError();
        }

        private void handleError() throws SOSXMLXSDValidatorException {
            if (this.error != null) {
                boolean fatal = false;
                if (this.error.getMessage() != null) {
                    String msg = this.error.getMessage().trim();
                    if (this.isDebugEnabled) {
                        LOGGER.debug(String.format("[handleError]%s", msg));
                    }
                    if (msg.startsWith("cvc-identity-constraint")) {
                        String key;
                        List l;
                        if (msg.toLowerCase().contains("not found for identity") && (l = Arrays.asList(msg.split(" ")).stream().filter(x -> x.startsWith("'")).collect(Collectors.toList())).size() == 3 && this.refElements.containsKey(key = ((String)l.get(1)).replaceAll("'", ""))) {
                            String[] arr = this.refElements.get(key).split(";");
                            String position = arr[1];
                            throw new SOSXMLXSDValidatorException(this.error, arr[0], position, position.split("-").length, false);
                        }
                    } else if (msg.startsWith("cvc-enumeration-valid") && this.currentElementValue != null) {
                        try {
                            int pos1 = msg.indexOf("'[");
                            int pos2 = msg.indexOf("]'");
                            List enumeration = Arrays.asList(msg.substring(pos1 + 2, pos2).split(",")).stream().map(x -> x.trim()).collect(Collectors.toList());
                            if (enumeration.contains(this.currentElementValue)) {
                                if (this.isDebugEnabled) {
                                    LOGGER.debug(String.format("[handleError][value=%s]error ignored", this.currentElementValue));
                                }
                                this.error = null;
                                return;
                            }
                        }
                        catch (Throwable ex) {
                            LOGGER.warn(String.format("[exception on enum handling][%s]%s", msg, ex.toString()), ex);
                        }
                    } else if (msg.startsWith("cvc-elt.1") || msg.startsWith("cvc-complex-type.2.4.a")) {
                        fatal = true;
                    }
                }
                String elementName = null;
                String position = null;
                int depth = 1;
                try {
                    elementName = this.currentElement.peek();
                    position = this.getCurrentElementPosition();
                    depth = this.currentDepth;
                }
                catch (Throwable e) {
                    elementName = this.rootElement == null ? "XML" : this.rootElement;
                    position = "1";
                }
                throw new SOSXMLXSDValidatorException(this.error, elementName, position, depth, fatal);
            }
        }

        private String getCurrentElementPosition() {
            return this.currentDepths.entrySet().stream().filter(x -> (Integer)x.getKey() <= this.currentDepth).map(x -> ((Integer)x.getValue()).toString()).collect(Collectors.joining("-"));
        }
    }
}

