/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.agentbatchinstaller.model;

import com.sos.jitl.agentbatchinstaller.model.JSUniversalAgentinstallation;
import com.sos.jitl.agentbatchinstaller.model.installations.Installation;
import com.sos.jitl.agentbatchinstaller.model.installations.Installations;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JSUniversalAgentInstallations {
    private ArrayList<Installation> listOfInstallations;
    private File installationsDefinitionFile;
    private Iterator<Installation> jsInstallationsIterator;
    private Installations installations;

    public JSUniversalAgentInstallations(File installationsDefinitionFile_) throws Exception {
        this.installationsDefinitionFile = installationsDefinitionFile_;
        this.readInstallationDefinitionFile();
    }

    public void reset() {
        this.jsInstallationsIterator = this.listOfInstallations.iterator();
    }

    public JSUniversalAgentinstallation next() {
        Installation i = this.jsInstallationsIterator.next();
        JSUniversalAgentinstallation j = new JSUniversalAgentinstallation();
        j.globals = this.installations.getGlobals();
        j.setValues(i);
        return j;
    }

    public Installations getInstallations() {
        return this.installations;
    }

    public Installation nextInstallation() {
        Installation i = this.jsInstallationsIterator.next();
        return i;
    }

    public boolean eof() {
        return !this.jsInstallationsIterator.hasNext();
    }

    public void readInstallationDefinitionFile() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Installations.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        this.installations = (Installations)unmarshaller.unmarshal(this.installationsDefinitionFile);
        this.listOfInstallations = (ArrayList)this.installations.getInstallation();
        this.reset();
    }

    public void writeFile(File output) throws JAXBException, ParseException, FileNotFoundException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Installations.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)this.installations, (OutputStream)new FileOutputStream(output));
    }
}

