/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.agentbatchinstaller.model;

import com.sos.jitl.agentbatchinstaller.model.JSUniversalAgentBatchInstallerExecuter;
import com.sos.jitl.agentbatchinstaller.model.installations.AgentOptions;
import com.sos.jitl.agentbatchinstaller.model.installations.Globals;
import com.sos.jitl.agentbatchinstaller.model.installations.Installation;
import com.sos.jitl.agentbatchinstaller.model.installations.Source;
import com.sos.jitl.agentbatchinstaller.model.installations.Ssh;
import com.sos.jitl.agentbatchinstaller.model.installations.Target;
import com.sos.jitl.agentbatchinstaller.model.installations.Transfer;
import java.io.File;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JSUniversalAgentinstallation
extends Installation {
    private static final String JOBSCHEDULER_UNIVERSAL_AGENT_INSTALL_SH = "jobscheduler_universal_agent_install.sh";
    protected Globals globals;
    private static final Logger LOGGER = LoggerFactory.getLogger(JSUniversalAgentBatchInstallerExecuter.class);
    private static final int SCHEDULER_AGENT_DEFAULT_PORT = 4445;
    private HashMap<String, String> listOfEntriesWithParameter;
    private File installationFile = null;

    JSUniversalAgentinstallation() {
    }

    private String getValue(String installationValue, String globalValue) {
        if (globalValue == null) {
            globalValue = "";
        }
        if (installationValue == null) {
            installationValue = "";
        }
        if (!installationValue.isEmpty() || "".equals(globalValue)) {
            return installationValue;
        }
        return globalValue;
    }

    private Integer getValue(Integer installationValue, Integer globalValue) {
        if (installationValue != null || globalValue == null) {
            return installationValue;
        }
        return globalValue;
    }

    public File getInstallationFile(File configurationPath) {
        if (this.installationFile == null) {
            this.installationFile = new File(configurationPath, this.getSsh().getHost() + "_" + this.getAgentOptions().getSchedulerHttpPort() + ".xml");
        }
        return this.installationFile;
    }

    private String replace(String parameterValue, String parameterName, String newValue) {
        String s = parameterValue.replaceAll("\\$\\{" + parameterName + "\\}", newValue);
        if (parameterName.contains("password")) {
            String sp = parameterValue.replaceAll("\\$\\{" + parameterName + "\\}", "********");
            this.listOfEntriesWithParameter.put(s, sp);
        }
        return s;
    }

    private String replaceAll(String value) {
        if (value == null) {
            return value;
        }
        value = this.replace(value, "install_path", this.getInstallPath());
        value = this.replace(value, "installation_file", this.getInstallationFile());
        value = this.replace(value, "agent_options.java_home", this.getAgentOptions().getJavaHome());
        value = this.replace(value, "agent_options.java_options", this.getAgentOptions().getJavaOptions());
        value = this.replace(value, "agent_options.scheduler_ip_address", this.getAgentOptions().getJavaHome());
        value = this.replace(value, "agent_options.scheduler_http_port", String.valueOf(this.getAgentOptions().getSchedulerHttpPort()));
        value = this.replace(value, "agent_options.scheduler_user", this.getAgentOptions().getSchedulerUser());
        value = this.replace(value, "agent_options.scheduler_log_dir", this.getAgentOptions().getSchedulerLogDir());
        value = this.replace(value, "agent_options.scheduler_kill_script", this.getAgentOptions().getSchedulerKillScript());
        value = this.replace(value, "agent_options.scheduler_pid_file_dir", this.getAgentOptions().getSchedulerPidFileDir());
        value = this.replace(value, "transfer.settings", this.getTransfer().getSettings());
        value = this.replace(value, "transfer.profile", this.getTransfer().getProfile());
        value = this.replace(value, "transfer.source.host", this.getTransfer().getSource().getHost());
        value = this.replace(value, "transfer.source.port", this.getTransfer().getSource().getPort());
        value = this.replace(value, "transfer.source.protocol", this.getTransfer().getSource().getProtocol());
        value = this.replace(value, "transfer.source.user", this.getTransfer().getSource().getUser());
        value = this.replace(value, "transfer.source.ssh_auth_method", this.getTransfer().getSource().getSshAuthMethod());
        value = this.replace(value, "transfer.source.ssh_auth_file", this.getTransfer().getSource().getSshAuthFile());
        value = this.replace(value, "transfer.source.password", this.getTransfer().getSource().getPassword());
        value = this.replace(value, "transfer.target.host", this.getTransfer().getTarget().getHost());
        value = this.replace(value, "transfer.target.port", this.getTransfer().getTarget().getPort());
        value = this.replace(value, "transfer.target.protocol", this.getTransfer().getTarget().getProtocol());
        value = this.replace(value, "transfer.target.user", this.getTransfer().getTarget().getUser());
        value = this.replace(value, "transfer.target.ssh_auth_method", this.getTransfer().getTarget().getSshAuthMethod());
        value = this.replace(value, "transfer.target.ssh_auth_file", this.getTransfer().getTarget().getSshAuthFile());
        value = this.replace(value, "transfer.target.password", this.getTransfer().getTarget().getPassword());
        value = this.replace(value, "ssh.auth_file", this.getSsh().getAuthFile());
        value = this.replace(value, "ssh.auth_method", this.getSsh().getAuthMethod());
        value = this.replace(value, "ssh.port", String.valueOf(this.getSsh().getPort()));
        value = this.replace(value, "ssh.host", this.getSsh().getHost());
        value = this.replace(value, "ssh.user", this.getSsh().getUser());
        value = this.replace(value, "ssh.password", this.getSsh().getPassword());
        value = this.replace(value, "ssh.sudo_password", this.getSsh().getSudoPassword());
        if (this.installationFile == null) {
            LOGGER.debug("Installationfile is not set. Will not be replaces");
            this.installationFile = new File("");
        } else {
            if (!"".equals(this.installationFile.getName())) {
                value = this.replace(value, "installation_file", this.installationFile.getName());
            }
            value = this.replace(value, "installation_file", this.installationFile.getName());
        }
        return value;
    }

    private void doReplacing() {
        this.setInstallPath(this.replaceAll(this.getInstallPath()));
        this.setInstallationFile(this.replaceAll(this.getInstallationFile()));
        this.getAgentOptions().setJavaHome(this.replaceAll(this.getAgentOptions().getJavaHome()));
        this.getAgentOptions().setJavaOptions(this.replaceAll(this.getAgentOptions().getJavaOptions()));
        this.getAgentOptions().setSchedulerIpAddress(this.replaceAll(this.getAgentOptions().getSchedulerIpAddress()));
        this.getAgentOptions().setSchedulerUser(this.replaceAll(this.getAgentOptions().getSchedulerUser()));
        this.getAgentOptions().setSchedulerLogDir(this.replaceAll(this.getAgentOptions().getSchedulerLogDir()));
        this.getAgentOptions().setSchedulerKillScript(this.replaceAll(this.getAgentOptions().getSchedulerKillScript()));
        this.getAgentOptions().setAgentInstallationScript(this.replaceAll(this.getAgentOptions().getAgentInstallationScript()));
        this.getAgentOptions().setSchedulerPidFileDir(this.replaceAll(this.getAgentOptions().getSchedulerPidFileDir()));
        this.getTransfer().setOperation(this.replaceAll(this.getTransfer().getOperation()));
        this.getTransfer().setFileSpec(this.replaceAll(this.getTransfer().getFileSpec()));
        this.getTransfer().setSettings(this.replaceAll(this.getTransfer().getSettings()));
        this.getTransfer().setProfile(this.replaceAll(this.getTransfer().getProfile()));
        this.getTransfer().getSource().setHost(this.replaceAll(this.getTransfer().getSource().getHost()));
        this.getTransfer().getSource().setPort(this.replaceAll(this.getTransfer().getSource().getPort()));
        this.getTransfer().getSource().setProtocol(this.replaceAll(this.getTransfer().getSource().getProtocol()));
        this.getTransfer().getSource().setUser(this.replaceAll(this.getTransfer().getSource().getUser()));
        this.getTransfer().getSource().setPassword(this.replaceAll(this.getTransfer().getSource().getPassword()));
        this.getTransfer().getSource().setDir(this.replaceAll(this.getTransfer().getSource().getDir()));
        this.getTransfer().getSource().setSshAuthMethod(this.replaceAll(this.getTransfer().getSource().getSshAuthMethod()));
        this.getTransfer().getSource().setSshAuthFile(this.replaceAll(this.getTransfer().getSource().getSshAuthFile()));
        this.getTransfer().getTarget().setHost(this.replaceAll(this.getTransfer().getTarget().getHost()));
        this.getTransfer().getTarget().setPort(this.replaceAll(this.getTransfer().getTarget().getPort()));
        this.getTransfer().getTarget().setProtocol(this.replaceAll(this.getTransfer().getTarget().getProtocol()));
        this.getTransfer().getTarget().setUser(this.replaceAll(this.getTransfer().getTarget().getUser()));
        this.getTransfer().getTarget().setPassword(this.replaceAll(this.getTransfer().getTarget().getPassword()));
        this.getTransfer().getTarget().setDir(this.replaceAll(this.getTransfer().getTarget().getDir()));
        this.getTransfer().getTarget().setSshAuthMethod(this.replaceAll(this.getTransfer().getTarget().getSshAuthMethod()));
        this.getTransfer().getTarget().setSshAuthFile(this.replaceAll(this.getTransfer().getTarget().getSshAuthFile()));
        this.getSsh().setAuthMethod(this.replaceAll(this.getSsh().getAuthMethod()));
        this.getSsh().setAuthFile(this.replaceAll(this.getSsh().getAuthFile()));
        this.getSsh().setSudoPassword(this.replaceAll(this.getSsh().getSudoPassword()));
        this.getSsh().setPassword(this.replaceAll(this.getSsh().getPassword()));
        this.getSsh().setUser(this.replaceAll(this.getSsh().getUser()));
        this.getSsh().setPort(this.replaceAll(this.getSsh().getPort()));
        this.getSsh().setHost(this.replaceAll(this.getSsh().getHost()));
        if (this.getPostprocessing() != null && this.getPostprocessing().getCommand() != null) {
            for (int i = 0; i < this.getPostprocessing().getCommand().size(); ++i) {
                String command = this.getPostprocessing().getCommand().get(i);
                String replacedCommand = this.replaceAll(command);
                this.getPostprocessing().getCommand().set(i, replacedCommand);
            }
        }
    }

    public void setValues(Installation installation) {
        this.listOfEntriesWithParameter = new HashMap();
        this.setInstallPath(this.getValue(installation.getInstallPath(), this.globals.getInstallPath()));
        this.setInstallationFile(this.getValue(installation.getInstallationFile(), this.globals.getInstallationFile()));
        this.setLastRun(installation.getLastRun());
        if (installation.getAgentOptions() == null) {
            installation.setAgentOptions(new AgentOptions());
        }
        if (this.globals.getAgentOptions() != null) {
            installation.getAgentOptions().setJavaHome(this.getValue(installation.getAgentOptions().getJavaHome(), this.globals.getAgentOptions().getJavaHome()));
            installation.getAgentOptions().setJavaOptions(this.getValue(installation.getAgentOptions().getJavaOptions(), this.globals.getAgentOptions().getJavaOptions()));
            installation.getAgentOptions().setSchedulerIpAddress(this.getValue(installation.getAgentOptions().getSchedulerIpAddress(), this.globals.getAgentOptions().getSchedulerIpAddress()));
            installation.getAgentOptions().setSchedulerHttpPort(this.getValue(installation.getAgentOptions().getSchedulerHttpPort(), this.globals.getAgentOptions().getSchedulerHttpPort()));
            installation.getAgentOptions().setSchedulerKillScript(this.getValue(installation.getAgentOptions().getSchedulerKillScript(), this.globals.getAgentOptions().getSchedulerKillScript()));
            installation.getAgentOptions().setSchedulerLogDir(this.getValue(installation.getAgentOptions().getSchedulerLogDir(), this.globals.getAgentOptions().getSchedulerLogDir()));
            installation.getAgentOptions().setSchedulerPidFileDir(this.getValue(installation.getAgentOptions().getSchedulerPidFileDir(), this.globals.getAgentOptions().getSchedulerPidFileDir()));
            installation.getAgentOptions().setSchedulerUser(this.getValue(installation.getAgentOptions().getSchedulerUser(), this.globals.getAgentOptions().getSchedulerUser()));
            installation.getAgentOptions().setAgentInstallationScript(this.getValue(installation.getAgentOptions().getAgentInstallationScript(), this.globals.getAgentOptions().getAgentInstallationScript()));
        }
        this.setAgentOptions(installation.getAgentOptions());
        if (installation.getAgentOptions().getAgentInstallationScript() == null || installation.getAgentOptions().getAgentInstallationScript().isEmpty()) {
            installation.getAgentOptions().setAgentInstallationScript(JOBSCHEDULER_UNIVERSAL_AGENT_INSTALL_SH);
        }
        if (installation.getTransfer() == null) {
            Transfer transfer = new Transfer();
            transfer.setSource(new Source());
            transfer.setTarget(new Target());
            installation.setTransfer(transfer);
        }
        if (installation.getTransfer().getSource() == null) {
            this.transfer.setSource(new Source());
            installation.setTransfer(this.transfer);
        }
        if (installation.getTransfer().getTarget() == null) {
            this.transfer.setTarget(new Target());
            installation.setTransfer(this.transfer);
        }
        installation.getTransfer().setSettings(this.getValue(installation.getTransfer().getSettings(), this.globals.getTransfer().getSettings()));
        installation.getTransfer().setProfile(this.getValue(installation.getTransfer().getProfile(), this.globals.getTransfer().getProfile()));
        if (installation.getTransfer().getTarget() != null && this.globals.getTransfer() != null && this.globals.getTransfer().getTarget() != null) {
            installation.getTransfer().getTarget().setHost(this.getValue(installation.getTransfer().getTarget().getHost(), this.globals.getTransfer().getTarget().getHost()));
            installation.getTransfer().getTarget().setPort(this.getValue(installation.getTransfer().getTarget().getPort(), this.globals.getTransfer().getTarget().getPort()));
            installation.getTransfer().getTarget().setProtocol(this.getValue(installation.getTransfer().getTarget().getProtocol(), this.globals.getTransfer().getTarget().getProtocol()));
            installation.getTransfer().getTarget().setUser(this.getValue(installation.getTransfer().getTarget().getUser(), this.globals.getTransfer().getTarget().getUser()));
            installation.getTransfer().getTarget().setPassword(this.getValue(installation.getTransfer().getTarget().getPassword(), this.globals.getTransfer().getTarget().getPassword()));
            installation.getTransfer().getTarget().setDir(this.getValue(installation.getTransfer().getTarget().getDir(), this.globals.getTransfer().getTarget().getDir()));
            installation.getTransfer().getTarget().setSshAuthMethod(this.getValue(installation.getTransfer().getTarget().getSshAuthMethod(), this.globals.getTransfer().getTarget().getSshAuthMethod()));
            installation.getTransfer().getTarget().setSshAuthFile(this.getValue(installation.getTransfer().getTarget().getSshAuthFile(), this.globals.getTransfer().getTarget().getSshAuthFile()));
        }
        if (installation.getTransfer().getSource() != null && this.globals.getTransfer() != null && this.globals.getTransfer().getSource() != null) {
            installation.getTransfer().getSource().setHost(this.getValue(installation.getTransfer().getSource().getHost(), this.globals.getTransfer().getSource().getHost()));
            installation.getTransfer().getSource().setPort(this.getValue(installation.getTransfer().getSource().getPort(), this.globals.getTransfer().getSource().getPort()));
            installation.getTransfer().getSource().setProtocol(this.getValue(installation.getTransfer().getSource().getProtocol(), this.globals.getTransfer().getSource().getProtocol()));
            installation.getTransfer().getSource().setUser(this.getValue(installation.getTransfer().getSource().getUser(), this.globals.getTransfer().getSource().getUser()));
            installation.getTransfer().getSource().setPassword(this.getValue(installation.getTransfer().getSource().getPassword(), this.globals.getTransfer().getSource().getPassword()));
            installation.getTransfer().getSource().setDir(this.getValue(installation.getTransfer().getSource().getDir(), this.globals.getTransfer().getSource().getDir()));
            installation.getTransfer().getSource().setSshAuthMethod(this.getValue(installation.getTransfer().getSource().getSshAuthMethod(), this.globals.getTransfer().getSource().getSshAuthMethod()));
            installation.getTransfer().getSource().setSshAuthFile(this.getValue(installation.getTransfer().getSource().getSshAuthFile(), this.globals.getTransfer().getSource().getSshAuthFile()));
        }
        this.setTransfer(installation.getTransfer());
        if (installation.getSsh() == null) {
            installation.setSsh(new Ssh());
        }
        if (this.globals.getSsh() != null) {
            installation.getSsh().setAuthMethod(this.getValue(installation.getSsh().getAuthMethod(), this.globals.getSsh().getAuthMethod()));
            installation.getSsh().setPassword(this.getValue(installation.getSsh().getPassword(), this.globals.getSsh().getPassword()));
            installation.getSsh().setSudoPassword(this.getValue(installation.getSsh().getSudoPassword(), this.globals.getSsh().getSudoPassword()));
            installation.getSsh().setPort(this.getValue(installation.getSsh().getPort(), this.globals.getSsh().getPort()));
            installation.getSsh().setHost(this.getValue(installation.getSsh().getHost(), this.globals.getSsh().getHost()));
            installation.getSsh().setUser(this.getValue(installation.getSsh().getUser(), this.globals.getSsh().getUser()));
            installation.getSsh().setAuthMethod(this.getValue(installation.getSsh().getAuthMethod(), this.globals.getSsh().getAuthMethod()));
        }
        this.setSsh(installation.getSsh());
        if (installation.getPostprocessing() == null || installation.getPostprocessing().getCommand() == null || installation.getPostprocessing().getCommand().isEmpty()) {
            installation.setPostprocessing(this.globals.getPostprocessing());
        }
        if (installation.getPostprocessing() == null) {
            LOGGER.debug("no Postprocessing given");
        }
        this.setPostprocessing(installation.getPostprocessing());
        if (installation.getAgentOptions().getSchedulerIpAddress() == null || installation.getAgentOptions().getSchedulerIpAddress().isEmpty()) {
            installation.getAgentOptions().setSchedulerIpAddress(installation.getSsh().getHost());
        }
        if (installation.getAgentOptions().getSchedulerHttpPort() == null) {
            installation.getAgentOptions().setSchedulerHttpPort(4445);
        }
        this.doReplacing();
    }

    public HashMap<String, String> getListOfEntriesWithParameter() {
        return this.listOfEntriesWithParameter;
    }
}

