/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.checkhistory;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.checkhistory.HistoryHelper;
import com.sos.jitl.checkhistory.classes.JobSchedulerHistoryInfoEntry;
import com.sos.jitl.checkhistory.interfaces.IJobSchedulerHistoryInfo;

public class JobSchedulerHistoryInfo
implements IJobSchedulerHistoryInfo {
    private String startTime = "0:00:00:00";
    private String endTime = "0:00:00:00";
    private HistoryHelper jobHistoryHelper = new HistoryHelper();
    public JobSchedulerHistoryInfoEntry lastCompleted;
    public JobSchedulerHistoryInfoEntry running = new JobSchedulerHistoryInfoEntry();
    public JobSchedulerHistoryInfoEntry lastCompletedSuccessful;
    public JobSchedulerHistoryInfoEntry lastCompletedWithError;

    public JobSchedulerHistoryInfo() {
        this.running.name = "running";
        this.lastCompleted = new JobSchedulerHistoryInfoEntry();
        this.lastCompleted.name = "last";
        this.lastCompletedSuccessful = new JobSchedulerHistoryInfoEntry();
        this.lastCompletedSuccessful.name = "lastSuccessful";
        this.lastCompletedWithError = new JobSchedulerHistoryInfoEntry();
        this.lastCompletedWithError.name = "lastWithError";
    }

    private JobSchedulerHistoryInfoEntry getYoungerStartEntry(JobSchedulerHistoryInfoEntry e1, JobSchedulerHistoryInfoEntry e2) {
        if (e1 != null && !e1.found) {
            return e2;
        }
        if (e2 != null && !e2.found) {
            return e1;
        }
        if (e2 == null && e1 == null) {
            return null;
        }
        if (e1 == null && e2 != null) {
            return e2;
        }
        if (e2 == null && e1 != null) {
            return e1;
        }
        if (e1 != null && e2 != null && e1.start != null && e2.start != null && e1.start.isAfter(e2.start)) {
            return e1;
        }
        return e2;
    }

    public JobSchedulerHistoryInfoEntry getLastExecution() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getYoungerStartEntry(this.lastCompleted, this.running);
        return jobHistoryInfoEntry;
    }

    public boolean lastSuccessfulCompletedRunEndedAtTop() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompletedSuccessful();
        return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error == 0 && jobHistoryInfoEntry.top;
    }

    public boolean lastWithErrorCompletedRunEndedAtTop() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompletedWithError();
        return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error != 0 && jobHistoryInfoEntry.top;
    }

    public boolean lastSuccessfulCompletedRunEndedTodayAtTop() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompletedSuccessful();
        return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error == 0 && HistoryHelper.isToday(jobHistoryInfoEntry.end) && jobHistoryInfoEntry.top;
    }

    public boolean lastWithErrorCompletedRunEndedTodayAtTop() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompletedWithError();
        return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error != 0 && HistoryHelper.isToday(jobHistoryInfoEntry.end) && jobHistoryInfoEntry.top;
    }

    public boolean lastCompletedRunEndedSuccessful() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompleted();
        return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error == 0;
    }

    public boolean lastCompletedRunEndedWithError() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompleted();
        return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error != 0;
    }

    public boolean lastCompletedRunEndedTodaySuccessful() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompleted();
        return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error == 0 && HistoryHelper.isToday(jobHistoryInfoEntry.end);
    }

    public boolean lastCompletedRunEndedTodayWithError() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompleted();
        return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error != 0 && HistoryHelper.isToday(jobHistoryInfoEntry.end);
    }

    public boolean isStartedToday() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastExecution();
        return jobHistoryInfoEntry != null && HistoryHelper.isToday(jobHistoryInfoEntry.start);
    }

    public boolean isStartedTodayCompletedSuccessful() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.lastCompletedSuccessful;
        return jobHistoryInfoEntry != null && HistoryHelper.isToday(jobHistoryInfoEntry.start);
    }

    public boolean isStartedTodayCompletedWithError() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.lastCompletedWithError;
        return jobHistoryInfoEntry != null && HistoryHelper.isToday(jobHistoryInfoEntry.start);
    }

    public boolean isStartedTodayCompleted() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.lastCompleted;
        return jobHistoryInfoEntry != null && HistoryHelper.isToday(jobHistoryInfoEntry.start);
    }

    public boolean isCompletedToday() {
        return this.lastCompleted != null && HistoryHelper.isToday(this.lastCompleted.end);
    }

    public boolean isCompletedTodaySuccessful() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.lastCompletedSuccessful;
        return jobHistoryInfoEntry != null && HistoryHelper.isToday(jobHistoryInfoEntry.end);
    }

    public boolean isCompletedTodayWithError() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.lastCompletedWithError;
        return jobHistoryInfoEntry != null && HistoryHelper.isToday(jobHistoryInfoEntry.end);
    }

    public boolean endedWithErrorAfter(String time) {
        return this.jobHistoryHelper.isAfter(this.lastCompletedWithError.end, time);
    }

    public boolean endedSuccessfulAfter(String time) {
        return this.jobHistoryHelper.isAfter(this.lastCompletedSuccessful.end, time);
    }

    public boolean endedAfter(String time) {
        return this.jobHistoryHelper.isAfter(this.lastCompleted.end, time);
    }

    public boolean isCompletedWithErrorAfter(String time) {
        return this.endedWithErrorAfter(time);
    }

    public boolean isCompletedSuccessfulAfter(String time) {
        return this.endedSuccessfulAfter(time);
    }

    public boolean isCompletedAfter(String time) {
        return this.endedAfter(time);
    }

    public boolean isEndedWithErrorAfter(String time) {
        return this.endedWithErrorAfter(time);
    }

    public boolean isEndedSuccessfulAfter(String time) {
        return this.endedSuccessfulAfter(time);
    }

    public boolean isEndedAfter(String time) {
        return this.endedAfter(time);
    }

    public boolean isCompletedWithErrorBefore() {
        return this.lastCompletedWithError.found;
    }

    public boolean isCompletedSuccessfulBefore() {
        return this.lastCompletedSuccessful.found;
    }

    public boolean isCompletedBefore() {
        return this.lastCompleted.found;
    }

    public boolean lastCompleteIsEndedBefore(String time) {
        return this.jobHistoryHelper.isBefore(this.lastCompleted.end, time);
    }

    public boolean lastCompleteSuccessfulIsEndedBefore(String time) {
        return this.jobHistoryHelper.isBefore(this.lastCompletedSuccessful.end, time);
    }

    public boolean lastCompleteWithErrorIsEndedBefore(String time) {
        return this.jobHistoryHelper.isBefore(this.lastCompletedWithError.end, time);
    }

    public boolean lastCompletedIsStartedBefore(String time) {
        return this.jobHistoryHelper.isBefore(this.lastCompleted.start, time);
    }

    public boolean lastCompleteSuccessfulIsStartedBefore(String time) {
        return this.jobHistoryHelper.isBefore(this.lastCompletedSuccessful.start, time);
    }

    public boolean lastCompleteWithErrorIsStartedBefore(String time) {
        return this.jobHistoryHelper.isBefore(this.lastCompletedWithError.start, time);
    }

    public boolean startedWithErrorAfter(String time) {
        return this.jobHistoryHelper.isAfter(this.lastCompletedWithError.start, time);
    }

    public boolean startedSuccessfulAfter(String time) {
        return this.jobHistoryHelper.isAfter(this.lastCompletedSuccessful.start, time);
    }

    public boolean startedAfter(String time) {
        return this.jobHistoryHelper.isAfter(this.getLastExecution().start, time);
    }

    public boolean isStartedWithErrorAfter(String time) {
        return this.startedWithErrorAfter(time);
    }

    public boolean isStartedSuccessfulAfter(String time) {
        return this.startedSuccessfulAfter(time);
    }

    public boolean isStartedAfter(String time) {
        return this.startedAfter(time);
    }

    @Override
    public JobSchedulerHistoryInfoEntry getLastCompleted() {
        return this.lastCompleted;
    }

    @Override
    public JobSchedulerHistoryInfoEntry getRunning() {
        return this.running;
    }

    @Override
    public JobSchedulerHistoryInfoEntry getLastCompletedSuccessful() {
        return this.lastCompletedSuccessful;
    }

    @Override
    public JobSchedulerHistoryInfoEntry getLastCompletedWithError() {
        return this.lastCompletedWithError;
    }

    @Override
    public boolean queryHistory(String query) {
        boolean result = false;
        String methodName = HistoryHelper.getMethodName(query);
        String time = "";
        switch (methodName.toLowerCase()) {
            case "isstartedtoday": {
                result = this.isStartedToday();
                break;
            }
            case "isstartedtodaycompletedsuccessful": {
                result = this.isStartedTodayCompletedSuccessful();
                break;
            }
            case "isstartedtodaycompletedwitherror": {
                result = this.isStartedTodayCompletedWithError();
                break;
            }
            case "isstartedtodaycompleted": {
                result = this.isStartedTodayCompleted();
                break;
            }
            case "iscompletedtoday": {
                result = this.isCompletedToday();
                break;
            }
            case "iscompletedtodaysuccessful": {
                result = this.isCompletedTodaySuccessful();
                break;
            }
            case "iscompletedtodaywitherror": {
                result = this.isCompletedTodayWithError();
                break;
            }
            case "iscompletedafter": {
                time = HistoryHelper.getParameter(this.endTime, query);
                result = this.isCompletedAfter(time);
                break;
            }
            case "iscompletedwitherrorafter": {
                time = HistoryHelper.getParameter(this.endTime, query);
                result = this.isCompletedWithErrorAfter(time);
                break;
            }
            case "iscompletedsuccessfulafter": {
                time = HistoryHelper.getParameter(this.endTime, query);
                result = this.isCompletedSuccessfulAfter(time);
                break;
            }
            case "isstartedafter": {
                time = HistoryHelper.getParameter(this.startTime, query);
                result = this.isStartedAfter(time);
                break;
            }
            case "isstartedwitherrorafter": {
                time = HistoryHelper.getParameter(this.startTime, query);
                result = this.isStartedWithErrorAfter(time);
                break;
            }
            case "isstartedsuccessfulafter": {
                time = HistoryHelper.getParameter(this.startTime, query);
                result = this.isStartedSuccessfulAfter(time);
                break;
            }
            case "lastcompletedisendedbefore": {
                time = HistoryHelper.getParameter(this.endTime, query);
                result = this.lastCompleteIsEndedBefore(time);
                break;
            }
            case "lastcompletedsuccessfulisendedbefore": {
                time = HistoryHelper.getParameter(this.endTime, query);
                result = this.lastCompleteSuccessfulIsEndedBefore(time);
                break;
            }
            case "lastcompletedwitherrorisendedbefore": {
                time = HistoryHelper.getParameter(this.endTime, query);
                result = this.lastCompleteWithErrorIsEndedBefore(time);
                break;
            }
            case "lastcompletedisstartedbefore": {
                time = HistoryHelper.getParameter(this.startTime, query);
                result = this.lastCompletedIsStartedBefore(time);
                break;
            }
            case "lastcompletedsuccessfulisstartedbefore": {
                time = HistoryHelper.getParameter(this.startTime, query);
                result = this.lastCompleteSuccessfulIsStartedBefore(time);
                break;
            }
            case "lastcompletedwitherrorisstartedbefore": {
                time = HistoryHelper.getParameter(this.startTime, query);
                result = this.lastCompleteWithErrorIsStartedBefore(time);
                break;
            }
            case "iscompletedbefore": {
                result = this.isCompletedBefore();
                break;
            }
            case "iscompletedsuccessfulbefore": {
                result = this.isCompletedSuccessfulBefore();
                break;
            }
            case "iscompletedwitherrorbefore": {
                result = this.isCompletedWithErrorBefore();
                break;
            }
            case "lastsuccessfulcompletedrunendedattop": {
                result = this.lastSuccessfulCompletedRunEndedAtTop();
                break;
            }
            case "lastsuccessfulcompletedrunendedtodayattop": {
                result = this.lastSuccessfulCompletedRunEndedTodayAtTop();
                break;
            }
            case "lastwitherrorcompletedrunendedattop": {
                result = this.lastWithErrorCompletedRunEndedAtTop();
                break;
            }
            case "lastwitherrorcompletedrunendedtodayattop": {
                result = this.lastWithErrorCompletedRunEndedTodayAtTop();
                break;
            }
            case "lastcompletedrunendedsuccessful": {
                result = this.lastCompletedRunEndedSuccessful();
                break;
            }
            case "lastcompletedrunendedwitherror": {
                result = this.lastCompletedRunEndedWithError();
                break;
            }
            case "lastcompletedrunendedtodaysuccessful": {
                result = this.lastCompletedRunEndedTodaySuccessful();
                break;
            }
            case "lastcompletedrunendedtodaywitherror": {
                result = this.lastCompletedRunEndedTodayWithError();
                break;
            }
            default: {
                throw new JobSchedulerException("unknown command: " + query);
            }
        }
        return result;
    }

    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }
}

