/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.checkhistory.classes;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.checkhistory.classes.HistoryDataSource;
import com.sos.jitl.checkhistory.classes.HistoryInterval;
import com.sos.jitl.reporting.db.DBItemReportTask;
import com.sos.jitl.reporting.db.DBItemReportTrigger;
import com.sos.jitl.reporting.db.ReportTaskExecutionsDBLayer;
import com.sos.jitl.reporting.db.ReportTriggerDBLayer;
import com.sos.joc.model.common.Err;
import com.sos.joc.model.common.HistoryState;
import com.sos.joc.model.common.HistoryStateText;
import com.sos.joc.model.job.TaskHistoryItem;
import com.sos.joc.model.order.OrderHistoryItem;
import com.sos.scheduler.model.answers.HistoryEntry;
import com.sos.scheduler.model.answers.JobChain;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryDatabaseExecuter
extends HistoryDataSource {
    private SOSHibernateSession sosHibernateSession = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryDatabaseExecuter.class);

    public HistoryDatabaseExecuter(SOSHibernateSession sosHibernateSession) {
        super(null);
        this.sosHibernateSession = sosHibernateSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected HistoryEntry getJobHistoryEntry(String state) throws Exception {
        HistoryEntry historyEntry = null;
        try {
            void var8_10;
            String[] states;
            ArrayList<TaskHistoryItem> listOfHistory = new ArrayList<TaskHistoryItem>();
            ReportTaskExecutionsDBLayer reportTaskExecutionsDBLayer = new ReportTaskExecutionsDBLayer(this.sosHibernateSession);
            this.sosHibernateSession.beginTransaction();
            reportTaskExecutionsDBLayer.getFilter().setLimit(1);
            reportTaskExecutionsDBLayer.getFilter().setOrderCriteria("historyId");
            reportTaskExecutionsDBLayer.getFilter().setSortMode("DESC");
            reportTaskExecutionsDBLayer.getFilter().setSchedulerId(this.schedulerId);
            if (!"".equals(this.timeLimit)) {
                HistoryInterval historyInterval = this.historyHelper.getUTCIntervalFromTimeLimit(this.timeLimit);
                reportTaskExecutionsDBLayer.getFilter().setExecutedFrom(historyInterval.getFrom().toDate());
                reportTaskExecutionsDBLayer.getFilter().setExecutedTo(historyInterval.getTo().toDate());
            }
            String[] stringArray = states = state.split(",");
            int n = stringArray.length;
            boolean bl = false;
            while (var8_10 < n) {
                String s = stringArray[var8_10];
                s = s.replaceAll("'", "");
                reportTaskExecutionsDBLayer.getFilter().addState(s);
                ++var8_10;
            }
            reportTaskExecutionsDBLayer.getFilter().addJobPath(this.jobName);
            List<Object> listOfDBItemReportTaskDBItems = new ArrayList();
            listOfDBItemReportTaskDBItems = reportTaskExecutionsDBLayer.getSchedulerHistoryListFromTo();
            if (listOfDBItemReportTaskDBItems != null) {
                for (DBItemReportTask dBItemReportTask : listOfDBItemReportTaskDBItems) {
                    TaskHistoryItem taskHistoryItem = new TaskHistoryItem();
                    taskHistoryItem.setJobschedulerId(dBItemReportTask.getSchedulerId());
                    taskHistoryItem.setAgent(dBItemReportTask.getAgentUrl());
                    taskHistoryItem.setClusterMember(dBItemReportTask.getClusterMemberId());
                    taskHistoryItem.setEndTime(dBItemReportTask.getEndTime());
                    if (dBItemReportTask.getError()) {
                        Err error = new Err();
                        error.setCode(dBItemReportTask.getErrorCode());
                        error.setMessage(dBItemReportTask.getErrorText());
                        taskHistoryItem.setError(error);
                    }
                    taskHistoryItem.setExitCode(dBItemReportTask.getExitCode());
                    taskHistoryItem.setJob(dBItemReportTask.getName());
                    taskHistoryItem.setStartTime(dBItemReportTask.getStartTime());
                    HistoryState historyState = new HistoryState();
                    if (dBItemReportTask.isSuccessFull()) {
                        historyState.setSeverity(Integer.valueOf(0));
                        historyState.set_text(HistoryStateText.SUCCESSFUL);
                    }
                    if (dBItemReportTask.isInComplete()) {
                        historyState.setSeverity(Integer.valueOf(1));
                        historyState.set_text(HistoryStateText.INCOMPLETE);
                    }
                    if (dBItemReportTask.isFailed()) {
                        historyState.setSeverity(Integer.valueOf(2));
                        historyState.set_text(HistoryStateText.FAILED);
                    }
                    taskHistoryItem.setState(historyState);
                    taskHistoryItem.setSurveyDate(dBItemReportTask.getCreated());
                    taskHistoryItem.setTaskId(dBItemReportTask.getHistoryIdAsString());
                    listOfHistory.add(taskHistoryItem);
                }
            }
            if (listOfHistory.size() > 0) {
                historyEntry = new HistoryEntry();
                historyEntry.setError(BigInteger.valueOf(0L));
                if (((TaskHistoryItem)listOfHistory.get(0)).getError() != null) {
                    historyEntry.setError(BigInteger.valueOf(1L));
                    historyEntry.setErrorCode(((TaskHistoryItem)listOfHistory.get(0)).getError().getCode());
                    historyEntry.setErrorText(((TaskHistoryItem)listOfHistory.get(0)).getError().getMessage());
                }
                historyEntry.setExitCode(BigInteger.valueOf(((TaskHistoryItem)listOfHistory.get(0)).getExitCode().intValue()));
                historyEntry.setTaskId(this.string2BigInteger(((TaskHistoryItem)listOfHistory.get(0)).getTaskId()));
                historyEntry.setId(this.string2BigInteger(((TaskHistoryItem)listOfHistory.get(0)).getTaskId()));
                historyEntry.setJobName(((TaskHistoryItem)listOfHistory.get(0)).getJob());
                if (((TaskHistoryItem)listOfHistory.get(0)).getStartTime() != null) {
                    historyEntry.setStartTime(((TaskHistoryItem)listOfHistory.get(0)).getStartTime().toString());
                }
                if (((TaskHistoryItem)listOfHistory.get(0)).getEndTime() != null) {
                    historyEntry.setEndTime(((TaskHistoryItem)listOfHistory.get(0)).getEndTime().toString());
                }
            }
        }
        finally {
            this.sosHibernateSession.rollback();
        }
        return historyEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobChain.OrderHistory.Order getJobChainHistoryEntry(String state) throws SOSHibernateException {
        String[] states;
        JobChain.OrderHistory.Order order = null;
        ArrayList<OrderHistoryItem> listOfHistory = new ArrayList<OrderHistoryItem>();
        ReportTriggerDBLayer reportTriggerDBLayer = new ReportTriggerDBLayer(this.sosHibernateSession);
        reportTriggerDBLayer.getFilter().setSchedulerId(this.schedulerId);
        reportTriggerDBLayer.getFilter().setLimit(1);
        reportTriggerDBLayer.getFilter().setOrderCriteria("historyId");
        reportTriggerDBLayer.getFilter().setSortMode("DESC");
        for (String s : states = state.split(",")) {
            s = s.replaceAll("'", "");
            reportTriggerDBLayer.getFilter().addState(s);
        }
        reportTriggerDBLayer.getFilter().addOrderPath(this.jobChainName, this.orderId);
        if (!"".equals(this.timeLimit)) {
            HistoryInterval historyInterval = this.historyHelper.getUTCIntervalFromTimeLimit(this.timeLimit);
            reportTriggerDBLayer.getFilter().setExecutedFrom(historyInterval.getFrom().toDate());
            reportTriggerDBLayer.getFilter().setExecutedTo(historyInterval.getTo().toDate());
        }
        try {
            List<DBItemReportTrigger> listOfDBItemReportTrigger = reportTriggerDBLayer.getSchedulerOrderHistoryListFromTo();
            for (DBItemReportTrigger dbItemReportTrigger : listOfDBItemReportTrigger) {
                OrderHistoryItem history = new OrderHistoryItem();
                history.setEndTime(dbItemReportTrigger.getEndTime());
                history.setHistoryId(String.valueOf(dbItemReportTrigger.getHistoryId()));
                history.setJobChain(dbItemReportTrigger.getParentName());
                history.setNode(dbItemReportTrigger.getState());
                history.setOrderId(dbItemReportTrigger.getName());
                history.setPath(dbItemReportTrigger.getFullOrderQualifier());
                history.setStartTime(dbItemReportTrigger.getStartTime());
                HistoryState historyState = new HistoryState();
                if (dbItemReportTrigger.getStartTime() != null && dbItemReportTrigger.getEndTime() == null) {
                    historyState.setSeverity(Integer.valueOf(1));
                    historyState.set_text(HistoryStateText.INCOMPLETE);
                } else if (dbItemReportTrigger.getResultError()) {
                    historyState.setSeverity(Integer.valueOf(2));
                    historyState.set_text(HistoryStateText.FAILED);
                } else if (dbItemReportTrigger.getEndTime() != null && !dbItemReportTrigger.getResultError()) {
                    historyState.setSeverity(Integer.valueOf(0));
                    historyState.set_text(HistoryStateText.SUCCESSFUL);
                }
                history.setState(historyState);
                history.setSurveyDate(dbItemReportTrigger.getCreated());
                listOfHistory.add(history);
            }
            if (listOfHistory.size() > 0) {
                order = new JobChain.OrderHistory.Order();
                order.setId(((OrderHistoryItem)listOfHistory.get(0)).getOrderId());
                order.setState(((OrderHistoryItem)listOfHistory.get(0)).getNode());
                order.setOrder(((OrderHistoryItem)listOfHistory.get(0)).getOrderId());
                order.setHistoryId(this.string2BigInteger(((OrderHistoryItem)listOfHistory.get(0)).getHistoryId()));
                order.setJobChain(((OrderHistoryItem)listOfHistory.get(0)).getJobChain());
                if (((OrderHistoryItem)listOfHistory.get(0)).getStartTime() != null) {
                    order.setStartTime(((OrderHistoryItem)listOfHistory.get(0)).getStartTime().toString());
                }
                if (((OrderHistoryItem)listOfHistory.get(0)).getEndTime() != null) {
                    order.setEndTime(((OrderHistoryItem)listOfHistory.get(0)).getEndTime().toString());
                }
            }
        }
        finally {
            this.sosHibernateSession.rollback();
        }
        return order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderHistoryItem getJobChainOrderHistoryEntry(BigInteger orderHistoryId) throws SOSHibernateException {
        ArrayList<OrderHistoryItem> listOfHistory = new ArrayList<OrderHistoryItem>();
        ReportTriggerDBLayer reportTriggerDBLayer = new ReportTriggerDBLayer(this.sosHibernateSession);
        reportTriggerDBLayer.getFilter().setSchedulerId(this.schedulerId);
        reportTriggerDBLayer.getFilter().setLimit(1);
        reportTriggerDBLayer.getFilter().addOrderHistoryId(orderHistoryId.longValue());
        try {
            OrderHistoryItem orderHistoryItem;
            List<DBItemReportTrigger> listOfDBItemReportTrigger = reportTriggerDBLayer.getSchedulerOrderHistoryListFromTo();
            for (DBItemReportTrigger dbItemReportTrigger : listOfDBItemReportTrigger) {
                OrderHistoryItem history = new OrderHistoryItem();
                history.setEndTime(dbItemReportTrigger.getEndTime());
                history.setHistoryId(String.valueOf(dbItemReportTrigger.getHistoryId()));
                history.setJobChain(dbItemReportTrigger.getParentName());
                history.setNode(dbItemReportTrigger.getState());
                history.setOrderId(dbItemReportTrigger.getName());
                history.setPath(dbItemReportTrigger.getFullOrderQualifier());
                history.setStartTime(dbItemReportTrigger.getStartTime());
                HistoryState historyState = new HistoryState();
                if (dbItemReportTrigger.getStartTime() != null && dbItemReportTrigger.getEndTime() == null) {
                    historyState.setSeverity(Integer.valueOf(1));
                    historyState.set_text(HistoryStateText.INCOMPLETE);
                } else if (dbItemReportTrigger.getResultError()) {
                    historyState.setSeverity(Integer.valueOf(2));
                    historyState.set_text(HistoryStateText.FAILED);
                } else if (dbItemReportTrigger.getEndTime() != null && !dbItemReportTrigger.getResultError()) {
                    historyState.setSeverity(Integer.valueOf(0));
                    historyState.set_text(HistoryStateText.SUCCESSFUL);
                }
                history.setState(historyState);
                history.setSurveyDate(dbItemReportTrigger.getCreated());
                listOfHistory.add(history);
            }
            if (listOfHistory.size() > 0) {
                orderHistoryItem = (OrderHistoryItem)listOfHistory.get(0);
                return orderHistoryItem;
            }
            orderHistoryItem = null;
            return orderHistoryItem;
        }
        finally {
            this.sosHibernateSession.rollback();
        }
    }
}

