/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.checkrunhistory;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.checkrunhistory.IJobSchedulerHistory;
import com.sos.jitl.checkrunhistory.IJobSchedulerHistoryInfo;
import com.sos.jitl.checkrunhistory.JobHistoryHelper;
import com.sos.jitl.checkrunhistory.JobSchedulerHistoryInfo;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.answers.Answer;
import com.sos.scheduler.model.answers.ERROR;
import com.sos.scheduler.model.answers.HistoryEntry;
import com.sos.scheduler.model.commands.JSCmdShowHistory;
import com.sos.scheduler.model.commands.ShowHistory;
import java.io.File;
import java.math.BigInteger;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Spooler;

public class JobHistory
implements IJobSchedulerHistory {
    private static final int NUMBER_OF_RUNS = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(JobHistory.class);
    private String host;
    private int port;
    private Spooler spooler;
    private HistoryEntry lastCompletedHistoryEntry = null;
    private HistoryEntry lastRunningHistoryEntry = null;
    private HistoryEntry lastCompletedSuccessfullHistoryEntry = null;
    private HistoryEntry lastCompletedWithErrorHistoryEntry = null;
    private int lastCompletedHistoryEntryPos;
    private int lastRunningHistoryEntryPos;
    private int lastCompletedSuccessfullHistoryEntryPos;
    private int lastCompletedWithErrorHistoryEntryPos;
    private String timeLimit;
    private int numberOfStarts;
    private int numberOfCompletedSuccessful;
    private int numberOfCompletedWithError;
    private int numberOfCompleted;
    private int count;
    private JobHistoryHelper jobHistoryHelper = new JobHistoryHelper();
    private String relativePath = "";
    private String actHistoryObjectName = "";

    public JobHistory(String host_, int port_) {
        this.host = host_;
        this.port = port_;
        this.timeLimit = "";
    }

    public JobHistory(Spooler spooler_) {
        this.spooler = spooler_;
        this.timeLimit = "";
    }

    public JobSchedulerHistoryInfo getJobInfo(String jobName) throws Exception {
        return (JobSchedulerHistoryInfo)this.getJobSchedulerHistoryInfo(jobName);
    }

    public JobSchedulerHistoryInfo getJobInfo(String jobName, String timeLimit_) throws Exception {
        return (JobSchedulerHistoryInfo)this.getJobSchedulerHistoryInfo(jobName, timeLimit_);
    }

    public JobSchedulerHistoryInfo getJobInfo(String jobName, int limit, String timeLimit_) throws Exception {
        return (JobSchedulerHistoryInfo)this.getJobSchedulerHistoryInfo(jobName, limit, timeLimit_);
    }

    public JobSchedulerHistoryInfo getJobHistoryInfo(String jobName, int numberOfRuns) throws Exception {
        return (JobSchedulerHistoryInfo)this.getJobSchedulerHistoryInfo(jobName, numberOfRuns);
    }

    @Override
    public IJobSchedulerHistoryInfo getJobSchedulerHistoryInfo(String jobName) throws Exception {
        this.lastCompletedHistoryEntry = null;
        this.lastRunningHistoryEntry = null;
        this.lastCompletedSuccessfullHistoryEntry = null;
        this.lastCompletedWithErrorHistoryEntry = null;
        return this.getJobSchedulerHistoryInfo(jobName, 100);
    }

    public IJobSchedulerHistoryInfo getJobSchedulerHistoryInfo(String jobName, String timeLimit_) throws Exception {
        this.lastCompletedHistoryEntry = null;
        this.lastRunningHistoryEntry = null;
        this.lastCompletedSuccessfullHistoryEntry = null;
        this.lastCompletedWithErrorHistoryEntry = null;
        this.timeLimit = timeLimit_;
        return this.getJobSchedulerHistoryInfo(jobName, 100);
    }

    public IJobSchedulerHistoryInfo getJobSchedulerHistoryInfo(String jobName, int limit, String timeLimit_) throws Exception {
        this.lastCompletedHistoryEntry = null;
        this.lastRunningHistoryEntry = null;
        this.lastCompletedSuccessfullHistoryEntry = null;
        this.lastCompletedWithErrorHistoryEntry = null;
        this.timeLimit = timeLimit_;
        return this.getJobSchedulerHistoryInfo(jobName, limit);
    }

    public IJobSchedulerHistoryInfo getJobSchedulerHistoryInfo(String jobName, int numberOfRuns) throws Exception {
        this.getHistory(jobName, numberOfRuns);
        JobSchedulerHistoryInfo jobHistoryInfo = new JobSchedulerHistoryInfo();
        if (this.lastCompletedHistoryEntry != null) {
            jobHistoryInfo.lastCompleted.found = true;
            jobHistoryInfo.lastCompleted.position = this.lastCompletedHistoryEntryPos;
            jobHistoryInfo.lastCompleted.errorMessage = this.lastCompletedHistoryEntry.getErrorText();
            jobHistoryInfo.lastCompleted.executionResult = this.jobHistoryHelper.big2int(this.lastCompletedHistoryEntry.getExitCode());
            jobHistoryInfo.lastCompleted.start = this.jobHistoryHelper.getDateFromString(this.lastCompletedHistoryEntry.getStartTime());
            jobHistoryInfo.lastCompleted.end = this.jobHistoryHelper.getDateFromString(this.lastCompletedHistoryEntry.getEndTime());
            jobHistoryInfo.lastCompleted.error = this.jobHistoryHelper.big2int(this.lastCompletedHistoryEntry.getError());
            jobHistoryInfo.lastCompleted.errorCode = this.lastCompletedHistoryEntry.getErrorCode();
            jobHistoryInfo.lastCompleted.id = this.jobHistoryHelper.big2int(this.lastCompletedHistoryEntry.getId());
            jobHistoryInfo.lastCompleted.jobName = this.lastCompletedHistoryEntry.getJobName();
            jobHistoryInfo.lastCompleted.duration = this.jobHistoryHelper.getDuration(jobHistoryInfo.lastCompleted.start, jobHistoryInfo.lastCompleted.end);
        } else {
            jobHistoryInfo.lastCompleted.found = false;
            LOGGER.debug(String.format("no completed job run found for the job:%s in the last %s job runs", jobName, numberOfRuns));
        }
        if (this.lastCompletedSuccessfullHistoryEntry != null) {
            jobHistoryInfo.lastCompletedSuccessful.found = true;
            jobHistoryInfo.lastCompletedSuccessful.position = this.lastCompletedSuccessfullHistoryEntryPos;
            jobHistoryInfo.lastCompletedSuccessful.errorMessage = this.lastCompletedSuccessfullHistoryEntry.getErrorText();
            jobHistoryInfo.lastCompletedSuccessful.executionResult = this.jobHistoryHelper.big2int(this.lastCompletedSuccessfullHistoryEntry.getExitCode());
            jobHistoryInfo.lastCompletedSuccessful.start = this.jobHistoryHelper.getDateFromString(this.lastCompletedSuccessfullHistoryEntry.getStartTime());
            jobHistoryInfo.lastCompletedSuccessful.end = this.jobHistoryHelper.getDateFromString(this.lastCompletedSuccessfullHistoryEntry.getEndTime());
            jobHistoryInfo.lastCompletedSuccessful.error = this.jobHistoryHelper.big2int(this.lastCompletedSuccessfullHistoryEntry.getError());
            jobHistoryInfo.lastCompletedSuccessful.errorCode = this.lastCompletedSuccessfullHistoryEntry.getErrorCode();
            jobHistoryInfo.lastCompletedSuccessful.id = this.jobHistoryHelper.big2int(this.lastCompletedSuccessfullHistoryEntry.getId());
            jobHistoryInfo.lastCompletedSuccessful.jobName = this.lastCompletedSuccessfullHistoryEntry.getJobName();
            jobHistoryInfo.lastCompletedSuccessful.duration = this.jobHistoryHelper.getDuration(jobHistoryInfo.lastCompletedSuccessful.start, jobHistoryInfo.lastCompletedSuccessful.end);
        } else {
            jobHistoryInfo.lastCompletedSuccessful.found = false;
            LOGGER.debug(String.format("no successfull job run found for the job:%s in the last %s job runs", jobName, numberOfRuns));
        }
        if (this.lastCompletedWithErrorHistoryEntry != null) {
            jobHistoryInfo.lastCompletedWithError.found = true;
            jobHistoryInfo.lastCompletedWithError.position = this.lastCompletedWithErrorHistoryEntryPos;
            jobHistoryInfo.lastCompletedWithError.errorMessage = this.lastCompletedWithErrorHistoryEntry.getErrorText();
            jobHistoryInfo.lastCompletedWithError.executionResult = this.jobHistoryHelper.big2int(this.lastCompletedWithErrorHistoryEntry.getExitCode());
            jobHistoryInfo.lastCompletedWithError.start = this.jobHistoryHelper.getDateFromString(this.lastCompletedWithErrorHistoryEntry.getStartTime());
            jobHistoryInfo.lastCompletedWithError.end = this.jobHistoryHelper.getDateFromString(this.lastCompletedWithErrorHistoryEntry.getEndTime());
            jobHistoryInfo.lastCompletedWithError.error = this.jobHistoryHelper.big2int(this.lastCompletedWithErrorHistoryEntry.getError());
            jobHistoryInfo.lastCompletedWithError.errorCode = this.lastCompletedWithErrorHistoryEntry.getErrorCode();
            jobHistoryInfo.lastCompletedWithError.id = this.jobHistoryHelper.big2int(this.lastCompletedWithErrorHistoryEntry.getId());
            jobHistoryInfo.lastCompletedWithError.jobName = this.lastCompletedWithErrorHistoryEntry.getJobName();
            jobHistoryInfo.lastCompletedWithError.duration = this.jobHistoryHelper.getDuration(jobHistoryInfo.lastCompletedWithError.start, jobHistoryInfo.lastCompletedWithError.end);
        } else {
            jobHistoryInfo.lastCompletedWithError.found = false;
            LOGGER.debug(String.format("no job runs with error found for the job:%s in the last %s job runs", jobName, numberOfRuns));
        }
        if (this.lastRunningHistoryEntry != null) {
            jobHistoryInfo.running.found = true;
            jobHistoryInfo.running.position = this.lastRunningHistoryEntryPos;
            jobHistoryInfo.running.errorMessage = this.lastRunningHistoryEntry.getErrorText();
            jobHistoryInfo.running.executionResult = this.jobHistoryHelper.big2int(this.lastRunningHistoryEntry.getExitCode());
            jobHistoryInfo.running.start = this.jobHistoryHelper.getDateFromString(this.lastRunningHistoryEntry.getStartTime());
            jobHistoryInfo.running.end = null;
            jobHistoryInfo.running.error = this.jobHistoryHelper.big2int(this.lastRunningHistoryEntry.getError());
            jobHistoryInfo.running.errorCode = this.lastRunningHistoryEntry.getErrorCode();
            jobHistoryInfo.running.id = this.jobHistoryHelper.big2int(this.lastRunningHistoryEntry.getId());
            jobHistoryInfo.running.jobName = this.lastRunningHistoryEntry.getJobName();
            jobHistoryInfo.running.duration = "";
        } else {
            jobHistoryInfo.running.found = false;
            LOGGER.debug(String.format("no running jobs found for the job:%s in the last %s job runs", jobName, numberOfRuns));
        }
        return jobHistoryInfo;
    }

    private void getHistory(String jobName, int numberOfRuns) throws Exception {
        SchedulerObjectFactory jsFactory = null;
        jsFactory = this.spooler == null ? new SchedulerObjectFactory() : new SchedulerObjectFactory(this.spooler);
        jsFactory.initMarshaller(ShowHistory.class);
        JSCmdShowHistory showHistory = jsFactory.createShowHistory();
        if (!jobName.startsWith("/") && !this.relativePath.isEmpty()) {
            String s = jobName;
            jobName = new File(this.relativePath, jobName).getPath();
            jobName = jobName.replace('\\', '/');
            LOGGER.debug(String.format("Changed job name from %s to %s", s, jobName));
        }
        this.actHistoryObjectName = jobName;
        showHistory.setJob(jobName);
        showHistory.setPrev(BigInteger.valueOf(numberOfRuns));
        Answer answer = null;
        String lastMsg = "";
        try {
            if (this.spooler == null) {
                jsFactory.getOptions().ServerName.setValue(this.host);
                jsFactory.getOptions().PortNumber.value(this.port);
                showHistory.run();
                answer = showHistory.getAnswer();
            } else {
                showHistory.getAnswerFromSpooler(this.spooler);
                answer = showHistory.getAnswer();
            }
        }
        catch (Exception e) {
            lastMsg = String.format("Query to JobScheduler results into an exception:%s", e.getMessage());
            LOGGER.debug(lastMsg);
        }
        this.numberOfCompleted = 0;
        this.numberOfStarts = 0;
        this.numberOfCompletedSuccessful = 0;
        this.numberOfCompletedWithError = 0;
        if (answer != null) {
            ERROR error = answer.getERROR();
            if (error != null) {
                String msg = String.format("Answer from JobScheduler have the error \"%s\"\nNo entries found for the job:%s", error.getText(), jobName);
                LOGGER.debug(msg);
            } else {
                List jobHistoryEntries = answer.getHistory().getHistoryEntry();
                this.count = jobHistoryEntries.size();
                if (this.count == 0) {
                    String msg = "No entries found for the job:" + jobName;
                    LOGGER.debug(msg);
                } else {
                    int pos = 0;
                    for (HistoryEntry historyItem : jobHistoryEntries) {
                        if (historyItem.getEndTime() == null && historyItem.getStartTime() != null || this.jobHistoryHelper.isInTimeLimit(this.timeLimit, historyItem.getEndTime()) && historyItem.getSteps() != null && historyItem.getSteps().intValue() > 0) {
                            ++this.numberOfStarts;
                            if (historyItem.getEndTime() != null) {
                                ++this.numberOfCompleted;
                                if (this.lastCompletedHistoryEntry == null) {
                                    this.lastCompletedHistoryEntry = historyItem;
                                    this.lastCompletedHistoryEntryPos = pos;
                                }
                                if (historyItem.getExitCode().intValue() == 0) {
                                    ++this.numberOfCompletedSuccessful;
                                    if (this.lastCompletedSuccessfullHistoryEntry == null) {
                                        this.lastCompletedSuccessfullHistoryEntry = historyItem;
                                        this.lastCompletedSuccessfullHistoryEntryPos = pos;
                                    }
                                }
                                if (historyItem.getExitCode().intValue() != 0) {
                                    ++this.numberOfCompletedWithError;
                                    if (this.lastCompletedWithErrorHistoryEntry == null) {
                                        this.lastCompletedWithErrorHistoryEntry = historyItem;
                                        this.lastCompletedWithErrorHistoryEntryPos = pos;
                                    }
                                }
                            } else if (this.lastRunningHistoryEntry == null) {
                                this.lastRunningHistoryEntry = historyItem;
                                this.lastRunningHistoryEntryPos = pos;
                            }
                        }
                        ++pos;
                    }
                }
            }
        } else {
            throw new JobSchedulerException(lastMsg);
        }
    }

    public String getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public void setTimeLimit(String timeLimit) {
        this.timeLimit = timeLimit;
    }

    @Override
    public int getNumberOfCompleted() {
        return this.numberOfCompleted;
    }

    @Override
    public int getNumberOfStarts() {
        return this.numberOfStarts;
    }

    @Override
    public int getNumberOfCompletedSuccessful() {
        return this.numberOfCompletedSuccessful;
    }

    @Override
    public int getNumberOfCompletedWithError() {
        return this.numberOfCompletedWithError;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setRelativePath(String relativePath_) {
        if (!relativePath_.startsWith("/")) {
            relativePath_ = "/" + relativePath_;
        }
        this.relativePath = relativePath_ = relativePath_.replace('\\', '/');
    }

    @Override
    public String getActHistoryObjectName() {
        return this.actHistoryObjectName;
    }
}

