/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.checkrunhistory;

import com.sos.jitl.checkrunhistory.JobSchedulerCheckRunHistoryOptions;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import sos.util.SOSDate;

public class JobHistoryHelper {
    public String getDuration(LocalDateTime parStart, LocalDateTime parEnd) {
        if (parStart == null || parEnd == null) {
            return "";
        }
        Instant instant = parStart.toInstant(ZoneOffset.UTC);
        Date start = Date.from(instant);
        instant = parEnd.toInstant(ZoneOffset.UTC);
        Date end = Date.from(instant);
        if (start == null || end == null) {
            return "";
        }
        GregorianCalendar cal_1 = new GregorianCalendar();
        GregorianCalendar cal_2 = new GregorianCalendar();
        cal_1.setTime(start);
        cal_2.setTime(end);
        long time = cal_2.getTime().getTime() - cal_1.getTime().getTime();
        long seconds = (time /= 1000L) % 60L;
        long minutes = (time /= 60L) % 60L;
        long hours = (time /= 60L) % 24L;
        long days = time /= 24L;
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(11, (int)hours);
        calendar.set(12, (int)minutes);
        calendar.set(13, (int)seconds);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        String d = "";
        d = days > 0L ? String.format("%sd " + formatter.format(calendar.getTime()), days) : formatter.format(calendar.getTime());
        return d;
    }

    public String getOrderId(String jobChainAndOrder) {
        return this.getParameter(jobChainAndOrder);
    }

    public String getJobChainName(String jobChainAndOrder) {
        return this.getMethodName(jobChainAndOrder);
    }

    public String getParameter(String p) {
        p = p.trim();
        String s = "";
        Pattern pattern = Pattern.compile("^.*\\(([^\\)]*)\\)$", 40);
        Matcher matcher = pattern.matcher(p);
        if (matcher.find()) {
            s = matcher.group(1).trim();
        }
        return s;
    }

    public String getMethodName(String p) {
        String s = p = p.trim();
        Pattern pattern = Pattern.compile("^([^\\(]*)\\(.*\\)$", 40);
        Matcher matcher = pattern.matcher(p);
        if (matcher.find()) {
            s = matcher.group(1).trim();
        }
        return s.trim();
    }

    protected boolean isAfter(LocalDateTime timeToTest, String time) {
        if (time.length() == 8) {
            time = "0:" + time;
        }
        if (timeToTest == null) {
            return false;
        }
        JobSchedulerCheckRunHistoryOptions options = new JobSchedulerCheckRunHistoryOptions();
        options.start_time.setValue(time);
        ZonedDateTime zdt = ZonedDateTime.of(timeToTest, ZoneId.systemDefault());
        GregorianCalendar cal = GregorianCalendar.from(zdt);
        DateTime limit = new DateTime((Object)options.start_time.getDateObject());
        DateTime ended = new DateTime((Object)cal.getTime());
        return limit.toLocalDateTime().isBefore((ReadablePartial)ended.toLocalDateTime());
    }

    protected boolean isToday(LocalDateTime d) {
        LocalDateTime today = LocalDateTime.now();
        if (d == null) {
            return false;
        }
        return today.getDayOfYear() == d.getDayOfYear();
    }

    public String getParameter(String defaultValue, String p) {
        String param = this.getParameter(p);
        if (param.isEmpty()) {
            param = defaultValue;
        }
        return param;
    }

    protected int big2int(BigInteger b) {
        if (b == null) {
            return -1;
        }
        return b.intValue();
    }

    protected LocalDateTime getDateFromString(String inDateTime) throws Exception {
        LocalDateTime dateResult = null;
        Date date = null;
        if (inDateTime != null) {
            if (inDateTime.endsWith("Z")) {
                DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'H:mm:ss.SSSZ");
                DateTime dateTime = dateTimeFormatter.parseDateTime(inDateTime.replaceFirst("Z", "+00:00"));
                date = dateTime.toDate();
            } else {
                date = SOSDate.getDate((String)inDateTime, (String)SOSDate.dateTimeFormat);
            }
            dateResult = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            return dateResult;
        }
        return null;
    }

    public boolean isInTimeLimit(String timeLimit, String endTime) {
        if ("".equals(timeLimit)) {
            return true;
        }
        String localTimeLimit = timeLimit;
        if (!timeLimit.contains("..")) {
            localTimeLimit = ".." + localTimeLimit;
        }
        String from = localTimeLimit.replaceAll("^(.*)\\.\\..*$", "$1");
        String to = localTimeLimit.replaceAll("^.*\\.\\.(.*)$", "$1");
        if ("".equals(from)) {
            from = "00:00:00";
        }
        if (from.length() == 8) {
            from = "0:" + from;
        }
        if (to.length() == 8) {
            to = "0:" + to;
        }
        JobSchedulerCheckRunHistoryOptions options = new JobSchedulerCheckRunHistoryOptions();
        options.start_time.setValue(from);
        options.end_time.setValue(to);
        if ("".equals(to)) {
            DateTime ended;
            DateTime fromDate = new DateTime((Object)options.start_time.getDateObject());
            DateTime toDate = ended = new DateTime((Object)endTime);
            return !(!ended.toLocalDateTime().isEqual((ReadablePartial)toDate.toLocalDateTime()) && !ended.toLocalDateTime().isBefore((ReadablePartial)toDate.toLocalDateTime()) || !ended.toLocalDateTime().isEqual((ReadablePartial)fromDate.toLocalDateTime()) && !ended.toLocalDateTime().isAfter((ReadablePartial)fromDate.toLocalDateTime()));
        }
        DateTime fromDate = new DateTime((Object)options.start_time.getDateObject());
        DateTime ended = new DateTime((Object)endTime);
        DateTime toDate = new DateTime((Object)options.end_time.getDateObject());
        return !(!ended.toLocalDateTime().isEqual((ReadablePartial)toDate.toLocalDateTime()) && !ended.toLocalDateTime().isBefore((ReadablePartial)toDate.toLocalDateTime()) || !ended.toLocalDateTime().isEqual((ReadablePartial)fromDate.toLocalDateTime()) && !ended.toLocalDateTime().isAfter((ReadablePartial)fromDate.toLocalDateTime()));
    }
}

