/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.checkrunhistory;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.checkrunhistory.IJobSchedulerHistoryInfo;
import com.sos.jitl.checkrunhistory.JobHistoryHelper;
import com.sos.jitl.checkrunhistory.JobSchedulerHistoryInfoEntry;

public class JobSchedulerHistoryInfo
implements IJobSchedulerHistoryInfo {
    private String startTime = "0:00:00:00";
    private String endTime = "0:00:00:00";
    private JobHistoryHelper jobHistoryHelper = new JobHistoryHelper();
    public JobSchedulerHistoryInfoEntry lastCompleted;
    public JobSchedulerHistoryInfoEntry running = new JobSchedulerHistoryInfoEntry();
    public JobSchedulerHistoryInfoEntry lastCompletedSuccessful;
    public JobSchedulerHistoryInfoEntry lastCompletedWithError;

    public JobSchedulerHistoryInfo() {
        this.running.name = "running";
        this.lastCompleted = new JobSchedulerHistoryInfoEntry();
        this.lastCompleted.name = "last";
        this.lastCompletedSuccessful = new JobSchedulerHistoryInfoEntry();
        this.lastCompletedSuccessful.name = "lastSuccessful";
        this.lastCompletedWithError = new JobSchedulerHistoryInfoEntry();
        this.lastCompletedWithError.name = "lastWithError";
    }

    private JobSchedulerHistoryInfoEntry getYoungerEntry(JobSchedulerHistoryInfoEntry e1, JobSchedulerHistoryInfoEntry e2) {
        if (e1 != null && !e1.found) {
            return e2;
        }
        if (e2 != null && !e2.found) {
            return e1;
        }
        if (e2 == null && e1 == null) {
            return null;
        }
        if (e1 == null && e2 != null) {
            return e2;
        }
        if (e2 == null && e1 != null) {
            return e1;
        }
        if (e1 != null && e2 != null && e1.position < e2.position) {
            return e1;
        }
        return e2;
    }

    public JobSchedulerHistoryInfoEntry getLastExecution() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getYoungerEntry(this.lastCompleted, this.running);
        return jobHistoryInfoEntry;
    }

    public boolean lastSuccessfulCompletedRunEndedAtPosition(String position) {
        try {
            int p = Integer.parseInt(position);
            JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompletedSuccessful();
            return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error == 0 && jobHistoryInfoEntry.position == p;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean lastWithErrorCompletedRunEndedAtPosition(String position) {
        try {
            int p = Integer.parseInt(position);
            JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompletedWithError();
            return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error != 0 && jobHistoryInfoEntry.position == p;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean lastSuccessfulCompletedRunEndedTodayAtPosition(String position) {
        try {
            int p = Integer.parseInt(position);
            JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompletedSuccessful();
            return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error == 0 && this.jobHistoryHelper.isToday(jobHistoryInfoEntry.end) && jobHistoryInfoEntry.position == p;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean lastWithErrorCompletedRunEndedTodayAtPosition(String position) {
        try {
            int p = Integer.parseInt(position);
            JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompletedWithError();
            return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error != 0 && this.jobHistoryHelper.isToday(jobHistoryInfoEntry.end) && jobHistoryInfoEntry.position == p;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean lastCompletedRunEndedSuccessful() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompleted();
        return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error == 0;
    }

    public boolean lastCompletedRunEndedWithError() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompleted();
        return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error != 0;
    }

    public boolean lastCompletedRunEndedTodaySuccessful() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompleted();
        return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error == 0 && this.jobHistoryHelper.isToday(jobHistoryInfoEntry.end);
    }

    public boolean lastCompletedRunEndedTodayWithError() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastCompleted();
        return jobHistoryInfoEntry.found && jobHistoryInfoEntry.error != 0 && this.jobHistoryHelper.isToday(jobHistoryInfoEntry.end);
    }

    public boolean isStartedToday() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.getLastExecution();
        return jobHistoryInfoEntry != null && this.jobHistoryHelper.isToday(jobHistoryInfoEntry.start);
    }

    public boolean isStartedTodayCompletedSuccessful() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.lastCompletedSuccessful;
        return jobHistoryInfoEntry != null && this.jobHistoryHelper.isToday(jobHistoryInfoEntry.start);
    }

    public boolean isStartedTodayCompletedWithError() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.lastCompletedWithError;
        return jobHistoryInfoEntry != null && this.jobHistoryHelper.isToday(jobHistoryInfoEntry.start);
    }

    public boolean isStartedTodayCompleted() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.lastCompleted;
        return jobHistoryInfoEntry != null && this.jobHistoryHelper.isToday(jobHistoryInfoEntry.start);
    }

    public boolean isCompletedToday() {
        return this.lastCompleted != null && this.jobHistoryHelper.isToday(this.lastCompleted.end);
    }

    public boolean isCompletedTodaySuccessful() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.lastCompletedSuccessful;
        return jobHistoryInfoEntry != null && this.jobHistoryHelper.isToday(jobHistoryInfoEntry.end);
    }

    public boolean isCompletedTodayWithError() {
        JobSchedulerHistoryInfoEntry jobHistoryInfoEntry = this.lastCompletedWithError;
        return jobHistoryInfoEntry != null && this.jobHistoryHelper.isToday(jobHistoryInfoEntry.end);
    }

    public boolean endedWithErrorAfter(String time) {
        return this.jobHistoryHelper.isAfter(this.lastCompletedWithError.end, time);
    }

    public boolean endedSuccessfulAfter(String time) {
        return this.jobHistoryHelper.isAfter(this.lastCompletedSuccessful.end, time);
    }

    public boolean endedAfter(String time) {
        return this.jobHistoryHelper.isAfter(this.lastCompleted.end, time);
    }

    public boolean isCompletedWithErrorAfter(String time) {
        return this.endedWithErrorAfter(time);
    }

    public boolean isCompletedSuccessfulAfter(String time) {
        return this.endedSuccessfulAfter(time);
    }

    public boolean isCompletedAfter(String time) {
        return this.endedAfter(time);
    }

    public boolean isEndedWithErrorAfter(String time) {
        return this.endedWithErrorAfter(time);
    }

    public boolean isEndedSuccessfulAfter(String time) {
        return this.endedSuccessfulAfter(time);
    }

    public boolean isEndedAfter(String time) {
        return this.endedAfter(time);
    }

    public boolean isCompletedWithErrorBefore() {
        return this.lastCompleted.found;
    }

    public boolean isCompletedSuccessfulBefore() {
        return this.lastCompletedSuccessful.found;
    }

    public boolean isCompletedBefore() {
        return this.lastCompletedSuccessful.found;
    }

    public boolean startedWithErrorAfter(String time) {
        return this.jobHistoryHelper.isAfter(this.lastCompletedWithError.start, time);
    }

    public boolean startedSuccessfulAfter(String time) {
        return this.jobHistoryHelper.isAfter(this.lastCompletedSuccessful.start, time);
    }

    public boolean startedAfter(String time) {
        return this.jobHistoryHelper.isAfter(this.getLastExecution().start, time);
    }

    public boolean isStartedWithErrorAfter(String time) {
        return this.startedWithErrorAfter(time);
    }

    public boolean isStartedSuccessfulAfter(String time) {
        return this.startedSuccessfulAfter(time);
    }

    public boolean isStartedAfter(String time) {
        return this.startedAfter(time);
    }

    @Override
    public JobSchedulerHistoryInfoEntry getLastCompleted() {
        return this.lastCompleted;
    }

    @Override
    public JobSchedulerHistoryInfoEntry getRunning() {
        return this.running;
    }

    @Override
    public JobSchedulerHistoryInfoEntry getLastCompletedSuccessful() {
        return this.lastCompletedSuccessful;
    }

    @Override
    public JobSchedulerHistoryInfoEntry getLastCompletedWithError() {
        return this.lastCompletedWithError;
    }

    @Override
    public boolean queryHistory(String query) {
        boolean result = false;
        JobHistoryHelper jobHistoryHelper = new JobHistoryHelper();
        String methodName = jobHistoryHelper.getMethodName(query);
        String time = "";
        switch (methodName.toLowerCase()) {
            case "isstartedtoday": {
                result = this.isStartedToday();
                break;
            }
            case "isstartedtodaycompletedsuccessful": {
                result = this.isStartedTodayCompletedSuccessful();
                break;
            }
            case "isstartedtodaycompletedwitherror": {
                result = this.isStartedTodayCompletedWithError();
                break;
            }
            case "isstartedtodaycompleted": {
                result = this.isStartedTodayCompleted();
                break;
            }
            case "iscompletedtoday": {
                result = this.isCompletedToday();
                break;
            }
            case "iscompletedtodaysuccessful": {
                result = this.isCompletedTodaySuccessful();
                break;
            }
            case "iscompletedtodaywitherror": {
                result = this.isCompletedTodayWithError();
                break;
            }
            case "iscompletedafter": {
                time = jobHistoryHelper.getParameter(this.endTime, query);
                result = this.isCompletedAfter(time);
                break;
            }
            case "iscompletedwitherrorafter": {
                time = jobHistoryHelper.getParameter(this.endTime, query);
                result = this.isCompletedWithErrorAfter(time);
                break;
            }
            case "iscompletedsuccessfulafter": {
                time = jobHistoryHelper.getParameter(this.endTime, query);
                result = this.isCompletedSuccessfulAfter(time);
                break;
            }
            case "isstartedafter": {
                time = jobHistoryHelper.getParameter(this.startTime, query);
                result = this.isStartedAfter(time);
                break;
            }
            case "isstartedwitherrorafter": {
                time = jobHistoryHelper.getParameter(this.startTime, query);
                result = this.isStartedWithErrorAfter(time);
                break;
            }
            case "isstartedsuccessfulafter": {
                time = jobHistoryHelper.getParameter(this.startTime, query);
                result = this.isStartedSuccessfulAfter(time);
                break;
            }
            case "iscompletedbefore": {
                result = this.isCompletedBefore();
                break;
            }
            case "iscompletedsuccessfulbefore": {
                result = this.isCompletedSuccessfulBefore();
                break;
            }
            case "iscompletedwitherrorbefore": {
                result = this.isCompletedWithErrorBefore();
                break;
            }
            case "lastsuccessfulcompletedrunendedatposition": {
                result = this.lastSuccessfulCompletedRunEndedAtPosition(jobHistoryHelper.getParameter("0", query));
                break;
            }
            case "lastsuccessfulcompletedrunendedtodayatposition": {
                result = this.lastSuccessfulCompletedRunEndedTodayAtPosition(jobHistoryHelper.getParameter("0", query));
                break;
            }
            case "lastwitherrorcompletedrunendedatposition": {
                result = this.lastWithErrorCompletedRunEndedAtPosition(jobHistoryHelper.getParameter("0", query));
                break;
            }
            case "lastwitherrorcompletedrunendedtodayatposition": {
                result = this.lastWithErrorCompletedRunEndedTodayAtPosition(jobHistoryHelper.getParameter("0", query));
                break;
            }
            case "lastcompletedrunendedsuccessful": {
                result = this.lastCompletedRunEndedSuccessful();
                break;
            }
            case "lastcompletedrunendedwitherror": {
                result = this.lastCompletedRunEndedWithError();
                break;
            }
            case "lastcompletedrunendedtodaysuccessful": {
                result = this.lastCompletedRunEndedTodaySuccessful();
                break;
            }
            case "lastcompletedrunendedtodaywitherror": {
                result = this.lastCompletedRunEndedTodayWithError();
                break;
            }
            default: {
                throw new JobSchedulerException("unknown command: " + query);
            }
        }
        return result;
    }

    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }
}

