/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.dailyplan;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class ExecutionState {
    private Date plannedTime = null;
    private Date endTime = null;
    private Date startTime = null;
    private Date periodBegin = null;
    private int tolerance = 2;
    private int toleranceUnit = 12;
    private boolean haveError;

    public void setHaveError(boolean haveError) {
        this.haveError = haveError;
    }

    public void setPeriodBegin(Date periodBegin) {
        this.periodBegin = periodBegin;
    }

    public boolean isLate() {
        if (this.startTime == null) {
            return this.plannedTime.before(new Date());
        }
        if (this.periodStart()) {
            return false;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.plannedTime);
        ((Calendar)calendar).add(this.toleranceUnit, this.tolerance);
        Date scheduleToleranz = calendar.getTime();
        return this.startTime.after(scheduleToleranz);
    }

    private boolean isSuccessful() {
        return this.endTime != null && this.startTime != null && !this.haveError;
    }

    private boolean isFailed() {
        return this.endTime != null && this.startTime != null && this.haveError;
    }

    private boolean isPlanned() {
        return this.endTime == null && this.startTime == null;
    }

    private boolean isIncomplete() {
        return this.endTime == null && this.startTime != null;
    }

    public String getState() {
        if (this.isSuccessful()) {
            return "SUCCESSFUL";
        }
        if (this.isFailed()) {
            return "FAILED";
        }
        if (this.isIncomplete()) {
            return "INCOMPLETE";
        }
        if (this.isPlanned()) {
            return "PLANNED";
        }
        return null;
    }

    public boolean singleStart() {
        return this.periodBegin == null;
    }

    public boolean periodStart() {
        return this.periodBegin != null;
    }

    public void setPlannedTime(Date plannedTime) {
        this.plannedTime = plannedTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    public void setToleranceUnit(int toleranceUnit) {
        this.toleranceUnit = toleranceUnit;
    }
}

