/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.dailyplan.filter;

import com.sos.hibernate.classes.SOSHibernateIntervalFilter;
import com.sos.jitl.dailyplan.db.DailyPlanCalender2DBFilter;
import com.sos.joc.model.common.Folder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DailyPlanFilter
extends SOSHibernateIntervalFilter {
    private Date plannedStart;
    private Date plannedStartFrom;
    private Date plannedStartTo;
    private Boolean isLate;
    private String schedulerId;
    private String jobChain;
    private Boolean isJobStream;
    private String orderId;
    private String jobStream;
    private Long jobStreamStarterId;
    private String job;
    private List<String> states;
    private Set<Folder> listOfFolders;

    public Set<Folder> getListOfFolders() {
        return this.listOfFolders;
    }

    public void setListOfFolders(Set<Folder> listOfFolders) {
        this.listOfFolders = listOfFolders;
    }

    public void addFolderPaths(Set<Folder> folders) {
        if (this.listOfFolders == null) {
            this.listOfFolders = new HashSet<Folder>();
        }
        if (folders != null) {
            this.listOfFolders.addAll(folders);
        }
    }

    public void addFolderPath(String folder, boolean recursive) {
        if (this.listOfFolders == null) {
            this.listOfFolders = new HashSet<Folder>();
        }
        Folder filterFolder = new Folder();
        filterFolder.setFolder(folder);
        filterFolder.setRecursive(Boolean.valueOf(recursive));
        this.listOfFolders.add(filterFolder);
    }

    public List<String> getStates() {
        return this.states;
    }

    public String getJobChain() {
        return this.jobChain;
    }

    public void setJobChain(String jobChain) {
        this.jobChain = jobChain;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public Date getPlannedStartFrom() {
        return this.plannedStartFrom;
    }

    public void setPlannedStartFrom(Date plannedStartFrom) {
        this.plannedStartFrom = plannedStartFrom;
    }

    public void setPlannedStartFrom(String plannedStartFrom) throws ParseException {
        if (plannedStartFrom == null || "".equals(plannedStartFrom)) {
            this.plannedStartFrom = null;
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat(this.dateFormat);
            Date d = formatter.parse(plannedStartFrom);
            this.setPlannedStartFrom(d);
        }
    }

    public void setPlannedStartFrom(String plannedStartFrom, String dateFormat) throws ParseException {
        this.dateFormat = dateFormat;
        this.setPlannedStartFrom(plannedStartFrom);
    }

    public void setPlannedStartTo(String plannedStartTo, String dateFormat) throws ParseException {
        this.dateFormat = dateFormat;
        this.setPlannedStartTo(plannedStartTo);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Date getPlannedStartTo() {
        return this.plannedStartTo;
    }

    public void setPlannedStartTo(Date plannedStartTo) {
        this.plannedStartTo = plannedStartTo;
    }

    public void setPlannedStartTo(String plannedStartTo) throws ParseException {
        if (plannedStartTo == null || "".equals(plannedStartTo)) {
            this.plannedStartTo = null;
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat(this.dateFormat);
            Date d = formatter.parse(plannedStartTo);
            this.setPlannedStartTo(d);
        }
    }

    public Boolean isLate() {
        return this.isLate != null && this.isLate != false;
    }

    public Boolean getIsLate() {
        return this.isLate;
    }

    public void setLate(Boolean late) {
        this.isLate = late;
    }

    public String getSchedulerId() {
        return this.schedulerId;
    }

    public void setSchedulerId(String schedulerId) {
        this.schedulerId = schedulerId;
    }

    public void addState(String state) {
        if (this.states == null) {
            this.states = new ArrayList<String>();
        }
        this.states.add(state);
    }

    public void setIntervalFromDate(Date d) {
        this.plannedStartFrom = d;
    }

    public void setIntervalToDate(Date d) {
        this.plannedStartTo = d;
    }

    public void setIntervalFromDateIso(String s) {
    }

    public void setIntervalToDateIso(String s) {
    }

    public void setCalender2DBFilter(DailyPlanCalender2DBFilter dailyPlanCalender2DBFilter) {
        if (!"".equals(dailyPlanCalender2DBFilter.getForJob())) {
            this.setJob(dailyPlanCalender2DBFilter.getForJob());
        }
        if (!"".equals(dailyPlanCalender2DBFilter.getForJobChain())) {
            this.setJobChain(dailyPlanCalender2DBFilter.getForJobChain());
        }
        if (!"".equals(dailyPlanCalender2DBFilter.getForOrderId())) {
            this.setOrderId(dailyPlanCalender2DBFilter.getForOrderId());
        }
    }

    public void setPlannedStart(Date plannedStart) {
        this.plannedStart = plannedStart;
    }

    public Date getPlannedStart() {
        return this.plannedStart;
    }

    public boolean containsFolder(String path) {
        if (this.listOfFolders == null || this.listOfFolders.size() == 0) {
            return true;
        }
        Path p = Paths.get(path, new String[0]).getParent();
        String parent = "";
        if (p != null) {
            parent = p.toString().replace('\\', '/');
        }
        for (Folder folder : this.listOfFolders) {
            if ((!folder.getRecursive().booleanValue() || !(parent + "/").startsWith(folder.getFolder())) && !folder.equals((Object)parent)) continue;
            return true;
        }
        return false;
    }

    public String getJobStream() {
        return this.jobStream;
    }

    public void setJobStream(String jobStream) {
        this.jobStream = jobStream;
    }

    public Boolean isJobStream() {
        return this.isJobStream;
    }

    public void setIsJobStream(Boolean isJobStream) {
        this.isJobStream = isJobStream;
    }

    public Long getJobStreamStarterId() {
        return this.jobStreamStarterId;
    }

    public void setJobStreamStarterId(Long jobStreamStarterId) {
        this.jobStreamStarterId = jobStreamStarterId;
    }
}

