/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventhandler.handler;

import com.google.common.base.Joiner;
import com.sos.jitl.eventhandler.EventMeta;
import com.sos.jitl.eventhandler.http.HttpClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class EventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHandler.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private final HttpClient httpClient = new HttpClient();
    private int webserviceLimit = 1000;
    private int webserviceTimeout = 60;
    private int webserviceDelay = 0;
    private String baseUrl;
    private String identifier;

    public JsonObject getOverview(EventMeta.EventPath path, String bodyParamPath) throws Exception {
        return this.getOverview(path, this.getEventOverviewByEventPath(path), bodyParamPath);
    }

    public JsonObject getOverview(EventMeta.EventPath path, EventMeta.EventOverview overview, String bodyParamPath) throws Exception {
        String method = this.getMethodName("getOverview");
        if (SOSString.isEmpty((String)bodyParamPath)) {
            throw new Exception("missing bodyParamPath");
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[eventPath=%s][eventOverview=%s][bodyParamPath=%s]", new Object[]{method, path, overview, bodyParamPath}));
        }
        URIBuilder ub = new URIBuilder(this.getUri(path));
        ub.addParameter("return", overview.name());
        return this.httpClient.executeJsonPost(ub.build(), Collections.singletonMap("path", bodyParamPath));
    }

    public JsonObject getEvents(Long eventId, EventMeta.EventType[] eventTypes) throws Exception {
        return this.getEvents(eventId, this.getEventTypes(eventTypes), null);
    }

    public JsonObject getEvents(Long eventId, EventMeta.EventType[] eventTypes, String bodyParamPath) throws Exception {
        return this.getEvents(eventId, this.getEventTypes(eventTypes), bodyParamPath);
    }

    public JsonObject getEvents(Long eventId, String eventTypes) throws Exception {
        return this.getEvents(eventId, eventTypes, null);
    }

    public JsonObject getEvents(Long eventId, String eventTypes, String bodyParamPath) throws Exception {
        String method = this.getMethodName("getEvents");
        if (isDebugEnabled) {
            String bodyParamMsg = SOSString.isEmpty((String)bodyParamPath) ? "" : String.format("[bodyParamPath=%s]", bodyParamPath);
            LOGGER.debug(String.format("%s[%s][%s]%s", method, eventId, eventTypes, bodyParamMsg));
        }
        URIBuilder ub = new URIBuilder(this.getUri(EventMeta.EventPath.event));
        if (!SOSString.isEmpty((String)eventTypes)) {
            ub.addParameter("return", eventTypes);
        }
        ub.addParameter("after", eventId.toString());
        if (this.webserviceTimeout > 0) {
            ub.addParameter("timeout", String.valueOf(this.webserviceTimeout));
        }
        if (this.webserviceDelay > 0) {
            ub.addParameter("delay", String.valueOf(this.webserviceDelay));
        }
        if (this.webserviceLimit > 0) {
            ub.addParameter("limit", String.valueOf(this.webserviceLimit));
        }
        if (SOSString.isEmpty((String)bodyParamPath)) {
            return this.httpClient.executeJsonGet(ub.build());
        }
        Map<String, String> bodyParams = null;
        if (bodyParamPath != null) {
            bodyParams = Collections.singletonMap("path", bodyParamPath);
        }
        return this.httpClient.executeJsonPost(ub.build(), bodyParams);
    }

    public Long getEventId(JsonObject json) {
        JsonNumber r;
        Long eventId = null;
        if (json != null && (r = json.getJsonNumber(EventMeta.EventKey.eventId.name())) != null) {
            eventId = r.longValue();
        }
        return eventId;
    }

    public String getEventType(JsonObject json) {
        return json == null ? null : json.getString(EventMeta.EventKey.TYPE.name());
    }

    public JsonArray getEventSnapshots(JsonObject json) {
        return json == null ? null : json.getJsonArray(EventMeta.EventKey.eventSnapshots.name());
    }

    public String getEventKey(JsonObject json) {
        String eventKey = null;
        JsonValue key = (JsonValue)json.get((Object)EventMeta.EventKey.key.name());
        if (key != null) {
            if (key.getValueType().equals((Object)JsonValue.ValueType.STRING)) {
                eventKey = key.toString();
            } else if (key.getValueType().equals((Object)JsonValue.ValueType.OBJECT) && ((JsonObject)key).containsKey((Object)EventMeta.EventKey.jobPath.name())) {
                eventKey = ((JsonObject)key).getString(EventMeta.EventKey.jobPath.name());
            }
        }
        return eventKey;
    }

    public String getEventTypes(EventMeta.EventType[] type) {
        return type == null ? "" : Joiner.on((String)",").join((Object[])type);
    }

    public EventMeta.EventOverview getEventOverviewByEventTypes(EventMeta.EventType[] type) {
        if (type != null && type.length > 0) {
            String first = type[0].name();
            if (first.toLowerCase().startsWith(EventMeta.EventPath.fileBased.name().toLowerCase())) {
                return EventMeta.EventOverview.FileBasedOverview;
            }
            if (first.toLowerCase().startsWith(EventMeta.EventPath.order.name().toLowerCase())) {
                return EventMeta.EventOverview.OrderOverview;
            }
            if (first.toLowerCase().startsWith(EventMeta.EventPath.task.name().toLowerCase())) {
                return EventMeta.EventOverview.TaskOverview;
            }
            if (first.toLowerCase().startsWith(EventMeta.EventPath.jobChain.name().toLowerCase())) {
                return EventMeta.EventOverview.JobChainOverview;
            }
        }
        return null;
    }

    public EventMeta.EventOverview getEventOverviewByEventPath(EventMeta.EventPath path) {
        if (path != null) {
            if (path.equals((Object)EventMeta.EventPath.fileBased)) {
                return EventMeta.EventOverview.FileBasedOverview;
            }
            if (path.equals((Object)EventMeta.EventPath.order)) {
                return EventMeta.EventOverview.OrderOverview;
            }
            if (path.equals((Object)EventMeta.EventPath.task)) {
                return EventMeta.EventOverview.TaskOverview;
            }
            if (path.equals((Object)EventMeta.EventPath.jobChain)) {
                return EventMeta.EventOverview.JobChainOverview;
            }
        }
        return null;
    }

    public EventMeta.EventPath getEventPathByEventOverview(EventMeta.EventOverview overview) {
        if (overview != null) {
            if (overview.name().toLowerCase().startsWith(EventMeta.EventPath.fileBased.name().toLowerCase())) {
                return EventMeta.EventPath.fileBased;
            }
            if (overview.name().toLowerCase().startsWith(EventMeta.EventPath.order.name().toLowerCase())) {
                return EventMeta.EventPath.order;
            }
            if (overview.name().toLowerCase().startsWith(EventMeta.EventPath.task.name().toLowerCase())) {
                return EventMeta.EventPath.task;
            }
            if (overview.name().toLowerCase().startsWith(EventMeta.EventPath.jobChain.name().toLowerCase())) {
                return EventMeta.EventPath.jobChain;
            }
            if (overview.name().toLowerCase().startsWith(EventMeta.EventPath.event.name().toLowerCase())) {
                return EventMeta.EventPath.event;
            }
        }
        return null;
    }

    public void setBaseUrl(String host, String port) {
        this.baseUrl = String.format("http://%s:%s", host, port);
    }

    public URI getUri(EventMeta.EventPath path) throws URISyntaxException {
        if (this.baseUrl == null) {
            throw new URISyntaxException("null", "baseUrl is NULL");
        }
        if (path == null) {
            throw new URISyntaxException("null", "path is NULL");
        }
        StringBuilder uri = new StringBuilder();
        uri.append(this.baseUrl);
        uri.append("/jobscheduler/master/api/");
        uri.append(path.name());
        return new URI(uri.toString());
    }

    public String getMethodName(String name) {
        String prefix = this.identifier == null ? "" : String.format("[%s]", this.identifier);
        return String.format("%s[%s]", prefix, name);
    }

    public void setIdentifier(String val) {
        this.identifier = val;
        this.httpClient.setIdentifier(this.identifier);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public int getWebserviceTimeout() {
        return this.webserviceTimeout;
    }

    public void setWebserviceTimeout(int val) {
        this.webserviceTimeout = val;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

