/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventhandler.http;

import com.sos.jitl.restclient.JobSchedulerRestApiClient;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.Map;
import javassist.NotFoundException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private static final boolean isTraceEnabled = LOGGER.isTraceEnabled();
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_APPLICATION_JSON = "application/json";
    private int connectTimeout = 30;
    private int connectionRequestTimeout = 30;
    private int socketTimeout = 75;
    private JobSchedulerRestApiClient client;
    private String identifier;

    public void create() {
        String method = this.getMethodName("create");
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[connectTimeout=%ss][socketTimeout=%ss][connectionRequestTimeout=%ss]", method, this.connectTimeout, this.socketTimeout, this.connectionRequestTimeout));
        }
        this.client = new JobSchedulerRestApiClient();
        this.client.setAutoCloseHttpClient(false);
        this.client.setConnectionTimeout(this.connectTimeout * 1000);
        this.client.setConnectionRequestTimeout(this.connectionRequestTimeout * 1000);
        this.client.setSocketTimeout(this.socketTimeout * 1000);
        this.client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        this.client.createHttpClient();
    }

    public void tryCreate() {
        if (this.client == null) {
            this.create();
        }
    }

    public void close() {
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s%s", this.getMethodName("close"), this.client == null ? "[skip]client is NULL" : ""));
        }
        if (this.client != null) {
            this.client.closeHttpClient();
            this.client = null;
        }
    }

    public boolean isClosed() {
        return this.client == null;
    }

    public String executeGet(URI uri, String contentType, String accept) throws Exception {
        String method = this.getMethodName("executeGet");
        if (this.client == null) {
            throw new Exception(String.format("%s[%s]client is NULL", method, uri));
        }
        this.client.addHeader(HEADER_CONTENT_TYPE, contentType);
        this.client.addHeader(HEADER_ACCEPT, accept);
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[call]%s", method, uri));
        }
        String response = this.client.getRestService(uri);
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[response]%s", method, response));
        }
        this.checkResponse(uri, response);
        return response;
    }

    public JsonObject executeJsonGet(URI uri) throws Exception {
        return this.readJsonObject(uri, this.executeGet(uri, HEADER_APPLICATION_JSON, HEADER_APPLICATION_JSON));
    }

    public JsonObject executeJsonPost(URI uri) throws Exception {
        return this.executeJsonPost(uri, null);
    }

    public JsonObject executeJsonPost(URI uri, Map<String, String> bodyParams) throws Exception {
        String body = null;
        if (bodyParams != null) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            for (Map.Entry<String, String> pair : bodyParams.entrySet()) {
                builder.add(pair.getKey(), pair.getValue());
            }
            body = builder.build().toString();
        }
        return this.readJsonObject(uri, this.executePost(uri, HEADER_APPLICATION_JSON, HEADER_APPLICATION_JSON, body));
    }

    public String executePost(URI uri, String contentType, String accept) throws Exception {
        return this.executePost(uri, contentType, accept, null);
    }

    public String executePost(URI uri, String contentType, String accept, String body) throws Exception {
        String method = this.getMethodName("executePost");
        if (this.client == null) {
            throw new Exception(String.format("%s[%s]client is NULL", method, uri));
        }
        this.client.addHeader(HEADER_CONTENT_TYPE, contentType);
        this.client.addHeader(HEADER_ACCEPT, accept);
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[call][%s][body=%s]", method, uri, body));
        }
        String response = this.client.postRestService(uri, body);
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[response]%s", method, response));
        }
        this.checkResponse(uri, response);
        return response;
    }

    private void checkResponse(URI uri, String response) throws Exception {
        String method = this.getMethodName("checkResponse");
        int statusCode = this.client.statusCode();
        String contentType = this.client.getResponseHeader(HEADER_CONTENT_TYPE);
        if (isTraceEnabled) {
            LOGGER.trace(String.format("%s[%s][%s]", method, statusCode, contentType));
        }
        switch (statusCode) {
            case 200: {
                if (!SOSString.isEmpty((String)response)) break;
                throw new Exception(String.format("%s[%s][%s][%s]response is empty", method, uri, statusCode, contentType));
            }
            case 404: {
                throw new NotFoundException(String.format("%s[%s][%s][%s]%s", method, uri, statusCode, contentType, this.getResponseReason()));
            }
            default: {
                throw new Exception(String.format("%s[%s][%s][%s]%s", method, uri, statusCode, contentType, this.getResponseReason()));
            }
        }
    }

    private String getResponseReason() {
        try {
            return this.client.getHttpResponse().getStatusLine().getReasonPhrase();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private JsonObject readJsonObject(URI uri, String response) throws Exception {
        JsonObject json = null;
        StringReader sr = new StringReader(response);
        JsonReader jr = Json.createReader((Reader)sr);
        try {
            json = jr.readObject();
        }
        catch (Throwable e) {
            LOGGER.error(String.format("%s[%s][readJsonObject]%s", this.getMethodName("readJsonObject"), uri.toString(), e.toString()), e);
            throw e;
        }
        finally {
            jr.close();
            sr.close();
        }
        return json;
    }

    public String getMethodName(String name) {
        String prefix = this.identifier == null ? "" : String.format("[%s]", this.identifier);
        return String.format("%s[%s]", prefix, name);
    }

    public void setIdentifier(String val) {
        this.identifier = val;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setConnectionRequestTimeout(int val) {
        this.connectionRequestTimeout = val;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectTimeout(int val) {
        this.connectTimeout = val;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setSocketTimeout(int val) {
        this.socketTimeout = val;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }
}

