/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventing;

import com.sos.JSHelper.Basics.IJSCommands;
import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.eventing.JSEventsClient;
import com.sos.jitl.eventing.JSEventsClientOptions;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sos.connection.SOSConnection;
import sos.scheduler.command.SOSSchedulerCommand;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Order;
import sos.spooler.Spooler;
import sos.spooler.Supervisor_client;

public class JSEventsClientBaseClass
extends JobSchedulerJobAdapter {
    protected static final String conNodeNameEVENT = "event";
    protected static String tableEvents = "REPORTING_CUSTOM_EVENTS";
    protected final boolean continue_with_spooler_process = true;
    protected final boolean continue_with_task = true;
    protected JSEventsClientOptions jsEventsClientOptions = null;
    protected JSEventsClient jsEventsClient = null;
    private static final String NODE_NAME_EVENTS = "events";
    private static final Logger LOGGER = LoggerFactory.getLogger(JSEventsClientBaseClass.class);

    public void setOptions(JSEventsClientOptions pobjOptions) {
        this.jsEventsClientOptions = pobjOptions;
    }

    protected void doProcessing() throws Exception {
        this.initialize();
        this.jsEventsClientOptions.checkMandatory();
        this.jsEventsClient.execute();
    }

    protected void initialize() {
        this.jsEventsClient = new JSEventsClient();
        this.jsEventsClientOptions = this.jsEventsClient.getOptions();
        if (this.jsEventsClientOptions.ExitCode.isNotDirty()) {
            this.jsEventsClientOptions.ExitCode.value(this.spooler_task.exit_code());
        }
        if (!this.jsEventsClientOptions.scheduler_event_handler_host.isDirty()) {
            if (this.spooler != null) {
                Supervisor_client objRemoteConfigurationService = null;
                try {
                    objRemoteConfigurationService = this.spooler.supervisor_client();
                    this.jsEventsClientOptions.scheduler_event_handler_host.setValue(objRemoteConfigurationService.hostname());
                    this.jsEventsClientOptions.scheduler_event_handler_port.value(objRemoteConfigurationService.tcp_port());
                }
                catch (Exception e) {
                    this.jsEventsClientOptions.scheduler_event_handler_host.setValue(this.spooler.hostname());
                    this.jsEventsClientOptions.scheduler_event_handler_port.value(SOSSchedulerCommand.getHTTPPortFromScheduler((Spooler)this.spooler));
                }
            } else {
                throw new JobSchedulerException("No Event Service specified. Parameter " + this.jsEventsClientOptions.scheduler_event_handler_host.getShortKey());
            }
        }
        this.jsEventsClient.setJSJobUtilites((JSJobUtilities)this);
        this.jsEventsClient.setJSCommands((IJSCommands)this);
        try {
            Order order = this.spooler_task.order();
            this.jsEventsClientOptions.setCurrentNodeName(this.getCurrentNodeName(order, false));
            this.jsEventsClientOptions.setAllOptions(this.getSchedulerParameterAsProperties(order));
        }
        catch (Exception e) {
            throw new JobSchedulerException("error " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean spooler_init() {
        return super.spooler_init();
    }

    public void spooler_exit() {
        super.spooler_exit();
    }

    public Document readEventsFromDB(SOSConnection conn) throws Exception {
        Document eventsDoc = null;
        try {
            conn.executeUpdate("DELETE FROM " + this.getEventsTableName() + " WHERE \"EXPIRES\"<=%now AND (\"SPOOLER_ID\" IS NULL OR \"SPOOLER_ID\"='' OR \"SPOOLER_ID\"='" + this.spooler.id() + "')");
            conn.commit();
            Vector vEvents = conn.getArrayAsVector("SELECT \"SPOOLER_ID\", \"REMOTE_SCHEDULER_HOST\", \"REMOTE_SCHEDULER_PORT\", \"JOB_CHAIN\", \"ORDER_ID\", \"JOB_NAME\", \"EVENT_CLASS\", \"EVENT_ID\", \"EXIT_CODE\", \"CREATED\", \"EXPIRES\", \"PARAMETERS\" FROM " + this.getEventsTableName() + " WHERE (\"SPOOLER_ID\" IS NULL OR \"SPOOLER_ID\"='' OR \"SPOOLER_ID\"='" + this.spooler.id() + "') ORDER BY \"ID\" ASC");
            String[] strAttr = new String[]{"remote_scheduler_host", "remote_scheduler_port", "job_chain", "order_id", "job_name", "event_class", "event_id", "exit_code", "expires", "created"};
            Iterator vIterator = vEvents.iterator();
            int vCount = 0;
            eventsDoc = this.createEventsDocument(NODE_NAME_EVENTS);
            while (vIterator.hasNext()) {
                HashMap record = (HashMap)vIterator.next();
                Element event = eventsDoc.createElement(conNodeNameEVENT);
                EventNode objEvent = new EventNode(event, record);
                event.setAttribute("scheduler_id", objEvent.getVal("spooler_id"));
                for (String strAttributeName : strAttr) {
                    objEvent.setAttr(strAttributeName);
                }
                if (objEvent.hasParameters()) {
                    Document eventParameters = this.createEventsDocument(new InputSource(new StringReader(objEvent.getParameters())));
                    LOGGER.debug("Importing params node...");
                    Node impParameters = eventsDoc.importNode(eventParameters.getDocumentElement(), true);
                    LOGGER.debug("appending params child...");
                    event.appendChild(impParameters);
                }
                eventsDoc.getLastChild().appendChild(event);
                ++vCount;
            }
            LOGGER.info(vCount + " events read from database");
        }
        catch (Exception e) {
            throw new JobSchedulerException("Failed to read events from database: " + e, (Throwable)e);
        }
        return eventsDoc;
    }

    public String getEventsTableName() {
        return tableEvents;
    }

    protected Document createDomDocument() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        Document eventDocument = null;
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            eventDocument = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return eventDocument;
    }

    protected Document createEventsDocument(String pstrNodeName) {
        Document eventDocument = this.createDomDocument();
        eventDocument.appendChild(eventDocument.createElement(NODE_NAME_EVENTS));
        return eventDocument;
    }

    protected Document createEventsDocument(InputSource pobjInputSource) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        Document eventDocument = null;
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            eventDocument = docBuilder.parse(pobjInputSource);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return eventDocument;
    }

    private String getText(Node n) {
        if (n != null) {
            return n.getNodeValue();
        }
        return "";
    }

    private String modifyXMLTags(String pstrEventString) {
        return pstrEventString.replaceAll(String.valueOf('\u00fe'), "<").replaceAll(String.valueOf('\u00ff'), ">");
    }

    private String sendCommand(String command) {
        String s = "";
        SOSSchedulerCommand socket = null;
        LOGGER.debug("...sendCommand: " + command);
        try {
            if (socket == null) {
                socket = new SOSSchedulerCommand();
                socket.connect(this.jsEventsClientOptions.scheduler_event_handler_host.getValue(), this.jsEventsClientOptions.scheduler_event_handler_port.value());
            }
            socket.sendRequest(command);
            s = socket.getResponse();
            LOGGER.debug("Response = " + this.modifyXMLTags(s));
        }
        catch (Exception ee) {
            throw new JobSchedulerException(String.format("Error sending command to Job Scheduler: '%1$s' \n %2$s", command, ee.getMessage()), (Throwable)ee);
        }
        return s;
    }

    private class EventNode {
        public Element event = null;
        public HashMap<?, ?> record = null;

        EventNode(Element pevent, HashMap<?, ?> hshmap) {
            this.event = pevent;
            this.record = hshmap;
        }

        public void setAttr(String pstrName) {
            this.event.setAttribute(pstrName, this.getVal(pstrName));
        }

        public String getParameters() {
            return this.record.get("parameters").toString();
        }

        public boolean hasParameters() {
            return this.getParameters().length() > 0;
        }

        public String getVal(String pstrName) {
            String strR = this.record.get(pstrName).toString();
            return strR;
        }
    }
}

