/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventing.eventhandler;

import com.sos.jitl.eventing.eventhandler.SOSActions;
import com.sos.jitl.eventing.eventhandler.SOSEventCommand;
import com.sos.jitl.eventing.eventhandler.SOSEventGroups;
import com.sos.jitl.eventing.eventhandler.SchedulerEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOSEvaluateEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSEvaluateEvents.class);
    private LinkedHashSet<SOSActions> listOfActions;
    private List<SchedulerEvent> listOfActiveEvents = new ArrayList<SchedulerEvent>();
    private String errmsg;

    public void reconnect() {
        this.listOfActiveEvents = new ArrayList<SchedulerEvent>();
    }

    public String getEventStatus(SchedulerEvent event) {
        String erg = "missing";
        for (SchedulerEvent e : this.listOfActiveEvents) {
            if (!event.isEqual(e)) continue;
            event.setCreated(e.getCreated());
            event.setExpires(e.getExpires());
            erg = "active";
        }
        return erg;
    }

    private void fillTreeItem(SOSActions a, Node n) {
        a.commandNodes = n.getChildNodes();
        for (int i = 0; i < a.commandNodes.getLength(); ++i) {
            Node command = a.commandNodes.item(i);
            if (!"command".equals(command.getNodeName()) && !"remove_event".equals(command.getNodeName()) && !"add_event".equals(command.getNodeName())) continue;
            SOSEventCommand ec = new SOSEventCommand();
            ec.setCommand(command);
            a.listOfCommands.add(ec);
        }
    }

    private void fillEvents(Node eventGroup, SOSEventGroups evg) {
        NodeList events = eventGroup.getChildNodes();
        for (int i = 0; i < events.getLength(); ++i) {
            Node event = events.item(i);
            if (!"event".equals(event.getNodeName())) continue;
            NamedNodeMap attr = event.getAttributes();
            SchedulerEvent e = new SchedulerEvent();
            e.setProperties(attr);
            e.setEventClassIfBlank(evg.event_class);
            evg.listOfEvents.add(e);
        }
    }

    private void fillEventGroups(SOSActions a, Node n) {
        NamedNodeMap attrEvents = n.getAttributes();
        a.condition = this.getText(attrEvents.getNamedItem("logic"));
        NodeList eventGroups = n.getChildNodes();
        for (int i = 0; i < eventGroups.getLength(); ++i) {
            Node eventGroup = eventGroups.item(i);
            if (!"event_group".equals(eventGroup.getNodeName())) continue;
            NamedNodeMap attr = eventGroup.getAttributes();
            SOSEventGroups evg = new SOSEventGroups(this.getText(attr.getNamedItem("group")));
            evg.condition = this.getText(attr.getNamedItem("logic"));
            evg.group = this.getText(attr.getNamedItem("group"));
            evg.event_class = this.getText(attr.getNamedItem("event_class"));
            this.fillEvents(eventGroup, evg);
            a.listOfEventGroups.add(evg);
        }
    }

    private void fillAction(SOSActions a, NodeList actionChilds) {
        for (int i = 0; i < actionChilds.getLength(); ++i) {
            Node n = actionChilds.item(i);
            if ("commands".equals(n.getNodeName())) {
                a.commands = n;
                this.fillTreeItem(a, n);
            }
            if (!"events".equals(n.getNodeName())) continue;
            this.fillEventGroups(a, n);
        }
    }

    public void readConfigurationFile(File f) throws DOMException, Exception {
        this.listOfActions = new LinkedHashSet();
        if (f.exists()) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                this.listOfActions.clear();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(f);
                NodeList actions = doc.getElementsByTagName("action");
                if (actions.item(0) == null) {
                    this.errmsg = "No actions defined in " + f.getCanonicalPath();
                    LOGGER.info(this.errmsg);
                } else {
                    for (int i = 0; i < actions.getLength(); ++i) {
                        NamedNodeMap attr = actions.item(i).getAttributes();
                        String action_name = this.getText(attr.getNamedItem("name"));
                        SOSActions a = new SOSActions(action_name);
                        this.listOfActions.add(a);
                        this.fillAction(a, actions.item(i).getChildNodes());
                    }
                }
            }
            catch (ParserConfigurationException e) {
                this.errmsg = "Error reading actions from " + f.getAbsolutePath();
                LOGGER.info(this.errmsg);
            }
        }
    }

    private String getText(Node n) {
        if (n != null) {
            return n.getNodeValue();
        }
        return "";
    }

    public LinkedHashSet<SOSActions> getListOfActions() {
        return this.listOfActions;
    }

    public List<SchedulerEvent> getListOfActiveEvents() {
        return this.listOfActiveEvents;
    }

    public static void main(String[] args) {
        SOSEvaluateEvents eval = new SOSEvaluateEvents();
        String configuration_filename = "c:/roche/scheduler/config/events/splitt_gsg.actions.xml";
        File f = new File(configuration_filename);
        try {
            eval.readConfigurationFile(f);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        for (SOSActions a : eval.getListOfActions()) {
            int ii;
            NamedNodeMap attr;
            Node n;
            int i;
            for (i = 0; i < a.getCommandNodes().getLength(); ++i) {
                n = a.getCommandNodes().item(i);
                if (!"command".equals(n.getNodeName())) continue;
                System.out.println(n.getNodeName());
                attr = n.getAttributes();
                if (attr == null) continue;
                for (ii = 0; ii < attr.getLength(); ++ii) {
                    System.out.println(attr.item(ii).getNodeName() + "=" + attr.item(ii).getNodeValue());
                }
            }
            for (i = 0; i < a.getCommands().getChildNodes().getLength(); ++i) {
                n = a.getCommands().getChildNodes().item(i);
                if (!"command".equals(n.getNodeName())) continue;
                System.out.println(n.getNodeName());
                attr = n.getAttributes();
                if (attr == null) continue;
                for (ii = 0; ii < attr.getLength(); ++ii) {
                    System.out.println(attr.item(ii).getNodeName() + "=" + attr.item(ii).getNodeValue());
                }
            }
            if (a != null) {
                for (SOSEventGroups evg : a.getListOfEventGroups()) {
                    for (SchedulerEvent event : evg.getListOfEvents()) {
                        System.out.println(event.getJobName() + " " + eval.getEventStatus(event));
                    }
                }
            }
            if (a.isActive(eval.getListOfActiveEvents())) {
                System.out.println(a.name + " is active");
                continue;
            }
            System.out.println(a.name + " is NOT active");
        }
    }

    public void setListOfActiveEvents(List<SchedulerEvent> listOfActiveEvents) {
        this.listOfActiveEvents = listOfActiveEvents;
    }
}

