/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.housekeeping.rotatelog;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.JSHelper.io.Files.JSFile;
import com.sos.JSHelper.io.Files.JSFolder;
import com.sos.jitl.housekeeping.rotatelog.JobSchedulerRotateLogOptions;
import com.sos.scheduler.messages.JSMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerRotateLog
extends JSJobUtilitiesClass<JobSchedulerRotateLogOptions> {
    private static final String JOB_SCHEDULER_OLD_LOG_FILENAME = "scheduler-old";
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerRotateLog.class);
    private String schedulerID = "";

    public JobSchedulerRotateLog() {
        super((Object)new JobSchedulerRotateLogOptions());
    }

    public JobSchedulerRotateLogOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new JobSchedulerRotateLogOptions();
        }
        return (JobSchedulerRotateLogOptions)((Object)this.objOptions);
    }

    public boolean executeDebugLog() {
        String methodName = "JobSchedulerRotateLog::ExecuteDebugLog";
        LOGGER.info(String.format(new JSMsg("JSJ-I-110").get(), "JobSchedulerRotateLog::ExecuteDebugLog"));
        try {
            this.schedulerID = ((JobSchedulerRotateLogOptions)((Object)this.objOptions)).jobSchedulerID.getValue();
            this.getOptions().setJobSchedulerID(new SOSOptionString(this.schedulerID));
            this.getOptions().checkMandatory();
            try {
                JSFolder objLogDirectory = ((JobSchedulerRotateLogOptions)((Object)this.objOptions)).file_path.getFolder();
                JSFile fleSchedulerLog = objLogDirectory.getNewFile("scheduler.log");
                String strNewLogFileName = "scheduler-old.log";
                JSFile objNewLogFileName = objLogDirectory.getNewFile(strNewLogFileName);
                fleSchedulerLog.copy(objNewLogFileName);
            }
            catch (Exception e) {
                String strT = "an error occurred copying log file to scheduler-old.log: " + e.getMessage();
                throw new JobSchedulerException(strT, (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format(new JSMsg("JSJ-I-107").get(), "JobSchedulerRotateLog::ExecuteDebugLog") + " " + e.getMessage(), (Throwable)e);
            throw e;
        }
        LOGGER.debug(String.format(new JSMsg("JSJ-I-111").get(), "JobSchedulerRotateLog::ExecuteDebugLog"));
        return true;
    }

    public boolean executeMainLog() {
        String methodName = "JobSchedulerRotateLog::ExecuteMainLog";
        int intNoOfCompressedLogFilesDeleted = 0;
        int intNoOfLogFilesCompressed = 0;
        String deleteSchedulerLogFileSpec = "";
        String strRegExpr4CompressedFiles2Delete = "";
        String strRegExpr4LogFiles2Compress = "";
        LOGGER.info(String.format(new JSMsg("JSJ-I-110").get(), "JobSchedulerRotateLog::ExecuteMainLog"));
        try {
            this.schedulerID = ((JobSchedulerRotateLogOptions)((Object)this.objOptions)).jobSchedulerID.getValue();
            this.getOptions().setJobSchedulerID(new SOSOptionString(this.schedulerID));
            this.getOptions().checkMandatory();
            LOGGER.debug(this.getOptions().dirtyString());
            try {
                JSFolder objLogDirectory = ((JobSchedulerRotateLogOptions)((Object)this.objOptions)).file_path.getFolder();
                deleteSchedulerLogFileSpec = "(?i)^(scheduler.log\\.)([0-9\\-]+)" + this.getRegExp4SchedulerID() + "(\\" + ".log" + ")(\\.gz)?$";
                if (!"0".equals(((JobSchedulerRotateLogOptions)((Object)this.objOptions)).delete_file_age.getValue())) {
                    objLogDirectory.IncludeOlderThan = ((JobSchedulerRotateLogOptions)((Object)this.objOptions)).delete_file_age.getTimeAsMilliSeconds();
                    strRegExpr4CompressedFiles2Delete = "(?i)" + ((JobSchedulerRotateLogOptions)((Object)this.objOptions)).delete_file_specification.getValue();
                    intNoOfCompressedLogFilesDeleted = objLogDirectory.deleteFiles(strRegExpr4CompressedFiles2Delete);
                    LOGGER.info(intNoOfCompressedLogFilesDeleted + " compressed log files deleted for regexp: " + strRegExpr4CompressedFiles2Delete);
                    intNoOfCompressedLogFilesDeleted = objLogDirectory.deleteFiles(deleteSchedulerLogFileSpec);
                    LOGGER.info(intNoOfCompressedLogFilesDeleted + " compressed log files deleted for regexp: " + deleteSchedulerLogFileSpec);
                }
                if (!"0".equals(((JobSchedulerRotateLogOptions)((Object)this.objOptions)).compress_file_age.getValue())) {
                    LOGGER.debug(String.format("compress files older than %s mSecs", ((JobSchedulerRotateLogOptions)((Object)this.objOptions)).compress_file_age.getTimeAsMilliSeconds()));
                    objLogDirectory.IncludeOlderThan = ((JobSchedulerRotateLogOptions)((Object)this.objOptions)).compress_file_age.getTimeAsMilliSeconds();
                    strRegExpr4LogFiles2Compress = "(?i)" + ((JobSchedulerRotateLogOptions)((Object)this.objOptions)).compress_file_spec.getValue();
                    intNoOfLogFilesCompressed = objLogDirectory.compressFiles(strRegExpr4LogFiles2Compress);
                    LOGGER.info(intNoOfLogFilesCompressed + " log files compressed for regexp: " + strRegExpr4LogFiles2Compress);
                }
            }
            catch (Exception e) {
                String strT = "an error occurred cleaning up log files: " + e.getMessage();
                throw new JobSchedulerException(strT, (Throwable)e);
            }
            finally {
                LOGGER.info(intNoOfCompressedLogFilesDeleted + " compressed log files deleted for regexp: " + deleteSchedulerLogFileSpec);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format(new JSMsg("JSJ-I-107").get(), "JobSchedulerRotateLog::ExecuteMainLog") + " " + e.getMessage(), (Throwable)e);
            throw e;
        }
        LOGGER.debug(String.format(new JSMsg("JSJ-I-111").get(), "JobSchedulerRotateLog::ExecuteMainLog"));
        return true;
    }

    private String getRegExp4SchedulerID() {
        String strR = "";
        if (this.schedulerID != null) {
            strR = strR + "(\\." + this.schedulerID + ")";
        }
        return strR;
    }

    public void init() {
        this.doInitialize();
    }

    private void doInitialize() {
    }
}

