/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.inventory.data;

import com.sos.exception.SOSBadRequestException;
import com.sos.exception.SOSConnectionRefusedException;
import com.sos.exception.SOSConnectionResetException;
import com.sos.exception.SOSException;
import com.sos.hibernate.classes.DbItem;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.exceptions.SOSHibernateInvalidSessionException;
import com.sos.hibernate.exceptions.SOSHibernateObjectOperationException;
import com.sos.jitl.dailyplan.db.Calendar2DB;
import com.sos.jitl.dailyplan.db.DailyPlanCalender2DBFilter;
import com.sos.jitl.inventory.db.DBLayerInventory;
import com.sos.jitl.inventory.exceptions.SOSInventoryEventProcessingException;
import com.sos.jitl.inventory.helper.AgentHelper;
import com.sos.jitl.inventory.helper.Calendar2DBHelper;
import com.sos.jitl.inventory.helper.HttpHelper;
import com.sos.jitl.inventory.helper.InventoryRuntimeHelper;
import com.sos.jitl.inventory.helper.SaveOrUpdateHelper;
import com.sos.jitl.inventory.model.DocumentationDBLayer;
import com.sos.jitl.inventory.model.InventoryModel;
import com.sos.jitl.reporting.db.DBItemDocumentation;
import com.sos.jitl.reporting.db.DBItemDocumentationUsage;
import com.sos.jitl.reporting.db.DBItemInventoryAgentCluster;
import com.sos.jitl.reporting.db.DBItemInventoryAgentClusterMember;
import com.sos.jitl.reporting.db.DBItemInventoryAgentInstance;
import com.sos.jitl.reporting.db.DBItemInventoryClusterCalendarUsage;
import com.sos.jitl.reporting.db.DBItemInventoryFile;
import com.sos.jitl.reporting.db.DBItemInventoryInstance;
import com.sos.jitl.reporting.db.DBItemInventoryJob;
import com.sos.jitl.reporting.db.DBItemInventoryJobChain;
import com.sos.jitl.reporting.db.DBItemInventoryJobChainNode;
import com.sos.jitl.reporting.db.DBItemInventoryLock;
import com.sos.jitl.reporting.db.DBItemInventoryOperatingSystem;
import com.sos.jitl.reporting.db.DBItemInventoryOrder;
import com.sos.jitl.reporting.db.DBItemInventoryProcessClass;
import com.sos.jitl.reporting.db.DBItemInventorySchedule;
import com.sos.jitl.reporting.db.DBLayer;
import com.sos.jitl.reporting.helper.EConfigFileExtensions;
import com.sos.jitl.reporting.helper.ReportUtil;
import com.sos.jitl.reporting.helper.ReportXmlHelper;
import com.sos.jitl.reporting.plugin.FactEventHandler;
import com.sos.jitl.restclient.JobSchedulerRestApiClient;
import com.sos.scheduler.SOSJobSchedulerGlobal;
import com.sos.scheduler.engine.data.events.custom.VariablesCustomEvent;
import com.sos.scheduler.engine.eventbus.EventPublisher;
import com.sos.scheduler.engine.kernel.scheduler.SchedulerXmlCommandExecutor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;
import sos.xml.SOSXMLXPath;

public class InventoryEventUpdateUtil {
    private static final String APPLICATION_HEADER_XML_VALUE = "application/xml";
    private static final String WEBSERVICE_PARAM_VALUE_FILEBASED_DETAILED = "FileBasedDetailed";
    private static final String APPLICATION_HEADER_JSON_VALUE = "application/json";
    private static final String WEBSERVICE_PARAM_VALUE_FILEBASED_OVERVIEW = "FileBasedOverview";
    private static final String WEBSERVICE_PARAM_VALUE_FILEBASED_EVENT = "FileBasedEvent";
    private static final String WEBSERVICE_PARAM_VALUE_SCHEDULER_EVENT = "SchedulerEvent";
    private static final String WEBSERVICE_PARAM_VALUE_CALENDAR_EVENT = "VariablesCustomEvent";
    private static final String WEBSERVICE_PARAM_VALUE_CALENDAR_EVENT_KEY = "CalendarUsageUpdated";
    private static final String WEBSERVICE_PARAM_KEY_RETURN = "return";
    private static final String WEBSERVICE_PARAM_KEY_AFTER = "after";
    private static final String WEBSERVICE_PARAM_KEY_TIMEOUT = "timeout";
    private static final String WEBSERVICE_PARAM_VALUE_TIMEOUT = "60s";
    private static final Integer HTTP_CLIENT_SOCKET_TIMEOUT = 75000;
    private static final String WEBSERVICE_COMMAND_URL = "/jobscheduler/master/api/command";
    private static final String WEBSERVICE_FILE_BASED_URL = "/jobscheduler/master/api/fileBased";
    private static final String WEBSERVICE_EVENTS_URL = "/jobscheduler/master/api/event";
    private static final String ACCEPT_HEADER_KEY = "Accept";
    private static final String CONTENT_TYPE_HEADER_KEY = "Content-Type";
    private static final String POST_BODY_JSON_KEY = "path";
    private static final String POST_BODY_JSON_VALUE = "/";
    private static final String EVENT_TYPE = "TYPE";
    private static final String EVENT_TYPE_REMOVED = "FileBasedRemoved";
    private static final String EVENT_STATE_KEY = "state";
    private static final String EVENT_STATE_VALUE_STOPPING = "stopping";
    private static final String EVENT_TYPE_UPDATED = "FileBasedUpdated";
    private static final String CUSTOM_EVENT_TYPE_DAILYPLAN_UPDATED = "InventoryDailyPlanUpdated";
    private static final String EVENT_TYPE_NON_EMPTY = "NonEmpty";
    private static final String EVENT_TYPE_EMPTY = "Empty";
    private static final String EVENT_TYPE_TORN = "Torn";
    private static final String EVENT_KEY = "key";
    private static final String EVENT_ID = "eventId";
    private static final String EVENT_SNAPSHOT = "eventSnapshots";
    private static final String EVENT_SCHEDULER_STATE_CHANGED = "SchedulerStateChanged";
    private static final String JS_OBJECT_TYPE_JOB = "Job";
    private static final String CALENDAR_OBJECT_TYPE_JOB = "JOB";
    private static final String JS_OBJECT_TYPE_JOBCHAIN = "JobChain";
    private static final String JS_OBJECT_TYPE_ORDER = "Order";
    private static final String CALENDAR_OBJECT_TYPE_ORDER = "ORDER";
    private static final String JS_OBJECT_TYPE_PROCESS_CLASS = "ProcessClass";
    private static final String JS_OBJECT_TYPE_SCHEDULE = "Schedule";
    private static final String CALENDAR_OBJECT_TYPE_SCHEDULE = "SCHEDULE";
    private static final String JS_OBJECT_TYPE_LOCK = "Lock";
    private static final String JS_OBJECT_TYPE_FOLDER = "Folder";
    private static final String JS_OBJECT_TYPE_MONITOR = "Monitor";
    private static final String FILE_TYPE_JOB = "job";
    private static final String FILE_TYPE_JOBCHAIN = "job_chain";
    private static final String FILE_TYPE_ORDER = "order";
    private static final String FILE_TYPE_PROCESS_CLASS = "process_class";
    private static final String FILE_TYPE_AGENT_CLUSTER = "agent_cluster";
    private static final String FILE_TYPE_SCHEDULE = "schedule";
    private static final String FILE_TYPE_LOCK = "lock";
    private static final String DEFAULT_JOB_DOC_PATH = "/sos/jitl-jobs";
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryEventUpdateUtil.class);
    private Map<String, List<JsonObject>> groupedEvents = new HashMap<String, List<JsonObject>>();
    private String webserviceUrl = null;
    private SOSHibernateFactory factory = null;
    private DBItemInventoryInstance instance = null;
    private DBLayerInventory dbLayer = null;
    private Path liveDirectory = null;
    private Path cacheDirectory = null;
    private Long eventId = null;
    private String lastEventKey = null;
    private Long lastEventId = 0L;
    private Long newEventId = 0L;
    private List<DbItem> saveOrUpdateItems = new ArrayList<DbItem>();
    private Set<DBItemInventoryJobChainNode> saveOrUpdateNodeItems = new HashSet<DBItemInventoryJobChainNode>();
    private Set<DbItem> deleteItems = new HashSet<DbItem>();
    private Map<String, NodeList> jobChainNodesToSave = new HashMap<String, NodeList>();
    private Map<DBItemInventoryProcessClass, NodeList> remoteSchedulersToSave = new HashMap<DBItemInventoryProcessClass, NodeList>();
    private Map<String, SOSXMLXPath> pcXpaths = new HashMap<String, SOSXMLXPath>();
    private JobSchedulerRestApiClient restApiClient;
    private CloseableHttpClient httpClient;
    private boolean closed = false;
    private String host;
    private Integer port;
    private EventPublisher customEventBus;
    private Map<String, Map<String, String>> eventVariables = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> dailyPlanEventVariables = new HashMap<String, Map<String, String>>();
    private boolean hasDbErrors = false;
    private Path schedulerXmlPath;
    private SchedulerXmlCommandExecutor xmlCommandExecutor;
    private String schedulerId;
    private String answerXml;
    private Set<DBItemInventoryAgentInstance> agentsToDelete;
    private Set<DBItemInventoryAgentClusterMember> agentClusterMembersToDelete;
    private Map<Long, String> schedulesToCheckForUpdate = new HashMap<Long, String>();
    private Set<DBItemInventoryJob> jobsForDailyPlanUpdate = new HashSet<DBItemInventoryJob>();
    private Set<DBItemInventoryOrder> ordersForDailyPlanUpdate = new HashSet<DBItemInventoryOrder>();
    private Set<DBItemInventorySchedule> schedulesForDailyPlanUpdate = new HashSet<DBItemInventorySchedule>();
    private Boolean isWindows;
    private String hostFromHttpPort;
    private String httpPort;
    private String timezone;
    private Integer recurringExecution = 0;

    public InventoryEventUpdateUtil(String host, Integer port, SOSHibernateFactory factory, EventPublisher customEventBus, Path schedulerXmlPath, String schedulerId, String httpPort) {
        this.factory = factory;
        this.httpPort = httpPort;
        this.hostFromHttpPort = HttpHelper.getHttpHost(httpPort, "127.0.0.1");
        this.webserviceUrl = "http://" + this.hostFromHttpPort + ":" + port;
        this.host = host;
        this.port = port;
        this.customEventBus = customEventBus;
        this.schedulerXmlPath = schedulerXmlPath;
        this.schedulerId = schedulerId;
        this.cacheDirectory = this.schedulerXmlPath.getParent().resolve("cache");
        this.initInstance();
        this.initRestClient();
    }

    public InventoryEventUpdateUtil(String host, Integer port, SOSHibernateFactory factory, Path schedulerXmlPath, String schedulerId, String answerXml, String httpPort) {
        this.factory = factory;
        this.httpPort = httpPort;
        this.hostFromHttpPort = HttpHelper.getHttpHost(httpPort, "127.0.0.1");
        this.webserviceUrl = "http://" + this.hostFromHttpPort + ":" + port;
        this.host = host;
        this.port = port;
        this.customEventBus = null;
        this.schedulerXmlPath = schedulerXmlPath;
        this.schedulerId = schedulerId;
        this.answerXml = answerXml;
        this.cacheDirectory = this.schedulerXmlPath.getParent().resolve("cache");
        this.initInstance();
        this.initRestClient();
    }

    public void execute() throws Exception {
        LOGGER.debug("[inventory] Processing of FileBasedEvents started!");
        while (this.eventId == null) {
            this.eventId = this.initOverviewRequest();
        }
        this.lastEventId = this.eventId;
        while (!this.closed) {
            try {
                if (this.hasDbErrors) {
                    this.processAgain();
                }
                this.execute(this.lastEventId, this.lastEventKey);
                this.lastEventId = this.newEventId;
                LOGGER.debug("line 233: lastEventID set to : " + this.lastEventId);
            }
            catch (SOSHibernateInvalidSessionException e) {
                this.hasDbErrors = true;
                this.saveOrUpdateItems.clear();
                this.saveOrUpdateNodeItems.clear();
                if (!this.closed) {
                    this.restartExecution();
                    continue;
                }
                LOGGER.info("[inventory] execute: processing stopped.");
            }
            catch (Exception e) {
                if (!this.closed) {
                    this.restartExecution();
                    continue;
                }
                LOGGER.info("[inventory] execute: processing stopped.");
            }
        }
    }

    private void execute(Long eventId, String lastKey) throws Exception {
        if (!this.closed) {
            LOGGER.debug("[inventory] -- Processing FileBasedEvents --");
            JsonObject result = this.getFileBasedEvents(eventId);
            String type = result.getString(EVENT_TYPE);
            this.newEventId = result.getJsonNumber(EVENT_ID).longValue();
            JsonArray events = result.getJsonArray(EVENT_SNAPSHOT);
            if (events != null && !events.isEmpty()) {
                this.processEventType(type, events, lastKey);
            } else if (EVENT_TYPE_EMPTY.equalsIgnoreCase(type)) {
                this.lastEventKey = lastKey;
            }
        }
    }

    private void initInstance() {
        try (SOSHibernateSession dbConnection = null;){
            dbConnection = this.factory.openStatelessSession("inventory");
            this.dbLayer = new DBLayerInventory(dbConnection);
            this.instance = this.dbLayer.getInventoryInstance(this.schedulerId, this.host, this.port);
            if (this.instance != null) {
                this.liveDirectory = Paths.get(this.instance.getLiveDirectory(), new String[0]);
                DBItemInventoryOperatingSystem os = this.dbLayer.getInventoryOpSysById(this.instance.getOsId());
                if (os != null) {
                    this.isWindows = os.getName().equalsIgnoreCase("windows") ? Boolean.valueOf(os.getName().equalsIgnoreCase("windows")) : Boolean.valueOf(false);
                }
                this.timezone = this.instance.getTimeZone();
            }
        }
    }

    private void initRestClient() {
        this.restApiClient = new JobSchedulerRestApiClient();
        this.restApiClient.setAutoCloseHttpClient(false);
        this.restApiClient.setSocketTimeout(HTTP_CLIENT_SOCKET_TIMEOUT);
        this.restApiClient.addHeader(CONTENT_TYPE_HEADER_KEY, APPLICATION_HEADER_JSON_VALUE);
        this.restApiClient.addHeader(ACCEPT_HEADER_KEY, APPLICATION_HEADER_JSON_VALUE);
        this.restApiClient.addHeader("Cache-Control", "no-cache, no-store, no-transform, must-revalidate");
        this.restApiClient.createHttpClient();
        this.httpClient = this.restApiClient.getHttpClient();
    }

    private void processAgain() throws Exception {
        if (!this.closed) {
            try {
                if (this.recurringExecution < 3) {
                    Integer n = this.recurringExecution;
                    Integer n2 = this.recurringExecution = Integer.valueOf(this.recurringExecution + 1);
                    this.execute(this.lastEventId, this.lastEventKey);
                } else {
                    this.recurringExecution = 0;
                    if (this.newEventId != 0L && this.newEventId != this.lastEventId) {
                        this.lastEventId = this.newEventId;
                    }
                    LOGGER.debug("[inventory] tried to process events three times unsuccessfully, complete configuration update started instead!");
                    InventoryModel modelProcessing = new InventoryModel(this.factory, this.instance, this.schedulerXmlPath);
                    modelProcessing.setAnswerXml(this.answerXml);
                    modelProcessing.setXmlCommandExecutor(this.xmlCommandExecutor);
                    modelProcessing.process();
                    LOGGER.debug("[inventory] complete configuration update finished!");
                }
                this.hasDbErrors = false;
            }
            catch (SOSHibernateInvalidSessionException e) {
                this.hasDbErrors = true;
                throw e;
            }
            catch (Exception e) {
                throw new SOSInventoryEventProcessingException(e);
            }
        }
    }

    public void restartExecution() {
        if (!this.closed) {
            this.cleanup();
            if (this.httpClient == null) {
                this.initRestClient();
            } else {
                if (this.restApiClient != null) {
                    this.restApiClient.closeHttpClient();
                } else {
                    try {
                        this.httpClient.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.initRestClient();
            }
        }
    }

    private void cleanup() {
        this.eventId = null;
        if (this.groupedEvents != null) {
            this.groupedEvents.clear();
        }
        if (this.saveOrUpdateItems != null) {
            this.saveOrUpdateItems.clear();
        }
        if (this.saveOrUpdateNodeItems != null) {
            this.saveOrUpdateNodeItems.clear();
        }
        if (this.deleteItems != null) {
            this.deleteItems.clear();
        }
        if (this.agentsToDelete != null) {
            this.agentsToDelete.clear();
        }
        if (this.agentClusterMembersToDelete != null) {
            this.agentClusterMembersToDelete.clear();
        }
        if (this.eventVariables != null) {
            this.eventVariables.clear();
        }
        if (this.dailyPlanEventVariables != null) {
            this.dailyPlanEventVariables.clear();
        }
        if (this.remoteSchedulersToSave != null) {
            this.remoteSchedulersToSave.clear();
        }
        if (this.jobChainNodesToSave != null) {
            this.jobChainNodesToSave.clear();
        }
        if (this.schedulesToCheckForUpdate != null) {
            this.schedulesToCheckForUpdate.clear();
        }
        if (this.jobsForDailyPlanUpdate != null) {
            this.jobsForDailyPlanUpdate.clear();
        }
        if (this.ordersForDailyPlanUpdate != null) {
            this.ordersForDailyPlanUpdate.clear();
        }
        if (this.schedulesForDailyPlanUpdate != null) {
            this.schedulesForDailyPlanUpdate.clear();
        }
        SaveOrUpdateHelper.clearExisitingItems();
    }

    private JsonObject getLastEvent(String key, List<JsonObject> events) {
        JsonObject lastEvent = null;
        for (JsonObject event : events) {
            this.eventId = event.getJsonNumber(EVENT_ID).longValue();
            lastEvent = event;
        }
        return lastEvent;
    }

    private void addToExistingGroup(String path, List<JsonObject> events) {
        List<JsonObject> existingGroup = this.groupedEvents.get(path);
        existingGroup.addAll(events);
        this.groupedEvents.put(path, existingGroup);
    }

    private void groupEvents(JsonArray events, String lastKey) {
        String state = null;
        for (JsonObject evt : events.getValuesAs(JsonObject.class)) {
            if (!EVENT_SCHEDULER_STATE_CHANGED.equals(evt.getString(EVENT_TYPE)) || !EVENT_STATE_VALUE_STOPPING.equals(state = evt.getString(EVENT_STATE_KEY))) continue;
            this.closed = true;
            break;
        }
        if (state == null || state != null && !EVENT_STATE_VALUE_STOPPING.equalsIgnoreCase(state)) {
            for (JsonObject event : events.getValuesAs(JsonObject.class)) {
                ArrayList<JsonObject> pathEvents = new ArrayList<JsonObject>();
                String key = event.getString(EVENT_KEY, null);
                String type = event.getString(EVENT_TYPE, null);
                if (key == null || type == null) continue;
                if (lastKey == null) {
                    lastKey = key;
                } else if (!lastKey.equals(key)) {
                    pathEvents.clear();
                    lastKey = key;
                }
                if ((!WEBSERVICE_PARAM_VALUE_CALENDAR_EVENT.equals(type) || !WEBSERVICE_PARAM_VALUE_CALENDAR_EVENT_KEY.equals(key)) && (!type.startsWith("FileBased") || !key.contains(":"))) continue;
                pathEvents.add(event);
                if (this.groupedEvents.containsKey(lastKey)) {
                    this.addToExistingGroup(lastKey, pathEvents);
                    continue;
                }
                this.groupedEvents.put(lastKey, pathEvents);
            }
        }
        this.lastEventKey = lastKey;
    }

    private void processGroupedEvents(Map<String, List<JsonObject>> events) throws Exception {
        this.sortGroupedEvents(events);
        String lastKey = null;
        Iterator<String> iterator = events.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            lastKey = key = iterator.next();
            if (WEBSERVICE_PARAM_VALUE_CALENDAR_EVENT_KEY.equals(key)) {
                for (JsonObject jsonObject : events.get(key)) {
                    this.eventId = this.processEvent(jsonObject);
                }
                continue;
            }
            JsonObject event = this.getLastEvent(key, events.get(key));
            this.eventId = this.processEvent(event);
        }
        this.lastEventId = this.newEventId;
        LOGGER.debug("line 473: lastEventID set to newEventId: " + this.lastEventId);
        this.processDbTransaction();
        this.saveOrUpdateItems.clear();
        this.saveOrUpdateNodeItems.clear();
        this.deleteItems.clear();
        if (this.agentsToDelete != null && !this.agentsToDelete.isEmpty()) {
            this.agentsToDelete.clear();
        }
        if (this.agentClusterMembersToDelete != null && !this.agentClusterMembersToDelete.isEmpty()) {
            this.agentClusterMembersToDelete.clear();
        }
        if (this.schedulesToCheckForUpdate != null && !this.schedulesToCheckForUpdate.isEmpty()) {
            this.schedulesToCheckForUpdate.clear();
        }
        if (this.eventVariables != null && !this.eventVariables.isEmpty()) {
            this.eventVariables.clear();
        }
        if (this.groupedEvents != null && !this.groupedEvents.isEmpty()) {
            this.groupedEvents.clear();
        }
        this.lastEventKey = lastKey;
    }

    private void sortGroupedEvents(Map<String, List<JsonObject>> events) {
        Comparator<JsonObject> eventGroupComparator = new Comparator<JsonObject>(){

            @Override
            public int compare(JsonObject o1, JsonObject o2) {
                if (o1.getString(InventoryEventUpdateUtil.EVENT_TYPE).equals(InventoryEventUpdateUtil.EVENT_TYPE_REMOVED)) {
                    return -1;
                }
                return 0;
            }
        };
        for (List<JsonObject> list : events.values()) {
            Collections.sort(list, eventGroupComparator);
        }
        Comparator<String> eventGroupKeyComparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                List listO1 = (List)InventoryEventUpdateUtil.this.groupedEvents.get(o1);
                for (JsonObject o1Object : listO1) {
                    if (!o1Object.getString(InventoryEventUpdateUtil.EVENT_TYPE).equals(InventoryEventUpdateUtil.EVENT_TYPE_REMOVED)) continue;
                    return -1;
                }
                return 0;
            }
        };
        TreeMap<String, List<JsonObject>> sortedEvents = new TreeMap<String, List<JsonObject>>(eventGroupKeyComparator);
        for (String key : events.keySet()) {
            sortedEvents.put(key, events.get(key));
        }
    }

    private String getName(DbItem item) {
        if (item instanceof DBItemInventoryJob) {
            return ((DBItemInventoryJob)item).getName();
        }
        if (item instanceof DBItemInventoryJobChain) {
            return ((DBItemInventoryJobChain)item).getName();
        }
        if (item instanceof DBItemInventoryOrder) {
            return ((DBItemInventoryOrder)item).getName();
        }
        if (item instanceof DBItemInventoryProcessClass) {
            return ((DBItemInventoryProcessClass)item).getName();
        }
        if (item instanceof DBItemInventorySchedule) {
            return ((DBItemInventorySchedule)item).getName();
        }
        if (item instanceof DBItemInventoryLock) {
            return ((DBItemInventoryLock)item).getName();
        }
        return null;
    }

    private void setFileId(DbItem item, Long fileId) {
        if (item instanceof DBItemInventoryJob) {
            ((DBItemInventoryJob)item).setFileId(fileId);
        } else if (item instanceof DBItemInventoryJobChain) {
            ((DBItemInventoryJobChain)item).setFileId(fileId);
        } else if (item instanceof DBItemInventoryOrder) {
            ((DBItemInventoryOrder)item).setFileId(fileId);
        } else if (item instanceof DBItemInventoryProcessClass) {
            ((DBItemInventoryProcessClass)item).setFileId(fileId);
        } else if (item instanceof DBItemInventorySchedule) {
            ((DBItemInventorySchedule)item).setFileId(fileId);
        } else if (item instanceof DBItemInventoryLock) {
            ((DBItemInventoryLock)item).setFileId(fileId);
        }
    }

    private boolean isdataForUpdatePresent() {
        return this.saveOrUpdateItems != null && !this.saveOrUpdateItems.isEmpty() || this.saveOrUpdateNodeItems != null && !this.saveOrUpdateNodeItems.isEmpty() || this.deleteItems != null && !this.deleteItems.isEmpty() || this.agentsToDelete != null && !this.agentsToDelete.isEmpty() || this.agentClusterMembersToDelete != null && !this.agentClusterMembersToDelete.isEmpty() || this.schedulesToCheckForUpdate != null & !this.schedulesToCheckForUpdate.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDbTransaction() throws SOSHibernateException, SOSInventoryEventProcessingException {
        block65: {
            if (!this.closed) {
                HashMap<DBItemInventoryJobChain, List<DBItemInventoryJob>> processedJobChains = new HashMap<DBItemInventoryJobChain, List<DBItemInventoryJob>>();
                try (SOSHibernateSession dbConnection = null;){
                    if (!this.isdataForUpdatePresent()) break block65;
                    dbConnection = this.factory.openStatelessSession("inventory");
                    this.dbLayer = new DBLayerInventory(dbConnection);
                    HashSet<DbItem> processedItems = new HashSet<DbItem>();
                    LOGGER.debug("[inventory] processing of DB transactions started");
                    this.dbLayer.getSession().beginTransaction();
                    SaveOrUpdateHelper.clearExisitingItems();
                    SaveOrUpdateHelper.initExistingItems(this.dbLayer, this.instance);
                    Long fileId = null;
                    String filePath = null;
                    for (DbItem item : this.saveOrUpdateItems) {
                        try {
                            NodeList nl;
                            Long id;
                            if (item instanceof DBItemInventoryFile) {
                                id = SaveOrUpdateHelper.saveOrUpdateItem(this.dbLayer, item);
                                LOGGER.debug("processed file got id from autoincrement: " + id.toString());
                                fileId = id;
                                filePath = ((DBItemInventoryFile)item).getFileName();
                                LOGGER.debug(String.format("[inventory] file %1$s saved or updated", filePath));
                                continue;
                            }
                            if (item instanceof DBItemInventoryJob) {
                                this.jobsForDailyPlanUpdate.add((DBItemInventoryJob)item);
                            } else if (item instanceof DBItemInventoryOrder) {
                                this.ordersForDailyPlanUpdate.add((DBItemInventoryOrder)item);
                            } else if (item instanceof DBItemInventorySchedule) {
                                this.schedulesForDailyPlanUpdate.add((DBItemInventorySchedule)item);
                            }
                            if (filePath != null && fileId != null) {
                                NodeList nl2;
                                String name = this.getName(item);
                                if (name != null && !name.isEmpty() && filePath.contains(name)) {
                                    this.setFileId(item, fileId);
                                }
                                LOGGER.debug("save or update item: " + this.getName(item) + " !");
                                Long id2 = SaveOrUpdateHelper.saveOrUpdateItem(this.dbLayer, item);
                                processedItems.add(item);
                                LOGGER.debug("processed JobSchedulerObject got id from autoincrement: " + id2.toString());
                                LOGGER.debug(String.format("[inventory] item %1$s saved or updated", name));
                                if (item instanceof DBItemInventoryJobChain) {
                                    if (processedJobChains.keySet().contains((DBItemInventoryJobChain)item)) {
                                        ((List)processedJobChains.get((DBItemInventoryJobChain)item)).addAll(this.dbLayer.getAllJobsFromJobChain(((DBItemInventoryJobChain)item).getInstanceId(), ((DBItemInventoryJobChain)item).getId()));
                                    } else {
                                        processedJobChains.put((DBItemInventoryJobChain)item, this.dbLayer.getAllJobsFromJobChain(((DBItemInventoryJobChain)item).getInstanceId(), ((DBItemInventoryJobChain)item).getId()));
                                    }
                                    nl2 = this.jobChainNodesToSave.get(this.getName(item));
                                    this.dbLayer.deleteOldNodes((DBItemInventoryJobChain)item);
                                    SaveOrUpdateHelper.clearExistingJobChainNodes();
                                    SaveOrUpdateHelper.initExisitingJobChainNodes(this.dbLayer, this.instance);
                                    this.createJobChainNodes(nl2, (DBItemInventoryJobChain)item);
                                } else if (item instanceof DBItemInventoryProcessClass) {
                                    nl2 = this.remoteSchedulersToSave.get(item);
                                    this.saveAgentClusters(dbConnection, (DBItemInventoryProcessClass)item, nl2);
                                } else if (item instanceof DBItemInventorySchedule) {
                                    Long scheduleId = id2;
                                    String scheduleName = ((DBItemInventorySchedule)item).getName();
                                    this.schedulesToCheckForUpdate.put(scheduleId, scheduleName);
                                }
                                fileId = null;
                                filePath = null;
                                continue;
                            }
                            id = SaveOrUpdateHelper.saveOrUpdateItem(this.dbLayer, item);
                            LOGGER.debug("save or update item: " + this.getName(item) + " !");
                            LOGGER.debug(String.format("[inventory] item %1$s saved or updated", this.getName(item)));
                            if (item instanceof DBItemInventoryJobChain) {
                                if (processedJobChains.keySet().contains((DBItemInventoryJobChain)item)) {
                                    ((List)processedJobChains.get((DBItemInventoryJobChain)item)).addAll(this.dbLayer.getAllJobsFromJobChain(((DBItemInventoryJobChain)item).getInstanceId(), ((DBItemInventoryJobChain)item).getId()));
                                } else {
                                    processedJobChains.put((DBItemInventoryJobChain)item, this.dbLayer.getAllJobsFromJobChain(((DBItemInventoryJobChain)item).getInstanceId(), ((DBItemInventoryJobChain)item).getId()));
                                }
                                nl = this.jobChainNodesToSave.get(this.getName(item));
                                this.dbLayer.deleteOldNodes((DBItemInventoryJobChain)item);
                                SaveOrUpdateHelper.clearExistingJobChainNodes();
                                SaveOrUpdateHelper.initExisitingJobChainNodes(this.dbLayer, this.instance);
                                this.createJobChainNodes(nl, (DBItemInventoryJobChain)item);
                                continue;
                            }
                            if (item instanceof DBItemInventoryProcessClass) {
                                nl = this.remoteSchedulersToSave.get(item);
                                this.saveAgentClusters(dbConnection, (DBItemInventoryProcessClass)item, nl);
                                continue;
                            }
                            if (!(item instanceof DBItemInventorySchedule)) continue;
                            Long scheduleId = id;
                            String scheduleName = ((DBItemInventorySchedule)item).getName();
                            this.schedulesToCheckForUpdate.put(scheduleId, scheduleName);
                        }
                        catch (ConstraintViolationException e) {
                            LOGGER.debug(e.toString(), (Throwable)e);
                        }
                        catch (SOSHibernateObjectOperationException e) {
                            LOGGER.debug(e.toString(), (Throwable)e);
                        }
                    }
                    if (this.saveOrUpdateNodeItems != null) {
                        for (DBItemInventoryJobChainNode node : this.saveOrUpdateNodeItems) {
                            SaveOrUpdateHelper.saveOrUpdateItem(this.dbLayer, node);
                            LOGGER.debug(String.format("[inventory] job chain nodes for item %1$s saved or updated", node.getName()));
                        }
                    }
                    if (this.deleteItems != null) {
                        for (DbItem item : this.deleteItems) {
                            if (item instanceof DBItemInventoryJob) {
                                this.jobsForDailyPlanUpdate.add((DBItemInventoryJob)item);
                            } else if (item instanceof DBItemInventoryOrder) {
                                this.ordersForDailyPlanUpdate.add((DBItemInventoryOrder)item);
                            } else if (item instanceof DBItemInventorySchedule) {
                                this.schedulesForDailyPlanUpdate.add((DBItemInventorySchedule)item);
                            }
                            this.dbLayer.getSession().delete((Object)item);
                            if (this.getName(item) == null) continue;
                            LOGGER.debug("delete item from DB: " + this.getName(item) + " !");
                            LOGGER.debug(String.format("[inventory] item %1$s deleted", this.getName(item)));
                        }
                        this.deleteItems.clear();
                    }
                    if (processedJobChains != null && !processedJobChains.isEmpty()) {
                        for (DBItemInventoryJobChain jobChain : processedJobChains.keySet()) {
                            HashSet<DBItemInventoryJob> jobsToUpdate = new HashSet<DBItemInventoryJob>();
                            jobsToUpdate.addAll((Collection)processedJobChains.get(jobChain));
                            jobsToUpdate.addAll(this.dbLayer.getAllJobsFromJobChain(jobChain.getInstanceId(), jobChain.getId()));
                            for (DBItemInventoryJob job : jobsToUpdate) {
                                job.setModified(Date.from(Instant.now()));
                            }
                            ArrayList<DBItemInventoryJob> toUpdate = new ArrayList<DBItemInventoryJob>();
                            toUpdate.addAll(jobsToUpdate);
                            this.dbLayer.refreshUsedInJobChains(jobChain.getInstanceId(), toUpdate);
                        }
                        processedJobChains.clear();
                    }
                    if (processedItems != null && !processedItems.isEmpty()) {
                        for (DbItem processedItem : processedItems) {
                            List<DBItemInventoryJob> jobs;
                            DBItemInventoryProcessClass pc;
                            if (processedItem instanceof DBItemInventoryJob) {
                                List<DBItemInventoryJobChainNode> jobChainNodes;
                                DBItemInventoryJob job = (DBItemInventoryJob)processedItem;
                                if (!job.getIsOrderJob() || (jobChainNodes = this.dbLayer.getJobsJobChainNodes(job.getName(), job.getInstanceId())) == null || jobChainNodes.isEmpty()) continue;
                                job.setUsedInJobChains(jobChainNodes.size());
                                this.dbLayer.getSession().update((Object)job);
                                for (DBItemInventoryJobChainNode node : jobChainNodes) {
                                    node.setJobId(job.getId());
                                    this.dbLayer.getSession().update((Object)node);
                                }
                                continue;
                            }
                            if (!(processedItem instanceof DBItemInventoryProcessClass) || !(pc = (DBItemInventoryProcessClass)processedItem).getHasAgents() || (jobs = this.dbLayer.getJobsForProcessClass(pc.getName(), pc.getInstanceId())) == null || jobs.isEmpty()) continue;
                            for (DBItemInventoryJob job : jobs) {
                                job.setProcessClassId(pc.getId());
                                this.dbLayer.getSession().update((Object)job);
                            }
                        }
                    }
                    this.dbLayer.getSession().commit();
                    this.dbLayer.getSession().beginTransaction();
                    if (this.agentsToDelete != null) {
                        for (DBItemInventoryAgentInstance agent : this.agentsToDelete) {
                            this.dbLayer.getSession().delete((Object)agent);
                            if (agent.getUrl() == null) continue;
                            LOGGER.debug(String.format("[inventory] agent with URL %1$s deleted", agent.getUrl()));
                        }
                        this.agentsToDelete.clear();
                    }
                    if (this.agentClusterMembersToDelete != null) {
                        for (DBItemInventoryAgentClusterMember member : this.agentClusterMembersToDelete) {
                            this.dbLayer.getSession().delete((Object)member);
                            if (member.getUrl() == null) continue;
                            LOGGER.debug(String.format("[inventory] agentCluster member with URL %1$s deleted", member.getUrl()));
                        }
                        this.agentClusterMembersToDelete.clear();
                    }
                    if (this.schedulesToCheckForUpdate != null) {
                        for (Long scheduleId : this.schedulesToCheckForUpdate.keySet()) {
                            SaveOrUpdateHelper.updateScheduleIdForOrders(this.dbLayer, this.instance.getId(), scheduleId, this.schedulesToCheckForUpdate.get(scheduleId));
                            SaveOrUpdateHelper.updateScheduleIdForJobs(this.dbLayer, this.instance.getId(), scheduleId, this.schedulesToCheckForUpdate.get(scheduleId));
                        }
                        this.schedulesToCheckForUpdate.clear();
                    }
                    this.dbLayer.getSession().commit();
                    if (this.customEventBus != null && !this.hasDbErrors) {
                        for (String key : this.eventVariables.keySet()) {
                            this.customEventBus.publishCustomEvent(VariablesCustomEvent.keyed((String)key, this.eventVariables.get(key)));
                            LOGGER.info(String.format("[inventory] Custom Event - inventory updated - published on object %1$s!", key));
                        }
                        this.eventVariables.clear();
                    } else {
                        LOGGER.debug("[inventory] Custom Events not published due to errors or EventBus is NULL!");
                    }
                    LOGGER.debug("[inventory] processing of DB transactions finished");
                    try {
                        this.updateDailyPlan();
                        if (this.customEventBus != null && !this.hasDbErrors) {
                            for (String key : this.dailyPlanEventVariables.keySet()) {
                                this.customEventBus.publishCustomEvent(VariablesCustomEvent.keyed((String)key, this.dailyPlanEventVariables.get(key)));
                                LOGGER.info(String.format("[inventory] Custom Event - Daily Plan updated - published on object %1$s!", key));
                            }
                            this.dailyPlanEventVariables.clear();
                        } else {
                            LOGGER.debug("[inventory] Custom Events not published due to errors or EventBus is NULL!");
                        }
                        LOGGER.debug("[inventory] processing of DailyPlan creating DB transactions finished");
                    }
                    catch (Exception e) {
                        LOGGER.warn("[inventory] Error occurred updating Daily Plan: ", (Throwable)e);
                    }
                }
            }
        }
    }

    private void updateDailyPlan() throws Exception {
        DailyPlanCalender2DBFilter dailyPlanCalender2DBFilter;
        HashMap<String, String> values = new HashMap<String, String>();
        boolean hasItemsToUpdate = false;
        Calendar2DB calendar2Db = Calendar2DBHelper.initCalendar2Db(this.dbLayer, this.instance, this.hostFromHttpPort, this.port);
        if (!this.jobsForDailyPlanUpdate.isEmpty()) {
            hasItemsToUpdate = true;
            for (DBItemInventoryJob job : this.jobsForDailyPlanUpdate) {
                dailyPlanCalender2DBFilter = new DailyPlanCalender2DBFilter();
                dailyPlanCalender2DBFilter.setForJob(job.getName());
                calendar2Db.addDailyplan2DBFilter(dailyPlanCalender2DBFilter, this.instance.getId());
            }
        }
        this.jobsForDailyPlanUpdate.clear();
        if (!this.ordersForDailyPlanUpdate.isEmpty()) {
            hasItemsToUpdate = true;
            for (DBItemInventoryOrder order : this.ordersForDailyPlanUpdate) {
                dailyPlanCalender2DBFilter = new DailyPlanCalender2DBFilter();
                dailyPlanCalender2DBFilter.setForJobChain(order.getJobChainName());
                dailyPlanCalender2DBFilter.setForOrderId(order.getOrderId());
                calendar2Db.addDailyplan2DBFilter(dailyPlanCalender2DBFilter, this.instance.getId());
            }
        }
        this.ordersForDailyPlanUpdate.clear();
        if (!this.schedulesForDailyPlanUpdate.isEmpty()) {
            hasItemsToUpdate = true;
            for (DBItemInventorySchedule schedule : this.schedulesForDailyPlanUpdate) {
                dailyPlanCalender2DBFilter = new DailyPlanCalender2DBFilter();
                dailyPlanCalender2DBFilter.setForSchedule(schedule.getName());
                calendar2Db.addDailyplan2DBFilter(dailyPlanCalender2DBFilter, this.instance.getId());
            }
        }
        this.schedulesForDailyPlanUpdate.clear();
        if (hasItemsToUpdate) {
            calendar2Db.processDailyplan2DBFilter();
            values.put(FactEventHandler.CustomEventType.DailyPlanChanged.name(), CUSTOM_EVENT_TYPE_DAILYPLAN_UPDATED);
            this.dailyPlanEventVariables.put("DailyPlan", values);
        }
    }

    private void processEventType(String type, JsonArray events, String lastKey) throws Exception {
        if (!this.closed) {
            switch (type) {
                case "NonEmpty": {
                    this.groupEvents(events, lastKey);
                    for (String key : this.groupedEvents.keySet()) {
                        LOGGER.debug(key);
                    }
                    this.processGroupedEvents(this.groupedEvents);
                    break;
                }
                case "Torn": {
                    LOGGER.warn("Event queue is torn.");
                    this.restartExecution();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long processEvent(JsonObject event) throws SOSHibernateException, SOSInventoryEventProcessingException, Exception {
        Long l;
        String key = null;
        try (SOSHibernateSession dbConnection = null;){
            Object objectType;
            if (!this.closed && event != null) {
                dbConnection = this.factory.openStatelessSession("inventory");
                this.dbLayer = new DBLayerInventory(dbConnection);
                key = event.getString(EVENT_KEY);
                this.eventId = event.getJsonNumber(EVENT_ID).longValue();
                objectType = null;
                String path = null;
                Boolean isCalendarEvent = key.equals(WEBSERVICE_PARAM_VALUE_CALENDAR_EVENT_KEY);
                if (isCalendarEvent.booleanValue()) {
                    objectType = event.getJsonObject("variables").getString("objectType");
                    path = event.getJsonObject("variables").getString(POST_BODY_JSON_KEY);
                    key = (String)objectType + ":" + path;
                } else if (key.contains(":")) {
                    String[] keySplit = key.split(":");
                    objectType = keySplit[0];
                    if (keySplit.length > 1) {
                        path = keySplit[1];
                    }
                } else {
                    Long l2 = this.eventId;
                    return l2;
                }
                if (path != null && !path.isEmpty()) {
                    switch (objectType) {
                        case "Job": 
                        case "JOB": {
                            this.processJobEvent(path, event, key, isCalendarEvent);
                            break;
                        }
                        case "JobChain": {
                            this.processJobChainEvent(path, event, key);
                            break;
                        }
                        case "Order": 
                        case "ORDER": {
                            this.processOrderEvent(path, event, key, isCalendarEvent);
                            break;
                        }
                        case "ProcessClass": {
                            this.processProcessClassEvent(path, event, key);
                            break;
                        }
                        case "Schedule": 
                        case "SCHEDULE": {
                            this.processScheduleEvent(path, event, key, isCalendarEvent);
                            break;
                        }
                        case "Lock": {
                            this.processLockEvent(path, event, key);
                            break;
                        }
                        case "Monitor": {
                            this.processMonitorEvent(path, event, key);
                            break;
                        }
                    }
                }
            }
            objectType = this.eventId;
            return objectType;
        }
    }

    private Path fileExists(String path) {
        if (!this.closed) {
            String normalizePath = path.replaceFirst("^/+", "");
            Path p = this.liveDirectory.resolve(normalizePath);
            if (!Files.exists(p, new LinkOption[0]) && !Files.exists(p = this.cacheDirectory.resolve(normalizePath), new LinkOption[0])) {
                p = null;
            }
            return p;
        }
        return null;
    }

    private DBItemInventoryFile createNewInventoryFile(Long instanceId, Path filePath, String name, String type) {
        if (!this.closed) {
            DBItemInventoryFile dbFile = new DBItemInventoryFile();
            Path path = Paths.get(name, new String[0]);
            String fileDirectory = path.getParent().toString().replace('\\', '/');
            String fileBaseName = path.getFileName().toString();
            dbFile.setFileBaseName(fileBaseName);
            dbFile.setFileDirectory(fileDirectory);
            dbFile.setFileName(name.replace('\\', '/'));
            dbFile.setFileType(type.toLowerCase());
            dbFile.setInstanceId(instanceId);
            if (filePath != null) {
                try {
                    BasicFileAttributes attrs = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                    dbFile.setFileCreated(ReportUtil.convertFileTime2UTC(attrs.creationTime()));
                    dbFile.setFileModified(ReportUtil.convertFileTime2UTC(attrs.lastModifiedTime()));
                    dbFile.setFileLocalCreated(ReportUtil.convertFileTime2Local(attrs.creationTime()));
                    dbFile.setFileLocalModified(ReportUtil.convertFileTime2Local(attrs.lastModifiedTime()));
                }
                catch (IOException e) {
                    LOGGER.warn(String.format("[inventory] cannot read file attributes. file = %1$s, exception = %2$s:%3$s", filePath.toString(), e.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
                }
                catch (Exception e) {
                    LOGGER.warn("[inventory] cannot convert files create and modified timestamps! " + e.getMessage(), (Throwable)e);
                }
            }
            return dbFile;
        }
        return null;
    }

    private void processJobEvent(String path, JsonObject event, String key, Boolean isCalendarEvent) throws Exception {
        block50: {
            if (!this.closed) {
                HashMap<String, String> values = new HashMap<String, String>();
                try {
                    Date now = Date.from(Instant.now());
                    LOGGER.debug(String.format("[inventory] processing event on JOB: %1$s with path: %2$s", Paths.get(path, new String[0]).getFileName(), Paths.get(path, new String[0]).getParent()));
                    Path filePath = this.fileExists(path + EConfigFileExtensions.JOB.extension());
                    if (filePath != null) {
                        LOGGER.debug("filePath: " + filePath.toString());
                    } else {
                        LOGGER.debug("filePath: null");
                    }
                    Long instanceId = null;
                    if (this.instance == null) break block50;
                    instanceId = this.instance.getId();
                    DBItemInventoryJob job = null;
                    if (this.isWindows.booleanValue()) {
                        job = this.dbLayer.getInventoryJobCaseInsensitive(instanceId, path);
                        LOGGER.debug("OS is Windows");
                    } else {
                        job = this.dbLayer.getInventoryJob(instanceId, path);
                        LOGGER.debug("OS is Linux");
                    }
                    DBItemInventoryFile file = this.dbLayer.getInventoryFile(instanceId, path + EConfigFileExtensions.JOB.extension());
                    boolean fileExists = filePath != null;
                    LOGGER.debug("file exists: " + fileExists);
                    if (fileExists) {
                        LOGGER.debug("file found: going to add/update");
                        if (file == null) {
                            file = this.createNewInventoryFile(instanceId, filePath, path + EConfigFileExtensions.JOB.extension(), FILE_TYPE_JOB);
                            file.setCreated(now);
                        } else {
                            try {
                                BasicFileAttributes attrs = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                                file.setFileName((path + EConfigFileExtensions.JOB.extension()).replace('\\', '/'));
                                Path updatedPath = Paths.get(path, new String[0]);
                                String fileDirectory = updatedPath.getParent().toString().replace('\\', '/');
                                file.setFileDirectory(fileDirectory);
                                file.setModified(now);
                                file.setFileModified(ReportUtil.convertFileTime2UTC(attrs.lastModifiedTime()));
                                file.setFileLocalModified(ReportUtil.convertFileTime2Local(attrs.lastModifiedTime()));
                            }
                            catch (IOException e) {
                                LOGGER.warn(String.format("[inventory] cannot read file attributes. file = %1$s, exception = %2$s:%3$s", filePath.toString(), e.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
                            }
                            catch (Exception e) {
                                LOGGER.warn("[inventory] cannot convert files create and modified timestamps! " + e.getMessage(), (Throwable)e);
                            }
                        }
                        if (job == null) {
                            LOGGER.debug("job not found in DB: create new entry");
                            job = new DBItemInventoryJob();
                            job.setCreated(now);
                            job.setInstanceId(instanceId);
                            job.setFileId(file.getId());
                        } else {
                            LOGGER.debug("job found in DB: updating entry");
                        }
                        job.setName(path);
                        job.setBaseName(Paths.get(path, new String[0]).getFileName().toString());
                        SOSXMLXPath xPath = new SOSXMLXPath(filePath.toString());
                        String title = ReportXmlHelper.getTitle(xPath);
                        String criticality = ReportXmlHelper.getCriticality(xPath);
                        boolean isOrderJob = ReportXmlHelper.isOrderJob(xPath);
                        boolean isRuntimeDefined = ReportXmlHelper.isRuntimeDefined(xPath);
                        job.setTitle(title);
                        if (criticality != null && !criticality.isEmpty()) {
                            job.setCriticality(criticality);
                        } else {
                            job.setCriticality(SOSJobSchedulerGlobal.JOB_CRITICALITY.NORMAL.toString());
                        }
                        job.setIsOrderJob(isOrderJob);
                        job.setIsRuntimeDefined(isRuntimeDefined);
                        job.setRunTimeIsTemporary(false);
                        if (xPath.getRoot().hasAttribute(FILE_TYPE_PROCESS_CLASS)) {
                            String processClass = ReportXmlHelper.getProcessClass(xPath);
                            if (processClass != null) {
                                Path jobPath = Paths.get(job.getName(), new String[0]);
                                String resolvedProcessClassPath = jobPath.getParent().resolve(processClass).normalize().toString().replace('\\', '/');
                                DBItemInventoryProcessClass ipc = this.dbLayer.getProcessClassIfExists(instanceId, resolvedProcessClassPath);
                                if (ipc != null) {
                                    job.setProcessClass(processClass);
                                    job.setProcessClassName(ipc.getName());
                                    job.setProcessClassId(ipc.getId());
                                } else {
                                    job.setProcessClass(processClass);
                                    job.setProcessClassName(resolvedProcessClassPath);
                                    job.setProcessClassId(DBLayer.DEFAULT_ID);
                                }
                            } else {
                                job.setProcessClass(null);
                                job.setProcessClassId(DBLayer.DEFAULT_ID);
                                job.setProcessClassName(".");
                            }
                        } else {
                            job.setProcessClass(null);
                            job.setProcessClassId(DBLayer.DEFAULT_ID);
                            job.setProcessClassName(".");
                        }
                        String schedule = ReportXmlHelper.getScheduleFromRuntime(xPath);
                        if (schedule != null && !schedule.isEmpty()) {
                            String scheduleName = Paths.get(path, new String[0]).getParent().resolve(schedule).normalize().toString().replace("\\", POST_BODY_JSON_VALUE);
                            DBItemInventorySchedule is = this.dbLayer.getScheduleIfExists(instanceId, scheduleName);
                            if (is != null) {
                                job.setSchedule(schedule);
                                job.setScheduleName(is.getName());
                                job.setScheduleId(is.getId());
                            } else {
                                job.setSchedule(schedule);
                                job.setScheduleName(scheduleName);
                                job.setScheduleId(DBLayer.DEFAULT_ID);
                            }
                        } else {
                            job.setScheduleId(DBLayer.DEFAULT_ID);
                            job.setScheduleName(".");
                        }
                        String maxTasks = xPath.getRoot().getAttribute("tasks");
                        if (maxTasks != null && !maxTasks.isEmpty()) {
                            job.setMaxTasks(Integer.parseInt(maxTasks));
                        } else {
                            job.setMaxTasks(1);
                        }
                        Boolean hasDescription = ReportXmlHelper.hasDescription(xPath);
                        if (hasDescription != null) {
                            job.setHasDescription(ReportXmlHelper.hasDescription(xPath));
                        }
                        Node scriptNode = xPath.selectSingleNode("/job/script");
                        boolean isYadeJob = false;
                        if (scriptNode != null) {
                            if (((Element)scriptNode).hasAttribute("java_class")) {
                                String script;
                                switch (script = ((Element)scriptNode).getAttribute("java_class")) {
                                    case "sos.scheduler.jade.JadeJob": 
                                    case "sos.scheduler.jade.Jade4DMZJob": 
                                    case "sos.scheduler.jade.SFTPSendJob": 
                                    case "sos.scheduler.jade.SFTPReceiveJob": 
                                    case "sos.scheduler.job.SOSDExJSAdapterClass": 
                                    case "sos.scheduler.job.SOSJade4DMZJSAdapter": {
                                        isYadeJob = true;
                                        break;
                                    }
                                    default: {
                                        isYadeJob = false;
                                    }
                                }
                            }
                            if (((Element)scriptNode).hasAttribute("language")) {
                                job.setScriptLanguage(((Element)scriptNode).getAttribute("language"));
                            }
                        }
                        job.setIsYadeJob(isYadeJob);
                        job.setModified(now);
                        file.setModified(now);
                        if (schedule == null || schedule.isEmpty()) {
                            this.updateRuntimeAndCalendarUsage(CALENDAR_OBJECT_TYPE_JOB, job, xPath, isCalendarEvent);
                        }
                        this.saveOrUpdateItems.add(file);
                        this.saveOrUpdateItems.add(job);
                        String docuPath = xPath.selectSingleNodeValue("description/include/@file");
                        if (docuPath != null && (docuPath.startsWith("jobs/") || docuPath.startsWith("./jobs/"))) {
                            docuPath = docuPath.replaceFirst("jobs", DEFAULT_JOB_DOC_PATH);
                            this.createOrUpdateDocumentationUsage(this.dbLayer.getSession(), this.instance.getSchedulerId(), docuPath, job.getId(), job.getName(), CALENDAR_OBJECT_TYPE_JOB);
                        }
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_UPDATED);
                    } else if (!fileExists && job != null) {
                        this.deleteCalendarUsages(job);
                        this.deleteItems.add(job);
                        if (file != null) {
                            this.deleteItems.add(file);
                        }
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_REMOVED);
                    }
                    this.eventVariables.put(key, values);
                }
                catch (SOSHibernateInvalidSessionException e) {
                    this.hasDbErrors = true;
                    throw e;
                }
                catch (SAXParseException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void processJobChainEvent(String path, JsonObject event, String key) throws Exception {
        block30: {
            if (!this.closed) {
                HashMap<String, String> values = new HashMap<String, String>();
                try {
                    Date now = Date.from(Instant.now());
                    Path filePath = this.fileExists(path + EConfigFileExtensions.JOB_CHAIN.extension());
                    if (filePath != null) {
                        LOGGER.debug("filePath: " + filePath.toString());
                    } else {
                        LOGGER.debug("filePath: null");
                    }
                    Long instanceId = null;
                    if (this.instance == null) break block30;
                    instanceId = this.instance.getId();
                    LOGGER.debug(String.format("[inventory] processing event on JOBCHAIN: %1$s with path: %2$s", Paths.get(path, new String[0]).getFileName(), Paths.get(path, new String[0]).getParent()));
                    DBItemInventoryJobChain jobChain = null;
                    if (this.isWindows.booleanValue()) {
                        jobChain = this.dbLayer.getInventoryJobChainCaseInsensitive(instanceId, path);
                        LOGGER.debug("OS is Windows");
                    } else {
                        jobChain = this.dbLayer.getInventoryJobChain(instanceId, path);
                        LOGGER.debug("OS is Linux");
                    }
                    DBItemInventoryFile file = this.dbLayer.getInventoryFile(instanceId, path + EConfigFileExtensions.JOB_CHAIN.extension());
                    boolean fileExists = filePath != null;
                    LOGGER.debug("file exists: " + fileExists);
                    if (fileExists) {
                        DBItemInventoryProcessClass ipc;
                        Path jobChainPath;
                        LOGGER.debug("file found: going to add/update");
                        if (file == null) {
                            file = this.createNewInventoryFile(instanceId, filePath, path + EConfigFileExtensions.JOB_CHAIN.extension(), FILE_TYPE_JOBCHAIN);
                            file.setCreated(now);
                        } else {
                            try {
                                BasicFileAttributes attrs = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                                file.setFileName((path + EConfigFileExtensions.JOB_CHAIN.extension()).replace('\\', '/'));
                                Path updatedPath = Paths.get(path, new String[0]);
                                String fileDirectory = updatedPath.getParent().toString().replace('\\', '/');
                                file.setFileDirectory(fileDirectory);
                                file.setModified(now);
                                file.setFileModified(ReportUtil.convertFileTime2UTC(attrs.lastModifiedTime()));
                                file.setFileLocalModified(ReportUtil.convertFileTime2Local(attrs.lastModifiedTime()));
                            }
                            catch (IOException e) {
                                LOGGER.warn(String.format("[inventory] cannot read file attributes. file = %1$s, exception = %2$s:%3$s", filePath.toString(), e.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
                            }
                            catch (Exception e) {
                                LOGGER.warn("[inventory] cannot convert files create and modified timestamps! " + e.getMessage(), (Throwable)e);
                            }
                        }
                        if (jobChain == null) {
                            LOGGER.debug("jobChain not found in DB: create new entry");
                            jobChain = new DBItemInventoryJobChain();
                            jobChain.setInstanceId(instanceId);
                            jobChain.setCreated(now);
                        } else {
                            LOGGER.debug("jobChain found in DB: updating entry");
                        }
                        jobChain.setName(path);
                        jobChain.setBaseName(Paths.get(path, new String[0]).getFileName().toString());
                        SOSXMLXPath xpath = new SOSXMLXPath(filePath.toString());
                        if (xpath.getRoot() == null) {
                            throw new SOSInventoryEventProcessingException("xpath document element missing");
                        }
                        String title = ReportXmlHelper.getTitle(xpath);
                        String startCause = ReportXmlHelper.getJobChainStartCause(xpath);
                        jobChain.setTitle(title);
                        jobChain.setStartCause(startCause);
                        String maxOrders = xpath.getRoot().getAttribute("max_orders");
                        if (maxOrders != null && !maxOrders.isEmpty()) {
                            jobChain.setMaxOrders(Integer.parseInt(maxOrders));
                        }
                        jobChain.setDistributed(xpath.getRoot().hasAttribute("distributed") && "yes,1,true".contains(xpath.getRoot().getAttribute("distributed")));
                        if (xpath.getRoot().hasAttribute(FILE_TYPE_PROCESS_CLASS)) {
                            String processClass = ReportXmlHelper.getProcessClass(xpath);
                            jobChainPath = Paths.get(jobChain.getName(), new String[0]);
                            String resolvedProcessClassPath = jobChainPath.getParent().resolve(processClass).normalize().toString().replace('\\', '/');
                            ipc = this.dbLayer.getProcessClassIfExists(instanceId, resolvedProcessClassPath);
                            if (ipc != null) {
                                jobChain.setProcessClass(processClass);
                                jobChain.setProcessClassName(ipc.getName());
                                jobChain.setProcessClassId(ipc.getId());
                            } else {
                                jobChain.setProcessClass(processClass);
                                jobChain.setProcessClassName(resolvedProcessClassPath);
                                jobChain.setProcessClassId(DBLayer.DEFAULT_ID);
                            }
                        } else {
                            jobChain.setProcessClass(null);
                            jobChain.setProcessClassName(".");
                            jobChain.setProcessClassId(DBLayer.DEFAULT_ID);
                        }
                        if (xpath.getRoot().hasAttribute("file_watching_process_class")) {
                            String fwProcessClass = ReportXmlHelper.getFileWatchingProcessClass(xpath);
                            jobChainPath = Paths.get(jobChain.getName(), new String[0]);
                            String resolvedFwProcessClassPath = jobChainPath.getParent().resolve(fwProcessClass).normalize().toString().replace('\\', '/');
                            ipc = this.dbLayer.getProcessClassIfExists(instanceId, resolvedFwProcessClassPath);
                            if (ipc != null) {
                                jobChain.setFileWatchingProcessClass(fwProcessClass);
                                jobChain.setFileWatchingProcessClassName(ipc.getName());
                                jobChain.setFileWatchingProcessClassId(ipc.getId());
                            } else {
                                jobChain.setFileWatchingProcessClass(fwProcessClass);
                                jobChain.setFileWatchingProcessClassName(resolvedFwProcessClassPath);
                                jobChain.setFileWatchingProcessClassId(DBLayer.DEFAULT_ID);
                            }
                        } else {
                            jobChain.setFileWatchingProcessClass(null);
                            jobChain.setFileWatchingProcessClassName(".");
                            jobChain.setFileWatchingProcessClassId(DBLayer.DEFAULT_ID);
                        }
                        NodeList nl = ReportXmlHelper.getRootChilds(xpath);
                        jobChain.setModified(now);
                        file.setModified(now);
                        this.saveOrUpdateItems.add(file);
                        this.saveOrUpdateItems.add(jobChain);
                        this.jobChainNodesToSave.put(jobChain.getName(), nl);
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_UPDATED);
                    } else if (!fileExists && jobChain != null) {
                        List<DBItemInventoryJobChainNode> nodes = this.dbLayer.getJobChainNodes(instanceId, jobChain.getId());
                        if (nodes != null && !nodes.isEmpty()) {
                            this.deleteItems.addAll(nodes);
                        }
                        this.deleteItems.add(jobChain);
                        if (file != null) {
                            this.deleteItems.add(file);
                        }
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_REMOVED);
                    }
                    this.eventVariables.put(key, values);
                }
                catch (SOSHibernateInvalidSessionException e) {
                    this.hasDbErrors = true;
                    throw e;
                }
                catch (SAXParseException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void createJobChainNodes(NodeList nl, DBItemInventoryJobChain jobChain) throws Exception {
        if (!this.closed) {
            Date now = Date.from(Instant.now());
            int ordering = 1;
            try {
                if (nl != null) {
                    for (int j = 0; j < nl.getLength(); ++j) {
                        DBItemInventoryJobChainNode node;
                        Element jobChainNodeElement = (Element)nl.item(j);
                        String jobName = null;
                        String nodeName = jobChainNodeElement.getNodeName();
                        String job = jobChainNodeElement.getAttribute(FILE_TYPE_JOB);
                        String state = jobChainNodeElement.getAttribute(EVENT_STATE_KEY);
                        String nextState = jobChainNodeElement.getAttribute("next_state");
                        String errorState = jobChainNodeElement.getAttribute("error_state");
                        Integer nodeType = this.getJobChainNodeType(nodeName, jobChainNodeElement);
                        String directory = jobChainNodeElement.getAttribute("directory");
                        String regex = null;
                        if (jobChainNodeElement.hasAttribute("regex")) {
                            regex = jobChainNodeElement.getAttribute("regex");
                        }
                        if ((node = this.dbLayer.getJobChainNodeIfExists(jobChain.getInstanceId(), jobChain.getId(), nodeType, state, directory, regex)) == null) {
                            node = new DBItemInventoryJobChainNode();
                            node.setInstanceId(jobChain.getInstanceId());
                            node.setJobChainId(jobChain.getId());
                            node.setState(state);
                            node.setCreated(now);
                        }
                        node.setName(nodeName);
                        node.setNextState(nextState);
                        node.setErrorState(errorState);
                        node.setCreated(ReportUtil.getCurrentDateTime());
                        node.setModified(ReportUtil.getCurrentDateTime());
                        node.setNestedJobChainId(DBLayer.DEFAULT_ID);
                        node.setNestedJobChainName(".");
                        if (job != null && !job.isEmpty()) {
                            Path jobPath = Paths.get(jobChain.getName(), new String[0]).getParent().resolve(job).normalize();
                            jobName = jobPath.toString().replace("\\", POST_BODY_JSON_VALUE);
                            if (jobName != null && !jobName.isEmpty()) {
                                node.setJobName(jobName);
                            } else {
                                node.setJobName(".");
                            }
                            node.setJob(job);
                            DBItemInventoryJob jobDbItem = this.dbLayer.getJobIfExists(jobChain.getInstanceId(), jobName);
                            if (jobDbItem != null) {
                                node.setJobId(jobDbItem.getId());
                            } else {
                                node.setJobId(DBLayer.DEFAULT_ID);
                            }
                        } else {
                            node.setJob(null);
                            node.setJobId(DBLayer.DEFAULT_ID);
                            node.setJobName(".");
                        }
                        node.setNodeType(nodeType);
                        switch (node.getNodeType()) {
                            case 1: {
                                String delay;
                                if (jobChainNodeElement.hasAttribute("delay") && (delay = jobChainNodeElement.getAttribute("delay")) != null && !delay.isEmpty()) {
                                    node.setDelay(Integer.parseInt(delay));
                                }
                                if (!jobChainNodeElement.hasAttribute("on_error")) break;
                                node.setOnError(jobChainNodeElement.getAttribute("on_error"));
                                break;
                            }
                            case 2: {
                                if (jobChainNodeElement.hasAttribute(FILE_TYPE_JOBCHAIN)) {
                                    String jobchain = jobChainNodeElement.getAttribute(FILE_TYPE_JOBCHAIN);
                                    Path jobChainPath = Paths.get(jobChain.getName(), new String[0]);
                                    String nestedJobChain = jobChainPath.getParent().resolve(jobchain).normalize().toString().replace('\\', '/');
                                    DBItemInventoryJobChain ijc = this.dbLayer.getJobChain(jobChain.getInstanceId(), nestedJobChain);
                                    if (ijc != null) {
                                        node.setNestedJobChain(jobchain);
                                        node.setNestedJobChainName(ijc.getName());
                                        node.setNestedJobChainId(ijc.getId());
                                        break;
                                    }
                                    node.setNestedJobChain(jobchain);
                                    node.setNestedJobChainName(nestedJobChain);
                                    node.setNestedJobChainId(DBLayer.DEFAULT_ID);
                                    break;
                                }
                                node.setNestedJobChain(null);
                                node.setNestedJobChainId(DBLayer.DEFAULT_ID);
                                node.setNestedJobChainName(".");
                                break;
                            }
                            case 3: {
                                node.setDirectory(directory);
                                if (regex == null) break;
                                node.setRegex(regex);
                                break;
                            }
                            case 4: {
                                if (jobChainNodeElement.hasAttribute("move_to")) {
                                    node.setMovePath(jobChainNodeElement.getAttribute("move_to"));
                                    node.setFileSinkOp(1);
                                    break;
                                }
                                node.setFileSinkOp(2);
                                break;
                            }
                        }
                        node.setInstanceId(jobChain.getInstanceId());
                        node.setOrdering(new Long(ordering));
                        node.setModified(now);
                        this.saveOrUpdateNodeItems.add(node);
                        ++ordering;
                    }
                }
            }
            catch (SOSHibernateInvalidSessionException e) {
                this.hasDbErrors = true;
                throw e;
            }
        }
    }

    private void processOrderEvent(String path, JsonObject event, String key, Boolean isCalendarEvent) throws Exception {
        block30: {
            if (!this.closed) {
                HashMap<String, String> values = new HashMap<String, String>();
                try {
                    Date now = Date.from(Instant.now());
                    Path filePath = this.fileExists(path + EConfigFileExtensions.ORDER.extension());
                    if (filePath != null) {
                        LOGGER.debug("filePath: " + filePath.toString());
                    } else {
                        LOGGER.debug("filePath: null");
                    }
                    Long instanceId = null;
                    if (this.instance == null) break block30;
                    instanceId = this.instance.getId();
                    LOGGER.debug(String.format("[inventory] processing event on ORDER: %1$s with path: %2$s", Paths.get(path, new String[0]).getFileName(), Paths.get(path, new String[0]).getParent()));
                    DBItemInventoryOrder order = null;
                    if (this.isWindows.booleanValue()) {
                        order = this.dbLayer.getInventoryOrderCaseInsensitive(instanceId, path);
                        LOGGER.debug("OS is Windows");
                    } else {
                        order = this.dbLayer.getInventoryOrder(instanceId, path);
                        LOGGER.debug("OS is Linux");
                    }
                    DBItemInventoryFile file = this.dbLayer.getInventoryFile(instanceId, path + EConfigFileExtensions.ORDER.extension());
                    boolean fileExists = filePath != null;
                    LOGGER.debug("file exists: " + fileExists);
                    if (fileExists) {
                        String schedule;
                        String priority;
                        LOGGER.debug("file found: going to add/update");
                        if (file == null) {
                            file = this.createNewInventoryFile(instanceId, filePath, path + EConfigFileExtensions.ORDER.extension(), FILE_TYPE_ORDER);
                            file.setCreated(now);
                        } else {
                            try {
                                BasicFileAttributes attrs = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                                file.setFileName((path + EConfigFileExtensions.ORDER.extension()).replace('\\', '/'));
                                Path updatedPath = Paths.get(path, new String[0]);
                                String fileDirectory = updatedPath.getParent().toString().replace('\\', '/');
                                file.setFileDirectory(fileDirectory);
                                file.setModified(now);
                                file.setFileModified(ReportUtil.convertFileTime2UTC(attrs.lastModifiedTime()));
                                file.setFileLocalModified(ReportUtil.convertFileTime2Local(attrs.lastModifiedTime()));
                            }
                            catch (IOException e) {
                                LOGGER.warn(String.format("[inventory] cannot read file attributes. file = %1$s, exception = %2$s:%3$s", filePath.toString(), e.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
                            }
                            catch (Exception e) {
                                LOGGER.warn("[inventory] cannot convert files create and modified timestamps! " + e.getMessage(), (Throwable)e);
                            }
                        }
                        String baseName = Paths.get(path, new String[0]).getFileName().toString();
                        if (order == null) {
                            LOGGER.debug("order not found in DB: create new entry");
                            order = new DBItemInventoryOrder();
                            order.setInstanceId(instanceId);
                            order.setCreated(now);
                        } else {
                            LOGGER.debug("order found in DB: updating entry");
                        }
                        SOSXMLXPath xpath = new SOSXMLXPath(filePath.toString());
                        if (xpath.getRoot() == null) {
                            throw new SOSInventoryEventProcessingException(String.format("xpath document element missing", new Object[0]));
                        }
                        String title = ReportXmlHelper.getTitle(xpath);
                        String jobChainName = path.substring(0, path.indexOf(","));
                        String orderId = baseName.substring(baseName.lastIndexOf(",") + 1);
                        boolean isRuntimeDefined = ReportXmlHelper.isRuntimeDefined(xpath);
                        order.setFileId(file.getId());
                        order.setJobChainName(jobChainName);
                        order.setName(path);
                        order.setBaseName(baseName);
                        order.setOrderId(orderId);
                        order.setTitle(title);
                        order.setIsRuntimeDefined(isRuntimeDefined);
                        order.setRunTimeIsTemporary(false);
                        Long jobChainId = this.dbLayer.getJobChainId(instanceId, jobChainName);
                        if (jobChainId != null) {
                            order.setJobChainId(jobChainId);
                        } else {
                            order.setJobChainId(DBLayer.DEFAULT_ID);
                        }
                        if (xpath.getRoot().hasAttribute(EVENT_STATE_KEY)) {
                            order.setInitialState(xpath.getRoot().getAttribute(EVENT_STATE_KEY));
                        }
                        if (xpath.getRoot().hasAttribute("end_state")) {
                            order.setEndState(xpath.getRoot().getAttribute("end_state"));
                        }
                        if (xpath.getRoot().hasAttribute("priority") && (priority = xpath.getRoot().getAttribute("priority")) != null && !priority.isEmpty()) {
                            order.setPriority(Integer.parseInt(priority));
                        }
                        if ((schedule = ReportXmlHelper.getScheduleFromRuntime(xpath)) != null && !schedule.isEmpty()) {
                            String scheduleName = Paths.get(path, new String[0]).getParent().resolve(schedule).normalize().toString().replace("\\", POST_BODY_JSON_VALUE);
                            DBItemInventorySchedule is = this.dbLayer.getScheduleIfExists(instanceId, scheduleName);
                            if (is != null) {
                                order.setSchedule(schedule);
                                order.setScheduleName(is.getName());
                                order.setScheduleId(is.getId());
                            } else {
                                order.setSchedule(schedule);
                                order.setScheduleName(scheduleName);
                                order.setScheduleId(DBLayer.DEFAULT_ID);
                            }
                        } else {
                            order.setSchedule(null);
                            order.setScheduleId(DBLayer.DEFAULT_ID);
                            order.setScheduleName(".");
                        }
                        order.setModified(now);
                        file.setModified(now);
                        if (schedule == null || schedule.isEmpty()) {
                            this.updateRuntimeAndCalendarUsage(CALENDAR_OBJECT_TYPE_ORDER, order, xpath, isCalendarEvent);
                        }
                        this.saveOrUpdateItems.add(file);
                        this.saveOrUpdateItems.add(order);
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_UPDATED);
                    } else if (!fileExists && order != null) {
                        this.deleteCalendarUsages(order);
                        this.deleteItems.add(order);
                        if (file != null) {
                            this.deleteItems.add(file);
                        }
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_REMOVED);
                    }
                    this.eventVariables.put(key, values);
                }
                catch (SOSHibernateInvalidSessionException e) {
                    this.hasDbErrors = true;
                    throw e;
                }
                catch (SAXParseException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void processProcessClassEvent(String path, JsonObject event, String key) throws Exception {
        block15: {
            if (!this.closed) {
                HashMap<String, String> values = new HashMap<String, String>();
                try {
                    boolean fileExists;
                    Date now = Date.from(Instant.now());
                    Path filePath = this.fileExists(path + EConfigFileExtensions.PROCESS_CLASS.extension());
                    Long instanceId = null;
                    if (this.instance == null) break block15;
                    instanceId = this.instance.getId();
                    LOGGER.debug(String.format("[inventory] processing event on PROCESS_CLASS: %1$s with path: %2$s", Paths.get(path, new String[0]).getFileName(), Paths.get(path, new String[0]).getParent()));
                    DBItemInventoryProcessClass pc = null;
                    pc = this.isWindows != false ? this.dbLayer.getInventoryProcessClassCaseInsensitive(instanceId, path) : this.dbLayer.getInventoryProcessClass(instanceId, path);
                    DBItemInventoryFile file = this.dbLayer.getInventoryFile(instanceId, path + EConfigFileExtensions.PROCESS_CLASS.extension());
                    boolean bl = fileExists = filePath != null;
                    if (fileExists) {
                        String fileType;
                        SOSXMLXPath xpath = new SOSXMLXPath(filePath);
                        if (xpath.getRoot() == null) {
                            throw new Exception(String.format("xpath document element missing", new Object[0]));
                        }
                        boolean hasAgent = ReportXmlHelper.hasAgents(xpath);
                        String string = fileType = hasAgent ? FILE_TYPE_AGENT_CLUSTER : FILE_TYPE_PROCESS_CLASS;
                        if (file == null) {
                            file = this.createNewInventoryFile(instanceId, filePath, path + EConfigFileExtensions.PROCESS_CLASS.extension(), fileType);
                            file.setCreated(now);
                        } else {
                            try {
                                BasicFileAttributes attrs = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                                file.setFileName((path + EConfigFileExtensions.PROCESS_CLASS.extension()).replace('\\', '/'));
                                Path updatedPath = Paths.get(path, new String[0]);
                                String fileDirectory = updatedPath.getParent().toString().replace('\\', '/');
                                file.setFileDirectory(fileDirectory);
                                file.setModified(now);
                                file.setFileModified(ReportUtil.convertFileTime2UTC(attrs.lastModifiedTime()));
                                file.setFileLocalModified(ReportUtil.convertFileTime2Local(attrs.lastModifiedTime()));
                                file.setFileType(fileType);
                            }
                            catch (IOException e) {
                                LOGGER.warn(String.format("[inventory] cannot read file attributes. file = %1$s, exception = %2$s:%3$s", filePath.toString(), e.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
                            }
                            catch (Exception e) {
                                LOGGER.warn("[inventory] cannot convert files create and modified timestamps! " + e.getMessage(), (Throwable)e);
                            }
                        }
                        if (pc == null) {
                            pc = new DBItemInventoryProcessClass();
                            pc.setInstanceId(instanceId);
                            pc.setCreated(now);
                            pc.setFileId(file.getId());
                        }
                        pc.setName(path);
                        pc.setBasename(Paths.get(path, new String[0]).getFileName().toString());
                        pc.setMaxProcesses(ReportXmlHelper.getMaxProcesses(xpath));
                        pc.setHasAgents(hasAgent);
                        pc.setModified(now);
                        file.setModified(now);
                        this.saveOrUpdateItems.add(file);
                        this.saveOrUpdateItems.add(pc);
                        NodeList remoteSchedulersParent = xpath.selectNodeList("/process_class/remote_schedulers");
                        this.remoteSchedulersToSave.put(pc, remoteSchedulersParent);
                        this.pcXpaths.put(pc.getName(), xpath);
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_UPDATED);
                    } else if (!fileExists && pc != null) {
                        this.deleteItems.add(pc);
                        if (file != null) {
                            this.deleteItems.add(file);
                        }
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_REMOVED);
                    }
                    this.eventVariables.put(key, values);
                }
                catch (SOSHibernateInvalidSessionException e) {
                    this.hasDbErrors = true;
                    throw e;
                }
                catch (SAXParseException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void processScheduleEvent(String path, JsonObject event, String key, Boolean isCalendarEvent) throws Exception {
        block20: {
            if (!this.closed) {
                HashMap<String, String> values = new HashMap<String, String>();
                try {
                    boolean fileExists;
                    Date now = Date.from(Instant.now());
                    Path filePath = this.fileExists(path + EConfigFileExtensions.SCHEDULE.extension());
                    Long instanceId = null;
                    if (this.instance == null) break block20;
                    instanceId = this.instance.getId();
                    LOGGER.debug(String.format("[inventory] processing event on SCHEDULE: %1$s with path: %2$s", Paths.get(path, new String[0]).getFileName(), Paths.get(path, new String[0]).getParent()));
                    DBItemInventorySchedule schedule = null;
                    schedule = this.isWindows != false ? this.dbLayer.getInventoryScheduleCaseInsensitive(instanceId, path) : this.dbLayer.getInventorySchedule(instanceId, path);
                    DBItemInventoryFile file = this.dbLayer.getInventoryFile(instanceId, path + EConfigFileExtensions.SCHEDULE.extension());
                    boolean bl = fileExists = filePath != null;
                    if (fileExists) {
                        if (file == null) {
                            file = this.createNewInventoryFile(instanceId, filePath, path + EConfigFileExtensions.SCHEDULE.extension(), FILE_TYPE_SCHEDULE);
                            file.setCreated(now);
                        } else {
                            try {
                                BasicFileAttributes attrs = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                                file.setFileName((path + EConfigFileExtensions.SCHEDULE.extension()).replace('\\', '/'));
                                Path updatedPath = Paths.get(path, new String[0]);
                                String fileDirectory = updatedPath.getParent().toString().replace('\\', '/');
                                file.setFileDirectory(fileDirectory);
                                file.setModified(now);
                                file.setFileModified(ReportUtil.convertFileTime2UTC(attrs.lastModifiedTime()));
                                file.setFileLocalModified(ReportUtil.convertFileTime2Local(attrs.lastModifiedTime()));
                            }
                            catch (IOException e) {
                                LOGGER.warn(String.format("[inventory] cannot read file attributes. file = %1$s, exception = %2$s:%3$s", filePath.toString(), e.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
                            }
                            catch (Exception e) {
                                LOGGER.warn("[inventory] cannot convert files create and modified timestamps! " + e.getMessage(), (Throwable)e);
                            }
                        }
                        if (schedule == null) {
                            schedule = new DBItemInventorySchedule();
                            schedule.setFileId(file.getId());
                            schedule.setInstanceId(instanceId);
                            schedule.setCreated(now);
                        }
                        schedule.setName(path);
                        schedule.setBasename(Paths.get(path, new String[0]).getFileName().toString());
                        SOSXMLXPath xpath = new SOSXMLXPath(filePath.toString());
                        if (xpath.getRoot() == null) {
                            throw new SOSInventoryEventProcessingException(String.format("xpath document element missing", new Object[0]));
                        }
                        schedule.setTitle(ReportXmlHelper.getTitle(xpath));
                        schedule.setSubstitute(ReportXmlHelper.getSubstitute(xpath));
                        schedule.setSubstituteValidFrom(ReportXmlHelper.getSubstituteValidFromTo(xpath, "valid_from", this.timezone));
                        schedule.setSubstituteValidTo(ReportXmlHelper.getSubstituteValidFromTo(xpath, "valid_to", this.timezone));
                        boolean pathNormalizationFailure = false;
                        Path parentPath = Paths.get(schedule.getName(), new String[0]).getParent();
                        DBItemInventorySchedule substituteItem = this.dbLayer.getSubstituteIfExists(parentPath.resolve(schedule.getSubstitute()).normalize().toString().replace("\\", POST_BODY_JSON_VALUE), schedule.getInstanceId());
                        if (substituteItem != null) {
                            schedule.setSubstituteId(substituteItem.getId());
                            try {
                                schedule.setSubstituteName(parentPath.resolve(substituteItem.getName()).normalize().toString().replace("\\", POST_BODY_JSON_VALUE));
                            }
                            catch (Exception e) {
                                pathNormalizationFailure = true;
                            }
                        } else {
                            schedule.setSubstituteId(DBLayer.DEFAULT_ID);
                            schedule.setSubstituteName(".");
                        }
                        schedule.setModified(now);
                        file.setModified(now);
                        if (!pathNormalizationFailure) {
                            this.updateRuntimeAndCalendarUsage(CALENDAR_OBJECT_TYPE_SCHEDULE, schedule, xpath, isCalendarEvent);
                            List<DBItemInventoryClusterCalendarUsage> dbCalendarUsages = this.dbLayer.getAllCalendarUsagesForObject(this.schedulerId, schedule.getName(), CALENDAR_OBJECT_TYPE_SCHEDULE);
                            InventoryRuntimeHelper.recalculateRuntime(this.dbLayer, CALENDAR_OBJECT_TYPE_SCHEDULE, schedule.getName(), EConfigFileExtensions.SCHEDULE.extension(), dbCalendarUsages, this.liveDirectory, this.timezone);
                            this.saveOrUpdateItems.add(file);
                            this.saveOrUpdateItems.add(schedule);
                            values.put("InventoryEventUpdateFinished", EVENT_TYPE_UPDATED);
                        }
                    } else if (!fileExists && schedule != null) {
                        this.deleteCalendarUsages(schedule);
                        this.deleteItems.add(schedule);
                        if (file != null) {
                            this.deleteItems.add(file);
                        }
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_REMOVED);
                    }
                    this.eventVariables.put(key, values);
                }
                catch (SOSHibernateInvalidSessionException e) {
                    this.hasDbErrors = true;
                    throw e;
                }
                catch (SAXParseException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void processLockEvent(String path, JsonObject event, String key) throws Exception {
        block15: {
            if (!this.closed) {
                HashMap<String, String> values = new HashMap<String, String>();
                try {
                    boolean fileExists;
                    Date now = Date.from(Instant.now());
                    Path filePath = this.fileExists(path + EConfigFileExtensions.LOCK.extension());
                    Long instanceId = null;
                    if (this.instance == null) break block15;
                    instanceId = this.instance.getId();
                    LOGGER.debug(String.format("[inventory] processing event on LOCK: %1$s with path: %2$s", Paths.get(path, new String[0]).getFileName(), Paths.get(path, new String[0]).getParent()));
                    DBItemInventoryLock lock = null;
                    lock = this.isWindows != false ? this.dbLayer.getInventoryLockCaseInsensitive(instanceId, path) : this.dbLayer.getInventoryLock(instanceId, path);
                    DBItemInventoryFile file = this.dbLayer.getInventoryFile(instanceId, path + EConfigFileExtensions.LOCK.extension());
                    boolean bl = fileExists = filePath != null;
                    if (fileExists) {
                        if (file == null) {
                            file = this.createNewInventoryFile(instanceId, filePath, path + EConfigFileExtensions.LOCK.extension(), FILE_TYPE_LOCK);
                            file.setCreated(now);
                        } else {
                            try {
                                BasicFileAttributes attrs = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                                file.setFileName((path + EConfigFileExtensions.LOCK.extension()).replace('\\', '/'));
                                Path updatedPath = Paths.get(path, new String[0]);
                                String fileDirectory = updatedPath.getParent().toString().replace('\\', '/');
                                file.setFileDirectory(fileDirectory);
                                file.setModified(now);
                                file.setFileModified(ReportUtil.convertFileTime2UTC(attrs.lastModifiedTime()));
                                file.setFileLocalModified(ReportUtil.convertFileTime2Local(attrs.lastModifiedTime()));
                            }
                            catch (IOException e) {
                                LOGGER.warn(String.format("[inventory] cannot read file attributes. file = %1$s, exception = %2$s:%3$s", filePath.toString(), e.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
                            }
                            catch (Exception e) {
                                LOGGER.warn("[inventory] cannot convert files create and modified timestamps! " + e.getMessage(), (Throwable)e);
                            }
                        }
                        if (lock == null) {
                            lock = new DBItemInventoryLock();
                            lock.setInstanceId(instanceId);
                            lock.setFileId(file.getId());
                            lock.setCreated(now);
                        }
                        lock.setName(path);
                        lock.setBasename(Paths.get(path, new String[0]).getFileName().toString());
                        SOSXMLXPath xpath = new SOSXMLXPath(filePath.toString());
                        if (xpath.getRoot() == null) {
                            throw new SOSInventoryEventProcessingException(String.format("xpath document element missing", new Object[0]));
                        }
                        lock.setMaxNonExclusive(ReportXmlHelper.getMaxNonExclusive(xpath));
                        lock.setModified(now);
                        file.setModified(now);
                        this.saveOrUpdateItems.add(file);
                        this.saveOrUpdateItems.add(lock);
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_UPDATED);
                    } else if (!fileExists && lock != null) {
                        this.deleteItems.add(lock);
                        if (file != null) {
                            this.deleteItems.add(file);
                        }
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_REMOVED);
                    }
                    this.eventVariables.put(key, values);
                }
                catch (SOSHibernateInvalidSessionException e) {
                    this.hasDbErrors = true;
                    throw e;
                }
                catch (SAXParseException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void processMonitorEvent(String path, JsonObject event, String key) throws Exception {
        block12: {
            if (!this.closed) {
                HashMap<String, String> values = new HashMap<String, String>();
                try {
                    boolean fileExists;
                    Date now = Date.from(Instant.now());
                    Path filePath = this.fileExists(path + EConfigFileExtensions.MONITOR.extension());
                    Long instanceId = null;
                    if (this.instance == null) break block12;
                    instanceId = this.instance.getId();
                    LOGGER.debug(String.format("[inventory] processing event on MONITOR: %1$s with path: %2$s", Paths.get(path, new String[0]).getFileName(), Paths.get(path, new String[0]).getParent()));
                    DBItemInventoryFile file = this.dbLayer.getInventoryFile(instanceId, path + EConfigFileExtensions.MONITOR.extension());
                    boolean bl = fileExists = filePath != null;
                    if (fileExists) {
                        if (file == null) {
                            file = this.createNewInventoryFile(instanceId, filePath, path + EConfigFileExtensions.MONITOR.extension(), EConfigFileExtensions.MONITOR.type());
                            file.setCreated(now);
                        } else {
                            try {
                                BasicFileAttributes attrs = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                                file.setFileName((path + EConfigFileExtensions.MONITOR.extension()).replace('\\', '/'));
                                Path updatedPath = Paths.get(path, new String[0]);
                                String fileDirectory = updatedPath.getParent().toString().replace('\\', '/');
                                file.setFileDirectory(fileDirectory);
                                file.setModified(now);
                                file.setFileModified(ReportUtil.convertFileTime2UTC(attrs.lastModifiedTime()));
                                file.setFileLocalModified(ReportUtil.convertFileTime2Local(attrs.lastModifiedTime()));
                            }
                            catch (IOException e) {
                                LOGGER.warn(String.format("[inventory] cannot read file attributes. file = %1$s, exception = %2$s:%3$s", filePath.toString(), e.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
                            }
                            catch (Exception e) {
                                LOGGER.warn("[inventory] cannot convert files create and modified timestamps! " + e.getMessage(), (Throwable)e);
                            }
                        }
                        file.setModified(now);
                        this.saveOrUpdateItems.add(file);
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_UPDATED);
                    } else if (!fileExists) {
                        if (file != null) {
                            this.deleteItems.add(file);
                        }
                        values.put("InventoryEventUpdateFinished", EVENT_TYPE_REMOVED);
                    }
                    this.eventVariables.put(key, values);
                }
                catch (SOSHibernateInvalidSessionException e) {
                    this.hasDbErrors = true;
                    throw e;
                }
            }
        }
    }

    private void saveAgentClusters(SOSHibernateSession dbConnection, DBItemInventoryProcessClass pc, NodeList nl) throws Exception {
        if (!this.closed) {
            this.agentsToDelete = new HashSet<DBItemInventoryAgentInstance>();
            Map<String, Integer> remoteSchedulers = this.getRemoteSchedulersFromProcessClass(this.pcXpaths.get(pc.getName()));
            String remoteScheduler = this.pcXpaths.get(pc.getName()).selectSingleNodeValue("/process_class/@remote_scheduler");
            if (remoteSchedulers == null || remoteSchedulers.isEmpty()) {
                remoteSchedulers = new HashMap<String, Integer>();
                if (remoteScheduler != null && !remoteScheduler.isEmpty()) {
                    remoteSchedulers.put(remoteScheduler.toLowerCase(), 1);
                } else {
                    remoteScheduler = this.pcXpaths.get(pc.getName()).selectSingleNodeValue("/process_class/remote_schedulers/remote_scheduler/@remote_scheduler");
                    if (remoteScheduler != null && !remoteScheduler.isEmpty()) {
                        remoteSchedulers.put(remoteScheduler.toLowerCase(), 1);
                    }
                }
            }
            if (remoteSchedulers != null && !remoteSchedulers.isEmpty()) {
                List<DBItemInventoryAgentInstance> agentsFromDb = this.dbLayer.getAllAgentInstancesForInstance(this.instance.getId());
                List<String> agentUrls = AgentHelper.getAgentInstanceUrls(this.instance, this.httpPort);
                for (DBItemInventoryAgentInstance dBItemInventoryAgentInstance : agentsFromDb) {
                    if (agentUrls.contains(dBItemInventoryAgentInstance.getUrl())) continue;
                    this.agentsToDelete.add(dBItemInventoryAgentInstance);
                }
                HashSet<DBItemInventoryAgentInstance> newAgentsToAdd = new HashSet<DBItemInventoryAgentInstance>();
                for (String agentUrl : agentUrls) {
                    boolean found = false;
                    for (DBItemInventoryAgentInstance agent : agentsFromDb) {
                        if (!agent.getUrl().equals(agentUrl)) continue;
                        found = true;
                    }
                    if (found) continue;
                    DBItemInventoryAgentInstance agentToSave = AgentHelper.createNewAgent(this.instance, agentUrl, dbConnection, true);
                    newAgentsToAdd.add(agentToSave);
                }
                for (DBItemInventoryAgentInstance agent : newAgentsToAdd) {
                    SaveOrUpdateHelper.saveOrUpdateAgentInstance(agent, dbConnection);
                }
                if (nl != null && nl.getLength() > 0) {
                    Element element = (Element)nl.item(0);
                    String schedulingType = element.getAttribute("select");
                    if (schedulingType != null && !schedulingType.isEmpty()) {
                        this.processAgentCluster(remoteSchedulers, schedulingType, pc.getInstanceId(), pc.getId());
                    } else if (remoteSchedulers.size() == 1) {
                        this.processAgentCluster(remoteSchedulers, "single", pc.getInstanceId(), pc.getId());
                    } else {
                        this.processAgentCluster(remoteSchedulers, "first", pc.getInstanceId(), pc.getId());
                    }
                } else {
                    this.processAgentCluster(remoteSchedulers, "single", pc.getInstanceId(), pc.getId());
                }
            }
        }
    }

    private Map<String, Integer> getRemoteSchedulersFromProcessClass(SOSXMLXPath xpath) throws Exception {
        NodeList remoteSchedulers = xpath.selectNodeList("remote_schedulers/remote_scheduler");
        int ordering = 1;
        HashMap<String, Integer> remoteSchedulerUrls = new HashMap<String, Integer>();
        for (int i = 0; i < remoteSchedulers.getLength(); ++i) {
            Element remoteScheduler = (Element)remoteSchedulers.item(i);
            String url = remoteScheduler.getAttribute("remote_scheduler");
            if (url == null || url.isEmpty()) continue;
            remoteSchedulerUrls.put(url.toLowerCase(), ordering);
            ++ordering;
        }
        return remoteSchedulerUrls;
    }

    private void markRemovedAgentClusterMembersForLaterDelete(List<DBItemInventoryAgentClusterMember> actualAgentClusterMembers) throws SOSHibernateException {
        if (!this.closed) {
            this.agentClusterMembersToDelete = new HashSet<DBItemInventoryAgentClusterMember>();
            HashSet<DBItemInventoryAgentClusterMember> dbClusterMembers = new HashSet<DBItemInventoryAgentClusterMember>();
            for (DBItemInventoryAgentClusterMember actualMember : actualAgentClusterMembers) {
                dbClusterMembers.addAll(this.dbLayer.getAllAgentClusterMembersForInstanceAndCluster(actualMember.getInstanceId(), actualMember.getAgentClusterId()));
            }
            for (DBItemInventoryAgentClusterMember member : dbClusterMembers) {
                if (actualAgentClusterMembers.contains(member)) continue;
                this.agentClusterMembersToDelete.add(member);
            }
        }
    }

    private Integer getJobChainNodeType(String nodeName, Element jobChainNode) {
        switch (nodeName) {
            case "job_chain_node": {
                if (jobChainNode.hasAttribute(JS_OBJECT_TYPE_JOB.toLowerCase())) {
                    return 1;
                }
                if (jobChainNode.hasAttribute(FILE_TYPE_JOBCHAIN)) {
                    return 2;
                }
                return 5;
            }
            case "job_chain_node.job_chain": {
                return 2;
            }
            case "file_order_source": {
                return 3;
            }
            case "file_order_sink": {
                return 4;
            }
            case "job_chain_node.end": {
                return 5;
            }
        }
        return null;
    }

    private void processAgentCluster(Map<String, Integer> remoteSchedulers, String schedulingType, Long instanceId, Long processClassId) throws Exception {
        if (!this.closed) {
            Integer numberOfAgents = remoteSchedulers.size();
            DBItemInventoryAgentCluster agentCluster = new DBItemInventoryAgentCluster();
            agentCluster.setInstanceId(instanceId);
            agentCluster.setProcessClassId(processClassId);
            agentCluster.setNumberOfAgents(numberOfAgents);
            agentCluster.setSchedulingType(schedulingType);
            Long clusterId = SaveOrUpdateHelper.saveOrUpdateAgentCluster(this.dbLayer, agentCluster, SaveOrUpdateHelper.getAgentClusters());
            ArrayList<DBItemInventoryAgentClusterMember> members = new ArrayList<DBItemInventoryAgentClusterMember>();
            for (String agentUrl : remoteSchedulers.keySet()) {
                DBItemInventoryAgentInstance agent = this.dbLayer.getInventoryAgentInstanceFromDb(agentUrl, instanceId);
                if (agent == null) continue;
                Integer ordering = remoteSchedulers.get(agent.getUrl().toLowerCase());
                if (ordering == null) {
                    ordering = 1;
                }
                DBItemInventoryAgentClusterMember agentClusterMember = new DBItemInventoryAgentClusterMember();
                agentClusterMember.setInstanceId(instanceId);
                agentClusterMember.setAgentClusterId(clusterId);
                agentClusterMember.setAgentInstanceId(agent.getId());
                agentClusterMember.setUrl(agent.getUrl());
                agentClusterMember.setOrdering(ordering);
                SaveOrUpdateHelper.saveOrUpdateAgentClusterMember(this.dbLayer, agentClusterMember, SaveOrUpdateHelper.getAgentClusterMembers());
                members.add(agentClusterMember);
            }
            this.markRemovedAgentClusterMembersForLaterDelete(members);
        }
    }

    private Long initOverviewRequest() throws SOSException {
        block10: {
            if (!this.closed) {
                try {
                    URIBuilder uriBuilder = new URIBuilder().setScheme("http").setHost(this.hostFromHttpPort).setPort(this.port.intValue()).setPath(WEBSERVICE_FILE_BASED_URL).addParameter(WEBSERVICE_PARAM_KEY_RETURN, WEBSERVICE_PARAM_VALUE_FILEBASED_OVERVIEW);
                    JsonObject result = this.getJsonObjectFromResponse(uriBuilder.build(), true);
                    JsonNumber jsonEventId = result.getJsonNumber(EVENT_ID);
                    LOGGER.debug(String.format("[inventory] eventId received from Overview: %1$d", jsonEventId.longValue()));
                    if (jsonEventId != null) {
                        return jsonEventId.longValue();
                    }
                }
                catch (SOSConnectionRefusedException | SOSConnectionResetException e) {
                    if (!this.closed) {
                        LOGGER.error(e.getMessage(), e);
                        throw e;
                    }
                }
                catch (SOSBadRequestException e) {
                    if (!this.closed) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (Exception e) {
                    if (this.closed) break block10;
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private JsonObject getFileBasedEvents(Long eventId) throws Exception {
        block7: {
            if (!this.closed) {
                StringBuilder connectTo = new StringBuilder();
                connectTo.append(this.webserviceUrl);
                connectTo.append(WEBSERVICE_EVENTS_URL);
                try {
                    URIBuilder uriBuilder = new URIBuilder(connectTo.toString());
                    uriBuilder.clearParameters();
                    uriBuilder.addParameter(WEBSERVICE_PARAM_KEY_RETURN, "FileBasedEvent,SchedulerEvent,VariablesCustomEvent");
                    uriBuilder.addParameter(WEBSERVICE_PARAM_KEY_TIMEOUT, WEBSERVICE_PARAM_VALUE_TIMEOUT);
                    uriBuilder.addParameter(WEBSERVICE_PARAM_KEY_AFTER, eventId.toString());
                    LOGGER.debug(String.format("[inventory] request eventId send: %1$d", eventId));
                    JsonObject result = this.getJsonObjectFromResponse(uriBuilder.build(), false);
                    JsonNumber jsonEventId = result.getJsonNumber(EVENT_ID);
                    String type = result.getString(EVENT_TYPE);
                    if (EVENT_TYPE_NON_EMPTY.equalsIgnoreCase(type)) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        result = this.getJsonObjectFromResponse(uriBuilder.build(), false);
                    }
                    this.newEventId = jsonEventId.longValue();
                    LOGGER.debug(String.format("[inventory] eventId received from FileBasedEvents: %1$d", this.newEventId));
                    return result;
                }
                catch (Exception e) {
                    if (!this.closed) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        throw e;
                    }
                    break block7;
                }
            }
            throw new SOSInventoryEventProcessingException("[inventory] JobScheduler is closed!");
        }
        return null;
    }

    private JsonObject getJsonObjectFromResponse(URI uri, boolean withBody) throws SOSException {
        if (!this.closed) {
            String response = null;
            if (withBody) {
                JsonObjectBuilder builder = Json.createObjectBuilder();
                builder.add(POST_BODY_JSON_KEY, POST_BODY_JSON_VALUE);
                response = this.restApiClient.postRestService(uri, builder.build().toString());
            } else {
                response = this.restApiClient.postRestService(uri, null);
            }
            LOGGER.debug("[inventory] " + response);
            int httpReplyCode = this.restApiClient.statusCode();
            String contentType = this.restApiClient.getResponseHeader(CONTENT_TYPE_HEADER_KEY);
            switch (httpReplyCode) {
                case 200: {
                    JsonObject json = null;
                    if (contentType.contains(APPLICATION_HEADER_JSON_VALUE)) {
                        JsonReader rdr = Json.createReader((Reader)new StringReader(response));
                        json = rdr.readObject();
                    }
                    if (json != null) {
                        return json;
                    }
                    throw new SOSInventoryEventProcessingException("[inventory] Unexpected content type '" + contentType + "'. Response: " + response);
                }
                case 400: {
                    if (response.contains("com.sos.scheduler.engine.common.async.CallQueue$ClosedException")) {
                        throw new SOSConnectionResetException(response);
                    }
                    throw new SOSBadRequestException("[inventory] 400 Response: " + response);
                }
            }
            throw new SOSBadRequestException("[inventory] " + httpReplyCode + " " + this.restApiClient.getHttpResponse().getStatusLine().getReasonPhrase());
        }
        return null;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
        if (closed) {
            this.cleanup();
        }
    }

    public void setXmlCommandExecutor(SchedulerXmlCommandExecutor xmlCommandExecutor) {
        this.xmlCommandExecutor = xmlCommandExecutor;
    }

    private void createOrUpdateDocumentationUsage(SOSHibernateSession connection, String schedulerId, String docuPath, Long jobId, String jobPath, String objectType) throws Exception {
        if (connection == null) {
            connection = this.factory.openStatelessSession();
        }
        DocumentationDBLayer dbLayer = new DocumentationDBLayer(connection);
        DBItemDocumentationUsage dbDocuUsage = dbLayer.getDocumentationUsageForAssignment(schedulerId, jobPath, objectType);
        DBItemDocumentation dbReferencedDocu = dbLayer.getDocumentation(schedulerId, docuPath);
        if (dbDocuUsage == null && dbReferencedDocu != null) {
            DBItemDocumentationUsage newDocuUsage = new DBItemDocumentationUsage();
            newDocuUsage.setDocumentationId(dbReferencedDocu.getId());
            newDocuUsage.setSchedulerId(schedulerId);
            newDocuUsage.setPath(jobPath);
            newDocuUsage.setObjectType(objectType);
            newDocuUsage.setCreated(Date.from(Instant.now()));
            newDocuUsage.setModified(newDocuUsage.getCreated());
            connection.save((Object)newDocuUsage);
        }
    }

    private void deleteCalendarUsages(DbItem item) throws SOSHibernateException {
        List<DBItemInventoryClusterCalendarUsage> calendarUsages = this.dbLayer.getCalendarUsagesToDelete(item);
        for (DBItemInventoryClusterCalendarUsage dbCalendarUsage : calendarUsages) {
            this.deleteItems.add(dbCalendarUsage);
        }
    }

    private void updateRuntimeAndCalendarUsage(String type, DbItem dbItem, SOSXMLXPath xPath, Boolean isCalendarEvent) {
        List<DBItemInventoryClusterCalendarUsage> dbCalendarUsages = null;
        try {
            this.dbLayer.getSession().beginTransaction();
            if (CALENDAR_OBJECT_TYPE_ORDER.equals(type)) {
                dbCalendarUsages = this.dbLayer.getAllCalendarUsagesForObject(this.schedulerId, ((DBItemInventoryOrder)dbItem).getName(), type);
                InventoryRuntimeHelper.createOrUpdateCalendarUsage(xPath, dbCalendarUsages, dbItem, type, this.dbLayer, this.liveDirectory, this.schedulerId, this.timezone, isCalendarEvent);
            } else if (CALENDAR_OBJECT_TYPE_JOB.equals(type)) {
                dbCalendarUsages = this.dbLayer.getAllCalendarUsagesForObject(this.schedulerId, ((DBItemInventoryJob)dbItem).getName(), type);
                InventoryRuntimeHelper.createOrUpdateCalendarUsage(xPath, dbCalendarUsages, dbItem, type, this.dbLayer, this.liveDirectory, this.schedulerId, this.timezone, isCalendarEvent);
            } else if (CALENDAR_OBJECT_TYPE_SCHEDULE.equals(type)) {
                dbCalendarUsages = this.dbLayer.getAllCalendarUsagesForObject(this.schedulerId, ((DBItemInventorySchedule)dbItem).getName(), type);
                InventoryRuntimeHelper.createOrUpdateCalendarUsage(xPath, dbCalendarUsages, dbItem, type, this.dbLayer, this.liveDirectory, this.schedulerId, this.timezone, isCalendarEvent);
            }
            this.dbLayer.getSession().commit();
        }
        catch (Exception e) {
            try {
                this.dbLayer.getSession().rollback();
            }
            catch (SOSHibernateException sOSHibernateException) {
                // empty catch block
            }
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

