/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.inventory.model;

import com.sos.classes.Latin1ToUtf8;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.classes.UtcTimeHelper;
import com.sos.jitl.dailyplan.db.Calendar2DB;
import com.sos.jitl.inventory.db.DBLayerInventory;
import com.sos.jitl.inventory.exceptions.SOSInventoryModelProcessingException;
import com.sos.jitl.inventory.helper.Calendar2DBHelper;
import com.sos.jitl.inventory.helper.HttpHelper;
import com.sos.jitl.inventory.helper.InventoryRuntimeHelper;
import com.sos.jitl.inventory.helper.SaveOrUpdateHelper;
import com.sos.jitl.inventory.model.DocumentationDBLayer;
import com.sos.jitl.reporting.db.DBItemDocumentation;
import com.sos.jitl.reporting.db.DBItemDocumentationUsage;
import com.sos.jitl.reporting.db.DBItemInventoryAgentCluster;
import com.sos.jitl.reporting.db.DBItemInventoryAgentClusterMember;
import com.sos.jitl.reporting.db.DBItemInventoryAgentInstance;
import com.sos.jitl.reporting.db.DBItemInventoryAppliedLock;
import com.sos.jitl.reporting.db.DBItemInventoryClusterCalendarUsage;
import com.sos.jitl.reporting.db.DBItemInventoryFile;
import com.sos.jitl.reporting.db.DBItemInventoryInstance;
import com.sos.jitl.reporting.db.DBItemInventoryJob;
import com.sos.jitl.reporting.db.DBItemInventoryJobChain;
import com.sos.jitl.reporting.db.DBItemInventoryJobChainNode;
import com.sos.jitl.reporting.db.DBItemInventoryLock;
import com.sos.jitl.reporting.db.DBItemInventoryOrder;
import com.sos.jitl.reporting.db.DBItemInventoryProcessClass;
import com.sos.jitl.reporting.db.DBItemInventorySchedule;
import com.sos.jitl.reporting.db.DBItemSubmission;
import com.sos.jitl.reporting.db.DBItemSubmittedObject;
import com.sos.jitl.reporting.db.DBLayer;
import com.sos.jitl.reporting.helper.EConfigFileExtensions;
import com.sos.jitl.reporting.helper.EStartCauses;
import com.sos.jitl.reporting.helper.ReportUtil;
import com.sos.jitl.reporting.plugin.FactEventHandler;
import com.sos.scheduler.SOSJobSchedulerGlobal;
import com.sos.scheduler.engine.data.events.custom.VariablesCustomEvent;
import com.sos.scheduler.engine.eventbus.EventPublisher;
import com.sos.scheduler.engine.kernel.scheduler.SchedulerXmlCommandExecutor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.xml.SOSXMLXPath;

public class InventoryModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryModel.class);
    private static final String DEFAULT_PROCESS_CLASS_NAME = "(default)";
    private static final String COMMAND = "<show_state what=\"cluster source job_chains job_chain_orders schedules\" />";
    private static final String DEFAULT_JOB_DOC_PATH = "/sos/jitl-jobs";
    private DBItemInventoryInstance inventoryInstance;
    private int countTotalJobs = 0;
    private int countSuccessJobs = 0;
    private int countTotalJobChains = 0;
    private int countSuccessJobChains = 0;
    private int countTotalOrders = 0;
    private int countSuccessOrders = 0;
    private int countNotFoundJobChainJobs = 0;
    private int countTotalLocks = 0;
    private int countTotalMonitors = 0;
    private int countSuccessLocks = 0;
    private int countTotalProcessClasses = 0;
    private int countSuccessProcessClasses = 0;
    private int countTotalSchedules = 0;
    private int countSuccessSchedules = 0;
    private LinkedHashMap<String, ArrayList<String>> notFoundJobChainJobs;
    private LinkedHashMap<String, String> errorJobChains;
    private LinkedHashMap<String, String> errorOrders;
    private LinkedHashMap<String, String> errorJobs;
    private Map<String, String> errorLocks;
    private Map<String, String> errorProcessClasses;
    private Map<String, String> errorSchedules;
    private Date started;
    private Path schedulerXmlPath;
    private String answerXml;
    private List<DBItemInventoryFile> dbFiles;
    private List<DBItemInventoryJob> dbJobs;
    private List<DBItemInventoryJobChain> dbJobChains;
    private List<DBItemInventoryOrder> dbOrders;
    private List<DBItemInventoryProcessClass> dbProcessClasses;
    private List<DBItemInventorySchedule> dbSchedules;
    private List<DBItemInventoryLock> dbLocks;
    private List<DBItemInventoryAppliedLock> dbAppliedLocks;
    private List<DBItemInventoryAgentCluster> dbAgentCLusters;
    private List<DBItemInventoryAgentClusterMember> dbAgentClusterMembers;
    private List<DBItemInventoryClusterCalendarUsage> dbCalendarUsages;
    private List<Long> dbCalendarIds;
    private DBLayerInventory inventoryDbLayer;
    private SOSXMLXPath xPathAnswerXml;
    private Integer filesDeleted;
    private Integer jobsDeleted;
    private Integer jobChainsDeleted;
    private Integer jobChainNodesDeleted;
    private Integer ordersDeleted;
    private Integer appliedLocksDeleted;
    private Integer locksDeleted;
    private Integer schedulesDeleted;
    private Integer processClassesDeleted;
    private Integer agentClustersDeleted;
    private Integer agentClusterMembersDeleted;
    private SchedulerXmlCommandExecutor xmlCommandExecutor;
    private SOSHibernateFactory factory;
    private String httpHost;
    private Integer httpPort;
    private Path liveDirectory;
    private String timezone;
    private EventPublisher customEventBus;

    public InventoryModel(SOSHibernateFactory factory, DBItemInventoryInstance jsInstanceItem, Path schedulerXmlPath, EventPublisher customEventBus) throws Exception {
        this.schedulerXmlPath = schedulerXmlPath;
        this.inventoryInstance = jsInstanceItem;
        this.factory = factory;
        this.timezone = this.inventoryInstance.getTimeZone();
        this.customEventBus = customEventBus;
    }

    public InventoryModel(SOSHibernateFactory factory, DBItemInventoryInstance jsInstanceItem, Path schedulerXmlPath) throws Exception {
        this.schedulerXmlPath = schedulerXmlPath;
        this.inventoryInstance = jsInstanceItem;
        this.factory = factory;
        this.timezone = this.inventoryInstance.getTimeZone();
        this.customEventBus = null;
    }

    public void process() throws Exception {
        String method = "process";
        SOSHibernateSession connection = null;
        try {
            connection = this.factory.openStatelessSession();
            this.inventoryDbLayer = new DBLayerInventory(connection);
            String toTimeZoneString = "UTC";
            String fromTimeZoneString = DateTimeZone.getDefault().getID();
            this.started = UtcTimeHelper.convertTimeZonesToDate((String)fromTimeZoneString, (String)toTimeZoneString, (DateTime)new DateTime());
            this.processUncommittedSubmissions();
            this.initCounters();
            this.initExistingItems();
            connection.beginTransaction();
            this.processSchedulerXml();
            connection.commit();
            connection.close();
            if (this.answerXml == null && this.xmlCommandExecutor != null) {
                this.answerXml = this.xmlCommandExecutor.executeXml(COMMAND);
            }
            this.xPathAnswerXml = new SOSXMLXPath(new StringBuffer(this.answerXml));
            String httpPortFromAnswerXml = this.xPathAnswerXml.selectSingleNodeValue("/spooler/answer/state/@http_port");
            if (httpPortFromAnswerXml != null && !httpPortFromAnswerXml.isEmpty()) {
                this.httpHost = HttpHelper.getHttpHost(httpPortFromAnswerXml, "localhost");
                this.httpPort = HttpHelper.getHttpPort(httpPortFromAnswerXml);
            }
            this.processStateAnswerXML();
            connection = this.factory.openStatelessSession();
            this.inventoryDbLayer = new DBLayerInventory(connection);
            connection.beginTransaction();
            this.inventoryDbLayer.refreshUsedInJobChains(this.inventoryInstance.getId(), this.dbJobs);
            connection.commit();
            connection.close();
            connection = this.factory.openStatelessSession();
            this.inventoryDbLayer = new DBLayerInventory(connection);
            connection.beginTransaction();
            this.cleanUpInventoryAfter(this.started);
            connection.commit();
            connection.close();
            connection = this.factory.openStatelessSession();
            this.inventoryDbLayer = new DBLayerInventory(connection);
            this.updateDailyPlan(connection);
            this.logSummary();
            this.resume();
        }
        catch (Exception ex) {
            try {
                if (this.inventoryDbLayer != null && this.inventoryDbLayer.getSession() != null) {
                    this.inventoryDbLayer.getSession().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SOSInventoryModelProcessingException(String.format("%s: %s", method, ex.toString()), ex);
        }
        finally {
            connection.close();
            try {
                if (this.customEventBus != null) {
                    HashMap<String, String> valueMap = new HashMap<String, String>();
                    valueMap.put("DBUpdate", "finished");
                    this.customEventBus.publishCustomEvent(VariablesCustomEvent.keyed((String)"InventoryInitialized", valueMap));
                    LOGGER.info("[inventory] Initialization finished. Custom Event - InventoryInitialized - published!");
                    valueMap = new HashMap();
                    valueMap.put(FactEventHandler.CustomEventType.DailyPlanChanged.name(), "InventoryDailyPlanUpdated");
                    this.customEventBus.publishCustomEvent(VariablesCustomEvent.keyed((String)"DailyPlan", valueMap));
                    LOGGER.info("[inventory] Custom Event - Daily Plan updated - published on inventory initialization!");
                } else {
                    LOGGER.info("[inventory] Custom Events not published due to errors or EventBus is NULL!");
                }
            }
            catch (Exception e) {
                LOGGER.info("[inventory] Custom Events not published!");
            }
        }
    }

    public void setXmlCommandExecutor(SchedulerXmlCommandExecutor xmlCommandExecutor) {
        this.xmlCommandExecutor = xmlCommandExecutor;
    }

    private void initExistingItems() throws Exception {
        this.inventoryDbLayer.getSession().beginTransaction();
        this.dbFiles = this.inventoryDbLayer.getAllFilesForInstance(this.inventoryInstance.getId());
        this.dbJobs = this.inventoryDbLayer.getAllJobsForInstance(this.inventoryInstance.getId());
        this.dbJobChains = this.inventoryDbLayer.getAllJobChainsForInstance(this.inventoryInstance.getId());
        this.dbOrders = this.inventoryDbLayer.getAllOrdersForInstance(this.inventoryInstance.getId());
        this.dbProcessClasses = this.inventoryDbLayer.getAllProcessClassesForInstance(this.inventoryInstance.getId());
        this.dbSchedules = this.inventoryDbLayer.getAllSchedulesForInstance(this.inventoryInstance.getId());
        this.dbLocks = this.inventoryDbLayer.getAllLocksForInstance(this.inventoryInstance.getId());
        this.dbAppliedLocks = this.inventoryDbLayer.getAllAppliedLocks();
        this.dbAgentCLusters = this.inventoryDbLayer.getAllAgentClustersForInstance(this.inventoryInstance.getId());
        this.dbAgentClusterMembers = this.inventoryDbLayer.getAllAgentClusterMembersForInstance(this.inventoryInstance.getId());
        this.dbCalendarUsages = this.inventoryDbLayer.getAllCalendarUsagesForSchedulerId(this.inventoryInstance.getSchedulerId());
        this.dbCalendarIds = this.inventoryDbLayer.getAllCalendarIds();
        this.inventoryDbLayer.getSession().commit();
    }

    private void initCounters() {
        this.countTotalJobs = 0;
        this.countTotalJobChains = 0;
        this.countTotalOrders = 0;
        this.countSuccessJobs = 0;
        this.countSuccessJobChains = 0;
        this.countSuccessOrders = 0;
        this.countNotFoundJobChainJobs = 0;
        this.countTotalLocks = 0;
        this.countSuccessLocks = 0;
        this.countTotalProcessClasses = 0;
        this.countSuccessProcessClasses = 0;
        this.countTotalSchedules = 0;
        this.countSuccessSchedules = 0;
        this.countTotalMonitors = 0;
        this.notFoundJobChainJobs = new LinkedHashMap();
        this.errorJobChains = new LinkedHashMap();
        this.errorOrders = new LinkedHashMap();
        this.errorJobs = new LinkedHashMap();
        this.errorLocks = new LinkedHashMap<String, String>();
        this.errorProcessClasses = new LinkedHashMap<String, String>();
        this.errorSchedules = new LinkedHashMap<String, String>();
    }

    private void logSummary() {
        int i;
        String method = "logSummary";
        LOGGER.debug(String.format("%s: inserted or updated jobs = %s (total %s, error = %s)", method, this.countSuccessJobs, this.countTotalJobs, this.errorJobs.size()));
        LOGGER.debug(String.format("%s: inserted or updated job chains = %s (total %s, error = %s)", method, this.countSuccessJobChains, this.countTotalJobChains, this.errorJobChains.size()));
        LOGGER.debug(String.format("%s: inserted or updated orders = %s (total %s, error = %s)", method, this.countSuccessOrders, this.countTotalOrders, this.errorOrders.size()));
        LOGGER.debug(String.format("%s: inserted or updated process classes = %s (total %s, error = %s)", method, this.countSuccessProcessClasses, this.countTotalProcessClasses, this.errorProcessClasses.size()));
        LOGGER.debug(String.format("%s: inserted or updated schedules = %s (total %s, error = %s)", method, this.countSuccessSchedules, this.countTotalSchedules, this.errorSchedules.size()));
        LOGGER.debug(String.format("%s: inserted or updated locks = %s (total %s, error = %s)", method, this.countSuccessLocks, this.countTotalLocks, this.errorLocks.size()));
        LOGGER.debug(String.format("%s: inserted or updated monitors = %s", method, this.countTotalMonitors));
        if (!this.errorJobChains.isEmpty()) {
            LOGGER.debug(String.format("%s:   errors by insert or update job chains:", method));
            i = 1;
            for (Map.Entry<String, String> entry : this.errorJobChains.entrySet()) {
                LOGGER.debug(String.format("%s:     %s) %s: %s", method, i, entry.getKey(), entry.getValue()));
                ++i;
            }
        }
        if (!this.errorOrders.isEmpty()) {
            LOGGER.debug(String.format("%s:   errors by insert or update orders:", method));
            i = 1;
            for (Map.Entry<String, String> entry : this.errorOrders.entrySet()) {
                LOGGER.debug(String.format("%s:     %s) %s: %s", method, i, entry.getKey(), entry.getValue()));
                ++i;
            }
        }
        if (!this.errorJobs.isEmpty()) {
            LOGGER.debug(String.format("%s:   errors by insert or update jobs:", method));
            i = 1;
            for (Map.Entry<String, String> entry : this.errorJobs.entrySet()) {
                LOGGER.debug(String.format("%s:     %s) %s: %s", method, i, entry.getKey(), entry.getValue()));
                ++i;
            }
        }
        if (!this.errorLocks.isEmpty()) {
            LOGGER.debug(String.format("%s:   errors by insert or update locks:", method));
            i = 1;
            for (Map.Entry<String, String> entry : this.errorLocks.entrySet()) {
                LOGGER.debug(String.format("%s:     %s) %s: %s", method, i, entry.getKey(), entry.getValue()));
                ++i;
            }
        }
        if (!this.errorProcessClasses.isEmpty()) {
            LOGGER.debug(String.format("%s:   errors by insert or update process classes:", method));
            i = 1;
            for (Map.Entry<String, String> entry : this.errorProcessClasses.entrySet()) {
                LOGGER.debug(String.format("%s:     %s) %s: %s", method, i, entry.getKey(), entry.getValue()));
                ++i;
            }
        }
        if (!this.errorSchedules.isEmpty()) {
            LOGGER.debug(String.format("%s:   errors by insert or update schedules:", method));
            i = 1;
            for (Map.Entry<String, String> entry : this.errorSchedules.entrySet()) {
                LOGGER.debug(String.format("%s:     %s) %s: %s", method, i, entry.getKey(), entry.getValue()));
                ++i;
            }
        }
        if (this.countNotFoundJobChainJobs > 0) {
            LOGGER.debug(String.format("%s: jobs not found on the disc (declared in the job chains) = %s", method, this.countNotFoundJobChainJobs));
            i = 1;
            for (Map.Entry<String, Object> entry : this.notFoundJobChainJobs.entrySet()) {
                LOGGER.debug(String.format("%s:     %s) %s", method, i, entry.getKey()));
                for (int j = 0; j < ((ArrayList)entry.getValue()).size(); ++j) {
                    LOGGER.debug(String.format("%s:         %s) %s", method, j + 1, ((ArrayList)entry.getValue()).get(j)));
                }
                ++i;
            }
        }
        LOGGER.debug(String.format("cleanUpInventoryAfter: delete Inventory entries older than %1$s", this.started.toString()));
        LOGGER.debug(String.format("%1$s old Files deleted from inventory.", this.filesDeleted));
        LOGGER.debug(String.format("%1$s old Jobs deleted from inventory.", this.jobsDeleted));
        LOGGER.debug(String.format("%1$s old JobChains deleted from inventory.", this.jobChainsDeleted));
        LOGGER.debug(String.format("%1$s old JobChainNodes deleted from inventory.", this.jobChainNodesDeleted));
        LOGGER.debug(String.format("%1$s old Orders deleted from inventory.", this.ordersDeleted));
        LOGGER.debug(String.format("%1$s old Locks deleted from inventory.", this.locksDeleted));
        LOGGER.debug(String.format("%1$s old Applied Locks deleted from inventory.", this.appliedLocksDeleted));
        LOGGER.debug(String.format("%1$s old Schedules deleted from inventory.", this.schedulesDeleted));
        LOGGER.debug(String.format("%1$s old Process Classes deleted from inventory.", this.processClassesDeleted));
        LOGGER.debug(String.format("%1$s old Agent Clusters deleted from inventory.", this.agentClustersDeleted));
        LOGGER.debug(String.format("%1$s old Agent Cluster Members deleted from inventory.", this.agentClusterMembersDeleted));
    }

    private void resume() throws Exception {
        if (this.countSuccessJobChains == 0 && this.countSuccessOrders == 0 && this.countSuccessJobs == 0 && this.countSuccessLocks == 0 && this.countSuccessProcessClasses == 0 && this.countSuccessSchedules == 0) {
            throw new Exception(String.format("error occured: 0 job chains, orders, jobs locks, process classes or schedules inserted or updated!", new Object[0]));
        }
        if (!(this.errorJobChains.isEmpty() && this.errorOrders.isEmpty() && this.errorJobs.isEmpty() && this.errorLocks.isEmpty() && this.errorProcessClasses.isEmpty() && this.errorSchedules.isEmpty())) {
            LOGGER.warn(String.format("error occured: insert or update failed by %s job chains, %s orders, %s jobs, %s locks, %s process classes, %s schedules", this.errorJobChains.size(), this.errorOrders.size(), this.errorJobs.size(), this.errorLocks.size(), this.errorProcessClasses.size(), this.errorSchedules.size()));
        }
    }

    private DBItemInventoryFile processFileForObjectsInSchedulerXml(String objName, String fileType) throws Exception {
        String method = "  processFileForObjectsInSchedulerXml";
        Date fileCreated = null;
        Date fileModified = null;
        Date fileLocalCreated = null;
        Date fileLocalModified = null;
        BasicFileAttributes attrs = null;
        try {
            attrs = Files.readAttributes(this.schedulerXmlPath, BasicFileAttributes.class, new LinkOption[0]);
            fileCreated = ReportUtil.convertFileTime2UTC(attrs.creationTime());
            fileModified = ReportUtil.convertFileTime2UTC(attrs.lastModifiedTime());
            fileLocalCreated = ReportUtil.convertFileTime2Local(attrs.creationTime());
            fileLocalModified = ReportUtil.convertFileTime2Local(attrs.lastModifiedTime());
        }
        catch (IOException exception) {
            LOGGER.debug(String.format("%s: cannot read file attributes. file = %s, exception = %s  ", method, this.schedulerXmlPath.toString(), exception.toString()));
        }
        DBItemInventoryFile item = new DBItemInventoryFile();
        item.setInstanceId(this.inventoryInstance.getId());
        item.setFileType(fileType);
        item.setFileName("/" + objName);
        item.setFileBaseName(objName);
        item.setFileDirectory("/");
        item.setFileCreated(fileCreated);
        item.setFileModified(fileModified);
        item.setFileLocalCreated(fileLocalCreated);
        item.setFileLocalModified(fileLocalModified);
        Long id = SaveOrUpdateHelper.saveOrUpdateFile(this.inventoryDbLayer, item, this.dbFiles);
        if (item.getId() == null) {
            item.setId(id);
        }
        LOGGER.debug(String.format("%s: file     id = %s, fileType = %s, fileName = %s, fileBasename = %s, fileDirectory = %s, fileCreated = %s, fileModified = %s", method, item.getId(), item.getFileType(), item.getFileName(), item.getFileBaseName(), item.getFileDirectory(), item.getFileCreated(), item.getFileModified()));
        return item;
    }

    private Integer getJobChainNodeType(String nodeName, Element jobChainNode) {
        switch (nodeName) {
            case "job_chain_node": {
                if (jobChainNode.hasAttribute("job")) {
                    return 1;
                }
                if (jobChainNode.hasAttribute("job_chain")) {
                    return 2;
                }
                return 5;
            }
            case "job_chain_node.job_chain": {
                return 2;
            }
            case "file_order_source": {
                return 3;
            }
            case "file_order_sink": {
                return 4;
            }
            case "job_chain_node.end": {
                return 5;
            }
        }
        return null;
    }

    private void processDefaultProcessClass(Integer maxProcesses) throws Exception {
        ++this.countTotalProcessClasses;
        String name = "/(default)";
        try {
            DBItemInventoryFile dbItemFile = this.processFileForObjectsInSchedulerXml(DEFAULT_PROCESS_CLASS_NAME, EConfigFileExtensions.PROCESS_CLASS.type());
            DBItemInventoryProcessClass item = new DBItemInventoryProcessClass();
            item.setInstanceId(dbItemFile.getInstanceId());
            item.setFileId(dbItemFile.getId());
            item.setName(name);
            item.setBasename(DEFAULT_PROCESS_CLASS_NAME);
            item.setMaxProcesses(maxProcesses);
            item.setHasAgents(false);
            Long id = SaveOrUpdateHelper.saveOrUpdateProcessClass(this.inventoryDbLayer, item, this.dbProcessClasses);
            if (item.getId() == null) {
                item.setId(id);
            }
            ++this.countSuccessProcessClasses;
        }
        catch (Exception ex) {
            LOGGER.warn(String.format("processDefaultProcessClass: default processClass cannot be inserted, exception = %s ", ex.toString()), (Throwable)ex);
            this.errorProcessClasses.put(name, ex.toString());
        }
    }

    private void processAgentCluster(Map<String, Integer> remoteSchedulers, String schedulingType, Long instanceId, Long processClassId) throws Exception {
        Integer numberOfAgents = remoteSchedulers.size();
        DBItemInventoryAgentCluster agentCluster = new DBItemInventoryAgentCluster();
        agentCluster.setInstanceId(instanceId);
        agentCluster.setProcessClassId(processClassId);
        agentCluster.setNumberOfAgents(numberOfAgents);
        agentCluster.setSchedulingType(schedulingType);
        Long clusterId = SaveOrUpdateHelper.saveOrUpdateAgentCluster(this.inventoryDbLayer, agentCluster, this.dbAgentCLusters);
        for (String agentUrl : remoteSchedulers.keySet()) {
            DBItemInventoryAgentInstance agent = this.inventoryDbLayer.getInventoryAgentInstanceFromDb(agentUrl, instanceId);
            if (agent == null) continue;
            Integer ordering = remoteSchedulers.get(agent.getUrl().toLowerCase());
            DBItemInventoryAgentClusterMember agentClusterMember = new DBItemInventoryAgentClusterMember();
            agentClusterMember.setInstanceId(instanceId);
            agentClusterMember.setAgentClusterId(clusterId);
            agentClusterMember.setAgentInstanceId(agent.getId());
            agentClusterMember.setUrl(agent.getUrl());
            agentClusterMember.setOrdering(ordering);
            SaveOrUpdateHelper.saveOrUpdateAgentClusterMember(this.inventoryDbLayer, agentClusterMember, this.dbAgentClusterMembers);
        }
    }

    private void cleanUpInventoryAfter(Date started) throws Exception {
        this.filesDeleted = this.inventoryDbLayer.deleteItemsFromDb(started, DBLayer.DBITEM_INVENTORY_FILES, this.inventoryInstance.getId());
        this.jobsDeleted = this.inventoryDbLayer.deleteItemsFromDb(started, DBLayer.DBITEM_INVENTORY_JOBS, this.inventoryInstance.getId());
        this.jobChainsDeleted = this.inventoryDbLayer.deleteItemsFromDb(started, DBLayer.DBITEM_INVENTORY_JOB_CHAINS, this.inventoryInstance.getId());
        this.jobChainNodesDeleted = this.inventoryDbLayer.deleteItemsFromDb(started, DBLayer.DBITEM_INVENTORY_JOB_CHAIN_NODES, this.inventoryInstance.getId());
        this.ordersDeleted = this.inventoryDbLayer.deleteItemsFromDb(started, DBLayer.DBITEM_INVENTORY_ORDERS, this.inventoryInstance.getId());
        this.appliedLocksDeleted = this.inventoryDbLayer.deleteAppliedLocksFromDb(started, this.inventoryInstance.getId());
        this.locksDeleted = this.inventoryDbLayer.deleteItemsFromDb(started, DBLayer.DBITEM_INVENTORY_LOCKS, this.inventoryInstance.getId());
        this.schedulesDeleted = this.inventoryDbLayer.deleteItemsFromDb(started, DBLayer.DBITEM_INVENTORY_SCHEDULES, this.inventoryInstance.getId());
        this.processClassesDeleted = this.inventoryDbLayer.deleteItemsFromDb(started, DBLayer.DBITEM_INVENTORY_PROCESS_CLASSES, this.inventoryInstance.getId());
        this.agentClustersDeleted = this.inventoryDbLayer.deleteItemsFromDb(started, DBLayer.DBITEM_INVENTORY_AGENT_CLUSTER, this.inventoryInstance.getId());
        this.agentClusterMembersDeleted = this.inventoryDbLayer.deleteItemsFromDb(started, DBLayer.DBITEM_INVENTORY_AGENT_CLUSTERMEMBERS, this.inventoryInstance.getId());
        for (DBItemInventoryClusterCalendarUsage usage : this.dbCalendarUsages) {
            if (this.dbCalendarIds.contains(usage.getCalendarId())) continue;
            this.inventoryDbLayer.getSession().delete((Object)usage);
        }
    }

    private void processSchedulerXml() throws Exception {
        SOSXMLXPath xPathSchedulerXml = new SOSXMLXPath(this.schedulerXmlPath);
        String maxProcesses = xPathSchedulerXml.selectSingleNodeValue("/spooler/config/process_classes/process_class[not(@name)]/@max_processes");
        if (maxProcesses != null && !maxProcesses.isEmpty()) {
            this.processDefaultProcessClass(Integer.parseInt(maxProcesses));
        } else {
            this.processDefaultProcessClass(30);
        }
        String supervisor = xPathSchedulerXml.selectSingleNodeValue("/spooler/config/@supervisor");
        if (supervisor != null && !supervisor.isEmpty()) {
            DBItemInventoryInstance supervisorInstance = this.inventoryDbLayer.getInventorySupervisorInstance(supervisor);
            DBItemInventoryInstance updateInstance = this.inventoryDbLayer.getInventoryInstance(this.inventoryInstance.getId());
            if (supervisorInstance != null) {
                updateInstance.setSupervisorId(supervisorInstance.getId());
                this.inventoryDbLayer.getSession().update((Object)updateInstance);
            }
        }
    }

    private void processStateAnswerXML() throws Exception {
        try (SOSHibernateSession connection = this.factory.openStatelessSession();){
            this.inventoryDbLayer = new DBLayerInventory(connection);
            connection.beginTransaction();
            NodeList processClassNodes = this.xPathAnswerXml.selectNodeList("/spooler/answer/state/process_classes/process_class[file_based/@file]");
            for (int i = 0; i < processClassNodes.getLength(); ++i) {
                try {
                    this.processProcessClassFromNodes((Element)processClassNodes.item(i));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            NodeList lockNodes = this.xPathAnswerXml.selectNodeList("/spooler/answer/state/locks/lock[file_based/@file]");
            for (int i = 0; i < lockNodes.getLength(); ++i) {
                try {
                    this.processLockFromNodes((Element)lockNodes.item(i));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            NodeList scheduleNodes = this.xPathAnswerXml.selectNodeList("/spooler/answer/state/schedules/schedule[file_based/@file]");
            for (int i = 0; i < scheduleNodes.getLength(); ++i) {
                try {
                    this.processScheduleFromNodes((Element)scheduleNodes.item(i));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            NodeList jobNodes = this.xPathAnswerXml.selectNodeList("/spooler/answer/state/jobs/job[file_based/@file]");
            for (int i = 0; i < jobNodes.getLength(); ++i) {
                try {
                    this.processJobFromNodes((Element)jobNodes.item(i));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            NodeList jobChainNodes = this.xPathAnswerXml.selectNodeList("/spooler/answer/state/job_chains/job_chain[file_based/@file]");
            for (int i = 0; i < jobChainNodes.getLength(); ++i) {
                try {
                    this.processJobChainFromNodes((Element)jobChainNodes.item(i));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            NodeList orderNodes = this.xPathAnswerXml.selectNodeList("/spooler/answer/state/job_chains/job_chain/job_chain_node/order_queue/order[file_based/@file or (@in_database_only='yes' and @order_source_type='Permanent')]");
            for (int i = 0; i < orderNodes.getLength(); ++i) {
                try {
                    this.processOrderFromNodes((Element)orderNodes.item(i));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            NodeList monitorNodes = this.xPathAnswerXml.selectNodeList("/spooler/answer/state/monitors/monitor[file_based/@file]");
            for (int i = 0; i < monitorNodes.getLength(); ++i) {
                try {
                    this.processMonitorFromNodes((Element)monitorNodes.item(i));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            connection.commit();
        }
    }

    private DBItemInventoryFile processFile(Element element, EConfigFileExtensions fileExtension, Boolean save) throws Exception {
        String fileName = null;
        if (element.hasAttribute("path")) {
            fileName = Latin1ToUtf8.convert((String)(element.getAttribute("path") + fileExtension.extension()));
        }
        String fileBasename = fileName.substring(fileName.lastIndexOf("/") + 1);
        String fileDirectory = fileName.substring(0, fileName.lastIndexOf("/"));
        String fileType = fileExtension.type();
        String method = "  processFile";
        Date fileCreated = null;
        Date fileModified = null;
        Date fileLocalCreated = null;
        Date fileLocalModified = null;
        Path path = null;
        Element fileBasedElem = (Element)this.xPathAnswerXml.selectSingleNode((Node)element, "file_based");
        path = fileBasedElem.hasAttribute("file") ? Paths.get(Latin1ToUtf8.convert((String)fileBasedElem.getAttribute("file")), new String[0]) : this.liveDirectory.resolve(fileName.substring(1));
        try {
            BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            fileCreated = ReportUtil.convertFileTime2UTC(attrs.creationTime());
            fileModified = ReportUtil.convertFileTime2UTC(attrs.lastModifiedTime());
            fileLocalCreated = ReportUtil.convertFileTime2Local(attrs.creationTime());
            fileLocalModified = ReportUtil.convertFileTime2Local(attrs.lastModifiedTime());
            DBItemInventoryFile item = new DBItemInventoryFile();
            item.setInstanceId(this.inventoryInstance.getId());
            item.setFileType(fileType);
            item.setFileName(fileName);
            item.setFileBaseName(fileBasename);
            item.setFileDirectory(fileDirectory);
            item.setFileCreated(fileCreated);
            item.setFileModified(fileModified);
            item.setFileLocalCreated(fileLocalCreated);
            item.setFileLocalModified(fileLocalModified);
            if (save != null && save.booleanValue()) {
                Long id = SaveOrUpdateHelper.saveOrUpdateFile(this.inventoryDbLayer, item, this.dbFiles);
                if (item.getId() == null) {
                    item.setId(id);
                }
            }
            LOGGER.debug(String.format("%s: file     id = %s, fileType = %s, fileName = %s, fileBasename = %s, fileDirectory = %s, fileCreated = %s, fileModified = %s", method, item.getId(), item.getFileType(), item.getFileName(), item.getFileBaseName(), item.getFileDirectory(), item.getFileCreated(), item.getFileModified()));
            return item;
        }
        catch (IOException | IllegalArgumentException exception) {
            LOGGER.debug(String.format("%s: cannot read file attributes. file = %s, exception = %s  ", method, path.toString(), exception.toString()));
            return null;
        }
    }

    private void processJobFromNodes(Element job) throws Exception {
        String method = "    processJob";
        DBItemInventoryFile file = this.processFile(job, EConfigFileExtensions.JOB, true);
        if (file != null) {
            ++this.countTotalJobs;
            Element jobSource = (Element)this.xPathAnswerXml.selectSingleNode((Node)job, "source/job");
            if (jobSource == null) {
                jobSource = this.getSourceFromFile(job);
            }
            try {
                String docuPath;
                String criticality;
                DBItemInventoryJob item = new DBItemInventoryJob();
                String name = null;
                name = file.getFileName().replace(EConfigFileExtensions.JOB.extension(), "");
                item.setName(name);
                String baseName = file.getFileBaseName().replace(EConfigFileExtensions.JOB.extension(), "");
                item.setBaseName(baseName);
                String title = jobSource.getAttribute("title");
                if (title != null && !title.isEmpty()) {
                    item.setTitle(title);
                }
                if ((criticality = jobSource.getAttribute("criticality")) != null && !criticality.isEmpty()) {
                    item.setCriticality(criticality);
                } else {
                    item.setCriticality(SOSJobSchedulerGlobal.JOB_CRITICALITY.NORMAL.toString());
                }
                boolean isOrderJob = jobSource.hasAttribute("order") && "yes,1,true".contains(jobSource.getAttribute("order").toLowerCase());
                item.setIsOrderJob(isOrderJob);
                Node runTimeNode = this.xPathAnswerXml.selectSingleNode((Node)jobSource, "run_time");
                boolean isRuntimeDefined = false;
                if (runTimeNode != null) {
                    if (((Element)runTimeNode).hasAttribute("schedule")) {
                        isRuntimeDefined = true;
                    } else if (runTimeNode.hasChildNodes()) {
                        NodeList childNodes = runTimeNode.getChildNodes();
                        for (int i = 0; i < childNodes.getLength(); ++i) {
                            if (childNodes.item(i).getNodeType() != 1) continue;
                            isRuntimeDefined = true;
                            break;
                        }
                    }
                    item.setIsRuntimeDefined(isRuntimeDefined);
                } else {
                    item.setIsRuntimeDefined(false);
                }
                item.setInstanceId(file.getInstanceId());
                item.setFileId(file.getId());
                item.setCreated(ReportUtil.getCurrentDateTime());
                item.setModified(ReportUtil.getCurrentDateTime());
                if (jobSource.hasAttribute("process_class")) {
                    String processClass = jobSource.getAttribute("process_class");
                    Path path = Paths.get(item.getName(), new String[0]);
                    processClass = path.getParent().resolve(processClass).normalize().toString().replace('\\', '/');
                    DBItemInventoryProcessClass pc = this.processClassExists(processClass);
                    if (pc != null) {
                        item.setProcessClass(processClass);
                        item.setProcessClassName(pc.getName());
                        item.setProcessClassId(pc.getId());
                    } else {
                        item.setProcessClass(processClass);
                        Path jobPath = Paths.get(item.getName(), new String[0]);
                        String resolvedProcessClassPath = jobPath.getParent().resolve(processClass).normalize().toString().replace('\\', '/');
                        item.setProcessClassName(resolvedProcessClassPath);
                        item.setProcessClassId(DBLayer.DEFAULT_ID);
                    }
                } else {
                    item.setProcessClass(null);
                    item.setProcessClassName(".");
                    item.setProcessClassId(DBLayer.DEFAULT_ID);
                }
                String schedule = null;
                if (runTimeNode != null && ((Element)runTimeNode).hasAttribute("schedule")) {
                    schedule = ((Element)runTimeNode).getAttribute("schedule");
                }
                if (schedule != null && !schedule.isEmpty()) {
                    Path path = Paths.get(item.getName(), new String[0]).getParent();
                    String resolvedSchedulePath = path.resolve(schedule).normalize().toString().replace("\\", "/");
                    DBItemInventorySchedule is = this.scheduleExists(resolvedSchedulePath);
                    if (is != null) {
                        item.setSchedule(schedule);
                        item.setScheduleName(is.getName());
                        item.setScheduleId(is.getId());
                    } else {
                        item.setSchedule(schedule);
                        item.setScheduleName(resolvedSchedulePath);
                        item.setScheduleId(DBLayer.DEFAULT_ID);
                    }
                } else {
                    item.setSchedule(null);
                    item.setScheduleName(".");
                    item.setScheduleId(DBLayer.DEFAULT_ID);
                }
                String maxTasks = jobSource.getAttribute("tasks");
                if (maxTasks != null && !maxTasks.isEmpty()) {
                    item.setMaxTasks(Integer.parseInt(maxTasks));
                } else {
                    item.setMaxTasks(1);
                }
                NodeList description = jobSource.getElementsByTagName("description");
                item.setHasDescription(description != null && description.getLength() > 0);
                Node scriptNode = this.xPathAnswerXml.selectSingleNode((Node)jobSource, "script");
                boolean isYadeJob = false;
                if (scriptNode != null) {
                    if (((Element)scriptNode).hasAttribute("java_class")) {
                        String script;
                        switch (script = ((Element)scriptNode).getAttribute("java_class")) {
                            case "sos.scheduler.jade.JadeJob": 
                            case "sos.scheduler.jade.Jade4DMZJob": 
                            case "sos.scheduler.jade.SFTPSendJob": 
                            case "sos.scheduler.jade.SFTPReceiveJob": 
                            case "sos.scheduler.job.SOSDExJSAdapterClass": 
                            case "sos.scheduler.job.SOSJade4DMZJSAdapter": {
                                isYadeJob = true;
                                break;
                            }
                            default: {
                                isYadeJob = false;
                            }
                        }
                    }
                    if (((Element)scriptNode).hasAttribute("language")) {
                        item.setScriptLanguage(((Element)scriptNode).getAttribute("language"));
                    }
                }
                item.setIsYadeJob(isYadeJob);
                Long id = SaveOrUpdateHelper.saveOrUpdateJob(this.inventoryDbLayer, item, this.dbJobs);
                if (item.getId() == null) {
                    item.setId(id);
                }
                if (!this.dbJobs.contains(item)) {
                    this.dbJobs.add(item);
                }
                if ((docuPath = this.xPathAnswerXml.selectSingleNodeValue((Node)jobSource, "description/include/@file")) != null && (docuPath.startsWith("jobs/") || docuPath.startsWith("./jobs/"))) {
                    docuPath = docuPath.replaceFirst("jobs", DEFAULT_JOB_DOC_PATH);
                    this.createOrUpdateDocumentationUsage(this.inventoryDbLayer.getSession(), this.inventoryInstance.getSchedulerId(), docuPath, item.getId(), item.getName(), "JOB");
                }
                LOGGER.debug(String.format("%s: job     id = %s, jobName = %s, jobBasename = %s, title = %s, isOrderJob = %s, isRuntimeDefined = %s", method, item.getId(), item.getName(), item.getBaseName(), item.getTitle(), item.getIsOrderJob(), item.getIsRuntimeDefined()));
                ++this.countSuccessJobs;
                NodeList lockUses = jobSource.getElementsByTagName("lock.use");
                if (lockUses != null && lockUses.getLength() > 0) {
                    for (int i = 0; i < lockUses.getLength(); ++i) {
                        DBItemInventoryLock lock;
                        Element lockUse = (Element)lockUses.item(i);
                        String lockName = lockUse.getAttribute("lock");
                        if (lockName.contains("/")) {
                            lockName = lockName.substring(lockName.lastIndexOf("/") + 1);
                        }
                        if ((lock = this.lockExists(lockName)) == null) continue;
                        DBItemInventoryAppliedLock appliedLock = this.appliedLockExists(lock.getId(), item.getId());
                        if (appliedLock == null) {
                            appliedLock = new DBItemInventoryAppliedLock();
                            appliedLock.setJobId(item.getId());
                            appliedLock.setLockId(lock.getId());
                        }
                        Long appLockId = SaveOrUpdateHelper.saveOrUpdateAppliedLock(this.inventoryDbLayer, appliedLock, this.dbAppliedLocks);
                        if (appliedLock.getId() == null) {
                            appliedLock.setId(appLockId);
                        }
                        this.dbAppliedLocks.add(appliedLock);
                    }
                }
                if (schedule != null && !schedule.isEmpty()) {
                    List<DBItemInventoryClusterCalendarUsage> dbCalendarUsages = null;
                    dbCalendarUsages = this.inventoryDbLayer.getAllCalendarUsagesForObject(this.inventoryInstance.getSchedulerId(), item.getName(), "JOB");
                    Path filePath = this.liveDirectory.resolve(file.getFileName().substring(1));
                    InventoryRuntimeHelper.createOrUpdateCalendarUsage(this.getXPathFromFile(filePath), dbCalendarUsages, item, "JOB", this.inventoryDbLayer, this.liveDirectory, this.inventoryInstance.getSchedulerId(), this.timezone, false);
                }
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("%s: job file cannot be inserted = %s, exception = %s ", method, file.getFileName(), ex.toString()), (Throwable)ex);
                this.errorJobs.put(file.getFileName(), ex.toString());
            }
        }
    }

    private void processJobChainFromNodes(Element jobChain) throws Exception {
        String method = "    processJobChain";
        DBItemInventoryFile file = this.processFile(jobChain, EConfigFileExtensions.JOB_CHAIN, true);
        if (file != null) {
            ++this.countTotalJobChains;
            Element jobChainSource = (Element)jobChain.getElementsByTagName("job_chain").item(0);
            if (jobChainSource == null) {
                jobChainSource = this.getSourceFromFile(jobChain);
            }
            try {
                Path path;
                DBItemInventoryJobChain item = new DBItemInventoryJobChain();
                String name = null;
                name = file.getFileName().replace(EConfigFileExtensions.JOB_CHAIN.extension(), "");
                item.setName(name);
                String baseName = file.getFileBaseName().replace(EConfigFileExtensions.JOB_CHAIN.extension(), "");
                item.setBaseName(baseName);
                String title = jobChainSource.getAttribute("title");
                if (title != null && !title.isEmpty()) {
                    item.setTitle(title);
                }
                NodeList fileOrderSources = jobChainSource.getElementsByTagName("file_order_source");
                String startCause = null;
                startCause = fileOrderSources != null && fileOrderSources.getLength() > 0 ? EStartCauses.FILE_TRIGGER.value() : EStartCauses.ORDER.value();
                item.setStartCause(startCause);
                item.setInstanceId(file.getInstanceId());
                item.setFileId(file.getId());
                item.setStartCause(startCause);
                item.setCreated(ReportUtil.getCurrentDateTime());
                item.setModified(ReportUtil.getCurrentDateTime());
                String maxOrders = jobChainSource.getAttribute("max_orders");
                if (maxOrders != null && !maxOrders.isEmpty()) {
                    item.setMaxOrders(Integer.parseInt(maxOrders));
                }
                item.setDistributed(jobChainSource.hasAttribute("distributed") && "yes,1,true".contains(jobChainSource.getAttribute("distributed")));
                if (jobChainSource.hasAttribute("process_class")) {
                    String processClass = jobChainSource.getAttribute("process_class");
                    path = Paths.get(item.getName(), new String[0]);
                    String resolvedProcessClassPath = path.getParent().resolve(processClass).normalize().toString().replace('\\', '/');
                    DBItemInventoryProcessClass pc = this.processClassExists(resolvedProcessClassPath);
                    if (pc != null) {
                        item.setProcessClass(processClass);
                        item.setProcessClassName(pc.getName());
                        item.setProcessClassId(pc.getId());
                    } else {
                        item.setProcessClass(processClass);
                        item.setProcessClassName(resolvedProcessClassPath);
                        item.setProcessClassId(DBLayer.DEFAULT_ID);
                    }
                } else {
                    item.setProcessClass(null);
                    item.setProcessClassName(".");
                    item.setProcessClassId(DBLayer.DEFAULT_ID);
                }
                if (jobChain.hasAttribute("file_watching_process_class")) {
                    String fwProcessClass = jobChain.getAttribute("file_watching_process_class");
                    path = Paths.get(item.getName(), new String[0]);
                    String resolvedFwProcessClassPath = path.getParent().resolve(fwProcessClass).normalize().toString().replace('\\', '/');
                    DBItemInventoryProcessClass ipc = this.processClassExists(resolvedFwProcessClassPath);
                    if (ipc != null) {
                        item.setFileWatchingProcessClass(fwProcessClass);
                        item.setFileWatchingProcessClassName(ipc.getName());
                        item.setFileWatchingProcessClassId(ipc.getId());
                    } else {
                        item.setFileWatchingProcessClass(fwProcessClass);
                        item.setFileWatchingProcessClassName(resolvedFwProcessClassPath);
                        item.setFileWatchingProcessClassId(DBLayer.DEFAULT_ID);
                    }
                } else {
                    item.setFileWatchingProcessClass(null);
                    item.setFileWatchingProcessClassName(".");
                    item.setFileWatchingProcessClassId(DBLayer.DEFAULT_ID);
                }
                Long id = SaveOrUpdateHelper.saveOrUpdateJobChain(this.inventoryDbLayer, item, this.dbJobChains);
                if (id != null) {
                    item.setId(id);
                }
                if (!this.dbJobChains.contains(item)) {
                    this.dbJobChains.add(item);
                }
                LOGGER.debug(String.format("%s: jobChain    id = %s, startCause = %s, jobChainName = %s, jobChainBasename = %s, title = %s", method, item.getId(), item.getStartCause(), item.getName(), item.getBaseName(), item.getTitle()));
                NodeList nl = this.xPathAnswerXml.selectNodeList((Node)jobChainSource, "*");
                int ordering = 1;
                this.inventoryDbLayer.deleteOldNodes(item);
                for (int j = 0; j < nl.getLength(); ++j) {
                    Element jobChainNodeElement = (Element)nl.item(j);
                    DBItemInventoryJobChainNode nodeItem = this.createInventoryJobChainNode(jobChainNodeElement, item);
                    nodeItem.setInstanceId(file.getInstanceId());
                    nodeItem.setOrdering(new Long(ordering));
                    this.inventoryDbLayer.getSession().save((Object)nodeItem);
                    ++ordering;
                    LOGGER.debug(String.format("%s: jobChainNode     id = %s, nodeName = %s, ordering = %s, state = %s, nextState = %s, errorState = %s, job = %s, jobName = %s", method, nodeItem.getId(), nodeItem.getName(), nodeItem.getOrdering(), nodeItem.getState(), nodeItem.getNextState(), nodeItem.getErrorState(), nodeItem.getJob(), nodeItem.getJobName()));
                }
                ++this.countSuccessJobChains;
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("%s: job chain file cannot be inserted = %s , exception = %s", method, file.getFileName(), ex.toString()), (Throwable)ex);
                this.errorJobChains.put(file.getFileName(), ex.toString());
            }
        }
    }

    private DBItemInventoryJobChainNode createInventoryJobChainNode(Element jobChainNodeElement, DBItemInventoryJobChain jobChain) throws Exception {
        String nodeName = jobChainNodeElement.getNodeName();
        String job = jobChainNodeElement.getAttribute("job");
        String state = jobChainNodeElement.getAttribute("state");
        String nextState = jobChainNodeElement.getAttribute("next_state");
        String errorState = jobChainNodeElement.getAttribute("error_state");
        DBItemInventoryJobChainNode nodeItem = new DBItemInventoryJobChainNode();
        String jobName = Paths.get(jobChain.getName(), new String[0]).getParent().resolve(job).normalize().toString().replace('\\', '/');
        if (job != null && !job.isEmpty()) {
            DBItemInventoryJob jobItem = this.jobExists(jobName);
            if (jobItem != null) {
                nodeItem.setJob(job);
                nodeItem.setJobName(jobItem.getName());
                nodeItem.setJobId(jobItem.getId());
            } else {
                nodeItem.setJob(job);
                nodeItem.setJobName(jobName);
                nodeItem.setJobId(DBLayer.DEFAULT_ID);
            }
        } else {
            nodeItem.setJob(null);
            nodeItem.setJobName(".");
            nodeItem.setJobId(DBLayer.DEFAULT_ID);
        }
        nodeItem.setJobChainId(jobChain.getId());
        nodeItem.setName(nodeName);
        nodeItem.setState(state);
        nodeItem.setNextState(nextState);
        nodeItem.setErrorState(errorState);
        nodeItem.setCreated(ReportUtil.getCurrentDateTime());
        nodeItem.setModified(ReportUtil.getCurrentDateTime());
        nodeItem.setNestedJobChainId(DBLayer.DEFAULT_ID);
        nodeItem.setNestedJobChainName(".");
        nodeItem.setNodeType(this.getJobChainNodeType(nodeName, jobChainNodeElement));
        switch (nodeItem.getNodeType()) {
            case 1: {
                String delay;
                if (jobChainNodeElement.hasAttribute("delay") && (delay = jobChainNodeElement.getAttribute("delay")) != null && !delay.isEmpty()) {
                    nodeItem.setDelay(Integer.parseInt(delay));
                }
                if (!jobChainNodeElement.hasAttribute("on_error")) break;
                nodeItem.setOnError(jobChainNodeElement.getAttribute("on_error"));
                break;
            }
            case 2: {
                if (jobChainNodeElement.hasAttribute("job_chain")) {
                    String jobchain = jobChainNodeElement.getAttribute("job_chain");
                    String resolvedJobchainPath = Paths.get(jobChain.getName(), new String[0]).getParent().resolve(jobchain).normalize().toString().replace("\\", "/");
                    DBItemInventoryJobChain ijc = this.inventoryDbLayer.getJobChain(jobChain.getInstanceId(), resolvedJobchainPath);
                    if (ijc != null) {
                        nodeItem.setNestedJobChain(jobchain);
                        nodeItem.setNestedJobChainName(ijc.getName());
                        nodeItem.setNestedJobChainId(ijc.getId());
                        break;
                    }
                    nodeItem.setNestedJobChain(jobchain);
                    nodeItem.setNestedJobChainName(resolvedJobchainPath);
                    nodeItem.setNestedJobChainId(DBLayer.DEFAULT_ID);
                    break;
                }
                nodeItem.setNestedJobChain(null);
                nodeItem.setNestedJobChainId(DBLayer.DEFAULT_ID);
                nodeItem.setNestedJobChainName(".");
                break;
            }
            case 3: {
                nodeItem.setDirectory(jobChainNodeElement.getAttribute("directory"));
                if (!jobChainNodeElement.hasAttribute("regex")) break;
                nodeItem.setRegex(jobChainNodeElement.getAttribute("regex"));
                break;
            }
            case 4: {
                if (jobChainNodeElement.hasAttribute("move_to")) {
                    nodeItem.setMovePath(jobChainNodeElement.getAttribute("move_to"));
                    nodeItem.setFileSinkOp(1);
                    break;
                }
                nodeItem.setFileSinkOp(2);
                break;
            }
        }
        return nodeItem;
    }

    private void processOrderFromNodes(Element order) throws Exception {
        DBItemInventoryFile file;
        String method = "    processOrder";
        if (order.getAttribute("in_database_only").equals("yes") && order.getAttribute("order_source_type").equals("Permanent") && !order.getAttribute("job_chain").isEmpty()) {
            order.setAttribute("path", order.getAttribute("job_chain") + "," + order.getAttribute("order"));
        }
        if ((file = this.processFile(order, EConfigFileExtensions.ORDER, true)) != null) {
            ++this.countTotalOrders;
            try {
                String priority;
                DBItemInventoryOrder item = new DBItemInventoryOrder();
                String name = null;
                name = file.getFileName().replace(EConfigFileExtensions.ORDER.extension(), "");
                item.setName(name);
                String baseName = file.getFileBaseName().replace(EConfigFileExtensions.ORDER.extension(), "");
                item.setBaseName(baseName);
                String title = order.getAttribute("title");
                if (title != null && !title.isEmpty()) {
                    item.setTitle(title);
                }
                String jobChainBaseName = baseName.substring(0, baseName.indexOf(","));
                String directory = file.getFileDirectory().equals(".") ? "" : (file.getFileDirectory() + "/").replaceAll("//+", "/");
                String jobChainName = directory + jobChainBaseName;
                String orderId = baseName.substring(baseName.lastIndexOf(",") + 1);
                Node runTimeNode = this.xPathAnswerXml.selectSingleNode((Node)order, "run_time");
                boolean isRuntimeDefined = false;
                if (runTimeNode != null) {
                    if (((Element)runTimeNode).hasAttribute("schedule")) {
                        isRuntimeDefined = true;
                    } else if (runTimeNode.hasChildNodes()) {
                        NodeList childNodes = runTimeNode.getChildNodes();
                        for (int i = 0; i < childNodes.getLength(); ++i) {
                            if (childNodes.item(i).getNodeType() != 1) continue;
                            isRuntimeDefined = true;
                            break;
                        }
                    }
                    item.setIsRuntimeDefined(isRuntimeDefined);
                } else {
                    item.setIsRuntimeDefined(false);
                }
                NodeList runtimes = order.getElementsByTagName("run_time");
                item.setInstanceId(file.getInstanceId());
                item.setFileId(file.getId());
                item.setJobChainName(jobChainName);
                item.setOrderId(orderId);
                item.setCreated(ReportUtil.getCurrentDateTime());
                item.setModified(ReportUtil.getCurrentDateTime());
                DBItemInventoryJobChain jobChain = this.jobChainExists(jobChainBaseName);
                if (jobChain != null) {
                    item.setJobChainId(jobChain.getId());
                } else {
                    item.setJobChainId(DBLayer.DEFAULT_ID);
                }
                if (order.hasAttribute("state")) {
                    item.setInitialState(order.getAttribute("state"));
                }
                if (order.hasAttribute("end_state")) {
                    item.setEndState(order.getAttribute("end_state"));
                }
                if (order.hasAttribute("priority") && (priority = order.getAttribute("priority")) != null && !priority.isEmpty()) {
                    item.setPriority(Integer.parseInt(priority));
                }
                String schedule = null;
                Node runtime = runtimes.item(0);
                if (runtime != null && ((Element)runtime).hasAttribute("schedule")) {
                    schedule = ((Element)runtime).getAttribute("schedule");
                }
                if (schedule != null && !schedule.isEmpty()) {
                    Path path = Paths.get(item.getName(), new String[0]).getParent();
                    String resolvedSchedulePath = path.resolve(schedule).normalize().toString().replace("\\", "/");
                    DBItemInventorySchedule is = this.scheduleExists(resolvedSchedulePath);
                    if (is != null) {
                        item.setSchedule(schedule);
                        item.setScheduleName(is.getName());
                        item.setScheduleId(is.getId());
                    } else {
                        item.setSchedule(schedule);
                        item.setScheduleName(resolvedSchedulePath);
                        item.setScheduleId(DBLayer.DEFAULT_ID);
                    }
                } else {
                    item.setSchedule(null);
                    item.setScheduleName(".");
                    item.setScheduleId(DBLayer.DEFAULT_ID);
                }
                Long id = SaveOrUpdateHelper.saveOrUpdateOrder(this.inventoryDbLayer, item, this.dbOrders);
                if (item.getId() == null) {
                    item.setId(id);
                }
                if (!this.dbOrders.contains(item)) {
                    this.dbOrders.add(item);
                }
                LOGGER.debug(String.format("%s: order     id = %s, jobChainName = %s, orderId = %s, title = %s, isRuntimeDefined = %s", method, item.getId(), item.getJobChainName(), item.getOrderId(), item.getTitle(), item.getIsRuntimeDefined()));
                ++this.countSuccessOrders;
                List<DBItemInventoryClusterCalendarUsage> dbCalendarUsages = null;
                dbCalendarUsages = this.inventoryDbLayer.getAllCalendarUsagesForObject(this.inventoryInstance.getSchedulerId(), item.getName(), "ORDER");
                Path filePath = this.liveDirectory.resolve(file.getFileName().substring(1));
                InventoryRuntimeHelper.createOrUpdateCalendarUsage(this.getXPathFromFile(filePath), dbCalendarUsages, item, "ORDER", this.inventoryDbLayer, this.liveDirectory, this.inventoryInstance.getSchedulerId(), this.timezone, false);
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("%s: order file cannot be inserted = %s, exception = ", method, file.getFileName(), ex.toString()), (Throwable)ex);
                this.errorOrders.put(file.getFileName(), ex.toString());
            }
        }
    }

    private void processProcessClassFromNodes(Element processClass) throws Exception {
        DBItemInventoryFile file;
        if (!processClass.getAttribute("path").isEmpty() && (file = this.processFile(processClass, EConfigFileExtensions.PROCESS_CLASS, false)) != null) {
            try {
                ++this.countTotalProcessClasses;
                Element processClassSource = (Element)processClass.getElementsByTagName("process_class").item(0);
                if (processClassSource == null) {
                    processClassSource = this.getSourceFromFile(processClass);
                }
                DBItemInventoryProcessClass item = new DBItemInventoryProcessClass();
                String name = null;
                name = file.getFileName().replace(EConfigFileExtensions.PROCESS_CLASS.extension(), "");
                item.setName(name);
                String baseName = file.getFileBaseName().replace(EConfigFileExtensions.PROCESS_CLASS.extension(), "");
                item.setBasename(baseName);
                item.setInstanceId(file.getInstanceId());
                String maxProcesses = processClassSource.getAttribute("max_processes");
                if (maxProcesses != null && !maxProcesses.isEmpty()) {
                    item.setMaxProcesses(Integer.parseInt(maxProcesses));
                }
                String remoteScheduler = processClassSource.getAttribute("remote_scheduler");
                NodeList remoteSchedulers = processClassSource.getElementsByTagName("remote_scheduler");
                if (remoteScheduler != null && !remoteScheduler.isEmpty()) {
                    item.setHasAgents(true);
                } else {
                    item.setHasAgents(remoteSchedulers != null && remoteSchedulers.getLength() > 0);
                }
                if (!item.getHasAgents()) {
                    Long fileId = SaveOrUpdateHelper.saveOrUpdateFile(this.inventoryDbLayer, file, this.dbFiles);
                    if (file.getId() == null) {
                        file.setId(fileId);
                    }
                    item.setFileId(file.getId());
                    Long id = SaveOrUpdateHelper.saveOrUpdateProcessClass(this.inventoryDbLayer, item, this.dbProcessClasses);
                    if (item.getId() == null) {
                        item.setId(id);
                    }
                    LOGGER.debug(String.format("process: processClass     id = %s, processClassName = %s", item.getId(), item.getBasename()));
                    ++this.countSuccessProcessClasses;
                } else {
                    file.setFileType("agent_cluster");
                    Long fileId = SaveOrUpdateHelper.saveOrUpdateFile(this.inventoryDbLayer, file, this.dbFiles);
                    if (file.getId() == null) {
                        file.setId(fileId);
                    }
                    item.setFileId(file.getId());
                    Long id = SaveOrUpdateHelper.saveOrUpdateProcessClass(this.inventoryDbLayer, item, this.dbProcessClasses);
                    if (item.getId() == null) {
                        item.setId(id);
                    }
                    if (!this.dbProcessClasses.contains(item)) {
                        this.dbProcessClasses.add(item);
                    }
                    LOGGER.debug(String.format("process: processClass     id = %s, processClassName = %s", item.getId(), item.getBasename()));
                    ++this.countSuccessProcessClasses;
                    Map<String, Integer> remoteSchedulerUrls = InventoryModel.getRemoteSchedulersFromProcessClass(remoteSchedulers);
                    if (remoteSchedulerUrls != null && !remoteSchedulerUrls.isEmpty()) {
                        NodeList remoteSchedulersParent = processClassSource.getElementsByTagName("remote_schedulers");
                        if (remoteSchedulersParent != null && remoteSchedulersParent.getLength() > 0) {
                            Element remoteSchedulerParent = (Element)remoteSchedulersParent.item(0);
                            String schedulingType = remoteSchedulerParent.getAttribute("select");
                            if (schedulingType != null && !schedulingType.isEmpty()) {
                                this.processAgentCluster(remoteSchedulerUrls, schedulingType, item.getInstanceId(), item.getId());
                            } else if (remoteSchedulerUrls.size() == 1) {
                                this.processAgentCluster(remoteSchedulerUrls, "single", item.getInstanceId(), item.getId());
                            } else {
                                this.processAgentCluster(remoteSchedulerUrls, "first", item.getInstanceId(), item.getId());
                            }
                        }
                    } else {
                        remoteSchedulerUrls = new HashMap<String, Integer>();
                        if (remoteScheduler != null && !remoteScheduler.isEmpty()) {
                            remoteSchedulerUrls.put(remoteScheduler.toLowerCase(), 1);
                            this.processAgentCluster(remoteSchedulerUrls, "single", item.getInstanceId(), item.getId());
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("    processProcessClass: processClass file cannot be inserted = %s, exception = %s ", file.getFileName(), ex.toString()), (Throwable)ex);
                this.errorProcessClasses.put(file.getFileName(), ex.toString());
            }
        }
    }

    private void processLockFromNodes(Element lock) throws Exception {
        DBItemInventoryFile file = this.processFile(lock, EConfigFileExtensions.LOCK, true);
        if (file != null) {
            ++this.countTotalLocks;
            try {
                DBItemInventoryLock item = new DBItemInventoryLock();
                String name = null;
                name = file.getFileName().replace(EConfigFileExtensions.LOCK.extension(), "");
                item.setName(name);
                String baseName = file.getFileBaseName().replace(EConfigFileExtensions.LOCK.extension(), "");
                item.setBasename(baseName);
                item.setInstanceId(file.getInstanceId());
                item.setFileId(file.getId());
                String maxNonExclusive = lock.getAttribute("max_non_exclusive");
                if (maxNonExclusive != null && !maxNonExclusive.isEmpty()) {
                    item.setMaxNonExclusive(Integer.parseInt(maxNonExclusive));
                }
                Long id = SaveOrUpdateHelper.saveOrUpdateLock(this.inventoryDbLayer, item, this.dbLocks);
                if (item.getId() == null) {
                    item.setId(id);
                }
                if (!this.dbLocks.contains(item)) {
                    this.dbLocks.add(item);
                }
                ++this.countSuccessLocks;
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("    processLock: lock file cannot be inserted = %s, exception = %s ", file.getFileName(), ex.toString()), (Throwable)ex);
                this.errorLocks.put(file.getFileName(), ex.toString());
            }
        }
    }

    private void processMonitorFromNodes(Element monitor) throws Exception {
        DBItemInventoryFile file = this.processFile(monitor, EConfigFileExtensions.MONITOR, true);
        if (file != null) {
            ++this.countTotalMonitors;
        }
    }

    private void processScheduleFromNodes(Element schedule) throws Exception {
        DBItemInventoryFile file = this.processFile(schedule, EConfigFileExtensions.SCHEDULE, true);
        if (file != null) {
            ++this.countTotalSchedules;
            try {
                DBItemInventorySchedule item = new DBItemInventorySchedule();
                String name = null;
                name = file.getFileName().replace(EConfigFileExtensions.SCHEDULE.extension(), "");
                item.setName(name);
                String baseName = file.getFileBaseName().replace(EConfigFileExtensions.SCHEDULE.extension(), "");
                item.setBasename(baseName);
                item.setInstanceId(file.getInstanceId());
                item.setFileId(file.getId());
                String title = schedule.getAttribute("title");
                if (title != null && !title.isEmpty()) {
                    item.setTitle(title);
                }
                item.setSubstitute(schedule.getAttribute("substitute"));
                String timezone = this.inventoryInstance.getTimeZone();
                item.setSubstituteValidFrom(this.getSubstituteValidFromTo(schedule, "valid_from", timezone));
                item.setSubstituteValidTo(this.getSubstituteValidFromTo(schedule, "valid_to", timezone));
                Path path = Paths.get(item.getName(), new String[0]).getParent();
                DBItemInventorySchedule substituteItem = this.scheduleExists(path.resolve(item.getSubstitute()).normalize().toString().replace("\\", "/"));
                boolean pathNormalizationFailure = false;
                if (substituteItem != null) {
                    item.setSubstituteId(substituteItem.getId());
                    try {
                        item.setSubstituteName(path.resolve(substituteItem.getName()).normalize().toString().replace("\\", "/"));
                    }
                    catch (Exception e) {
                        pathNormalizationFailure = true;
                    }
                } else {
                    item.setSubstituteId(DBLayer.DEFAULT_ID);
                    item.setSubstituteName(".");
                }
                if (!pathNormalizationFailure) {
                    Long id = SaveOrUpdateHelper.saveOrUpdateSchedule(this.inventoryDbLayer, item, this.dbSchedules);
                    if (item.getId() == null) {
                        item.setId(id);
                    }
                }
                if (!this.dbSchedules.contains(item)) {
                    this.dbSchedules.add(item);
                }
                ++this.countSuccessSchedules;
                List<DBItemInventoryClusterCalendarUsage> dbCalendarUsages = null;
                dbCalendarUsages = this.inventoryDbLayer.getAllCalendarUsagesForObject(this.inventoryInstance.getSchedulerId(), item.getName(), "SCHEDULE");
                Path filePath = this.liveDirectory.resolve(file.getFileName().substring(1));
                InventoryRuntimeHelper.createOrUpdateCalendarUsage(this.getXPathFromFile(filePath), dbCalendarUsages, item, "SCHEDULE", this.inventoryDbLayer, this.liveDirectory, this.inventoryInstance.getSchedulerId(), timezone, false);
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("processSchedule: schedule file cannot be inserted = %s, exception = %s ", file.getFileName(), ex.toString()), (Throwable)ex);
                this.errorSchedules.put(file.getFileName(), ex.toString());
            }
        }
    }

    private Date getSubstituteValidFromTo(Element schedule, String attribute, String timezone) throws Exception {
        String validFromTo = schedule.getAttribute(attribute);
        if (validFromTo != null && !validFromTo.isEmpty()) {
            LocalDateTime localDateTime = LocalDateTime.parse(validFromTo, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            ZonedDateTime zdt = ZonedDateTime.of(localDateTime, ZoneId.of(timezone));
            Instant valid = zdt.toInstant();
            return Date.from(valid);
        }
        return null;
    }

    private DBItemInventoryProcessClass processClassExists(String pcName) {
        for (DBItemInventoryProcessClass pc : this.dbProcessClasses) {
            if (!pcName.equalsIgnoreCase(pc.getName())) continue;
            return pc;
        }
        return null;
    }

    private DBItemInventorySchedule scheduleExists(String scheduleName) {
        for (DBItemInventorySchedule schedule : this.dbSchedules) {
            if (!scheduleName.equalsIgnoreCase(schedule.getName())) continue;
            return schedule;
        }
        return null;
    }

    private DBItemInventoryLock lockExists(String lockName) {
        for (DBItemInventoryLock lock : this.dbLocks) {
            if (!lockName.equalsIgnoreCase(lock.getBasename())) continue;
            return lock;
        }
        return null;
    }

    private DBItemInventoryJob jobExists(String jobName) {
        for (DBItemInventoryJob job : this.dbJobs) {
            if (!jobName.equalsIgnoreCase(job.getName())) continue;
            return job;
        }
        return null;
    }

    private DBItemInventoryJobChain jobChainExists(String jobChainName) {
        for (DBItemInventoryJobChain jobChain : this.dbJobChains) {
            if (!jobChainName.equalsIgnoreCase(jobChain.getBaseName())) continue;
            return jobChain;
        }
        return null;
    }

    private DBItemInventoryAppliedLock appliedLockExists(Long lockId, Long jobId) {
        for (DBItemInventoryAppliedLock appliedLock : this.dbAppliedLocks) {
            if (lockId != appliedLock.getLockId() || jobId != appliedLock.getJobId()) continue;
            return appliedLock;
        }
        return null;
    }

    public void setAnswerXml(String answerXml) {
        this.answerXml = answerXml;
    }

    public static Map<String, Integer> getRemoteSchedulersFromProcessClass(NodeList remoteSchedulers) throws Exception {
        int ordering = 1;
        HashMap<String, Integer> remoteSchedulerUrls = new HashMap<String, Integer>();
        for (int i = 0; i < remoteSchedulers.getLength(); ++i) {
            Element remoteScheduler = (Element)remoteSchedulers.item(i);
            String url = remoteScheduler.getAttribute("remote_scheduler");
            if (url == null || url.isEmpty()) continue;
            remoteSchedulerUrls.put(url.toLowerCase(), ordering);
            ++ordering;
        }
        return remoteSchedulerUrls;
    }

    private void createOrUpdateDocumentationUsage(SOSHibernateSession connection, String schedulerId, String docuPath, Long jobId, String jobPath, String objectType) throws Exception {
        if (connection == null) {
            connection = this.factory.openStatelessSession();
        }
        DocumentationDBLayer dbLayer = new DocumentationDBLayer(connection);
        DBItemDocumentationUsage dbDocuUsage = dbLayer.getDocumentationUsageForAssignment(schedulerId, jobPath, objectType);
        DBItemDocumentation dbReferencedDocu = dbLayer.getDocumentation(schedulerId, docuPath);
        if (dbDocuUsage == null && dbReferencedDocu != null) {
            DBItemDocumentationUsage newDocuUsage = new DBItemDocumentationUsage();
            newDocuUsage.setDocumentationId(dbReferencedDocu.getId());
            newDocuUsage.setSchedulerId(schedulerId);
            newDocuUsage.setPath(jobPath);
            newDocuUsage.setObjectType(objectType);
            newDocuUsage.setCreated(Date.from(Instant.now()));
            newDocuUsage.setModified(newDocuUsage.getCreated());
            connection.save((Object)newDocuUsage);
        }
    }

    private Element getSourceFromFile(Element element) throws Exception {
        String file = this.xPathAnswerXml.selectSingleNodeValue((Node)element, "file_based/@file");
        try {
            return new SOSXMLXPath(file).getRoot();
        }
        catch (Exception ex) {
            throw new Exception(String.format("[%s]%s", file, ex.toString()), ex);
        }
    }

    private void updateDailyPlan(SOSHibernateSession session) throws Exception {
        String pluginContext = MDC.get((String)"plugin");
        MDC.put((String)"plugin", (String)"dailyplan");
        Calendar2DB calendar2Db = Calendar2DBHelper.initCalendar2Db(this.inventoryDbLayer, this.inventoryInstance, this.httpHost, this.httpPort);
        calendar2Db.store();
        if (pluginContext != null) {
            MDC.put((String)"plugin", (String)pluginContext);
        } else {
            MDC.remove((String)"plugin");
        }
    }

    public void setLiveDirectory(Path liveDirectory) {
        this.liveDirectory = liveDirectory;
    }

    private SOSXMLXPath getXPathFromFile(Path filePath) throws Exception {
        if (Files.exists(filePath, new LinkOption[0])) {
            return new SOSXMLXPath(filePath);
        }
        return null;
    }

    private void processUncommittedSubmissions() throws Exception {
        LOGGER.info("***** processUncommittedSubmissions *****");
        this.inventoryDbLayer.getSession().beginTransaction();
        List<DBItemSubmission> submissions = this.inventoryDbLayer.getUncommittedSubmissions(this.inventoryInstance.getId());
        this.inventoryDbLayer.getSession().commit();
        for (DBItemSubmission submission : submissions) {
            this.inventoryDbLayer.getSession().beginTransaction();
            LOGGER.debug(String.format("***** processing submission with ID=%1$s *****", submission.getSubmissionId()));
            List<DBItemSubmittedObject> submittedObjects = this.inventoryDbLayer.getUncommittedSubmittedObjects(submission.getSubmissionId());
            this.inventoryDbLayer.getSession().commit();
            if (submittedObjects == null) continue;
            for (DBItemSubmittedObject submittedObject : submittedObjects) {
                if (submittedObject.getPath() == null) continue;
                boolean isFolder = false;
                if (submittedObject.getPath().endsWith("/")) {
                    isFolder = true;
                }
                Path path = this.liveDirectory.resolve(submittedObject.getPath().substring(1));
                LOGGER.info(String.format("***** processing submission for Object = %1$s *****", path.toString()));
                if (Files.exists(path, new LinkOption[0])) {
                    if (submittedObject.getToDelete()) {
                        if (isFolder) {
                            LOGGER.info(String.format("***** delete folder: %1$s *****", path.toString()));
                            for (Path p : Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).collect(Collectors.toSet())) {
                                Files.delete(p);
                            }
                        } else {
                            LOGGER.info(String.format("***** delete file for Object = %1$s *****", path.toString()));
                            Files.delete(path);
                        }
                    } else if (submittedObject.getContent() != null && !submittedObject.getContent().isEmpty() && !isFolder) {
                        FileTime fileTime = Files.getLastModifiedTime(path, new LinkOption[0]);
                        if (fileTime.compareTo(FileTime.fromMillis(submittedObject.getModified().getTime())) <= 0) {
                            LOGGER.debug(String.format("***** file date is older, overwriting file: %1$s *****", path.toString()));
                            this.writeFile(submittedObject.getContent(), path);
                        } else {
                            LOGGER.debug(String.format("***** file date is younger, not overwriting file: %1$s *****", path.toString()));
                        }
                    }
                } else if (!submittedObject.getToDelete()) {
                    if (isFolder) {
                        LOGGER.debug(String.format("***** create folder: %1$s *****", path.toString()));
                        Files.createDirectories(path, new FileAttribute[0]);
                    } else {
                        LOGGER.debug(String.format("***** create file: %1$s *****", path.toString()));
                        this.writeFile(submittedObject.getContent(), path);
                    }
                }
                this.inventoryDbLayer.getSession().beginTransaction();
                LOGGER.debug("***** delete processed submission *****");
                this.inventoryDbLayer.getSession().delete((Object)submission);
                this.inventoryDbLayer.getSession().commit();
                Long count = this.inventoryDbLayer.getUncommitedInstanceCount(submission.getSubmissionId());
                if (count == 0L) {
                    LOGGER.debug("***** LAST ENTRY! delete submitted object, too *****");
                    this.inventoryDbLayer.getSession().beginTransaction();
                    this.inventoryDbLayer.getSession().delete((Object)submittedObject);
                    this.inventoryDbLayer.getSession().commit();
                    continue;
                }
                LOGGER.debug(String.format("***** %1$d more submission found for this submitted object, not deleting submitted object. *****", count));
            }
        }
    }

    private void writeFile(String xml, Path path) {
        if (xml != null && !xml.isEmpty()) {
            try {
                Files.write(path, xml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error(String.format("Error: %1$s - occurred during update of file %2$s, file not updated!", e.getMessage(), path));
            }
        }
    }
}

