/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.jobstreams.classes.JSEvent;
import com.sos.jitl.jobstreams.db.DBItemEvent;
import com.sos.jitl.jobstreams.db.DBItemOutCondition;
import com.sos.jitl.jobstreams.db.DBItemOutConditionWithEvent;
import com.sos.jitl.jobstreams.db.FilterEvents;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayerEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLayerEvents.class);
    private static final String DBItemEvents = DBItemEvent.class.getSimpleName();
    private static final String DBItemOutCondition = DBItemOutCondition.class.getSimpleName();
    private final SOSHibernateSession sosHibernateSession;

    public DBLayerEvents(SOSHibernateSession session) {
        this.sosHibernateSession = session;
    }

    public DBItemEvent getEventsDbItem(Long id) throws SOSHibernateException {
        return (DBItemEvent)this.sosHibernateSession.get(DBItemEvent.class, (Serializable)id);
    }

    public FilterEvents resetFilter() {
        FilterEvents filter = new FilterEvents();
        filter.setEvent("");
        filter.setSession("");
        filter.setJobStream("");
        return filter;
    }

    public String getContextListSql(List<String> list) {
        StringBuilder sql = new StringBuilder();
        sql.append("e.session in (");
        for (String s : list) {
            sql.append("'" + s + "',");
        }
        String s = sql.toString();
        s = s.substring(0, s.length() - 1);
        s = s + ")";
        return " (" + s + ") ";
    }

    private String getWhere(FilterEvents filter) {
        String where = "";
        String and = "";
        if (filter.getSchedulerId() != null && !"".equals(filter.getSchedulerId())) {
            where = filter.getIncludingGlobalEvent() != false ? where + and + " (o.schedulerId = :schedulerId or e.globalEvent=true)" : where + and + " o.schedulerId = :schedulerId";
            and = " and ";
        }
        if (filter.getSession() != null && !"".equals(filter.getSession())) {
            where = where + and + " e.session = :session";
            and = " and ";
        }
        if (filter.getEvent() != null && !"".equals(filter.getEvent())) {
            where = where + and + " e.event = :event";
            and = " and ";
        }
        if (filter.getGlobalEvent() != null) {
            where = where + and + " e.globalEvent = :globalEvent";
            and = " and ";
        }
        if (filter.getJob() != null && !"".equals(filter.getJob())) {
            where = where + and + " o.job = :job";
            and = " and ";
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            where = where + and + " e.jobStream = :jobStream";
            and = " and ";
        }
        if (filter.getOutConditionId() != null) {
            where = where + and + " e.outConditionId = :outConditionId";
            and = " and ";
        }
        if (filter.getJobStreamHistoryId() != null) {
            where = where + and + " e.jobStreamHistoryId = :jobStreamHistoryId";
            and = " and ";
        }
        if (filter.getListOfSession() != null && filter.getListOfSession().size() > 0) {
            where = where + and + this.getContextListSql(filter.getListOfSession());
            and = " and ";
        }
        if (filter.getJoin() != null && !"".equals(filter.getJoin())) {
            where = where + and + filter.getJoin();
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    private String getDeleteWhere(FilterEvents filter) {
        String where = "";
        String and = "";
        if (filter.getSchedulerId() != null && !"".equals(filter.getSchedulerId())) {
            where = where + and + " schedulerId = :schedulerId";
            and = " and ";
        }
        if (filter.getJob() != null && !"".equals(filter.getJob())) {
            where = where + and + " job = :job";
            and = " and ";
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            where = where + and + " jobStream = :jobStream";
            and = " and ";
        }
        if (filter.getJobStreamHistoryId() != null) {
            where = where + and + " e.jobStreamHistoryId = :jobStreamHistoryId";
            and = " and ";
        }
        where = " where " + where;
        return where;
    }

    private <T> Query<T> bindParameters(FilterEvents filter, Query<T> query) {
        if (filter.getEvent() != null && !"".equals(filter.getEvent())) {
            query.setParameter("event", (Object)filter.getEvent());
        }
        if (filter.getGlobalEvent() != null) {
            query.setParameter("globalEvent", (Object)filter.getGlobalEvent());
        }
        if (filter.getSchedulerId() != null && !"".equals(filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)filter.getSchedulerId());
        }
        if (filter.getSession() != null && !"".equals(filter.getSession())) {
            query.setParameter("session", (Object)filter.getSession());
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            query.setParameter("jobStream", (Object)filter.getJobStream());
        }
        if (filter.getJob() != null && !"".equals(filter.getJob())) {
            query.setParameter("job", (Object)filter.getJob());
        }
        if (filter.getOutConditionId() != null) {
            query.setParameter("outConditionId", (Object)filter.getOutConditionId());
        }
        if (filter.getJobStreamHistoryId() != null) {
            query.setParameter("jobStreamHistoryId", (Object)filter.getJobStreamHistoryId());
        }
        return query;
    }

    public List<DBItemOutConditionWithEvent> executeGetEventsList(FilterEvents filter, int limit) throws SOSHibernateException {
        filter.setJoin("e.outConditionId=o.id");
        String q = "select e.id as eventId,e.outConditionId as outConditionId,e.jobStreamHistoryId as jobStreamHistoryId,e.session as session,e.event as event, e.created as created, e.jobStream as jobStream,e.globalEvent as globalEvent,o.schedulerId as jobSchedulerId  from " + DBItemEvents + " e, " + DBItemOutCondition + " o " + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        query.setResultTransformer(Transformers.aliasToBean(DBItemOutConditionWithEvent.class));
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public List<DBItemOutConditionWithEvent> getEventsList(FilterEvents filter, int limit) throws SOSHibernateException {
        filter.setJoin("e.outConditionId=o.id");
        if (filter.getListOfSession() != null) {
            ArrayList<DBItemOutConditionWithEvent> resultList = new ArrayList<DBItemOutConditionWithEvent>();
            int size = filter.getListOfSession().size();
            if (size > 1000) {
                ArrayList copy = (ArrayList)filter.getListOfSession().stream().collect(Collectors.toList());
                for (int i = 0; i < size; i += 1000) {
                    if (size > i + 1000) {
                        filter.setListOfSession(copy.subList(i, i + 1000));
                    } else {
                        filter.setListOfSession(copy.subList(i, size));
                    }
                    resultList.addAll(this.executeGetEventsList(filter, limit));
                }
                return resultList;
            }
            return this.executeGetEventsList(filter, limit);
        }
        return this.executeGetEventsList(filter, limit);
    }

    public Integer delete(FilterEvents filter) throws SOSHibernateException {
        int row = 0;
        String hql = "";
        String schedulerId = filter.getSchedulerId();
        if (filter.getGlobalEvent() != null && filter.getGlobalEvent().booleanValue()) {
            filter.setSchedulerId("");
            hql = "delete from " + DBItemEvents + " e " + this.getWhere(filter);
        } else if (filter.getSchedulerId() == null || filter.getSchedulerId().isEmpty()) {
            hql = "delete from " + DBItemEvents + " e " + this.getWhere(filter);
        } else {
            filter.setSchedulerId("");
            String select = "select id from " + DBItemOutCondition + " where schedulerId = :schedulerId";
            hql = "delete from " + DBItemEvents + " e " + this.getWhere(filter) + " and e.outConditionId in ( " + select + ")";
            filter.setSchedulerId(schedulerId);
        }
        Query query = this.sosHibernateSession.createQuery(hql);
        query = this.bindParameters(filter, query);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public void store(JSEvent event) throws SOSHibernateException {
        FilterEvents filterEvents = new FilterEvents();
        filterEvents.setEvent(event.getEvent());
        filterEvents.setJobStream(event.getJobStream());
        filterEvents.setOutConditionId(event.getOutConditionId());
        filterEvents.setSession(event.getSession());
        filterEvents.setSchedulerId(event.getSchedulerId());
        filterEvents.setGlobalEvent(event.isGlobalEvent());
        this.delete(filterEvents);
        this.sosHibernateSession.save((Object)event.getItemEvent());
    }

    public int updateEvents(Long oldId, Long newId) throws SOSHibernateException {
        String hql = "update " + DBItemEvents + " set outConditionId=" + newId + " where outConditionId=:oldId";
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        query.setParameter("oldId", (Object)oldId);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public int updateEventsWithJobStream(String oldJobStream, String newJobStream) throws SOSHibernateException {
        String hql = "update " + DBItemEvents + " set jobStream='" + newJobStream + "' where jobStream=:oldJobStream";
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        query.setParameter("oldJobStream", (Object)oldJobStream);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }
}

