/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.jobstreams.db.DBItemInCondition;
import com.sos.jitl.jobstreams.db.DBItemInConditionCommand;
import com.sos.jitl.jobstreams.db.FilterInConditionCommands;
import com.sos.joc.model.jobstreams.InCondition;
import com.sos.joc.model.jobstreams.InConditionCommand;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayerInConditionCommands {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLayerInConditionCommands.class);
    private static final String DBItemInConditionCommand = DBItemInConditionCommand.class.getSimpleName();
    private static final String DBItemInCondition = DBItemInCondition.class.getSimpleName();
    private final SOSHibernateSession sosHibernateSession;

    public DBLayerInConditionCommands(SOSHibernateSession session) {
        this.sosHibernateSession = session;
    }

    public DBItemInConditionCommand getInConditionCommandDbItem(Long id) throws Exception {
        return (DBItemInConditionCommand)this.sosHibernateSession.get(DBItemInConditionCommand.class, (Serializable)id);
    }

    public FilterInConditionCommands resetFilter() {
        FilterInConditionCommands filter = new FilterInConditionCommands();
        filter.setCommand("");
        filter.setCommandParam("");
        return filter;
    }

    private String getDeleteWhere(FilterInConditionCommands filter) {
        String where = "";
        String and = "";
        if (filter.getJob() != null && !"".equals(filter.getJob())) {
            where = where + and + " job = :job";
            and = " and ";
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            where = where + and + " jobStream = :jobstream";
            and = " and ";
        }
        if (filter.getFolder() != null && !"".equals(filter.getFolder())) {
            where = where + and + " folder = :folder";
            and = " and ";
        }
        where = " where " + where;
        return where;
    }

    private String getWhere(FilterInConditionCommands filter) {
        String where = "";
        String and = "";
        if (filter.getCommand() != null && !"".equals(filter.getCommand())) {
            where = where + and + " command = :command";
            and = " and ";
        }
        if (filter.getCommandParam() != null && !"".equals(filter.getCommandParam())) {
            where = where + and + " commandParam = :commandParam";
            and = " and ";
        }
        if (filter.getInConditionId() != null) {
            where = where + and + " inConditionId = :inConditionId";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    private <T> Query<T> bindParameters(FilterInConditionCommands filter, Query<T> query) {
        if (filter.getCommand() != null && !"".equals(filter.getCommand())) {
            query.setParameter("command", (Object)filter.getCommand());
        }
        if (filter.getCommandParam() != null && !"".equals(filter.getCommandParam())) {
            query.setParameter("commandParam", (Object)filter.getCommandParam());
        }
        if (filter.getInConditionId() != null) {
            query.setParameter("inConditionId", (Object)filter.getInConditionId());
        }
        if (filter.getJob() != null) {
            query.setParameter("job", (Object)filter.getJob());
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            query.setParameter("jobstream", (Object)filter.getJobStream());
        }
        if (filter.getFolder() != null && !"".equals(filter.getFolder())) {
            query.setParameter("folder", (Object)filter.getFolder());
        }
        return query;
    }

    public List<DBItemInConditionCommand> getInConditionCommandsList______(FilterInConditionCommands filter, int limit) throws SOSHibernateException {
        String q = " from " + DBItemInConditionCommand + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public int deleteByInConditionId(FilterInConditionCommands filterConditionCommands) throws SOSHibernateException {
        String hql = "delete from " + DBItemInConditionCommand + " i " + this.getWhere(filterConditionCommands);
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        query = this.bindParameters(filterConditionCommands, query);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public int deleteCommandWithInConditions(FilterInConditionCommands filterConditionCommands) throws SOSHibernateException {
        String select = "select id from " + DBItemInCondition + this.getDeleteWhere(filterConditionCommands);
        String hql = "delete from " + DBItemInConditionCommand + " where inConditionId in ( " + select + ")";
        Query query = this.sosHibernateSession.createQuery(hql);
        this.bindParameters(filterConditionCommands, query);
        int row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public void deleteInsert(DBItemInCondition dbItemInCondition, InCondition inCondition) throws SOSHibernateException {
        FilterInConditionCommands filterInConditionCommands = new FilterInConditionCommands();
        filterInConditionCommands.setInConditionId(inCondition.getId());
        if (inCondition.getId() != null) {
            this.deleteByInConditionId(filterInConditionCommands);
        }
        for (InConditionCommand inConditionCommand : inCondition.getInconditionCommands()) {
            DBItemInConditionCommand dbItemInConditionCommand = new DBItemInConditionCommand();
            dbItemInConditionCommand.setInConditionId(dbItemInCondition.getId());
            dbItemInConditionCommand.setCommand(inConditionCommand.getCommand());
            dbItemInConditionCommand.setCommandParam(inConditionCommand.getCommandParam());
            dbItemInConditionCommand.setCreated(new Date());
            this.sosHibernateSession.save((Object)dbItemInConditionCommand);
        }
    }
}

