/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.jobstreams.db.DBItemJobStreamParameter;
import com.sos.jitl.jobstreams.db.FilterJobStreamParameters;
import java.io.Serializable;
import java.util.List;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayerJobStreamParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLayerJobStreamParameters.class);
    private static final String DBItemJobStreamParameter = DBItemJobStreamParameter.class.getSimpleName();
    private final SOSHibernateSession sosHibernateSession;

    public DBLayerJobStreamParameters(SOSHibernateSession session) {
        this.sosHibernateSession = session;
    }

    public DBItemJobStreamParameter getJobStreamParametersDbItem(Long id) throws SOSHibernateException {
        return (DBItemJobStreamParameter)this.sosHibernateSession.get(DBItemJobStreamParameter.class, (Serializable)id);
    }

    public FilterJobStreamParameters resetFilter() {
        FilterJobStreamParameters filter = new FilterJobStreamParameters();
        filter.setName("");
        return filter;
    }

    private String getWhere(FilterJobStreamParameters filter) {
        String where = "";
        String and = " ";
        if (filter.getName() != null && !"".equals(filter.getName())) {
            where = where + and + " name = :name";
            and = " and ";
        }
        if (filter.getJobStreamStarterId() != null) {
            where = where + and + " jobStreamStarter  = :jobStreamStarter";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = " where " + where;
        }
        return where;
    }

    private <T> Query<T> bindParameters(FilterJobStreamParameters filter, Query<T> query) {
        if (filter.getName() != null) {
            query.setParameter("name", (Object)filter.getName());
        }
        if (filter.getJobStreamStarterId() != null) {
            query.setParameter("jobStreamStarter", (Object)filter.getJobStreamStarterId());
        }
        return query;
    }

    public List<DBItemJobStreamParameter> getJobStreamParametersList(FilterJobStreamParameters filter, int limit) throws SOSHibernateException {
        String q = "  from " + DBItemJobStreamParameter + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public Integer delete(FilterJobStreamParameters filter) throws SOSHibernateException {
        int row = 0;
        String hql = "";
        hql = "delete from " + DBItemJobStreamParameter + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(hql);
        query = this.bindParameters(filter, query);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public void save(DBItemJobStreamParameter jsJobStreamParameter) throws SOSHibernateException {
        this.sosHibernateSession.save((Object)jsJobStreamParameter);
    }
}

