/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.join;

import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.jitl.join.JobSchedulerJoinOrdersOptions;
import com.sos.jitl.join.JoinOrder;
import com.sos.jitl.join.JoinSerializer;
import com.sos.scheduler.messages.JSMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerJoinOrders
extends JSJobUtilitiesClass<JobSchedulerJoinOrdersOptions> {
    protected JobSchedulerJoinOrdersOptions jobSchedulerJoinOrdersOptions = null;
    private static final String CLASSNAME = "JobSchedulerJoinOrders";
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerJoinOrders.class);
    private JSJobUtilities objJSJobUtilities = this;
    private JoinOrder joinOrder;
    private String joinOrderListString;
    private boolean resumeAllOrders;
    private JoinSerializer joinSerializer;

    public JobSchedulerJoinOrders() {
        super((Object)new JobSchedulerJoinOrdersOptions());
    }

    public JobSchedulerJoinOrdersOptions getOptions() {
        if (this.jobSchedulerJoinOrdersOptions == null) {
            this.jobSchedulerJoinOrdersOptions = new JobSchedulerJoinOrdersOptions();
        }
        return this.jobSchedulerJoinOrdersOptions;
    }

    public JobSchedulerJoinOrdersOptions getOptions(JobSchedulerJoinOrdersOptions pobjOptions) {
        this.jobSchedulerJoinOrdersOptions = pobjOptions;
        return this.jobSchedulerJoinOrdersOptions;
    }

    public JobSchedulerJoinOrders execute() throws Exception {
        String METHODNAME = "JobSchedulerJoinOrders::execute";
        LOGGER.debug(String.format(JSMessages.JSJ_I_110.get(), "JobSchedulerJoinOrders::execute"));
        try {
            this.getOptions().checkMandatory();
            LOGGER.debug(this.getOptions().toString());
            this.joinSerializer = new JoinSerializer(this.joinOrderListString);
            LOGGER.debug(String.format("adding orders %s", this.joinOrder.getOrderId()));
            this.joinSerializer.addOrder(this.joinOrder);
            LOGGER.debug(String.format("%s orders found", this.joinSerializer.getJoinOrderList().size(this.joinOrder)));
            this.resumeAllOrders = this.getOptions().required_orders.value() <= this.joinSerializer.getJoinOrderList().size(this.joinOrder);
            LOGGER.debug(String.format("%s required -- %s found --> %s", this.getOptions().required_orders.value(), this.joinSerializer.getJoinOrderList().size(this.joinOrder), this.resumeAllOrders));
        }
        catch (Exception e) {
            try {
                LOGGER.error(e.getMessage(), (Throwable)e);
                LOGGER.error(String.format(JSMessages.JSJ_F_107.get(), "JobSchedulerJoinOrders::execute"), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                LOGGER.debug(String.format(JSMessages.JSJ_I_111.get(), "JobSchedulerJoinOrders::execute"));
                throw throwable;
            }
        }
        LOGGER.debug(String.format(JSMessages.JSJ_I_111.get(), "JobSchedulerJoinOrders::execute"));
        return this;
    }

    public String replaceSchedulerVars(String pstrString2Modify) {
        LOGGER.debug("replaceSchedulerVars as Dummy-call executed. No Instance of JobUtilites specified.");
        return pstrString2Modify;
    }

    public void setJSJobUtilites(JSJobUtilities pobjJSJobUtilities) {
        this.objJSJobUtilities = pobjJSJobUtilities == null ? this : pobjJSJobUtilities;
        LOGGER.debug("objJSJobUtilities = " + this.objJSJobUtilities.getClass().getName());
    }

    public JoinOrder getJoinOrder() {
        return this.joinOrder;
    }

    public void setJoinOrder(JoinOrder joinOrder) {
        this.joinOrder = joinOrder;
    }

    public void setJoinOrderListString(String joinOrderListString) {
        this.joinOrderListString = joinOrderListString;
    }

    public boolean isResumeAllOrders() {
        return this.resumeAllOrders;
    }

    public JoinSerializer getJoinSerializer() {
        return this.joinSerializer;
    }

    public JoinOrder getMainOrder(JoinOrder joinOrder) {
        return this.joinSerializer.getJoinOrderList().getMainOrder(joinOrder);
    }
}

