/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.join;

import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.join.JobSchedulerJoinOrders;
import com.sos.jitl.join.JobSchedulerJoinOrdersOptions;
import com.sos.jitl.join.JoinOrder;
import com.sos.jitl.join.JoinSerializer;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Variable_set;
import sos.xml.SOSXMLXPath;

public class JobSchedulerJoinOrdersJSAdapterClass
extends JobSchedulerJobAdapter {
    private static final String XML_PATH_PARAM_VALUE = "/spooler/answer/order/payload/params/param[@name='%s']/@value";
    private static final String COMMAND_GET_ORDER = "<show_order job_chain='%s' order='%s' what='payload'></show_order>";
    private static final String COMMAND_SET_SERIALIZED = "<modify_order job_chain='%s' order='%s'><params><param name='%s' value='%s'/><param name='%s' value='%s'/></params></modify_order>";
    private static final String JOIN_SERIALIZED_OBJECT_CHECK_PARAM_NAME = "join_serialized_object_check";
    private static final String JOIN_SERIALIZED_OBJECT_PARAM_NAME = "join_serialized_object";
    private static final String RESET_STATE_TEXT = "resetStateText";
    private static final String RESUME_FOR_STATE_TEXT = "<modify_order job_chain='%s' order='%s' suspended='no' state='%s'><params><param name='scheduler_join_state_text' value='%s'></param></params></modify_order>";
    private JobSchedulerJoinOrders jobSchedulerJoinOrders;
    private JobSchedulerJoinOrdersOptions jobSchedulerJoinOrdersOptions;
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerJoinOrdersJSAdapterClass.class);

    public boolean spooler_process() throws Exception {
        try {
            super.spooler_process();
            this.doProcessing();
            return this.getSpoolerProcess().isOrderJob();
        }
        catch (Exception e) {
            throw new JobSchedulerException("Fatal Error:" + e.getMessage(), (Throwable)e);
        }
    }

    private void suspendOrder() {
        if (!this.spooler_task.order().suspended()) {
            this.spooler_task.order().set_state(this.spooler_task.order().state());
            this.spooler_task.order().set_suspended(true);
        }
        LOGGER.debug(String.format("Suspending order %s", this.spooler_task.order().id()));
    }

    private void setRequired() {
        Variable_set v = this.spooler.create_variable_set();
        v.merge(this.spooler_task.params());
        v.merge(this.spooler_task.order().params());
        String stateParamName = this.spooler_task.order().job_chain().name() + "," + this.jobSchedulerJoinOrdersOptions.getCurrentNodeName() + "_required_orders";
        String stateParamValue = v.value(stateParamName);
        LOGGER.debug("1stateParamName=stateParamValue" + stateParamName + "=" + stateParamValue);
        if (!"".equals(stateParamValue)) {
            LOGGER.debug("required_order from " + stateParamName + "=" + stateParamValue);
            this.jobSchedulerJoinOrdersOptions.required_orders.setValue(stateParamValue);
            LOGGER.debug(String.format("New value for waiting for %s orders", this.jobSchedulerJoinOrdersOptions.required_orders.value()));
        } else {
            stateParamName = this.spooler_task.order().job_chain().name() + "_required_orders";
            stateParamValue = v.value(stateParamName);
            LOGGER.debug("2stateParamName=stateParamValue" + stateParamName + "=" + stateParamValue);
            if (!"".equals(stateParamValue)) {
                LOGGER.debug("required_order from " + stateParamName + "=" + stateParamValue);
                this.jobSchedulerJoinOrdersOptions.required_orders.setValue(stateParamValue);
                LOGGER.debug(String.format("New value for waiting for %s orders", this.jobSchedulerJoinOrdersOptions.required_orders.value()));
            }
        }
    }

    private JoinOrder createJoinOrder() {
        boolean isMainOrder;
        String jobChain = this.spooler_task.order().job_chain().path();
        String orderId = this.spooler_task.order().id();
        String joinSessionId = "";
        boolean bl = isMainOrder = !this.spooler_task.order().end_state().equals(this.spooler_task.order().state());
        if (isMainOrder) {
            joinSessionId = orderId;
        } else if (this.jobSchedulerJoinOrdersOptions.joinSessionId.isDirty()) {
            joinSessionId = this.jobSchedulerJoinOrdersOptions.joinSessionId.getValue();
            LOGGER.debug("join_session_id is" + joinSessionId);
        }
        return new JoinOrder(jobChain, orderId, joinSessionId, isMainOrder, this.jobSchedulerJoinOrdersOptions.getCurrentNodeName());
    }

    private void resetMainOrder() {
        LOGGER.debug("reset main order");
        this.setStateText("");
        this.spooler_task.order().params().set_value(JOIN_SERIALIZED_OBJECT_PARAM_NAME, "");
        this.spooler_task.order().params().set_value(JOIN_SERIALIZED_OBJECT_CHECK_PARAM_NAME, "");
    }

    private boolean setStateText(JoinOrder joinOrder) {
        String stateText = this.spooler_task.order().params().value("scheduler_join_state_text");
        if (joinOrder.isMainOrder() && !"".equals(stateText)) {
            this.spooler_task.order().params().set_var("scheduler_join_state_text", "");
            if (RESET_STATE_TEXT.equals(stateText)) {
                this.resetMainOrder();
            } else {
                LOGGER.debug("set statetext for main order: " + stateText);
                this.setStateText(stateText);
                this.suspendOrder();
            }
            return true;
        }
        return false;
    }

    private JoinOrder setStateTextAfter(JoinOrder joinOrder) {
        String stateText = String.format("...%s orders from %s required orders received", this.jobSchedulerJoinOrders.getJoinSerializer().getJoinOrderList().size(joinOrder), this.jobSchedulerJoinOrdersOptions.required_orders.value());
        JoinOrder mainOrder = null;
        if (joinOrder.isMainOrder()) {
            mainOrder = joinOrder;
            LOGGER.debug("This is the mainOrder. Set state text for main order: " + stateText);
            this.setStateText(stateText);
        } else {
            mainOrder = this.jobSchedulerJoinOrders.getMainOrder(joinOrder);
            if (mainOrder == null) {
                LOGGER.warn("Could not find main order for joinSessionId: " + joinOrder.getJoinSessionId());
            } else {
                LOGGER.debug("This is a subOrder. Resuming mainOrder to set state text: " + stateText);
                String stateTextCommand = String.format(RESUME_FOR_STATE_TEXT, mainOrder.getJobChain(), mainOrder.getOrderId(), this.spooler_task.order().job_chain_node().state(), stateText);
                this.executeXml(stateTextCommand);
            }
        }
        return mainOrder;
    }

    private String executeXml(String command) {
        LOGGER.debug("... command=" + command);
        String answer = this.spooler.execute_xml(command);
        LOGGER.debug(answer);
        return answer;
    }

    private void setSerializedObject(JoinOrder joinOrder) throws Exception {
        JoinSerializer joinSerializer = this.jobSchedulerJoinOrders.getJoinSerializer();
        if (joinSerializer != null) {
            if (joinOrder.isMainOrder()) {
                this.spooler_task.order().params().set_value(JOIN_SERIALIZED_OBJECT_PARAM_NAME, joinSerializer.getSerializedObject());
            } else {
                String checkFromOrder;
                String check = UUID.randomUUID().toString();
                String mainOrderId = joinOrder.getJoinSessionId();
                String setParamCommand = String.format(COMMAND_SET_SERIALIZED, joinOrder.getJobChain(), mainOrderId, JOIN_SERIALIZED_OBJECT_PARAM_NAME, joinSerializer.getSerializedObject(), JOIN_SERIALIZED_OBJECT_CHECK_PARAM_NAME, check);
                do {
                    this.executeXml(setParamCommand);
                    String getParamCommand = String.format(COMMAND_GET_ORDER, joinOrder.getJobChain(), mainOrderId);
                    String answer = this.executeXml(getParamCommand);
                    SOSXMLXPath sosxml = new SOSXMLXPath(new StringBuffer(answer));
                    checkFromOrder = sosxml.selectSingleNodeValue(String.format(XML_PATH_PARAM_VALUE, JOIN_SERIALIZED_OBJECT_CHECK_PARAM_NAME));
                    if (check.equals(checkFromOrder)) continue;
                    LOGGER.debug("...Waiting 3s because mainOrder does not confirm setting parameters.");
                    Thread.sleep(3000L);
                } while (!check.equals(checkFromOrder));
            }
            if (this.jobSchedulerJoinOrdersOptions.showJoinOrderList.value()) {
                joinSerializer.showJoinOrderList(joinOrder);
            }
        }
    }

    private String getSerializedObject(JoinOrder joinOrder) throws Exception {
        if (joinOrder.isMainOrder()) {
            return this.spooler_task.order().params().value(JOIN_SERIALIZED_OBJECT_PARAM_NAME);
        }
        String mainOrderId = joinOrder.getJoinSessionId();
        String getParamCommand = String.format(COMMAND_GET_ORDER, joinOrder.getJobChain(), mainOrderId);
        String answer = this.executeXml(getParamCommand);
        SOSXMLXPath sosxml = new SOSXMLXPath(new StringBuffer(answer));
        String xmlPath = String.format(XML_PATH_PARAM_VALUE, JOIN_SERIALIZED_OBJECT_PARAM_NAME);
        String paramValue = sosxml.selectSingleNodeValue(xmlPath);
        LOGGER.debug("xml path:" + xmlPath);
        LOGGER.debug("serializedString from order param:" + paramValue);
        return paramValue;
    }

    private void doProcessing() throws Exception {
        this.jobSchedulerJoinOrders = new JobSchedulerJoinOrders();
        this.jobSchedulerJoinOrdersOptions = this.jobSchedulerJoinOrders.getOptions();
        this.jobSchedulerJoinOrdersOptions.setCurrentNodeName(this.getCurrentNodeName(this.getSpoolerProcess().getOrder(), false));
        this.jobSchedulerJoinOrdersOptions.setAllOptions(this.getSchedulerParameterAsProperties(this.getSpoolerProcess().getOrder()));
        this.jobSchedulerJoinOrdersOptions.checkMandatory();
        this.jobSchedulerJoinOrders.setJSJobUtilites((JSJobUtilities)this);
        JoinOrder joinOrder = this.createJoinOrder();
        this.setRequired();
        this.jobSchedulerJoinOrders.setJoinOrder(joinOrder);
        String joinOrderListString = this.getSerializedObject(joinOrder);
        LOGGER.debug(String.format("Waiting for %s orders", this.jobSchedulerJoinOrdersOptions.required_orders.value()));
        if (!this.setStateText(joinOrder)) {
            if (joinOrder.isMainOrder()) {
                this.suspendOrder();
            }
            LOGGER.debug("Serialized String:" + joinOrderListString + "-");
            this.jobSchedulerJoinOrders.setJoinOrderListString(joinOrderListString);
            this.jobSchedulerJoinOrders.execute();
            JoinOrder mainOrder = this.setStateTextAfter(joinOrder);
            if (this.jobSchedulerJoinOrders.isResumeAllOrders() && mainOrder != null) {
                LOGGER.debug(String.format("reset list for: %s", joinOrder.getTitle()));
                this.jobSchedulerJoinOrders.getJoinSerializer().reset(joinOrder);
                LOGGER.debug("Resuming mainOrder to next state");
                if (joinOrder.isMainOrder()) {
                    this.resetMainOrder();
                    this.spooler_task.order().set_state(this.spooler_task.order().job_chain_node().next_state());
                    this.spooler_task.order().set_suspended(false);
                } else {
                    String resumeCommand = String.format(RESUME_FOR_STATE_TEXT, mainOrder.getJobChain(), mainOrder.getOrderId(), this.spooler_task.order().job_chain_node().state(), RESET_STATE_TEXT);
                    this.executeXml(resumeCommand);
                    LOGGER.debug(String.format("Resuming order %s", joinOrder.getOrderId()));
                }
            }
        }
        this.setSerializedObject(joinOrder);
    }
}

