/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.join;

import com.sos.jitl.join.JoinOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinOrderList
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JoinOrderList.class);
    private static final long serialVersionUID = 4371766177498357215L;
    private Map<String, List<JoinOrder>> joinSessionIdListOfOrders;

    private String getKey(JoinOrder joinOrder) {
        return joinOrder.getJoinSessionId() + "::" + joinOrder.getJoinState();
    }

    private boolean orderExist(List<JoinOrder> listOfOrders, JoinOrder joinOrder) {
        for (JoinOrder order : listOfOrders) {
            if (!order.getJobChain().equals(joinOrder.getJobChain()) || !order.getOrderId().equals(joinOrder.getOrderId())) continue;
            return true;
        }
        return false;
    }

    private List<JoinOrder> getListOfOrders(JoinOrder joinOrder) {
        List<JoinOrder> listOfOrders = this.joinSessionIdListOfOrders.get(this.getKey(joinOrder));
        if (listOfOrders == null) {
            listOfOrders = new ArrayList<JoinOrder>();
        }
        return listOfOrders;
    }

    public void addOrder(JoinOrder joinOrder) {
        List<JoinOrder> listOfOrders;
        if (this.joinSessionIdListOfOrders == null) {
            this.joinSessionIdListOfOrders = new HashMap<String, List<JoinOrder>>();
        }
        if (!this.orderExist(listOfOrders = this.getListOfOrders(joinOrder), joinOrder)) {
            listOfOrders.add(joinOrder);
            this.joinSessionIdListOfOrders.put(this.getKey(joinOrder), listOfOrders);
        } else {
            LOGGER.debug(String.format("Order %s will not be added to the list of orders as the list already contains it", joinOrder.getTitle()));
        }
    }

    public int size(JoinOrder joinOrder) {
        return this.joinSessionIdListOfOrders.get(this.getKey(joinOrder)).size();
    }

    public void reset(JoinOrder joinOrder) {
        if (this.joinSessionIdListOfOrders == null) {
            this.joinSessionIdListOfOrders = new HashMap<String, List<JoinOrder>>();
        }
        ArrayList listOfOrders = new ArrayList();
        this.joinSessionIdListOfOrders.put(this.getKey(joinOrder), listOfOrders);
    }

    public JoinOrder getMainOrder(JoinOrder joinOrder) {
        List<JoinOrder> listOfOrders = this.joinSessionIdListOfOrders.get(this.getKey(joinOrder));
        if (listOfOrders == null) {
            return null;
        }
        for (JoinOrder order : listOfOrders) {
            if (!order.isMainOrder()) continue;
            return order;
        }
        return null;
    }

    public void showJoinOrderList(JoinOrder joinOrder) {
        List<JoinOrder> listOfOrders = this.getListOfOrders(joinOrder);
        LOGGER.info("Members of list: " + joinOrder.paramNameForSerializedList());
        for (JoinOrder order : listOfOrders) {
            String s = order.getTitle();
            if (order.isMainOrder()) {
                s = s + " --> mainOrder";
            }
            LOGGER.info(s);
        }
    }
}

