/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.latecomers.classes;

import com.sos.jitl.latecomers.JobSchedulerStartLatecomersOptions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LateComersHelper {
    JobSchedulerStartLatecomersOptions jobSchedulerStartLatecomersOptions;

    public LateComersHelper(JobSchedulerStartLatecomersOptions jobSchedulerStartLatecomersOptions) {
        this.jobSchedulerStartLatecomersOptions = jobSchedulerStartLatecomersOptions;
    }

    public String getParent(String path) {
        Path p = Paths.get(path, new String[0]).getParent();
        if (p == null) {
            return null;
        }
        return p.toString().replace('\\', '/');
    }

    public boolean ignoreOrder(String jobChain, String orderId) {
        Matcher regExOrderMatcher = null;
        boolean ignore = false;
        String s = orderId != null && !orderId.isEmpty() && jobChain != null && !jobChain.isEmpty() ? jobChain + "," + orderId : jobChain;
        if (s != null && !s.isEmpty() && this.jobSchedulerStartLatecomersOptions.ignoreOrderList.isDirty()) {
            String[] ignoreOrders;
            for (String o : ignoreOrders = this.jobSchedulerStartLatecomersOptions.getIgnoreOrderList().getValue().split(";")) {
                regExOrderMatcher = Pattern.compile(o).matcher("");
                if (!ignore && (ignore = regExOrderMatcher.reset(s).find())) break;
            }
        }
        return ignore;
    }

    public boolean ignoreJob(String job) {
        Matcher regExJobMatcher = null;
        boolean ignore = false;
        if (job != null && !job.isEmpty() && this.jobSchedulerStartLatecomersOptions.ignoreJobList.isDirty()) {
            String[] ignoreJobs;
            for (String j : ignoreJobs = this.jobSchedulerStartLatecomersOptions.getIgnoreJobList().getValue().split(";")) {
                regExJobMatcher = Pattern.compile(j).matcher("");
                if (!ignore && (ignore = regExJobMatcher.reset(job).find())) break;
            }
        }
        return ignore;
    }

    public boolean ignoreFolder(String folderPath) {
        boolean ignore = false;
        if (folderPath != null && !folderPath.isEmpty() && this.jobSchedulerStartLatecomersOptions.ignoreFolderList.isDirty()) {
            String[] ignoreFolders;
            for (String f : ignoreFolders = this.jobSchedulerStartLatecomersOptions.getIgnoreFolderList().getValue().split(";")) {
                if (f.endsWith("/")) {
                    f = f.substring(0, f.length() - 1);
                }
                if (f.endsWith("*")) {
                    f = f.substring(0, f.length() - 1);
                    ignore = folderPath.startsWith(f);
                } else {
                    ignore = folderPath.equals(f);
                }
                if (ignore) break;
            }
        }
        return ignore;
    }

    public boolean considerJob(String job) {
        if (this.jobSchedulerStartLatecomersOptions.jobs.isDirty()) {
            Matcher regExJobMatcher = null;
            boolean consider = false;
            if (job != null && !job.isEmpty()) {
                String[] considerJobs;
                for (String j : considerJobs = this.jobSchedulerStartLatecomersOptions.getJobs().getValue().split(";")) {
                    regExJobMatcher = Pattern.compile(j).matcher("");
                    if (!consider && (consider = regExJobMatcher.reset(job).find())) break;
                }
            }
            return consider;
        }
        return job != null && !job.isEmpty();
    }

    public boolean considerOrder(String jobChain, String orderId) {
        if (this.jobSchedulerStartLatecomersOptions.orders.isDirty()) {
            Matcher regExOrderMatcher = null;
            boolean consider = false;
            String s = orderId != null && !orderId.isEmpty() && jobChain != null && !jobChain.isEmpty() ? jobChain + "," + orderId : jobChain;
            if (s != null && !s.isEmpty()) {
                String[] considerOrders;
                for (String o : considerOrders = this.jobSchedulerStartLatecomersOptions.getOrders().getValue().split(";")) {
                    regExOrderMatcher = Pattern.compile(o).matcher("");
                    if (!consider && (consider = regExOrderMatcher.reset(s).find())) break;
                }
            }
            return consider;
        }
        return jobChain != null && !jobChain.isEmpty();
    }
}

