/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.mail.smtp;

import com.sos.JSHelper.Annotations.JSOptionClass;
import com.sos.JSHelper.Annotations.JSOptionDefinition;
import com.sos.JSHelper.Exceptions.JSExceptionMandatoryOptionMissing;
import com.sos.JSHelper.Listener.JSListener;
import com.sos.JSHelper.Options.JSJobId;
import com.sos.JSHelper.Options.JSJobName;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionBoolean;
import com.sos.JSHelper.Options.SOSOptionHostName;
import com.sos.JSHelper.Options.SOSOptionPortNumber;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.mail.options.SOSSmtpMailOptions;

@JSOptionClass(name="JSSmtpMailOptions", description="Launch and observe any given job or job chain")
public class JSSmtpMailOptions
extends SOSSmtpMailOptions {
    private static final long serialVersionUID = 6441074884525254517L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JSSmtpMailOptions.class);
    private String strAlternativePrefix = "";
    public JSSmtpMailOptions objMailOnError = null;
    public JSSmtpMailOptions objMailOnSuccess = null;
    public JSSmtpMailOptions objMailOnJobStart = null;
    private String currentJobFolder = "";
    private String currentJobName = "";
    private int currentJobId = 0;
    @JSOptionDefinition(name="tasklog_to_body", description="add task log to body", key="tasklog_to_body", type="SOSOptionBoolean", mandatory=false)
    public SOSOptionBoolean tasklog_to_body = new SOSOptionBoolean((JSOptionsClass)this, "tasklog_to_body", "add task log to body", "false", "false", false);
    @JSOptionDefinition(name="job_name", description="job name", key="job_name", type="JSJobName", mandatory=false)
    public JSJobName job_name = new JSJobName((JSOptionsClass)this, "job_name", "job name", "", "", false);
    @JSOptionDefinition(name="job_id", description="task id of a job", key="job_id", type="JSJobId", mandatory=false)
    public JSJobId job_id = new JSJobId((JSOptionsClass)this, "job_id", "task id of a job", "", "", false);
    public JSJobId task_id = (JSJobId)this.job_id.setAlias("task_id");
    @JSOptionDefinition(name="enabled", description="enable monitor", key="enabled", type="SOSOptionBoolean", mandatory=false)
    public SOSOptionBoolean enabled = new SOSOptionBoolean((JSOptionsClass)this, "enabled", "enable monitor", "true", "true", false);
    @JSOptionDefinition(name="scheduler_host", description="jobscheduler hostname", key="scheduler_host", type="SOSOptionHostName", mandatory=false)
    public SOSOptionHostName scheduler_host = new SOSOptionHostName((JSOptionsClass)this, "scheduler_host", "jobscheduler hostname", "localhost", "localhost", false);
    @JSOptionDefinition(name="scheduler_port", description="jobscheduler port", key="scheduler_port", type="SOSOptionPortNumber", mandatory=false)
    public SOSOptionPortNumber scheduler_port = new SOSOptionPortNumber((JSOptionsClass)this, "scheduler_port", "jobscheduler port", "", "", false);

    public JSSmtpMailOptions() {
    }

    public JSSmtpMailOptions(JSListener pobjListener) {
        this();
    }

    public JSSmtpMailOptions getOptions(enuMailClasses penuMailClass) {
        JSSmtpMailOptions objO = this.objMailOnError;
        switch (penuMailClass) {
            case MailOnError: {
                break;
            }
            case MailOnJobStart: {
                objO = this.objMailOnJobStart;
                break;
            }
            case MailOnSuccess: {
                objO = this.objMailOnSuccess;
                break;
            }
            default: {
                objO = this;
            }
        }
        return objO;
    }

    public JSSmtpMailOptions(HashMap<String, String> JSSettings) throws Exception {
        super(JSSettings);
        this.objMailOnError = new JSSmtpMailOptions(JSSettings, "MailOnError_");
        this.objMailOnSuccess = new JSSmtpMailOptions(JSSettings, "MailOnSuccess_");
        this.objMailOnJobStart = new JSSmtpMailOptions(JSSettings, "MailOnJobStart_");
    }

    public boolean MailOnJobStart() {
        boolean flgR = false;
        if (this.objMailOnJobStart == null) {
            this.objMailOnJobStart = new JSSmtpMailOptions(this.getSettings(), "MailOnJobStart_");
            this.mergeDefaultSettings(this.objMailOnJobStart);
        }
        flgR = this.objMailOnJobStart.to.isDirty();
        return flgR;
    }

    public boolean MailOnError() {
        boolean flgR = false;
        if (this.objMailOnError == null) {
            this.objMailOnError = new JSSmtpMailOptions(this.getSettings(), "MailOnError_");
            this.mergeDefaultSettings(this.objMailOnError);
        }
        flgR = this.objMailOnError.to.isDirty();
        return flgR;
    }

    public boolean MailOnSuccess() {
        boolean flgR = false;
        if (this.objMailOnSuccess == null) {
            this.objMailOnSuccess = new JSSmtpMailOptions(this.getSettings(), "MailOnSuccess_");
            this.mergeDefaultSettings(this.objMailOnSuccess);
        }
        flgR = this.objMailOnSuccess.to.isDirty();
        return flgR;
    }

    private void mergeDefaultSettings(JSSmtpMailOptions pobjOpt) {
        if (pobjOpt.host.isNotDirty()) {
            pobjOpt.host.setValue(this.host.getValue());
        }
        if (pobjOpt.port.isNotDirty()) {
            pobjOpt.port.setValue(this.port.getValue());
        }
        if (pobjOpt.smtp_user.isNotDirty()) {
            pobjOpt.smtp_user.setValue(this.smtp_user.getValue());
        }
        if (pobjOpt.smtp_password.isNotDirty()) {
            pobjOpt.smtp_password.setValue(this.smtp_password.getValue());
        }
    }

    public JSSmtpMailOptions(HashMap<String, String> JSSettings, String pstrPrefix) {
        this.strAlternativePrefix = pstrPrefix;
        try {
            super.setAllOptions(JSSettings, this.strAlternativePrefix);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        LOGGER.trace(this.dirtyString());
    }

    public void checkMandatory() {
        try {
            super.checkMandatory();
        }
        catch (Exception e) {
            throw new JSExceptionMandatoryOptionMissing(e.toString());
        }
    }

    public SOSOptionBoolean gettasklog_to_body() {
        return this.tasklog_to_body;
    }

    public void settasklog_to_body(SOSOptionBoolean p_tasklog_to_body) {
        this.tasklog_to_body = p_tasklog_to_body;
    }

    public JSJobName getjob_name() {
        return this.job_name;
    }

    public void setjob_name(JSJobName p_job_name) {
        this.job_name = p_job_name;
    }

    public JSJobId getjob_id() {
        return this.job_id;
    }

    public void setjob_id(JSJobId p_job_id) {
        this.job_id = p_job_id;
    }

    public SOSOptionBoolean getenabled() {
        return this.enabled;
    }

    public void setenabled(SOSOptionBoolean enabled) {
        this.enabled = enabled;
    }

    public SOSOptionHostName getscheduler_host() {
        return this.scheduler_host;
    }

    public void setscheduler_host(SOSOptionHostName p_scheduler_host) {
        this.scheduler_host = p_scheduler_host;
    }

    public SOSOptionPortNumber getscheduler_port() {
        return this.scheduler_port;
    }

    public void setscheduler_port(SOSOptionPortNumber p_scheduler_port) {
        this.scheduler_port = p_scheduler_port;
    }

    public JSSmtpMailOptions setCurrentJobFolder(String val) throws Exception {
        this.currentJobFolder = val;
        return this;
    }

    public String getCurrentJobFolder() {
        return this.currentJobFolder;
    }

    public JSSmtpMailOptions setCurrentJobId(int val) throws Exception {
        this.currentJobId = val;
        return this;
    }

    public int getCurrentJobId() {
        return this.currentJobId;
    }

    public JSSmtpMailOptions setCurrentJobName(String val) throws Exception {
        this.currentJobName = val;
        return this;
    }

    public String getCurrentJobName() {
        return this.currentJobName;
    }

    public static enum enuMailClasses {
        MailDefault,
        MailOnError,
        MailOnSuccess,
        MailOnJobStart;

    }
}

