/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.managed.model;

import com.sos.hibernate.classes.SOSHibernateSQLExecutor;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.managed.job.ManagedDatabaseJobOptions;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Variable_set;
import sos.util.SOSString;

public class ManagedDatabaseModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedDatabaseModel.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    public static final String PARAMETER_NAME_VALUE = "name_value";
    private SOSHibernateSession session;
    private ManagedDatabaseJobOptions options;
    private boolean isOrderJob;
    private Variable_set orderParams;
    private StringBuffer warning;

    public ManagedDatabaseModel(SOSHibernateSession sess, ManagedDatabaseJobOptions opt, boolean isOrder, Variable_set op) throws Exception {
        this.session = sess;
        this.options = opt;
        this.isOrderJob = isOrder;
        this.orderParams = op;
    }

    public void process() throws Exception {
        try {
            if (SOSString.isEmpty((String)this.options.command.getValue())) {
                throw new Exception("command is empty.");
            }
            this.warning = new StringBuffer();
            SOSHibernateSQLExecutor executor = this.session.getSQLExecutor();
            List statements = null;
            try {
                Path path = Paths.get(this.options.command.getValue().trim(), new String[0]);
                if (Files.notExists(path, new LinkOption[0])) {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[load from file][%s]file not found", path));
                    }
                    throw new FileNotFoundException(String.format("[%s]file not found", path));
                }
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[load from file]%s", path));
                }
                statements = executor.getStatements(path);
            }
            catch (Throwable e) {
                statements = executor.getStatements(this.options.command.getValue());
            }
            this.session.beginTransaction();
            for (String statement : statements) {
                boolean isResultListQuery = SOSHibernateSQLExecutor.isResultListQuery((String)statement, (boolean)this.options.exec_returns_resultset.value());
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("isResultListQuery=%s", isResultListQuery));
                }
                LOGGER.info(String.format("executing database statement: %s", statement));
                if (isResultListQuery) {
                    this.executeResultSet(executor, statement, this.orderParams);
                    continue;
                }
                executor.executeUpdate(new String[]{statement});
            }
            this.session.commit();
        }
        catch (Exception e) {
            try {
                this.session.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
    }

    private void executeResultSet(SOSHibernateSQLExecutor executor, String statement, Variable_set orderParams) throws Exception {
        ResultSet rs;
        block22: {
            rs = null;
            try {
                boolean checkResultSet = !this.options.resultset_as_parameters.getValue().equalsIgnoreCase("false");
                boolean isParamValue = this.options.resultset_as_parameters.getValue().equals(PARAMETER_NAME_VALUE);
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("isOrderJob=%s, checkResultSet=%s, isParamValue=%s", this.isOrderJob, checkResultSet, isParamValue));
                }
                rs = executor.getResultSet(statement);
                if (!checkResultSet && !this.options.resultset_as_warning.value()) break block22;
                StringBuffer warn = new StringBuffer();
                int rowCount = 0;
                Map record = null;
                while (!(record = executor.nextAsStringMap(rs)).isEmpty()) {
                    ++rowCount;
                    if (this.isOrderJob && checkResultSet) {
                        if (orderParams == null) {
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("[order][skip set param: orderParams=null]%s", record));
                            }
                        } else if (isParamValue) {
                            String paramKey = null;
                            String paramValue = null;
                            int columnCounter = 0;
                            for (String key : record.keySet()) {
                                if (++columnCounter == 1) {
                                    paramKey = (String)record.get(key);
                                    continue;
                                }
                                if (columnCounter != 2) break;
                                paramValue = (String)record.get(key);
                            }
                            if (paramKey != null && paramValue != null) {
                                if (isDebugEnabled) {
                                    LOGGER.debug(String.format("[order][set param]%s=%s", paramKey, paramValue));
                                }
                                orderParams.set_var(paramKey, paramValue);
                            }
                        } else if (rowCount == 1) {
                            for (String key : record.keySet()) {
                                String value = (String)record.get(key);
                                if (isDebugEnabled) {
                                    LOGGER.debug(String.format("[order][set param]%s=%s", key, value));
                                }
                                orderParams.set_var(key, value);
                            }
                        }
                    }
                    if (!this.options.resultset_as_warning.value()) continue;
                    if (rowCount > 1) {
                        warn.append(", ");
                    }
                    warn.append(record);
                }
                if (warn.length() > 0) {
                    if (this.warning.length() > 0) {
                        this.warning.append("; ");
                    }
                    this.warning.append(warn);
                }
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    executor.close(rs);
                    throw throwable;
                }
            }
        }
        executor.close(rs);
    }

    public String getWarning() {
        return this.warning.length() == 0 ? null : String.format("execution terminated with warning: %s", this.warning);
    }
}

