/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.db;

import com.sos.hibernate.classes.ClassList;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.notification.db.DBItemReportingTaskAndOrder;
import com.sos.jitl.notification.db.DBItemSchedulerMonChecks;
import com.sos.jitl.notification.db.DBItemSchedulerMonInternalNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonResults;
import com.sos.jitl.notification.db.DBItemSchedulerMonSystemNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonSystemResults;
import com.sos.jitl.reporting.db.DBItemAuditLog;
import java.util.Date;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayer {
    final Logger LOGGER = LoggerFactory.getLogger(DBLayer.class);
    public static final String SCHEDULER_VARIABLES_NOTIFICATION = "notification_date";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DBITEM_SCHEDULER_MON_NOTIFICATIONS = DBItemSchedulerMonNotifications.class.getSimpleName();
    public static final String TABLE_SCHEDULER_MON_NOTIFICATIONS = "SCHEDULER_MON_NOTIFICATIONS";
    public static final String SEQUENCE_SCHEDULER_MON_NOTIFICATIONS = "SCHEDULER_MON_NOT_ID_SEQ";
    public static final String DBITEM_SCHEDULER_MON_INTERNAL_NOTIFICATIONS = DBItemSchedulerMonInternalNotifications.class.getSimpleName();
    public static final String TABLE_SCHEDULER_MON_INTERNAL_NOTIFICATIONS = "SCHEDULER_MON_INTNOTIFICATIONS";
    public static final String SEQUENCE_SCHEDULER_MON_INTERNAL_NOTIFICATIONS = "SCHEDULER_MON_INTNOT_ID_SEQ";
    public static final String DBITEM_SCHEDULER_MON_RESULTS = DBItemSchedulerMonResults.class.getSimpleName();
    public static final String TABLE_SCHEDULER_MON_RESULTS = "SCHEDULER_MON_RESULTS";
    public static final String SEQUENCE_SCHEDULER_MON_RESULTS = "SCHEDULER_MON_RES_ID_SEQ";
    public static final String DBITEM_SCHEDULER_MON_SYSNOTIFICATIONS = DBItemSchedulerMonSystemNotifications.class.getSimpleName();
    public static final String TABLE_SCHEDULER_MON_SYSNOTIFICATIONS = "SCHEDULER_MON_SYSNOTIFICATIONS";
    public static final String SEQUENCE_SCHEDULER_MON_SYSNOTIFICATIONS = "SCHEDULER_MON_SYSNOT_ID_SEQ";
    public static final String DBITEM_SCHEDULER_MON_SYSRESULTS = DBItemSchedulerMonSystemResults.class.getSimpleName();
    public static final String TABLE_SCHEDULER_MON_SYSRESULTS = "SCHEDULER_MON_SYSRESULTS";
    public static final String SEQUENCE_SCHEDULER_MON_SYSRESULTS = "SCHEDULER_MON_SYSR_ID_SEQ";
    public static final String DBITEM_SCHEDULER_MON_CHECKS = DBItemSchedulerMonChecks.class.getSimpleName();
    public static final String TABLE_SCHEDULER_MON_CHECKS = "SCHEDULER_MON_CHECKS";
    public static final String SEQUENCE_SCHEDULER_MON_CHECKS = "SCHEDULER_MON_CHECKS_ID_SEQ";
    public static final int RERUN_TRANSACTION_INTERVAL = 3;
    public static final String EMPTY_TEXT_VALUE = "";
    public static final String DEFAULT_EMPTY_NAME = "*";
    public static final Long DEFAULT_EMPTY_NUMERIC = new Long(0L);
    public static final Long NOTIFICATION_OBJECT_TYPE_JOB_CHAIN = new Long(0L);
    public static final Long NOTIFICATION_OBJECT_TYPE_JOB = new Long(1L);
    public static final Long NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_IF_LONGER_THAN = new Long(10L);
    public static final Long NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_IF_SHORTER_THAN = new Long(11L);
    public static final Long NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_WARNING = new Long(12L);
    public static final Long NOTIFICATION_OBJECT_TYPE_INTERNAL_MASTER_MESSAGE = new Long(20L);
    public static final Long NOTIFICATION_OBJECT_TYPE_DUMMY = new Long(100L);
    public static final Long NOTIFICATION_DUMMY_MAX_STEP = new Long(999999L);
    private SOSHibernateSession session;

    public DBLayer(SOSHibernateSession sess) {
        this.session = sess;
    }

    public SOSHibernateSession getSession() {
        return this.session;
    }

    public static ClassList getNotificationClassMapping() {
        ClassList cl = new ClassList();
        cl.add(DBItemSchedulerMonChecks.class);
        cl.add(DBItemSchedulerMonNotifications.class);
        cl.add(DBItemSchedulerMonResults.class);
        cl.add(DBItemSchedulerMonSystemNotifications.class);
        cl.add(DBItemSchedulerMonSystemResults.class);
        cl.add(DBItemSchedulerMonInternalNotifications.class);
        cl.add(DBItemReportingTaskAndOrder.class);
        cl.add(DBItemAuditLog.class);
        return cl;
    }

    public String quote(String fieldName) {
        return this.session.getFactory().quoteColumn(fieldName);
    }

    public static Date getCurrentDateTime() {
        return new DateTime(DateTimeZone.UTC).toLocalDateTime().toDate();
    }

    public static Date getCurrentDateTimeMinusDays(int days) {
        return new DateTime(DateTimeZone.UTC).toLocalDateTime().minusDays(days).toDate();
    }

    public static Date getCurrentDateTimeMinusMinutes(int minutes) {
        return new DateTime(DateTimeZone.UTC).toLocalDateTime().minusMinutes(minutes).toDate();
    }

    public static String getDateAsString(Date d) throws Exception {
        DateTimeFormatter f = DateTimeFormat.forPattern((String)DATETIME_FORMAT);
        DateTime dt = new DateTime((Object)d, DateTimeZone.UTC);
        return f.print((ReadableInstant)dt);
    }

    public static String getLocalDateAsString(Date d) throws Exception {
        DateTimeFormatter f = DateTimeFormat.forPattern((String)DATETIME_FORMAT);
        DateTime dt = new DateTime((Object)d);
        return f.print((ReadableInstant)dt);
    }

    public static Date getDateFromString(String d) throws Exception {
        DateTimeFormatter f = DateTimeFormat.forPattern((String)DATETIME_FORMAT);
        return f.parseDateTime(d).toDate();
    }

    public void flushScrollableResults(int readCount) throws Exception {
        if (readCount % 100 == 0 && this.getSession().getCurrentSession() instanceof Session) {
            Session s = (Session)this.getSession().getCurrentSession();
            s.clear();
            s.flush();
        }
    }
}

