/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.jobs.reset;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.notification.db.DBLayer;
import com.sos.jitl.notification.jobs.reset.ResetNotificationsJobOptions;
import com.sos.jitl.notification.model.reset.ResetNotificationsModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetNotificationsJob
extends JSJobUtilitiesClass<ResetNotificationsJobOptions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResetNotificationsJob.class);
    private SOSHibernateFactory factory;
    private SOSHibernateSession session;

    public ResetNotificationsJob() {
        super((Object)new ResetNotificationsJobOptions());
    }

    public void init() throws Exception {
        String methodName = "ResetNotificationsJob::init";
        LOGGER.debug("ResetNotificationsJob::init");
        try {
            this.factory = new SOSHibernateFactory(this.getOptions().hibernate_configuration_file_reporting.getValue());
            this.factory.setAutoCommit(this.getOptions().connection_autocommit.value());
            this.factory.setTransactionIsolation(this.getOptions().connection_transaction_isolation.value());
            this.factory.addClassMapping(DBLayer.getNotificationClassMapping());
            this.factory.build();
        }
        catch (Exception ex) {
            throw new Exception(String.format("reporting connection: %s", ex.toString()), ex);
        }
    }

    public void openSession() throws Exception {
        this.session = this.factory.openStatelessSession();
    }

    public void closeSession() throws Exception {
        if (this.session != null) {
            this.session.close();
        }
    }

    public void exit() {
        if (this.factory != null) {
            this.factory.close();
        }
    }

    public ResetNotificationsJob execute() throws Exception {
        String methodName = "ResetNotificationsJob::execute";
        LOGGER.debug("ResetNotificationsJob::execute");
        try {
            this.getOptions().checkMandatory();
            LOGGER.debug(this.getOptions().toString());
            ResetNotificationsModel model = new ResetNotificationsModel(this.session, this.getOptions());
            model.process();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s: %s", "ResetNotificationsJob::execute", e.toString()), (Throwable)e);
            throw e;
        }
        return this;
    }

    public ResetNotificationsJobOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new ResetNotificationsJobOptions();
        }
        return (ResetNotificationsJobOptions)((Object)this.objOptions);
    }
}

