/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.jobs.result;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.notification.db.DBLayer;
import com.sos.jitl.notification.jobs.result.StoreResultsJobOptions;
import com.sos.jitl.notification.model.result.StoreResultsModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResultsJob
extends JSJobUtilitiesClass<StoreResultsJobOptions> {
    private static Logger LOGGER = LoggerFactory.getLogger(StoreResultsJob.class);
    private final String className = StoreResultsJob.class.getSimpleName();
    private SOSHibernateFactory factory;
    private SOSHibernateSession session;

    public StoreResultsJob() {
        super((Object)new StoreResultsJobOptions());
    }

    public void init() throws Exception {
        try {
            this.factory = new SOSHibernateFactory(this.getOptions().scheduler_notification_hibernate_configuration_file.getValue());
            this.factory.setAutoCommit(this.getOptions().scheduler_notification_connection_autocommit.value());
            this.factory.setTransactionIsolation(this.getOptions().scheduler_notification_connection_transaction_isolation.value());
            this.factory.addClassMapping(DBLayer.getNotificationClassMapping());
            this.factory.build();
        }
        catch (Exception ex) {
            throw new Exception(String.format("reporting connection: %s", ex.toString()), ex);
        }
    }

    public void openSession() throws Exception {
        this.session = this.factory.openStatelessSession();
    }

    public void closeSession() throws Exception {
        if (this.session != null) {
            this.session.close();
        }
    }

    public void exit() {
        if (this.factory != null) {
            this.factory.close();
        }
    }

    public StoreResultsJob execute() throws Exception {
        String methodName = this.className + "::execute";
        LOGGER.debug(methodName);
        try {
            this.getOptions().checkMandatory();
            LOGGER.debug(this.getOptions().toString());
            StoreResultsModel model = new StoreResultsModel(this.session, this.getOptions());
            model.process();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s: %s", methodName, e.toString()), (Throwable)e);
            throw e;
        }
        return this;
    }

    public StoreResultsJobOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new StoreResultsJobOptions();
        }
        return (StoreResultsJobOptions)((Object)this.objOptions);
    }
}

