/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.jobs.result;

import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.jitl.notification.jobs.result.StoreResultsJob;
import com.sos.jitl.notification.jobs.result.StoreResultsJobOptions;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Order;
import sos.util.SOSString;

public class StoreResultsJobJSAdapterClass
extends JobSchedulerJobAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreResultsJobJSAdapterClass.class);
    StoreResultsJob job = null;
    StoreResultsJobOptions options = null;

    public void init(HashMap<String, String> params) throws Exception {
        this.job = new StoreResultsJob();
        this.options = this.job.getOptions();
        this.options.setAllOptions(params);
        this.job.setJSJobUtilites((JSJobUtilities)this);
        if (SOSString.isEmpty((String)this.options.scheduler_notification_hibernate_configuration_file.getValue())) {
            this.options.scheduler_notification_hibernate_configuration_file.setValue(this.getHibernateConfigurationReporting().toString());
        }
        this.job.init();
        this.job.openSession();
    }

    public void exit() throws Exception {
        if (this.job != null) {
            this.job.closeSession();
            this.job.exit();
        }
    }

    private void doProcessing(boolean isStandalone) throws Exception {
        Order order = this.spooler_task.order();
        if (!(isStandalone || order != null && order.job_chain() != null && order.job_chain_node() != null)) {
            LOGGER.info(String.format("exit processing. object is null: order = %s, order.job_chain = %s, order.job_chain_node = %s", order, order.job_chain(), order.job_chain_node()));
            return;
        }
        HashMap params = this.getJobOrOrderParameters(order);
        if (params != null && params.size() > 0) {
            this.init(params);
            this.options.mon_results_standalone.value(isStandalone);
            this.options.mon_results_scheduler_id.setValue(this.spooler.id());
            this.options.mon_results_task_id.value(this.spooler_task.id());
            if (isStandalone) {
                this.options.mon_results_order_history_id.setValue("0");
                this.options.mon_results_order_id.setValue("*");
                this.options.mon_results_job_chain_name.setValue("*");
                this.options.mon_results_order_step_state.setValue("*");
            } else {
                this.options.mon_results_order_history_id.setValue(order.history_id());
                this.options.mon_results_order_id.setValue(order.id());
                this.options.mon_results_job_chain_name.setValue(order.job_chain().path());
                this.options.mon_results_order_step_state.setValue(order.job_chain_node().state());
            }
            this.job.execute();
            this.exit();
        }
    }

    public void spooler_task_after() throws Exception {
        try {
            super.spooler_task_after();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            try {
                if (this.spooler_task.job().order_queue() == null) {
                    this.doProcessing(true);
                }
            }
            catch (Exception ex) {
                this.spooler_log.warn(ex.getMessage());
            }
        }
    }

    public boolean spooler_process_after(boolean processResult) throws Exception {
        boolean result = false;
        try {
            result = super.spooler_process_after(processResult);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            try {
                if (this.spooler_task.job().order_queue() != null) {
                    this.doProcessing(false);
                }
            }
            catch (Exception ex) {
                this.spooler_log.warn(ex.getMessage());
            }
        }
        return result;
    }
}

