/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.model.reset;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.notification.jobs.reset.ResetNotificationsJobOptions;
import com.sos.jitl.notification.model.INotificationModel;
import com.sos.jitl.notification.model.NotificationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class ResetNotificationsModel
extends NotificationModel
implements INotificationModel {
    final Logger logger = LoggerFactory.getLogger(ResetNotificationsModel.class);
    private ResetNotificationsJobOptions options;

    public ResetNotificationsModel(SOSHibernateSession sess, ResetNotificationsJobOptions opt) throws Exception {
        super(sess);
        this.options = opt;
    }

    @Override
    public void process() throws Exception {
        this.logger.info(String.format("process", new Object[0]));
        this.logger.info(String.format("process: operation = %s", this.options.operation.getValue()));
        if (this.options.operation.getValue().toLowerCase().equals("acknowledge")) {
            this.resetAcknowledged(this.options.system_id.getValue(), this.options.service_name.getValue());
        } else if (this.options.operation.getValue().toLowerCase().equals("reset_services")) {
            this.resetServices();
        } else {
            throw new Exception(String.format("unknown operation = %s", this.options.operation.getValue()));
        }
    }

    private void resetAcknowledged(String systemId, String serviceName) throws Exception {
        String method = "resetAcknowledged";
        if (SOSString.isEmpty((String)systemId)) {
            throw new Exception(String.format("missing systemId", new Object[0]));
        }
        this.logger.info(String.format("%s: systemId = %s, serviceName = %s", method, systemId, serviceName));
        try {
            this.getDbLayer().getSession().beginTransaction();
            int count = this.getDbLayer().resetAcknowledged(systemId, serviceName);
            this.getDbLayer().getSession().commit();
            this.logger.info(String.format("%s: updated %s", method, count));
        }
        catch (Exception ex) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    private void resetServices() throws Exception {
    }
}

