/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.plugins.notifier;

import com.sos.jitl.notification.db.DBItemSchedulerMonChecks;
import com.sos.jitl.notification.db.DBItemSchedulerMonNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonSystemNotifications;
import com.sos.jitl.notification.helper.EServiceMessagePrefix;
import com.sos.jitl.notification.helper.EServiceStatus;
import com.sos.jitl.notification.helper.ObjectHelper;
import com.sos.jitl.notification.helper.elements.monitor.jms.ElementNotificationJMS;
import com.sos.jitl.notification.plugins.notifier.SystemNotifierCustomPlugin;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class SystemNotifierSendJMSPlugin
extends SystemNotifierCustomPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemNotifierSendJMSPlugin.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private ElementNotificationJMS config = null;
    private Connection connection = null;
    private Session session = null;
    private String url4log;
    private String userName;
    private String password;

    @Override
    public void onInit() throws Exception {
        this.config = (ElementNotificationJMS)this.getNotificationMonitor().getMonitorInterface();
        this.createConnection();
    }

    @Override
    public void onNotifySystem(DBItemSchedulerMonSystemNotifications systemNotification, DBItemSchedulerMonNotifications notification, DBItemSchedulerMonChecks check, EServiceStatus status, EServiceMessagePrefix prefix) throws Exception {
        MessageProducer producer = this.createProducer(systemNotification.getServiceName());
        try {
            String msg = this.resolveAllVars(systemNotification, notification, check, status, prefix, this.config.getMessage());
            LOGGER.info(String.format("[onNotifySystem][%s][%s]%s", this.url4log, systemNotification.getServiceName(), msg));
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[onNotifySystem][priority=%s][deliveryMode=%s][timeToLive=%s]", this.config.getPriority(), this.config.getDeliveryMode(), this.config.getTimeToLive()));
            }
            producer.setPriority(this.config.getPriority());
            producer.setDeliveryMode(this.config.getDeliveryMode());
            producer.setTimeToLive(this.config.getTimeToLive());
            producer.send((Message)this.session.createTextMessage(msg));
        }
        catch (Throwable e) {
            LOGGER.error(String.format("[onNotifySystem][%s][%s][exception occurred while trying to send message]%s", this.url4log, systemNotification.getServiceName(), e.toString()), e);
            throw e;
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (Exception msg) {}
            }
        }
    }

    @Override
    public void onClose() {
        this.closeConnection();
    }

    private void createConnection() throws Exception {
        ConnectionFactory factory = this.createFactory();
        try {
            if (SOSString.isEmpty((String)this.userName)) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("createConnection...", new Object[0]));
                }
                this.connection = factory.createConnection();
            } else {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("createConnection[userName=%s, pass=********]...", this.userName));
                }
                this.connection = factory.createConnection(this.userName, this.password);
            }
            if (!SOSString.isEmpty((String)this.config.getClientId())) {
                this.connection.setClientID(this.config.getClientId());
            }
            this.connection.start();
        }
        catch (Throwable e) {
            LOGGER.error(String.format("[%s][exception occurred while trying to connect]%s", this.url4log, e.toString()), e);
            throw e;
        }
        try {
            this.session = this.connection.createSession(false, this.config.getAcknowledgeMode());
        }
        catch (Throwable e) {
            LOGGER.error(String.format("[%s][exception occurred while trying to create Session]%s", this.url4log, e.toString()), e);
            throw e;
        }
    }

    private ConnectionFactory createFactory() throws Exception {
        if (this.config.getConnectionFactory() != null) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("initialize ConnectionFactory[class=%s]", this.config.getConnectionFactory().getJavaClass()));
            }
            try {
                this.userName = this.config.getConnectionFactory().getUserName();
                this.password = this.config.getConnectionFactory().getPassword();
                this.url4log = "";
                return (ConnectionFactory)ObjectHelper.newInstance(this.config.getConnectionFactory().getJavaClass(), this.config.getConnectionFactory().getConstructorArguments());
            }
            catch (Throwable e) {
                LOGGER.error(String.format("can't initialize ConnectionFactory[class=%s]: %s", this.config.getConnectionFactory().getJavaClass(), e.toString()), e);
                throw e;
            }
        }
        if (this.config.getConnectionJNDI() != null) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("initialize ConnectionFactory[jndi file=%s, lookupName=%s]", this.config.getConnectionJNDI().getFile(), this.config.getConnectionJNDI().getLookupName()));
            }
            try {
                Properties env = this.loadJndiFile(this.config.getConnectionJNDI().getFile());
                if (env != null) {
                    this.url4log = env.getProperty("java.naming.provider.url");
                    this.userName = env.getProperty("java.naming.security.principal");
                    this.password = env.getProperty("java.naming.security.credentials");
                }
                InitialContext jndi = new InitialContext(env);
                return (ConnectionFactory)jndi.lookup(this.config.getConnectionJNDI().getLookupName());
            }
            catch (Throwable e) {
                LOGGER.error(String.format("can't initialize ConnectionFactory[jndi file=%s, lookupName=%s]: %s", this.config.getConnectionJNDI().getFile(), this.config.getConnectionJNDI().getLookupName(), e.toString()), e);
                throw e;
            }
        }
        throw new Exception(String.format("can't initialize ConnectionFactory: connection element not found (%s or %s)", ElementNotificationJMS.ELEMENT_NAME_CONNECTION_FACTORY, ElementNotificationJMS.ELEMENT_NAME_CONNECTION_JNDI));
    }

    private Properties loadJndiFile(String fileName) throws Exception {
        InputStream is = null;
        try {
            Properties p = new Properties();
            is = new FileInputStream(fileName);
            p.load(is);
            Properties properties = p;
            return properties;
        }
        catch (Throwable e) {
            throw new Exception(String.format("can't load jndi file=%s: %s", fileName, e.toString()), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void closeConnection() {
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]closeConnection ...", this.url4log));
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.connection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.session = null;
        this.connection = null;
    }

    private MessageProducer createProducer(String name) throws Exception {
        Object destination = null;
        try {
            name = this.normalizeDestinationName(name);
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][%s]create Destination...", this.url4log, this.config.getDestination(), name));
            }
            destination = this.config.isQueueDestination() ? this.session.createQueue(name) : this.session.createTopic(name);
        }
        catch (Throwable e) {
            LOGGER.error(String.format("[%s][%s][%s]exception occurred while trying to create Destination: %s", this.url4log, this.config.getDestination(), name, e.toString()), e);
            throw e;
        }
        try {
            return this.session.createProducer((Destination)destination);
        }
        catch (Throwable e) {
            LOGGER.error(String.format("[%s][%s][%s]exception occurred while trying to create MessageProducer: %s", this.url4log, this.config.getDestination(), name, e.toString()), e);
            throw e;
        }
    }

    private String normalizeDestinationName(String name) {
        name = name.replaceAll("&amp;", "&");
        return name;
    }
}

