/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.reporting.db.DBLayer;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
@Table(name="INVENTORY_AGENT_INSTANCES")
@SequenceGenerator(name="REPORTING_IAI_ID_SEQ", sequenceName="REPORTING_IAI_ID_SEQ", allocationSize=1)
public class DBItemInventoryAgentInstance
extends DbItem
implements Serializable {
    private static final long serialVersionUID = 6908223871310840514L;
    private Long id;
    private Long instanceId;
    private Long osId;
    private String hostname;
    private String version;
    private String url;
    private Integer state;
    private Date startedAt;
    private Date created;
    private Date modified;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_IAI_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public Long getId() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_IAI_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="[INSTANCE_ID]", nullable=false)
    public Long getInstanceId() {
        return this.instanceId;
    }

    @Column(name="[INSTANCE_ID]", nullable=false)
    public void setInstanceId(Long instanceId) {
        if (instanceId == null) {
            instanceId = DBLayer.DEFAULT_ID;
        }
        this.instanceId = instanceId;
    }

    @Column(name="[HOSTNAME]", nullable=true)
    public String getHostname() {
        return this.hostname;
    }

    @Column(name="[HOSTNAME]", nullable=true)
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Column(name="[OS_ID]", nullable=false)
    public Long getOsId() {
        return this.osId;
    }

    @Column(name="[OS_ID]", nullable=false)
    public void setOsId(Long osId) {
        if (osId == null) {
            osId = DBLayer.DEFAULT_ID;
        }
        this.osId = osId;
    }

    @Column(name="[VERSION]", nullable=true)
    public String getVersion() {
        return this.version;
    }

    @Column(name="[VERSION]", nullable=true)
    public void setVersion(String version) {
        if (version != null && version.length() > 30) {
            version = version.substring(0, 30);
        }
        this.version = version;
    }

    @Column(name="[URL]", nullable=false)
    public String getUrl() {
        return this.url;
    }

    @Column(name="[URL]", nullable=false)
    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name="[STATE]", nullable=false)
    public Integer getState() {
        return this.state;
    }

    @Column(name="[STATE]", nullable=false)
    public void setState(Integer state) {
        this.state = state;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[STARTED_AT]", nullable=true)
    public Date getStartedAt() {
        return this.startedAt;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[STARTED_AT]", nullable=true)
    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public Date getCreated() {
        return this.created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public void setCreated(Date created) {
        this.created = created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public Date getModified() {
        return this.modified;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public void setModified(Date modified) {
        this.modified = modified;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.instanceId).append((Object)this.url).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DBItemInventoryAgentInstance)) {
            return false;
        }
        DBItemInventoryAgentInstance rhs = (DBItemInventoryAgentInstance)other;
        return new EqualsBuilder().append((Object)this.instanceId, (Object)rhs.instanceId).append((Object)this.url, (Object)rhs.url).isEquals();
    }
}

