/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.reporting.db.DBLayer;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Type;
import sos.util.SOSString;

@Entity
@Table(name="INVENTORY_JOBS")
@SequenceGenerator(name="REPORTING_IJ_ID_SEQ", sequenceName="REPORTING_IJ_ID_SEQ", allocationSize=1)
public class DBItemInventoryJob
extends DbItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TITLE_MAX_LENGTH = 255;
    private Long id;
    private Long instanceId;
    private Long fileId;
    private String name;
    private String baseName;
    private String title;
    private boolean isOrderJob;
    private boolean isRuntimeDefined;
    private Boolean isYadeJob;
    private Date created;
    private Date modified;
    private Integer usedInJobChains;
    private String processClass;
    private String processClassName;
    private Long processClassId;
    private String schedule;
    private String scheduleName;
    private Long scheduleId;
    private Integer maxTasks;
    private String scriptLanguage;
    private Boolean hasDescription;
    private Boolean runTimeIsTemporary;
    private String criticality;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_IJ_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public Long getId() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_IJ_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public void setId(Long val) {
        this.id = val;
    }

    @Column(name="[INSTANCE_ID]", nullable=false)
    public Long getInstanceId() {
        return this.instanceId;
    }

    @Column(name="[INSTANCE_ID]", nullable=false)
    public void setInstanceId(Long val) {
        if (this.instanceId == null) {
            this.instanceId = DBLayer.DEFAULT_ID;
        }
        this.instanceId = val;
    }

    @Column(name="[FILE_ID]", nullable=false)
    public Long getFileId() {
        return this.fileId;
    }

    @Column(name="[FILE_ID]", nullable=false)
    public void setFileId(Long val) {
        if (this.fileId == null) {
            this.fileId = DBLayer.DEFAULT_ID;
        }
        this.fileId = val;
    }

    @Column(name="[NAME]", nullable=false)
    public void setName(String val) {
        this.name = val;
    }

    @Column(name="[NAME]", nullable=false)
    public String getName() {
        return this.name;
    }

    @Column(name="[BASENAME]", nullable=false)
    public void setBaseName(String val) {
        this.baseName = val;
    }

    @Column(name="[BASENAME]", nullable=false)
    public String getBaseName() {
        return this.baseName;
    }

    @Column(name="[TITLE]", nullable=true)
    public void setTitle(String val) {
        if (SOSString.isEmpty((String)val)) {
            val = null;
        } else if (val.length() > 255) {
            val = val.substring(0, 255);
        }
        this.title = val;
    }

    @Column(name="[TITLE]", nullable=true)
    public String getTitle() {
        return this.title;
    }

    @Column(name="[IS_ORDER_JOB]", nullable=false)
    @Type(type="numeric_boolean")
    public void setIsOrderJob(boolean val) {
        this.isOrderJob = val;
    }

    @Column(name="[IS_ORDER_JOB]", nullable=false)
    @Type(type="numeric_boolean")
    public boolean getIsOrderJob() {
        return this.isOrderJob;
    }

    @Column(name="[IS_RUNTIME_DEFINED]", nullable=false)
    @Type(type="numeric_boolean")
    public void setIsRuntimeDefined(boolean val) {
        this.isRuntimeDefined = val;
    }

    @Column(name="[CRITICALITY]", nullable=false)
    public void setCriticality(String val) {
        this.criticality = val;
    }

    @Column(name="[CRITICALITY]", nullable=false)
    public String getCriticality() {
        return this.criticality;
    }

    @Column(name="[IS_RUNTIME_DEFINED]", nullable=false)
    @Type(type="numeric_boolean")
    public boolean getIsRuntimeDefined() {
        return this.isRuntimeDefined;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public void setCreated(Date val) {
        this.created = val;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public Date getCreated() {
        return this.created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public void setModified(Date val) {
        this.modified = val;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public Date getModified() {
        return this.modified;
    }

    @Column(name="[USED_IN_JOB_CHAINS]", nullable=true)
    public Integer getUsedInJobChains() {
        return this.usedInJobChains;
    }

    @Column(name="[USED_IN_JOB_CHAINS]", nullable=true)
    public void setUsedInJobChains(Integer usedInJobChains) {
        this.usedInJobChains = usedInJobChains;
    }

    @Column(name="[PROCESS_CLASS]", nullable=true)
    public String getProcessClass() {
        return this.processClass;
    }

    @Column(name="[PROCESS_CLASS]", nullable=true)
    public void setProcessClass(String processClass) {
        this.processClass = processClass;
    }

    @Column(name="[PROCESS_CLASS_NAME]", nullable=false)
    public String getProcessClassName() {
        return this.processClassName;
    }

    @Column(name="[PROCESS_CLASS_NAME]", nullable=false)
    public void setProcessClassName(String processClassName) {
        if (processClassName == null || processClassName.isEmpty()) {
            processClassName = ".";
        }
        this.processClassName = processClassName;
    }

    @Column(name="[PROCESS_CLASS_ID]", nullable=false)
    public Long getProcessClassId() {
        return this.processClassId;
    }

    @Column(name="[PROCESS_CLASS_ID]", nullable=false)
    public void setProcessClassId(Long processClassId) {
        if (processClassId == null) {
            processClassId = DBLayer.DEFAULT_ID;
        }
        this.processClassId = processClassId;
    }

    @Column(name="[SCHEDULE]", nullable=true)
    public String getSchedule() {
        return this.schedule;
    }

    @Column(name="[SCHEDULE]", nullable=true)
    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Column(name="[SCHEDULE_NAME]", nullable=false)
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Column(name="[SCHEDULE_NAME]", nullable=false)
    public void setScheduleName(String scheduleName) {
        if (scheduleName == null || scheduleName.isEmpty()) {
            scheduleName = ".";
        }
        this.scheduleName = scheduleName;
    }

    @Column(name="[SCHEDULE_ID]", nullable=false)
    public Long getScheduleId() {
        return this.scheduleId;
    }

    @Column(name="[SCHEDULE_ID]", nullable=false)
    public void setScheduleId(Long scheduleId) {
        if (scheduleId == null) {
            scheduleId = DBLayer.DEFAULT_ID;
        }
        this.scheduleId = scheduleId;
    }

    @Column(name="[MAX_TASKS]", nullable=false)
    public Integer getMaxTasks() {
        return this.maxTasks;
    }

    @Column(name="[MAX_TASKS]", nullable=false)
    public void setMaxTasks(Integer maxTasks) {
        this.maxTasks = maxTasks;
    }

    @Column(name="[HAS_DESCRIPTION]", nullable=true)
    @Type(type="numeric_boolean")
    public Boolean getHasDescription() {
        return this.hasDescription;
    }

    @Column(name="[HAS_DESCRIPTION]", nullable=true)
    @Type(type="numeric_boolean")
    public void setHasDescription(Boolean hasDescription) {
        this.hasDescription = hasDescription;
    }

    @Column(name="[RUN_TIME_IS_TEMPORARY]", nullable=false)
    @Type(type="numeric_boolean")
    public Boolean getRunTimeIsTemporary() {
        return this.runTimeIsTemporary;
    }

    @Column(name="[RUN_TIME_IS_TEMPORARY]", nullable=false)
    @Type(type="numeric_boolean")
    public void setRunTimeIsTemporary(Boolean runTimeIsTemporary) {
        if (runTimeIsTemporary == null) {
            runTimeIsTemporary = false;
        }
        this.runTimeIsTemporary = runTimeIsTemporary;
    }

    @Column(name="[IS_YADE_JOB]", nullable=true)
    @Type(type="numeric_boolean")
    public Boolean getIsYadeJob() {
        return this.isYadeJob;
    }

    @Column(name="[IS_YADE_JOB]", nullable=true)
    @Type(type="numeric_boolean")
    public void setIsYadeJob(Boolean isYadeJob) {
        this.isYadeJob = isYadeJob;
    }

    @Column(name="[SCRIPT_LANGUAGE]", nullable=true)
    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    @Column(name="[SCRIPT_LANGUAGE]", nullable=true)
    public void setScriptLanguage(String scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.instanceId).append((Object)this.name).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DBItemInventoryJob)) {
            return false;
        }
        DBItemInventoryJob rhs = (DBItemInventoryJob)other;
        return new EqualsBuilder().append((Object)this.instanceId, (Object)rhs.instanceId).append((Object)this.name, (Object)rhs.name).isEquals();
    }
}

