/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.reporting.db.DBLayer;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Type;
import sos.util.SOSString;

@Entity
@Table(name="INVENTORY_JOB_CHAINS")
@SequenceGenerator(name="REPORTING_IJC_ID_SEQ", sequenceName="REPORTING_IJC_ID_SEQ", allocationSize=1)
public class DBItemInventoryJobChain
extends DbItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TITLE_MAX_LENGTH = 255;
    private Long id;
    private Long instanceId;
    private Long fileId;
    private String startCause;
    private String name;
    private String baseName;
    private String title;
    private Date created;
    private Date modified;
    private Integer maxOrders;
    private boolean distributed;
    private String processClass;
    private String processClassName;
    private Long processClassId;
    private String fileWatchingProcessClass;
    private String fileWatchingProcessClassName;
    private Long fileWatchingProcessClassId;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_IJC_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public Long getId() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_IJC_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public void setId(Long val) {
        this.id = val;
    }

    @Column(name="[INSTANCE_ID]", nullable=false)
    public Long getInstanceId() {
        return this.instanceId;
    }

    @Column(name="[INSTANCE_ID]", nullable=false)
    public void setInstanceId(Long val) {
        if (this.instanceId == null) {
            this.instanceId = DBLayer.DEFAULT_ID;
        }
        this.instanceId = val;
    }

    @Column(name="[FILE_ID]", nullable=false)
    public Long getFileId() {
        return this.fileId;
    }

    @Column(name="[FILE_ID]", nullable=false)
    public void setFileId(Long val) {
        if (this.fileId == null) {
            this.fileId = DBLayer.DEFAULT_ID;
        }
        this.fileId = val;
    }

    @Column(name="[START_CAUSE]", nullable=false)
    public void setStartCause(String val) {
        this.startCause = val;
    }

    @Column(name="[START_CAUSE]", nullable=false)
    public String getStartCause() {
        return this.startCause;
    }

    @Column(name="[NAME]", nullable=false)
    public void setName(String val) {
        this.name = val;
    }

    @Column(name="[NAME]", nullable=false)
    public String getName() {
        return this.name;
    }

    @Column(name="[BASENAME]", nullable=false)
    public void setBaseName(String val) {
        this.baseName = val;
    }

    @Column(name="[BASENAME]", nullable=false)
    public String getBaseName() {
        return this.baseName;
    }

    @Column(name="[TITLE]", nullable=true)
    public void setTitle(String val) {
        if (SOSString.isEmpty((String)val)) {
            val = null;
        } else if (val.length() > 255) {
            val = val.substring(0, 255);
        }
        this.title = val;
    }

    @Column(name="[TITLE]", nullable=true)
    public String getTitle() {
        return this.title;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public void setCreated(Date val) {
        this.created = val;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public Date getCreated() {
        return this.created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public void setModified(Date val) {
        this.modified = val;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public Date getModified() {
        return this.modified;
    }

    @Column(name="[MAX_ORDERS]", nullable=true)
    public Integer getMaxOrders() {
        return this.maxOrders;
    }

    @Column(name="[MAX_ORDERS]", nullable=true)
    public void setMaxOrders(Integer maxOrders) {
        this.maxOrders = maxOrders;
    }

    @Column(name="[DISTRIBUTED]", nullable=false)
    @Type(type="numeric_boolean")
    public boolean getDistributed() {
        return this.distributed;
    }

    @Column(name="[DISTRIBUTED]", nullable=false)
    @Type(type="numeric_boolean")
    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    @Column(name="[PROCESS_CLASS]", nullable=true)
    public String getProcessClass() {
        return this.processClass;
    }

    @Column(name="[PROCESS_CLASS]", nullable=true)
    public void setProcessClass(String processClass) {
        this.processClass = processClass;
    }

    @Column(name="[PROCESS_CLASS_NAME]", nullable=false)
    public String getProcessClassName() {
        return this.processClassName;
    }

    @Column(name="[PROCESS_CLASS_NAME]", nullable=false)
    public void setProcessClassName(String processClassName) {
        if (processClassName == null || processClassName.isEmpty()) {
            processClassName = ".";
        }
        this.processClassName = processClassName;
    }

    @Column(name="[PROCESS_CLASS_ID]", nullable=false)
    public Long getProcessClassId() {
        return this.processClassId;
    }

    @Column(name="[PROCESS_CLASS_ID]", nullable=false)
    public void setProcessClassId(Long processClassId) {
        if (processClassId == null) {
            processClassId = DBLayer.DEFAULT_ID;
        }
        this.processClassId = processClassId;
    }

    @Column(name="[FW_PROCESS_CLASS]", nullable=true)
    public String getFileWatchingProcessClass() {
        return this.fileWatchingProcessClass;
    }

    @Column(name="[FW_PROCESS_CLASS]", nullable=true)
    public void setFileWatchingProcessClass(String fileWatchingProcessClass) {
        this.fileWatchingProcessClass = fileWatchingProcessClass;
    }

    @Column(name="[FW_PROCESS_CLASS_NAME]", nullable=false)
    public String getFileWatchingProcessClassName() {
        return this.fileWatchingProcessClassName;
    }

    @Column(name="[FW_PROCESS_CLASS_NAME]", nullable=false)
    public void setFileWatchingProcessClassName(String fileWatchingProcessClassName) {
        if (fileWatchingProcessClassName == null || fileWatchingProcessClassName.isEmpty()) {
            fileWatchingProcessClassName = ".";
        }
        this.fileWatchingProcessClassName = fileWatchingProcessClassName;
    }

    @Column(name="[FW_PROCESS_CLASS_ID]", nullable=false)
    public Long getFileWatchingProcessClassId() {
        return this.fileWatchingProcessClassId;
    }

    @Column(name="[FW_PROCESS_CLASS_ID]", nullable=false)
    public void setFileWatchingProcessClassId(Long fileWatchingProcessClassId) {
        if (fileWatchingProcessClassId == null) {
            fileWatchingProcessClassId = DBLayer.DEFAULT_ID;
        }
        this.fileWatchingProcessClassId = fileWatchingProcessClassId;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.instanceId).append((Object)this.name).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DBItemInventoryJobChain)) {
            return false;
        }
        DBItemInventoryJobChain rhs = (DBItemInventoryJobChain)other;
        return new EqualsBuilder().append((Object)this.instanceId, (Object)rhs.instanceId).append((Object)this.name, (Object)rhs.name).isEquals();
    }
}

