/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.classes.SearchStringHelper;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.layer.SOSHibernateIntervalDBLayer;
import com.sos.jitl.reporting.db.DBItemReportExecution;
import com.sos.jitl.reporting.db.DBItemReportTask;
import com.sos.jitl.reporting.db.DBItemReportTrigger;
import com.sos.jitl.reporting.db.DBLayer;
import com.sos.jitl.reporting.db.filter.ReportExecutionFilter;
import com.sos.joc.model.common.Folder;
import com.sos.joc.model.job.OrderPath;
import com.sos.joc.model.job.TaskIdOfOrder;
import java.io.Serializable;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.TemporalType;
import org.hibernate.query.Query;

public class ReportTaskExecutionsDBLayer
extends SOSHibernateIntervalDBLayer<DBItemReportTask> {
    protected ReportExecutionFilter filter = null;
    private String lastQuery = "";

    public ReportTaskExecutionsDBLayer(SOSHibernateSession conn) {
        this.sosHibernateSession = conn;
        this.resetFilter();
    }

    public DBItemReportTask get(Long id) throws SOSHibernateException {
        return (DBItemReportTask)this.sosHibernateSession.get(DBItemReportTask.class, (Serializable)id);
    }

    public void resetFilter() {
        this.filter = new ReportExecutionFilter();
        this.filter.setDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        this.filter.setOrderCriteria("startTime");
        this.filter.setSortMode("desc");
    }

    public ReportExecutionFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ReportExecutionFilter filter_) {
        this.filter = filter_;
    }

    private String getStatusClause(String status) {
        if ("SUCCESSFUL".equals(status)) {
            return "(endTime != null and error <> 1)";
        }
        if ("INCOMPLETE".equals(status)) {
            return "(startTime != null and endTime is null)";
        }
        if ("FAILED".equals(status)) {
            return "(endTime != null and error = 1)";
        }
        return "";
    }

    protected String getWhere() {
        String where = "";
        String and = "";
        if (this.filter.getSchedulerId() != null && !this.filter.getSchedulerId().isEmpty()) {
            where = where + and + " schedulerId=:schedulerId";
            and = " and ";
        }
        if (this.filter.getTaskIds() != null && !this.filter.getTaskIds().isEmpty()) {
            where = where + and + " historyId in (:taskIds)";
            and = " and ";
        }
        if (this.filter.getStartTime() != null) {
            where = where + and + " startTime>= :startTime";
            and = " and ";
        }
        if (this.filter.getEndTime() != null) {
            where = where + and + " endTime < :endTime ";
            and = " and ";
        }
        if (this.filter.getListOfJobs() != null && this.filter.getListOfJobs().size() > 0) {
            where = where + and + SearchStringHelper.getStringListPathSql(this.filter.getListOfJobs(), (String)"name");
            and = " and ";
        } else {
            if (this.filter.getListOfExcludedJobs() != null && this.filter.getListOfExcludedJobs().size() > 0) {
                where = where + and + "(";
                for (String job : this.filter.getListOfExcludedJobs()) {
                    where = where + " name <> '" + job + "' and";
                }
                where = where + " 1=1)";
                and = " and ";
            }
            if (this.filter.getListOfFolders() != null && this.filter.getListOfFolders().size() > 0) {
                where = where + and + "(";
                for (Folder filterFolder : this.filter.getListOfFolders()) {
                    if (filterFolder.getRecursive().booleanValue()) {
                        String likeFolder = (filterFolder.getFolder() + "/%").replaceAll("//+", "/");
                        where = where + " (folder = '" + filterFolder.getFolder() + "' or folder like '" + likeFolder + "')";
                    } else {
                        where = where + " folder = '" + filterFolder.getFolder() + "'";
                    }
                    where = where + " or ";
                }
                where = where + " 0=1)";
                and = " and ";
            }
        }
        if (this.filter.getCriticality() != null && this.filter.getCriticality().size() > 0) {
            where = where + and + " criticality in (:criticalities)";
            and = " and ";
        }
        if (this.filter.getStates() != null && this.filter.getStates().size() > 0) {
            where = where + and + "(";
            for (String state : this.filter.getStates()) {
                where = where + this.getStatusClause(state) + " or ";
            }
            where = where + "1=0)";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    protected String getWhereFromTo() {
        return this.getWhereFromToStart();
    }

    protected String getWhereFromToStart() {
        return this.getWhereFromTo("startTime");
    }

    protected String getWhereFromToEnd() {
        return this.getWhereFromTo("endTime");
    }

    protected String getWhereFromTo(String fieldname_date_field) {
        String where = "";
        String and = "";
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            where = where + and + " schedulerId=:schedulerId";
            and = " and ";
        }
        if (this.filter.getTaskIds() != null && !this.filter.getTaskIds().isEmpty()) {
            where = where + and + " historyId in (:taskIds)";
            and = " and ";
        }
        if (this.filter.getExecutedFrom() != null) {
            where = where + and + fieldname_date_field + " >= :startTimeFrom";
            and = " and ";
        }
        if (this.filter.getExecutedTo() != null) {
            where = where + and + fieldname_date_field + " < :startTimeTo ";
            and = " and ";
        }
        if (this.filter.getCriticality() != null && this.filter.getCriticality().size() > 0) {
            where = where + and + " criticality in (:criticalities)";
            and = " and ";
        }
        if (this.filter.getStates() != null && this.filter.getStates().size() > 0) {
            where = where + and + "(";
            for (String state : this.filter.getStates()) {
                where = where + this.getStatusClause(state) + " or ";
            }
            where = where + "1=0)";
            and = " and ";
        }
        if (this.filter.getListOfJobs() != null && this.filter.getListOfJobs().size() > 0) {
            where = where + and + SearchStringHelper.getStringListPathSql(this.filter.getListOfJobs(), (String)"name");
            and = " and ";
        } else {
            if (this.filter.getListOfExcludedJobs() != null && this.filter.getListOfExcludedJobs().size() > 0) {
                where = where + and + "(";
                for (String job : this.filter.getListOfExcludedJobs()) {
                    where = where + " name <> '" + job + "' and";
                }
                where = where + " 1=1)";
                and = " and ";
            }
            if (this.filter.getListOfFolders() != null && this.filter.getListOfFolders().size() > 0) {
                where = where + and + "(";
                for (Folder filterFolder : this.filter.getListOfFolders()) {
                    if (filterFolder.getRecursive().booleanValue()) {
                        String likeFolder = (filterFolder.getFolder() + "/%").replaceAll("//+", "/");
                        where = where + " (folder = '" + filterFolder.getFolder() + "' or folder like '" + likeFolder + "')";
                    } else {
                        where = where + " folder = '" + filterFolder.getFolder() + "'";
                    }
                    where = where + " or ";
                }
                where = where + " 0=1)";
                and = " and ";
            }
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    public long deleteInterval() throws SOSHibernateException {
        int row = 0;
        String hql = "delete from " + DBLayer.DBITEM_REPORT_TASKS + " " + this.getWhereFromTo();
        Query query = this.sosHibernateSession.createQuery(hql);
        if (this.filter.getExecutedFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedTo(), TemporalType.TIMESTAMP);
        }
        row = this.sosHibernateSession.executeUpdate(query);
        this.sosHibernateSession.commit();
        return row;
    }

    public int delete() throws Exception {
        int row = 0;
        String hql = "delete from " + DBLayer.DBITEM_REPORT_TASKS + " " + this.getWhereFromTo();
        Query query = this.sosHibernateSession.createQuery(hql);
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getExecutedFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedTo(), TemporalType.TIMESTAMP);
        }
        row = this.sosHibernateSession.executeUpdate(query);
        this.sosHibernateSession.commit();
        return row;
    }

    private List<DBItemReportTask> executeQuery(Query<DBItemReportTask> query) throws SOSHibernateException {
        this.lastQuery = query.getQueryString();
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getTaskIds() != null && !this.filter.getTaskIds().isEmpty()) {
            query.setParameterList("taskIds", this.filter.getTaskIds());
        }
        if (this.filter.getExecutedFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedTo(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getCriticality() != null && !this.filter.getCriticality().isEmpty()) {
            query.setParameterList("criticalities", this.filter.getCriticality());
        }
        if (this.filter.getLimit() > 0) {
            query.setMaxResults(this.filter.getLimit());
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public List<DBItemReportTask> getSchedulerHistoryListFromTo() throws SOSHibernateException {
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBLayer.DBITEM_REPORT_TASKS, this.getWhereFromTo(), this.filter.getOrderCriteria(), this.filter.getSortMode()));
        return this.executeQuery((Query<DBItemReportTask>)query);
    }

    public List<DBItemReportTask> getSchedulerHistoryListFromHistoryIdAndNode(List<TaskIdOfOrder> o) throws SOSHibernateException {
        if (o != null && !o.isEmpty()) {
            StringBuilder sql = new StringBuilder();
            sql.append("from ").append(DBLayer.DBITEM_REPORT_TASKS).append(" where id in (");
            sql.append("select ta.id from " + DBLayer.DBITEM_REPORT_TASKS + " ta, " + DBItemReportExecution.class.getName() + " e");
            sql.append(" where ta.id=e.taskId");
            if (this.filter.getSchedulerId() != null && !this.filter.getSchedulerId().isEmpty()) {
                sql.append(" and ta.schedulerId=:schedulerId");
            }
            if (o.size() == 1) {
                sql.append(" and e.triggerHistoryId = :historyId and e.state = :state");
            } else {
                sql.append(" and ( 1=0");
                for (int i = 0; i < o.size(); ++i) {
                    sql.append(" or (e.triggerHistoryId = :historyId" + i + " and e.state = :state" + i + ")");
                }
                sql.append(" )");
            }
            sql.append(")");
            sql.append(" order by historyId desc");
            Query query = this.sosHibernateSession.createQuery(sql.toString());
            if (o.size() == 1) {
                query.setParameter("historyId", (Object)o.get(0).getHistoryId());
                query.setParameter("state", (Object)o.get(0).getState());
            } else {
                sql.append(" and ( 1=0");
                for (int i = 0; i < o.size(); ++i) {
                    query.setParameter("historyId" + i, (Object)o.get(i).getHistoryId());
                    query.setParameter("state" + i, (Object)o.get(i).getState());
                }
                sql.append(" )");
            }
            return this.executeQuery((Query<DBItemReportTask>)query);
        }
        return null;
    }

    public List<DBItemReportTask> getUnassignedSchedulerHistoryListFromTo() throws SOSHibernateException {
        Query query = this.sosHibernateSession.createQuery("from " + DBLayer.DBITEM_REPORT_TASKS + " " + this.getWhereFromTo() + " and id NOT IN (select reportExecutionId from DailyPlanDBItem where reportExecutionId is not null and isAssigned=1 and schedulerId=:schedulerId) " + this.filter.getOrderCriteria() + this.filter.getSortMode());
        return this.executeQuery((Query<DBItemReportTask>)query);
    }

    public List<DBItemReportTask> getSchedulerHistoryListFromToStart() throws SOSHibernateException {
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBLayer.DBITEM_REPORT_TASKS, this.getWhereFromToStart(), this.filter.getOrderCriteria(), this.filter.getSortMode()));
        return this.executeQuery((Query<DBItemReportTask>)query);
    }

    public List<DBItemReportTask> getSchedulerHistoryListFromToEnd() throws SOSHibernateException {
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBLayer.DBITEM_REPORT_TASKS, this.getWhereFromToEnd(), this.filter.getOrderCriteria(), this.filter.getSortMode()));
        return this.executeQuery((Query<DBItemReportTask>)query);
    }

    public List<DBItemReportTask> getSchedulerHistoryListSchedulersFromTo() throws SOSHibernateException {
        String q = "from " + DBLayer.DBITEM_REPORT_TASKS + " e where e.schedulerId IN (select distinct e.schedulerId from " + DBLayer.DBITEM_REPORT_TASKS + " " + this.getWhereFromTo() + ")";
        Query query = this.sosHibernateSession.createQuery(q);
        return this.executeQuery((Query<DBItemReportTask>)query);
    }

    public Long getCountSchedulerJobHistoryListFromTo(boolean successful) throws SOSHibernateException {
        if (this.getFilter().getStates() != null) {
            this.getFilter().getStates().clear();
        }
        if (this.getFilter().getCriticality() != null) {
            this.getFilter().getCriticality().clear();
        }
        if (successful) {
            this.getFilter().addState("SUCCESSFUL");
        } else {
            this.getFilter().addState("FAILED");
        }
        String where = this.getWhereFromToStart();
        Query query = this.sosHibernateSession.createQuery("select count(*) from " + DBLayer.DBITEM_REPORT_TASKS + " " + where);
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getExecutedFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedTo(), TemporalType.TIMESTAMP);
        }
        return (Long)this.sosHibernateSession.getSingleResult(query);
    }

    public List<DBItemReportTask> getHistoryItems() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBLayer.DBITEM_REPORT_TASKS, this.getWhere(), this.filter.getOrderCriteria(), this.filter.getSortMode()));
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getStartTime() != null) {
            query.setParameter("startTime", this.filter.getStartTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getEndTime() != null) {
            query.setParameter("endTime", this.filter.getEndTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getTaskIds() != null && !this.filter.getTaskIds().isEmpty()) {
            query.setParameterList("taskIds", this.filter.getTaskIds());
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        List historyList = this.sosHibernateSession.getResultList(query);
        return historyList;
    }

    public List<DBItemReportTask> getLastHistoryItems() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBLayer.DBITEM_REPORT_TASKS + " a ", this.getWhere() + " and historyId=(select max(historyId) from " + DBLayer.DBITEM_REPORT_TASKS + " b where a.name=b.name)", this.filter.getOrderCriteria(), this.filter.getSortMode()));
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getStartTime() != null) {
            query.setParameter("startTime", this.filter.getStartTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getEndTime() != null) {
            query.setParameter("endTime", this.filter.getEndTime(), TemporalType.TIMESTAMP);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        List historyList = this.sosHibernateSession.getResultList(query);
        return historyList;
    }

    public DBItemReportTask getHistoryItem() throws SOSHibernateException {
        this.filter.setLimit(1);
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBLayer.DBITEM_REPORT_TASKS, this.getWhere(), this.filter.getOrderCriteria(), this.filter.getSortMode()));
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getStartTime() != null) {
            query.setParameter("startTime", this.filter.getStartTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getEndTime() != null) {
            query.setParameter("endTime", this.filter.getEndTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getLimit() > 0) {
            query.setMaxResults(this.filter.getLimit());
        }
        return (DBItemReportTask)this.sosHibernateSession.getSingleResult(query);
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public void onAfterDeleting(DBItemReportTask h) {
    }

    public List<DBItemReportTask> getListOfItemsToDelete() throws SOSHibernateException {
        TimeZone.setDefault(TimeZone.getTimeZone("Etc/UTC"));
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBLayer.DBITEM_REPORT_TASKS, this.getWhereFromTo(), this.filter.getOrderCriteria(), this.filter.getSortMode()));
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getExecutedFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedTo(), TemporalType.TIMESTAMP);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public List<DBItemReportTask> getSchedulerHistoryListFromOrder(List<OrderPath> o) throws SOSHibernateException {
        if (o != null && !o.isEmpty()) {
            OrderPath orderPath;
            StringBuilder sql = new StringBuilder();
            sql.append("from ").append(DBLayer.DBITEM_REPORT_TASKS).append(" where id in (");
            sql.append("select ta.id from " + DBLayer.DBITEM_REPORT_TASKS + " ta, " + DBItemReportExecution.class.getName() + " e, " + DBItemReportTrigger.class.getName() + " tr");
            sql.append(" where ta.id=e.taskId and e.triggerId=tr.id");
            if (this.filter.getSchedulerId() != null && !this.filter.getSchedulerId().isEmpty()) {
                sql.append(" and ta.schedulerId=:schedulerId");
            }
            if (o.size() == 1) {
                OrderPath orderPath2 = o.get(0);
                sql.append(" and tr.parentName = :parentName");
                if (orderPath2.getOrderId() != null && !orderPath2.getOrderId().isEmpty()) {
                    sql.append(" and tr.name = :orderId");
                }
                if (orderPath2.getState() != null && !orderPath2.getState().isEmpty()) {
                    sql.append(" and e.state = :state");
                }
            } else {
                sql.append(" and ( 1=0");
                for (int i = 0; i < o.size(); ++i) {
                    orderPath = o.get(i);
                    sql.append(" or (tr.parentName = :parentName" + i);
                    if (orderPath.getOrderId() != null && !orderPath.getOrderId().isEmpty()) {
                        sql.append(" and tr.name = :orderId" + i);
                    }
                    if (orderPath.getState() != null && !orderPath.getState().isEmpty()) {
                        sql.append(" and e.state = :state" + i);
                    }
                    sql.append(")");
                }
                sql.append(" )");
            }
            sql.append(")");
            sql.append(" order by historyId desc");
            Query query = this.sosHibernateSession.createQuery(sql.toString());
            if (o.size() == 1) {
                orderPath = o.get(0);
                query.setParameter("parentName", (Object)orderPath.getJobChain());
                if (orderPath.getOrderId() != null && !orderPath.getOrderId().isEmpty()) {
                    query.setParameter("orderId", (Object)orderPath.getOrderId());
                }
                if (orderPath.getState() != null && !orderPath.getState().isEmpty()) {
                    query.setParameter("state", (Object)orderPath.getState());
                }
            } else {
                sql.append(" and ( 1=0");
                for (int i = 0; i < o.size(); ++i) {
                    OrderPath orderPath3 = o.get(i);
                    query.setParameter("parentName" + i, (Object)orderPath3.getJobChain());
                    if (orderPath3.getOrderId() != null && !orderPath3.getOrderId().isEmpty()) {
                        query.setParameter("orderId" + i, (Object)orderPath3.getOrderId());
                    }
                    if (orderPath3.getState() != null && !orderPath3.getState().isEmpty()) {
                        query.setParameter("state" + i, (Object)orderPath3.getState());
                    }
                    sql.append(")");
                }
                sql.append(" )");
            }
            return this.executeQuery((Query<DBItemReportTask>)query);
        }
        return null;
    }

    public List<DBItemReportTask> getSchedulerHistoryListFromTo(ReportExecutionFilter filter) throws SOSHibernateException {
        this.filter = filter;
        return this.getSchedulerHistoryListFromTo();
    }
}

