/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.job.report;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.reporting.db.DBLayer;
import com.sos.jitl.reporting.job.report.AggregationJobOptions;
import com.sos.jitl.reporting.model.report.AggregationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationJob
extends JSJobUtilitiesClass<AggregationJobOptions> {
    private final String className = AggregationJob.class.getSimpleName();
    private static Logger logger = LoggerFactory.getLogger(AggregationJob.class);
    private SOSHibernateSession session;
    private SOSHibernateFactory factory;

    public AggregationJob() {
        super((Object)new AggregationJobOptions());
    }

    public void init() throws Exception {
        try {
            this.factory = new SOSHibernateFactory(this.getOptions().hibernate_configuration_file.getValue());
            this.factory.setAutoCommit(this.getOptions().connection_autocommit.value());
            this.factory.setTransactionIsolation(this.getOptions().connection_transaction_isolation.value());
            this.factory.addClassMapping(DBLayer.getInventoryClassMapping());
            this.factory.addClassMapping(DBLayer.getReportingClassMapping());
            this.factory.build();
        }
        catch (Exception ex) {
            throw new Exception(String.format("init connection: %s", ex.toString()));
        }
    }

    public void openSession() throws Exception {
        this.session = this.factory.openStatelessSession();
    }

    public void closeSession() throws Exception {
        if (this.session != null) {
            this.session.close();
        }
    }

    public void exit() {
        if (this.factory != null) {
            this.factory.close();
        }
    }

    public AggregationJob execute() throws Exception {
        String methodName = this.className + "::execute";
        logger.debug(methodName);
        try {
            this.getOptions().checkMandatory();
            logger.debug(this.getOptions().toString());
            AggregationModel model = new AggregationModel(this.session, this.getOptions());
            model.process();
        }
        catch (Exception e) {
            logger.error(String.format("%s: %s", methodName, e.toString()));
            throw e;
        }
        return this;
    }

    public AggregationJobOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new AggregationJobOptions();
        }
        return (AggregationJobOptions)((Object)this.objOptions);
    }
}

