/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.model.report;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.reporting.db.DBItemReportExecution;
import com.sos.jitl.reporting.db.DBItemReportExecutionDate;
import com.sos.jitl.reporting.db.DBItemReportTask;
import com.sos.jitl.reporting.db.DBItemReportTrigger;
import com.sos.jitl.reporting.helper.CounterCreateResult;
import com.sos.jitl.reporting.helper.EReferenceType;
import com.sos.jitl.reporting.helper.ReportUtil;
import com.sos.jitl.reporting.job.report.AggregationJobOptions;
import com.sos.jitl.reporting.model.IReportingModel;
import com.sos.jitl.reporting.model.ReportingModel;
import java.util.Date;
import java.util.Optional;
import org.hibernate.ScrollableResults;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationModel
extends ReportingModel
implements IReportingModel {
    private Logger LOGGER = LoggerFactory.getLogger(AggregationModel.class);
    private AggregationJobOptions options;
    private CounterCreateResult counterTriggerAggregated;
    private CounterCreateResult counterExecutionAggregated;
    private CounterCreateResult counterTaskAggregated;
    private Optional<Integer> largeResultFetchSizeReporting = Optional.empty();

    public AggregationModel(SOSHibernateSession reportingConn, AggregationJobOptions opt) throws Exception {
        super(reportingConn);
        this.options = opt;
        this.largeResultFetchSizeReporting = this.getFetchSize(this.options.large_result_fetch_size.value());
    }

    @Override
    public void process() throws Exception {
        String method = "process";
        try {
            this.LOGGER.info(String.format("%s: large_result_fetch_size = %s", method, this.options.large_result_fetch_size.getValue()));
            DateTime start = new DateTime();
            this.initCounters();
            if (this.options.execute_aggregation.value()) {
                this.aggregateTriggers(this.options.current_scheduler_id.getValue());
                this.aggregateExecutions(this.options.current_scheduler_id.getValue());
                this.aggregateTasks(this.options.current_scheduler_id.getValue());
            } else {
                this.LOGGER.info(String.format("%s: skip processing. option \"execute_aggregation\" = false", method));
            }
            this.logSummary(start);
        }
        catch (Exception ex) {
            throw new Exception(String.format("%s: %s", method, ex.toString()), ex);
        }
    }

    private DBItemReportExecutionDate insertExecutionDate(EReferenceType type, String schedulerId, Long historyId, Long id, Date startDate, Date endDate) throws Exception {
        String method = "insertReportingExecutionDate";
        if (startDate == null) {
            throw new Exception(String.format("%s: startDate is NULL (type = %s, schedulerId = %s, historyId = %s, id = %s) ", method, type.value(), schedulerId, historyId, id));
        }
        DateTime startDateTime = new DateTime((Object)startDate);
        Long startDay = ReportUtil.getDayOfMonth(startDateTime);
        Long startWeek = ReportUtil.getWeekOfWeekyear(startDateTime);
        Long startQuarter = ReportUtil.getQuarterOfYear(startDateTime);
        Long startMonth = ReportUtil.getMonthOfYear(startDateTime);
        Long startYear = ReportUtil.getYear(startDateTime);
        Long endDay = new Long(0L);
        Long endWeek = new Long(0L);
        Long endQuarter = new Long(0L);
        Long endMonth = new Long(0L);
        Long endYear = new Long(0L);
        if (endDate != null) {
            DateTime endDateTime = new DateTime((Object)endDate);
            endDay = ReportUtil.getDayOfMonth(endDateTime);
            endWeek = ReportUtil.getWeekOfWeekyear(endDateTime);
            endQuarter = ReportUtil.getQuarterOfYear(endDateTime);
            endMonth = ReportUtil.getMonthOfYear(endDateTime);
            endYear = ReportUtil.getYear(endDateTime);
        }
        DBItemReportExecutionDate item = new DBItemReportExecutionDate();
        item.setSchedulerId(schedulerId);
        item.setHistoryId(historyId);
        item.setReferenceType(type.value());
        item.setReferenceId(id);
        item.setStartDay(startDay);
        item.setStartWeek(startWeek);
        item.setStartMonth(startMonth);
        item.setStartQuarter(startQuarter);
        item.setStartYear(startYear);
        item.setEndDay(endDay);
        item.setEndWeek(endWeek);
        item.setEndMonth(endMonth);
        item.setEndQuarter(endQuarter);
        item.setEndYear(endYear);
        item.setCreated(ReportUtil.getCurrentDateTime());
        item.setModified(ReportUtil.getCurrentDateTime());
        this.getDbLayer().getSession().save((Object)item);
        return item;
    }

    public void aggregateTriggers(String schedulerId) throws Exception {
        String method = "aggregateTriggers";
        int countExecutionDates = 0;
        int countTotal = 0;
        try (ScrollableResults results = null;){
            this.LOGGER.info(String.format("%s", method));
            DateTime start = new DateTime();
            this.getDbLayer().getSession().beginTransaction();
            results = this.getDbLayer().getResultsUncompletedTriggers(this.largeResultFetchSizeReporting, schedulerId);
            while (results.next()) {
                ++countTotal;
                DBItemReportTrigger item = (DBItemReportTrigger)results.get(0);
                if (item == null || item.getId() == null) {
                    throw new Exception("trigger or trigger.getId() is NULL");
                }
                this.getDbLayer().removeExecutionDate(EReferenceType.TRIGGER, item.getId());
                this.insertExecutionDate(EReferenceType.TRIGGER, item.getSchedulerId(), item.getHistoryId(), item.getId(), item.getStartTime(), item.getEndTime());
                item.setResultsCompleted(true);
                this.getDbLayer().getSession().update((Object)item);
                ++countExecutionDates;
                if (countTotal % this.options.log_info_step.value() != 0) continue;
                this.LOGGER.info(String.format("%s: %s entries processed ...", method, this.options.log_info_step.value()));
            }
            this.getDbLayer().getSession().commit();
            this.counterTriggerAggregated.setTotalUncompleted(countTotal);
            this.counterTriggerAggregated.setExecutionsDates(countExecutionDates);
            this.LOGGER.debug(String.format("%s: duration = %s", method, ReportUtil.getDuration(start, new DateTime())));
        }
    }

    public void aggregateExecutions(String schedulerId) throws Exception {
        String method = "aggregateExecutions";
        int countExecutionDates = 0;
        int countTotal = 0;
        try (ScrollableResults results = null;){
            this.LOGGER.info(String.format("%s", method));
            DateTime start = new DateTime();
            this.getDbLayer().getSession().beginTransaction();
            results = this.getDbLayer().getResultsUncompletedExecutions(this.largeResultFetchSizeReporting, schedulerId);
            while (results.next()) {
                ++countTotal;
                DBItemReportExecution item = (DBItemReportExecution)results.get(0);
                if (item == null || item.getId() == null) {
                    throw new Exception("item or item.getId() is NULL");
                }
                this.getDbLayer().removeExecutionDate(EReferenceType.EXECUTION, item.getId());
                this.insertExecutionDate(EReferenceType.EXECUTION, item.getSchedulerId(), item.getHistoryId(), item.getId(), item.getStartTime(), item.getEndTime());
                item.setResultsCompleted(true);
                this.getDbLayer().getSession().update((Object)item);
                ++countExecutionDates;
                if (countTotal % this.options.log_info_step.value() != 0) continue;
                this.LOGGER.info(String.format("%s: %s entries processed ...", method, this.options.log_info_step.value()));
            }
            this.getDbLayer().getSession().commit();
            this.counterExecutionAggregated.setTotalUncompleted(countTotal);
            this.counterExecutionAggregated.setExecutionsDates(countExecutionDates);
            this.LOGGER.debug(String.format("%s: duration = %s", method, ReportUtil.getDuration(start, new DateTime())));
        }
    }

    public void aggregateTasks(String schedulerId) throws Exception {
        String method = "aggregateTasks";
        int countExecutionDates = 0;
        int countTotal = 0;
        try (ScrollableResults results = null;){
            this.LOGGER.info(String.format("%s", method));
            DateTime start = new DateTime();
            this.getDbLayer().getSession().beginTransaction();
            results = this.getDbLayer().getResultsUncompletedTasks(this.largeResultFetchSizeReporting, schedulerId);
            while (results.next()) {
                ++countTotal;
                DBItemReportTask item = (DBItemReportTask)results.get(0);
                if (item == null || item.getId() == null) {
                    throw new Exception("item or item.getId() is NULL");
                }
                this.getDbLayer().removeExecutionDate(EReferenceType.TASK, item.getId());
                this.insertExecutionDate(EReferenceType.TASK, item.getSchedulerId(), item.getHistoryId(), item.getId(), item.getStartTime(), item.getEndTime());
                item.setResultsCompleted(true);
                this.getDbLayer().getSession().update((Object)item);
                ++countExecutionDates;
                if (countTotal % this.options.log_info_step.value() != 0) continue;
                this.LOGGER.info(String.format("%s: %s entries processed ...", method, this.options.log_info_step.value()));
            }
            this.getDbLayer().getSession().commit();
            this.counterTaskAggregated.setTotalUncompleted(countTotal);
            this.counterTaskAggregated.setExecutionsDates(countExecutionDates);
            this.LOGGER.debug(String.format("%s: duration = %s", method, ReportUtil.getDuration(start, new DateTime())));
        }
    }

    private void initCounters() throws Exception {
        this.counterTriggerAggregated = new CounterCreateResult();
        this.counterExecutionAggregated = new CounterCreateResult();
        this.counterTaskAggregated = new CounterCreateResult();
    }

    private void logSummary(DateTime start) throws Exception {
        String method = "logSummary";
        this.LOGGER.info(String.format("%s[trigger]: total=%s, inserted execution dates=%s", method, this.counterTriggerAggregated.getTotalUncompleted(), this.counterTriggerAggregated.getExecutionsDates()));
        this.LOGGER.info(String.format("%s[execution]: total=%s, inserted execution dates=%s", method, this.counterExecutionAggregated.getTotalUncompleted(), this.counterExecutionAggregated.getExecutionsDates()));
        this.LOGGER.info(String.format("%s[task]: total=%s, inserted execution dates=%s", method, this.counterTaskAggregated.getTotalUncompleted(), this.counterTaskAggregated.getExecutionsDates()));
        this.LOGGER.debug(String.format("%s: duration = %s", method, ReportUtil.getDuration(start, new DateTime())));
    }
}

