/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.model.report;

import com.sos.hibernate.classes.SOSHibernate;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.exceptions.SOSHibernateObjectOperationStaleStateException;
import com.sos.jitl.eventhandler.EventMeta;
import com.sos.jitl.eventhandler.plugin.notifier.Notifier;
import com.sos.jitl.reporting.db.DBItemReportExecution;
import com.sos.jitl.reporting.db.DBItemReportTask;
import com.sos.jitl.reporting.db.DBItemReportTrigger;
import com.sos.jitl.reporting.db.DBItemReportVariable;
import com.sos.jitl.reporting.db.DBItemSchedulerHistory;
import com.sos.jitl.reporting.db.DBItemSchedulerHistoryOrderStepReporting;
import com.sos.jitl.reporting.exceptions.SOSReportingConcurrencyException;
import com.sos.jitl.reporting.exceptions.SOSReportingInvalidSessionException;
import com.sos.jitl.reporting.exceptions.SOSReportingLockException;
import com.sos.jitl.reporting.helper.CounterSynchronize;
import com.sos.jitl.reporting.helper.EStartCauses;
import com.sos.jitl.reporting.helper.InventoryInfo;
import com.sos.jitl.reporting.helper.ReportUtil;
import com.sos.jitl.reporting.helper.TaskStarted;
import com.sos.jitl.reporting.job.report.FactJobOptions;
import com.sos.jitl.reporting.model.IReportingModel;
import com.sos.jitl.reporting.model.ReportingModel;
import com.sos.jitl.reporting.plugin.FactNotificationPlugin;
import com.sos.jitl.reporting.yade.TransferHistoryHandler;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.hibernate.query.Query;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class FactModel
extends ReportingModel
implements IReportingModel {
    public static final long RERUN_INTERVAL = 2L;
    public static final int MAX_RERUNS = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(FactModel.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private static final boolean isTraceEnabled = LOGGER.isTraceEnabled();
    private static final String TABLE_REPORTING_VARIABLES_VARIABLE_PREFIX = "reporting_";
    private static final String LOCK_PREFIX = "locked";
    private static final String LOCK_DELIMITER = "#";
    private static final int MAX_LOCK_WAIT = 15;
    private static final long MAX_LOCK_VERSION = 10000000L;
    private FactJobOptions options;
    private JsonArray events;
    private SOSHibernateSession schedulerSession;
    private CounterSynchronize counterOrderSyncUncompleted;
    private CounterSynchronize counterOrderSync;
    private CounterSynchronize counterTaskSyncUncompleted;
    private CounterSynchronize counterTaskSyncEvent;
    private CounterSynchronize counterTaskSync;
    private CounterSynchronize counterTaskSyncNotFounded;
    private long counterTaskStartedEventsInserted;
    private boolean isChanged = false;
    private boolean isOrdersChanged = false;
    private boolean isTasksChanged = false;
    private boolean isLocked = false;
    private String lockCause = null;
    private int maxHistoryAge;
    private int taskHistoryMaxUncompletedAge;
    private int orderHistoryMaxUncompletedAge;
    private Long maxHistoryTasks;
    private Long waitInterval;
    private String schedulerId;
    private List<Long> uncompletedTaskHistoryIds;
    private List<Long> eventTaskClosedHistoryIds;
    private Map<Long, TaskStarted> eventTaskStartedHistoryIds;
    private Optional<Integer> largeResultFetchSizeReporting = Optional.empty();
    private Optional<Integer> largeResultFetchSizeScheduler = Optional.empty();
    private FactNotificationPlugin notificationPlugin;
    private TransferHistoryHandler transferHistory;
    private HashMap<Long, DBItemReportTask> endedOrderTasks4notification;

    public FactModel(SOSHibernateSession reportingSess, SOSHibernateSession schedulerSess, FactJobOptions opt, JsonArray es) throws Exception {
        this.setReportingSession(reportingSess);
        this.schedulerSession = schedulerSess;
        this.options = opt;
        this.events = es;
        this.largeResultFetchSizeReporting = this.getFetchSize(this.options.large_result_fetch_size.value());
        this.largeResultFetchSizeScheduler = this.getFetchSize(this.options.large_result_fetch_size_scheduler.value());
        this.maxHistoryAge = ReportUtil.resolveAge2Minutes(this.options.max_history_age.getValue());
        this.maxHistoryTasks = new Long(this.options.max_history_tasks.value());
        this.taskHistoryMaxUncompletedAge = ReportUtil.resolveAge2Minutes(this.options.task_history_max_uncompleted_age.getValue());
        this.orderHistoryMaxUncompletedAge = ReportUtil.resolveAge2Minutes(this.options.order_history_max_uncompleted_age.getValue());
        this.waitInterval = new Long(this.options.wait_interval.value());
        this.schedulerId = this.options.current_scheduler_id.getValue();
        this.transferHistory = new TransferHistoryHandler();
        this.registerPlugin();
    }

    public void init(Notifier notifier, Path configDirectory) {
        this.pluginOnInit(notifier, configDirectory);
    }

    public void exit() {
        this.pluginOnExit();
    }

    @Override
    public void process() throws Exception {
        String method = "process";
        Date dateFrom = null;
        Date dateTo = ReportUtil.getCurrentDateTime();
        String dateToAsString = ReportUtil.getDateAsString(dateTo);
        Long dateToAsMinutes = ReportUtil.getDateAsMinutes(dateTo);
        Long dateToAsSeconds = ReportUtil.getDateAsSeconds(dateTo);
        DateTime start = new DateTime();
        this.initCounters();
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]execute_notification_plugin=%s", method, this.options.execute_notification_plugin.value()));
        }
        DBItemReportVariable reportingVariable = null;
        boolean finisched = false;
        try {
            this.isLocked = false;
            this.lockCause = null;
            reportingVariable = this.initSynchronizing(dateTo, dateToAsSeconds, dateToAsString);
            if (this.isLocked) {
                LOGGER.info(String.format("[%s to %s UTC][skip synchronizing][locked]%s", reportingVariable.getTextValue(), dateToAsString, this.lockCause));
            } else {
                dateFrom = this.getDateFrom(reportingVariable, dateTo, dateToAsString);
                String dateFromAsString = ReportUtil.getDateAsString(dateFrom);
                if (this.doProcessing(dateFrom, dateTo)) {
                    this.analyzeEvents(this.events);
                    this.synchronizeTaskClosedEvents(this.schedulerId, dateToAsMinutes);
                    this.synchronizeUncompletedTasks(this.schedulerId, dateToAsMinutes);
                    this.synchronizeTimePeriodTasks(this.schedulerId, dateFrom, dateTo, dateToAsMinutes, dateFromAsString, dateToAsString);
                    this.synchronizeUncompletedOrders(this.schedulerId, dateToAsMinutes);
                    this.synchronizeTimePeriodOrders(this.schedulerId, dateFrom, dateTo, dateToAsMinutes, dateFromAsString, dateToAsString);
                    this.synchronizeNotFounded(dateToAsMinutes);
                    this.synchronizeTaskStartedEvents(this.schedulerId, dateToAsMinutes);
                    this.updateNotificationRest();
                    this.finishSynchronizing(reportingVariable, dateToAsString);
                    finisched = true;
                    this.setChangedSummary();
                    this.logSummary(dateFromAsString, dateToAsString, start);
                } else {
                    LOGGER.info(String.format("[%s to %s UTC][skip synchronizing]time diff in seconds < wait interval(%s s)", dateFromAsString, dateToAsString, this.waitInterval));
                }
            }
        }
        catch (Exception e) {
            try {
                if (!finisched && reportingVariable != null && !SOSString.isEmpty((String)reportingVariable.getTextValue())) {
                    String oldDateFrom = this.getWithoutLocked(reportingVariable.getTextValue());
                    LOGGER.info(String.format("[%s][%s][%s][reset synchronizing on exception]%s", method, reportingVariable.getTextValue(), oldDateFrom, e.toString()), (Throwable)e);
                    this.finishSynchronizing(reportingVariable, oldDateFrom);
                } else {
                    LOGGER.info(String.format("[%s][%s][%s][skip][reset synchronizing on exception]%s", method, reportingVariable, finisched, e.toString()), (Throwable)e);
                }
            }
            catch (Throwable ee) {
                LOGGER.warn(String.format("[%s][error occured during reset synchronizing on exception]%s", method, ee.toString()), ee);
            }
            Exception ex = SOSHibernate.findLockException((Exception)e);
            if (ex == null) {
                ex = SOSHibernate.findInvalidSessionException((Exception)e);
                if (ex == null) {
                    throw e;
                }
                throw new SOSReportingInvalidSessionException(e);
            }
            throw new SOSReportingLockException(e);
        }
    }

    private void finishSynchronizing(DBItemReportVariable reportingVariable, String dateTo) throws Exception {
        String method = "finishSynchronizing";
        try {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]dateTo=%s", method, dateTo));
            }
            this.getDbLayer().getSession().beginTransaction();
            reportingVariable.setNumericValue(new Long(this.maxHistoryAge));
            reportingVariable.setTextValue(dateTo);
            this.getDbLayer().getSession().update((Object)reportingVariable);
            if (reportingVariable.getLockVersion() > 10000000L) {
                this.getDbLayer().resetReportVariableLockVersion(reportingVariable.getName());
            }
            this.getDbLayer().getSession().commit();
        }
        catch (SOSHibernateObjectOperationStaleStateException e) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[%s]%s", method, ex.toString()), (Throwable)ex);
            }
            LOGGER.warn(String.format("[%s]%s", method, e.toString()), (Throwable)e);
        }
        catch (Exception e) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[%s]%s", method, ex.toString()), (Throwable)ex);
            }
            throw new Exception(String.format("[%s]%s", method, e.toString()), e);
        }
    }

    private String getSetLocked(Date dateFrom, String dateTo) throws Exception {
        return this.getSetLocked(ReportUtil.getDateAsString(dateFrom), dateTo);
    }

    private String getSetLocked(String dateFrom, String dateTo) throws Exception {
        return "locked#" + dateFrom + LOCK_DELIMITER + dateTo;
    }

    private String getWithoutLocked(String val) {
        String[] arr = val.split(LOCK_DELIMITER);
        if (arr.length > 1) {
            return arr[1];
        }
        return val;
    }

    private boolean doProcessing(Date dateFrom, Date dateTo) {
        Long diff = ReportUtil.getDateAsSeconds(dateTo) - ReportUtil.getDateAsSeconds(dateFrom);
        if (diff < this.waitInterval) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[doProcessing][skip]diff=%ss, waitInterval=%ss", diff, this.waitInterval));
            }
            return false;
        }
        return true;
    }

    private DBItemReportVariable initSynchronizing(Date dateTo, Long dateToAsSeconds, String dateToAsString) throws Exception {
        String method = "initSynchronizing";
        DBItemReportVariable variable = null;
        try {
            String name = this.getSchedulerVariableName();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]name=%s", method, name));
            }
            this.getDbLayer().getSession().beginTransaction();
            variable = this.getDbLayer().getReportVariabe(name);
            if (variable == null) {
                Date dateFrom = ReportUtil.getDateTimeMinusMinutes(dateTo, new Long(this.maxHistoryAge));
                variable = this.getDbLayer().insertReportVariable(name, new Long(this.maxHistoryAge), this.getSetLocked(dateFrom, dateToAsString));
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s]dateFrom=%s (initial, %s-%s)", method, ReportUtil.getDateAsString(dateFrom), dateToAsString, this.maxHistoryAge));
                }
            } else {
                String dateFromAsString = variable.getTextValue();
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s]storedDateFrom=%s, dateTo=%s, storedMaxAge=%s, storedLockVersion=%s", method, dateFromAsString, dateToAsString, variable.getNumericValue(), variable.getLockVersion()));
                }
                Date dateFrom = null;
                if (SOSString.isEmpty((String)dateFromAsString)) {
                    dateFrom = ReportUtil.getDateTimeMinusMinutes(dateTo, new Long(this.maxHistoryAge));
                    dateFromAsString = ReportUtil.getDateAsString(dateFrom);
                } else if (dateFromAsString.startsWith("locked#")) {
                    String[] arr = dateFromAsString.split(LOCK_DELIMITER);
                    dateFromAsString = arr[1];
                    dateFrom = ReportUtil.getDateFromString(dateFromAsString);
                    Date anotherDateTo = null;
                    anotherDateTo = arr.length > 2 ? ReportUtil.getDateFromString(arr[2]) : dateFrom;
                    Long anotherDateToAsSeconds = ReportUtil.getDateAsSeconds(anotherDateTo);
                    Long diff = dateToAsSeconds - anotherDateToAsSeconds;
                    if (diff < 15L) {
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s]set isLocked: diff=%ss(dateToAsSeconds=%s-anotherDateToAsSeconds=%s) >= MAX_LOCK_WAIT=%ss", method, dateFromAsString, diff, dateToAsSeconds, anotherDateToAsSeconds, 15));
                        }
                        this.lockCause = String.format("diff=%ss between the current and the last request", diff);
                        this.isLocked = true;
                    }
                } else {
                    dateFrom = ReportUtil.getDateFromString(dateFromAsString);
                }
                if (!this.isLocked && this.doProcessing(dateFrom, dateTo)) {
                    variable.setNumericValue(new Long(this.maxHistoryAge));
                    String lockedValue = this.getSetLocked(dateFromAsString, dateToAsString);
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s]lockedValue=%s", method, lockedValue));
                    }
                    variable.setTextValue(lockedValue);
                    this.getDbLayer().getSession().update((Object)variable);
                }
            }
            this.getDbLayer().getSession().commit();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]dateFrom=%s, maxAge=%s, lockVersion=%s", method, variable.getTextValue(), variable.getNumericValue(), variable.getLockVersion()));
            }
        }
        catch (SOSHibernateObjectOperationStaleStateException e) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[%s]%s", method, ex.toString()), (Throwable)ex);
            }
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]set isLocked on SOSHibernateObjectOperationStaleStateException: %s", method, e.toString()));
            }
            this.lockCause = "locked by an another instance";
            this.isLocked = true;
        }
        catch (Exception e) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[%s]%s", method, ex.toString()), (Throwable)ex);
            }
            throw new Exception(String.format("[%s]%s", method, e.toString()), e);
        }
        return variable;
    }

    private String getSchedulerVariableName() {
        String name = String.format("%s%s", TABLE_REPORTING_VARIABLES_VARIABLE_PREFIX, this.schedulerId);
        if (name.length() > 255) {
            name = name.substring(0, 255);
        }
        return name.toLowerCase();
    }

    private void synchronizeUncompletedOrders(String schedulerId, Long dateToAsMinutes) throws Exception {
        String method = "synchronizeUncompletedOrders";
        if (schedulerId != null && !schedulerId.isEmpty()) {
            List<DBItemReportTrigger> triggers = null;
            try {
                this.getDbLayer().getSession().beginTransaction();
                triggers = this.getDbLayer().getSyncUncomplitedTriggers(this.largeResultFetchSizeScheduler, schedulerId);
                this.getDbLayer().getSession().commit();
            }
            catch (Throwable ex) {
                try {
                    this.getDbLayer().getSession().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOGGER.error(String.format("[%s]%s", method, ex.toString()), ex);
                return;
            }
            if (triggers != null) {
                int size = triggers.size();
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][reporting]%s orders", method, size));
                }
                if (size > 0) {
                    int counterTotal = 0;
                    int counterSkip = 0;
                    int counterInsertedTriggers = 0;
                    int counterUpdatedTriggers = 0;
                    int counterInsertedExecutions = 0;
                    int counterUpdatedExecutions = 0;
                    int counterInsertedTasks = 0;
                    int counterUpdatedTasks = 0;
                    for (int i = 0; i < size; ++i) {
                        DBItemReportTrigger trigger = triggers.get(i);
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][%s][%s][step>=%s]%s", method, i + 1, trigger.getParentName(), trigger.getName(), trigger.getResultSteps(), SOSString.toString((Object)trigger)));
                        }
                        Query<DBItemSchedulerHistoryOrderStepReporting> query = this.getDbLayer().getSchedulerHistoryOrderStepsQuery(this.schedulerSession, this.largeResultFetchSizeScheduler, schedulerId, trigger.getHistoryId(), trigger.getResultSteps());
                        CounterSynchronize counter = this.synchronizeOrderHistory(method, query, OrderSync.UNCOMPLETED, dateToAsMinutes);
                        counterTotal += counter.getTotal();
                        counterSkip += counter.getSkip();
                        counterInsertedTriggers += counter.getInsertedTriggers();
                        counterUpdatedTriggers += counter.getUpdatedTriggers();
                        counterInsertedExecutions += counter.getInsertedExecutions();
                        counterUpdatedExecutions += counter.getUpdatedExecutions();
                        counterInsertedTasks += counter.getInsertedTasks();
                        counterUpdatedTasks += counter.getUpdatedTasks();
                    }
                    this.counterOrderSyncUncompleted.setTotal(counterTotal);
                    this.counterOrderSyncUncompleted.setSkip(counterSkip);
                    this.counterOrderSyncUncompleted.setInsertedTriggers(counterInsertedTriggers);
                    this.counterOrderSyncUncompleted.setUpdatedTriggers(counterUpdatedTriggers);
                    this.counterOrderSyncUncompleted.setInsertedExecutions(counterInsertedExecutions);
                    this.counterOrderSyncUncompleted.setUpdatedExecutions(counterUpdatedExecutions);
                    this.counterOrderSyncUncompleted.setInsertedTasks(counterInsertedTasks);
                    this.counterOrderSyncUncompleted.setUpdatedTasks(counterUpdatedTasks);
                }
            }
        }
    }

    private List<Long> getTaskSyncUncomplitedHistoryIds(String schedulerId) throws Exception {
        String method = "getTaskSyncUncomplitedHistoryIds";
        ArrayList<Long> uncompletedIds = new ArrayList<Long>();
        try {
            this.getDbLayer().getSession().beginTransaction();
            List<Long> result = this.getDbLayer().getTaskSyncUncomplitedHistoryIds(this.largeResultFetchSizeReporting, schedulerId);
            this.getDbLayer().getSession().commit();
            for (int i = 0; i < result.size(); ++i) {
                Long historyId = result.get(i);
                if (uncompletedIds.contains(historyId)) continue;
                uncompletedIds.add(historyId);
            }
        }
        catch (Exception e) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[%s]%s", method, ex.toString()), (Throwable)ex);
            }
            throw e;
        }
        return uncompletedIds;
    }

    private void synchronizeUncompletedTasks(String schedulerId, Long dateToAsMinutes) throws Exception {
        String method = "synchronizeUncompletedTasks";
        this.uncompletedTaskHistoryIds = new ArrayList<Long>();
        int count = 0;
        boolean run = true;
        while (run) {
            ++count;
            try {
                this.uncompletedTaskHistoryIds = this.getTaskSyncUncomplitedHistoryIds(schedulerId);
                run = false;
            }
            catch (Exception e) {
                this.handleException(method, e, count);
            }
        }
        int size = this.uncompletedTaskHistoryIds.size();
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s][reporting]%s tasks", method, size));
        }
        if (size > 0) {
            if (size > 1000) {
                LOGGER.info(String.format("[%s]%s uncompleted tasks > as %s. do split...", method, size, 1000));
                int counterTotal = 0;
                int counterSkip = 0;
                int counterInsertedTriggers = 0;
                int counterUpdatedTriggers = 0;
                int counterInsertedExecutions = 0;
                int counterUpdatedExecutions = 0;
                int counterInsertedTasks = 0;
                int counterUpdatedTasks = 0;
                int counterTransferHistory = 0;
                ArrayList copy = (ArrayList)this.uncompletedTaskHistoryIds.stream().collect(Collectors.toList());
                for (int i = 0; i < size; i += 1000) {
                    List<Long> subList = size > i + 1000 ? copy.subList(i, i + 1000) : copy.subList(i, size);
                    Query<DBItemSchedulerHistory> query = this.getDbLayer().getSchedulerHistoryTasksQuery(this.schedulerSession, this.largeResultFetchSizeScheduler, schedulerId, subList);
                    CounterSynchronize counter = this.synchronizeTaskHistory(method, query, TaskSync.UNCOMPLETED, schedulerId, dateToAsMinutes);
                    counterTotal += counter.getTotal();
                    counterSkip += counter.getSkip();
                    counterInsertedTriggers += counter.getInsertedTriggers();
                    counterUpdatedTriggers += counter.getUpdatedTriggers();
                    counterInsertedExecutions += counter.getInsertedExecutions();
                    counterUpdatedExecutions += counter.getUpdatedExecutions();
                    counterInsertedTasks += counter.getInsertedTasks();
                    counterUpdatedTasks += counter.getUpdatedTasks();
                    counterTransferHistory += counter.getTransferHistory();
                }
                this.counterTaskSyncUncompleted.setTotal(counterTotal);
                this.counterTaskSyncUncompleted.setSkip(counterSkip);
                this.counterTaskSyncUncompleted.setInsertedTriggers(counterInsertedTriggers);
                this.counterTaskSyncUncompleted.setUpdatedTriggers(counterUpdatedTriggers);
                this.counterTaskSyncUncompleted.setInsertedExecutions(counterInsertedExecutions);
                this.counterTaskSyncUncompleted.setUpdatedExecutions(counterUpdatedExecutions);
                this.counterTaskSyncUncompleted.setInsertedTasks(counterInsertedTasks);
                this.counterTaskSyncUncompleted.setUpdatedTasks(counterUpdatedTasks);
                this.counterTaskSyncUncompleted.setTransferHistory(counterTransferHistory);
            } else {
                Query<DBItemSchedulerHistory> query = this.getDbLayer().getSchedulerHistoryTasksQuery(this.schedulerSession, this.largeResultFetchSizeScheduler, schedulerId, this.uncompletedTaskHistoryIds);
                this.counterTaskSyncUncompleted = this.synchronizeTaskHistory(method, query, TaskSync.UNCOMPLETED, schedulerId, dateToAsMinutes);
            }
        }
    }

    private void synchronizeTimePeriodOrders(String schedulerId, Date dateFrom, Date dateTo, Long dateToAsMinutes, String dateFromAsString, String dateToAsString) throws Exception {
        String method = "synchronizeTimePeriodOrders";
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s][%s to %s UTC]", method, dateFromAsString, dateToAsString));
        }
        Query<DBItemSchedulerHistoryOrderStepReporting> query = this.getDbLayer().getSchedulerHistoryOrderStepsQuery(this.schedulerSession, this.largeResultFetchSizeScheduler, schedulerId, dateFrom, dateTo);
        this.counterOrderSync = this.synchronizeOrderHistory(method, query, OrderSync.PERIOD, dateToAsMinutes);
    }

    private void synchronizeTimePeriodTasks(String schedulerId, Date dateFrom, Date dateTo, Long dateToAsMinutes, String dateFromAsString, String dateToAsString) throws Exception {
        String method = "synchronizeTimePeriodTasks";
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s][%s to %s UTC]", method, dateFromAsString, dateToAsString));
        }
        Query<DBItemSchedulerHistory> query = this.getDbLayer().getSchedulerHistoryTasksQuery(this.schedulerSession, this.largeResultFetchSizeScheduler, schedulerId, dateFrom, dateTo);
        this.counterTaskSync = this.synchronizeTaskHistory(method, query, TaskSync.PERIOD, schedulerId, dateToAsMinutes);
        this.eventTaskClosedHistoryIds = new ArrayList<Long>();
    }

    private void analyzeEvents(JsonArray events) throws Exception {
        String method = "analyzeEvents";
        this.eventTaskStartedHistoryIds = new HashMap<Long, TaskStarted>();
        this.eventTaskClosedHistoryIds = new ArrayList<Long>();
        if (events == null) {
            return;
        }
        try {
            int i = 0;
            String joType = null;
            for (i = 0; i < events.size(); ++i) {
                JsonObject jo = events.getJsonObject(i);
                joType = jo.getString(EventMeta.EventKey.TYPE.name());
                if (joType.equals(EventMeta.EventType.TaskClosed.name())) {
                    JsonValue key = (JsonValue)jo.get((Object)EventMeta.EventKey.key.name());
                    if (key == null || !key.getValueType().equals((Object)JsonValue.ValueType.OBJECT)) continue;
                    try {
                        this.eventTaskClosedHistoryIds.add(Long.parseLong(((JsonObject)key).getString("taskId")));
                    }
                    catch (Throwable e) {
                        LOGGER.error(String.format("[%s]can't get taskId from TaskClosed event: %s", method, e.toString()), e);
                    }
                    continue;
                }
                if (!joType.equals(EventMeta.EventType.TaskStarted.name())) continue;
                try {
                    TaskStarted ts = new TaskStarted(jo);
                    if (ts.getHistoryId() == null) continue;
                    this.eventTaskStartedHistoryIds.put(ts.getHistoryId(), ts);
                    continue;
                }
                catch (Throwable e) {
                    throw new Exception(String.format("TaskStarted event:%s", e.toString()), e);
                }
            }
            if (isDebugEnabled) {
                String add = "";
                if (i == 1) {
                    add = String.format(", EventType=%s", joType);
                }
                LOGGER.debug(String.format("[%s]Events=%s%s", method, i, add));
            }
        }
        catch (Throwable e) {
            LOGGER.error(String.format("[%s]exception on get taskId from TaskClosed/TaskStarted events: %s", method, e.toString()), e);
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]TaskClosed=%s, TaskStarted=%s", method, this.eventTaskClosedHistoryIds.size(), this.eventTaskStartedHistoryIds.size()));
        }
    }

    private void synchronizeTaskStartedEvents(String schedulerId, Long dateToAsMinutes) throws Exception {
        String method = "synchronizeTaskStartedEvents";
        this.counterTaskStartedEventsInserted = 0L;
        int size = this.eventTaskStartedHistoryIds.size();
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]size=%s", method, size));
        }
        if (size > 0) {
            List<Long> eventHistoryIds = this.eventTaskStartedHistoryIds.keySet().stream().collect(Collectors.toList());
            try {
                this.getDbLayer().getSession().beginTransaction();
                List<Long> dbHistoryIds = this.getDbLayer().getTasksHistoryIds(this.largeResultFetchSizeReporting, schedulerId, eventHistoryIds);
                for (int i = 0; i < eventHistoryIds.size(); ++i) {
                    Long historyId = eventHistoryIds.get(i);
                    if (dbHistoryIds.contains(historyId)) continue;
                    TaskStarted ts = this.eventTaskStartedHistoryIds.get(historyId);
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s]task.historyId=%s", method, ts.getJobPath(), ts.getHistoryId()));
                    }
                    List<Map<String, String>> infos = null;
                    try {
                        infos = this.getDbLayer().getInventoryJobInfoByJobName(schedulerId, this.options.current_scheduler_hostname.getValue(), this.options.current_scheduler_http_port.value(), ts.getJobPath());
                    }
                    catch (Exception e) {
                        throw new Exception(String.format("error on getInventoryJobInfoByJobName: %s", e.toString()), e);
                    }
                    InventoryInfo inventoryInfo = this.getInventoryInfo(method, infos);
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s][inventory_info]title=%s, isRuntimeDefined=%s, isOrderJob=%s", method, ts.getJobPath(), inventoryInfo.getTitle(), inventoryInfo.getIsRuntimeDefined(), inventoryInfo.getIsOrderJob()));
                    }
                    if (inventoryInfo.getIsOrderJob()) continue;
                    DBItemSchedulerHistory task = new DBItemSchedulerHistory();
                    task.setSpoolerId(schedulerId);
                    task.setId(ts.getHistoryId());
                    task.setClusterMemberId(null);
                    task.setSteps(new Integer(0));
                    task.setJobName(ts.getJobPath());
                    task.setStartTime(ts.getStartTime());
                    task.setEndTime(null);
                    task.setCause("unknown");
                    task.setExitCode(new Integer(0));
                    task.setError(new Boolean(false));
                    task.setErrorCode(null);
                    task.setErrorText(null);
                    task.setAgentUrl(null);
                    this.getDbLayer().insertTask(task, inventoryInfo, false, false, false);
                    ++this.counterTaskStartedEventsInserted;
                }
                this.getDbLayer().getSession().commit();
            }
            catch (Exception e) {
                try {
                    this.getDbLayer().getSession().rollback();
                }
                catch (Exception ex) {
                    LOGGER.warn(String.format("[%s]%s", method, ex.toString()), (Throwable)ex);
                }
                LOGGER.error(String.format("[%s]%s", method, e.toString()), (Throwable)e);
            }
        }
    }

    private void synchronizeTaskClosedEvents(String schedulerId, Long dateToAsMinutes) throws Exception {
        String method = "synchronizeTaskClosedEvents";
        int size = this.eventTaskClosedHistoryIds.size();
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]size=%s", method, size));
        }
        if (size > 0) {
            if (size > 1000) {
                LOGGER.info(String.format("[%s]%s TaskClosed events > as %s. do split...", method, size, 1000));
                int counterTotal = 0;
                int counterSkip = 0;
                int counterInsertedTriggers = 0;
                int counterUpdatedTriggers = 0;
                int counterInsertedExecutions = 0;
                int counterUpdatedExecutions = 0;
                int counterInsertedTasks = 0;
                int counterUpdatedTasks = 0;
                for (int i = 0; i < size; i += 1000) {
                    List<Long> subList = size > i + 1000 ? this.eventTaskClosedHistoryIds.subList(i, i + 1000) : this.eventTaskClosedHistoryIds.subList(i, size);
                    Query<DBItemSchedulerHistory> query = this.getDbLayer().getSchedulerHistoryTasksQuery(this.schedulerSession, this.largeResultFetchSizeScheduler, schedulerId, subList);
                    CounterSynchronize counter = this.synchronizeTaskHistory(method, query, TaskSync.EVENT, schedulerId, dateToAsMinutes);
                    counterTotal += counter.getTotal();
                    counterSkip += counter.getSkip();
                    counterInsertedTriggers += counter.getInsertedTriggers();
                    counterUpdatedTriggers += counter.getUpdatedTriggers();
                    counterInsertedExecutions += counter.getInsertedExecutions();
                    counterUpdatedExecutions += counter.getUpdatedExecutions();
                    counterInsertedTasks += counter.getInsertedTasks();
                    counterUpdatedTasks += counter.getUpdatedTasks();
                }
                this.counterTaskSyncEvent.setTotal(counterTotal);
                this.counterTaskSyncEvent.setSkip(counterSkip);
                this.counterTaskSyncEvent.setInsertedTriggers(counterInsertedTriggers);
                this.counterTaskSyncEvent.setUpdatedTriggers(counterUpdatedTriggers);
                this.counterTaskSyncEvent.setInsertedExecutions(counterInsertedExecutions);
                this.counterTaskSyncEvent.setUpdatedExecutions(counterUpdatedExecutions);
                this.counterTaskSyncEvent.setInsertedTasks(counterInsertedTasks);
                this.counterTaskSyncEvent.setUpdatedTasks(counterUpdatedTasks);
            } else {
                Query<DBItemSchedulerHistory> query = this.getDbLayer().getSchedulerHistoryTasksQuery(this.schedulerSession, this.largeResultFetchSizeScheduler, schedulerId, this.eventTaskClosedHistoryIds);
                this.counterTaskSyncEvent = this.synchronizeTaskHistory(method, query, TaskSync.EVENT, schedulerId, dateToAsMinutes);
            }
        }
    }

    private boolean calculateIsSyncCompleted(int maxUncompletedAge, Date startTime, Date endTime, Long dateToAsMinutes) {
        boolean completed = false;
        if (endTime == null) {
            if (startTime != null && maxUncompletedAge > 0) {
                Long startTimeMinutes = ReportUtil.getDateAsMinutes(startTime);
                Long diffMinutes = dateToAsMinutes - startTimeMinutes;
                if (diffMinutes > (long)maxUncompletedAge) {
                    completed = true;
                }
            }
        } else {
            completed = true;
        }
        return completed;
    }

    private synchronized CounterSynchronize synchronizeTaskHistory(String caller, Query<DBItemSchedulerHistory> query, TaskSync taskSync, String schedulerId, Long dateToAsMinutes) throws Exception {
        String method = "synchronizeTaskHistory";
        List<DBItemSchedulerHistory> result = this.getSchedulerHistoryTasks(query);
        CounterSynchronize counter = null;
        int count = 0;
        boolean run = true;
        while (run) {
            ++count;
            try {
                counter = this.synchronizeTaskHistory(caller, result, taskSync, schedulerId, dateToAsMinutes);
                run = false;
            }
            catch (Exception e) {
                this.handleException(method, e, count);
            }
        }
        return counter;
    }

    private void handleException(String callerMethod, Exception e, int count) throws Exception {
        if (count >= 3) {
            throw e;
        }
        Exception lae = SOSHibernate.findLockException((Exception)e);
        if (lae == null) {
            throw e;
        }
        LOGGER.warn(String.format("[%s]%s occured, wait %ss and try again (%s of %s) ...", callerMethod, lae.getClass().getName(), 2L, count, 3));
        Thread.sleep(2000L);
    }

    private List<DBItemSchedulerHistory> getSchedulerHistoryTasks(Query<DBItemSchedulerHistory> query) throws Exception {
        String method = "getSchedulerHistoryTasks";
        List result = null;
        try {
            this.schedulerSession.beginTransaction();
            result = this.schedulerSession.getResultList(query);
            this.schedulerSession.commit();
        }
        catch (Exception e) {
            try {
                this.schedulerSession.rollback();
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[%s]schedulerConnection %s", method, ex.toString()), (Throwable)ex);
            }
            throw new Exception(String.format("[%s]%s", method, e.toString()), e);
        }
        return result;
    }

    private CounterSynchronize synchronizeTaskHistory(String caller, List<DBItemSchedulerHistory> result, TaskSync taskSync, String schedulerId, Long dateToAsMinutes) throws Exception {
        String method = caller + "][synchronizeTaskHistory";
        CounterSynchronize counter = new CounterSynchronize();
        try {
            int counterTotal = 0;
            int counterSkip = 0;
            int counterInserted = 0;
            int counterUpdated = 0;
            int counterTransferHistory = 0;
            int totalSize = result.size();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][scheduler]%s tasks", method, totalSize));
            }
            if (totalSize > 0) {
                DateTime start = new DateTime();
                this.getDbLayer().getSession().beginTransaction();
                for (int i = 0; i < totalSize; ++i) {
                    DBItemSchedulerHistory task = result.get(i);
                    if (task.getJobName().equals("(Spooler)")) {
                        if (!isDebugEnabled) continue;
                        LOGGER.debug(String.format("[%s][%s][skip][scheduler][task][%s]%s", method, counterTotal, task.getId(), task.getJobName()));
                        continue;
                    }
                    ++counterTotal;
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s][scheduler][task][%s][%s]%s", method, counterTotal, task.getId(), task.getJobName(), SOSString.toString((Object)task)));
                    }
                    this.checkReduceEventTaskStartedHistoryIds(method, counterTotal, task.getId(), task.getJobName());
                    if (taskSync.equals((Object)TaskSync.PERIOD) && this.eventTaskClosedHistoryIds.contains(task.getId())) {
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][skip][scheduler][task][%s][%s]was already handled by event TaskClose", method, counterTotal, task.getId(), task.getJobName()));
                        }
                        ++counterSkip;
                        continue;
                    }
                    boolean syncCompleted = this.calculateIsSyncCompleted(this.taskHistoryMaxUncompletedAge, task.getStartTime(), task.getEndTime(), dateToAsMinutes);
                    DBItemReportTask reportTask = this.getDbLayer().getTask(schedulerId, task.getId());
                    if (reportTask == null) {
                        List<Map<String, String>> infos = null;
                        try {
                            infos = this.getDbLayer().getInventoryJobInfoByJobName(schedulerId, this.options.current_scheduler_hostname.getValue(), this.options.current_scheduler_http_port.value(), task.getJobName());
                        }
                        catch (Exception e) {
                            throw new Exception(String.format("error on getInventoryJobInfoByJobName: %s", e.toString()), e);
                        }
                        InventoryInfo inventoryInfo = this.getInventoryInfo(method, infos);
                        boolean isOrder = false;
                        if (task.getCause() == null) {
                            isOrder = inventoryInfo.getIsOrderJob();
                        } else if (task.getCause().equals(EStartCauses.ORDER.value())) {
                            isOrder = true;
                        }
                        boolean transferHistory = this.processTransferHistory(task, counterTransferHistory);
                        reportTask = this.getDbLayer().insertTask(task, inventoryInfo, isOrder, syncCompleted, transferHistory);
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][inserted][%s][%s][%s]%s", method, counterTotal, reportTask.getId(), reportTask.getHistoryId(), reportTask.getName(), SOSString.toString((Object)reportTask)));
                        }
                        ++counterInserted;
                    } else {
                        boolean updateExecutions = false;
                        if (reportTask.getError() && (reportTask.getExitCode() == null || reportTask.getExitCode().equals(new Integer(0)))) {
                            updateExecutions = true;
                        }
                        reportTask = this.processTransferHistory(reportTask, task, counterTransferHistory);
                        this.getDbLayer().updateTask(reportTask, task, syncCompleted);
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][updated][%s][%s][%s]%s", method, counterTotal, reportTask.getId(), reportTask.getHistoryId(), reportTask.getName(), SOSString.toString((Object)reportTask)));
                        }
                        if (updateExecutions) {
                            int rc = this.getDbLayer().updateComplitedExecutionsByTask(reportTask);
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("[%s][%s][updateComplitedExecutionsByTask][%s][%s][%s]updated executions=%s", method, counterTotal, reportTask.getId(), reportTask.getHistoryId(), reportTask.getName(), rc));
                            }
                        }
                        ++counterUpdated;
                    }
                    this.pluginOnProcess(reportTask);
                    if (taskSync.equals((Object)TaskSync.UNCOMPLETED) && this.uncompletedTaskHistoryIds.contains(task.getId())) {
                        this.uncompletedTaskHistoryIds.remove(task.getId());
                    }
                    if (counterTotal % this.options.log_info_step.value() != 0) continue;
                    LOGGER.info(String.format("[%s]%s of %s history steps processed ...", method, counterTotal, totalSize));
                }
                this.getDbLayer().getSession().commit();
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s]total history tasks=%s, inserted=%s, updated=%s, skip=%s, duration=%s", method, counterTotal, counterInserted, counterUpdated, counterSkip, ReportUtil.getDuration(start, new DateTime())));
                }
            }
            counter.setTotal(counterTotal);
            counter.setSkip(counterSkip);
            counter.setInsertedTriggers(0);
            counter.setUpdatedTriggers(0);
            counter.setInsertedExecutions(0);
            counter.setUpdatedExecutions(0);
            counter.setInsertedTasks(counterInserted);
            counter.setUpdatedTasks(counterUpdated);
            counter.setTransferHistory(counterTransferHistory);
        }
        catch (Exception e) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[%s]%s", method, ex.toString()), (Throwable)ex);
            }
            throw e;
        }
        return counter;
    }

    private synchronized CounterSynchronize synchronizeOrderHistory(String caller, Query<DBItemSchedulerHistoryOrderStepReporting> query, OrderSync orderSync, Long dateToAsMinutes) throws Exception {
        String method = "synchronizeOrderHistory";
        List<DBItemSchedulerHistoryOrderStepReporting> result = this.getSchedulerHistoryOrderSteps(query);
        CounterSynchronize counter = null;
        int count = 0;
        boolean run = true;
        while (run) {
            ++count;
            try {
                counter = this.synchronizeOrderHistory(caller, result, orderSync, dateToAsMinutes);
                run = false;
            }
            catch (Exception e) {
                this.handleException(method, e, count);
            }
        }
        return counter;
    }

    private List<DBItemSchedulerHistoryOrderStepReporting> getSchedulerHistoryOrderSteps(Query<DBItemSchedulerHistoryOrderStepReporting> query) throws Exception {
        String method = "getSchedulerHistoryOrderSteps";
        List result = null;
        try {
            this.schedulerSession.beginTransaction();
            result = this.schedulerSession.getResultList(query);
            this.schedulerSession.commit();
        }
        catch (Exception e) {
            try {
                this.schedulerSession.rollback();
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[%s]schedulerConnection %s", method, ex.toString()), (Throwable)ex);
            }
            throw new Exception(String.format("[%s]%s", method, e.toString()), e);
        }
        return result;
    }

    private CounterSynchronize synchronizeOrderHistory(String caller, List<DBItemSchedulerHistoryOrderStepReporting> result, OrderSync orderSync, Long dateToAsMinutes) throws Exception {
        String method = caller + "][synchronizeOrderHistory";
        CounterSynchronize counter = new CounterSynchronize();
        try {
            HashMap<Long, DBItemReportTrigger> triggerObjects = new HashMap<Long, DBItemReportTrigger>();
            int counterTotal = 0;
            int counterSkip = 0;
            int counterInsertedTriggers = 0;
            int counterUpdatedTriggers = 0;
            int counterInsertedExecutions = 0;
            int counterUpdatedExecutions = 0;
            int counterInsertedTasks = 0;
            int counterUpdatedTasks = 0;
            int counterTransferHistory = 0;
            int totalSize = result.size();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][scheduler]%s order steps", method, totalSize));
            }
            if (totalSize > 0) {
                DateTime start = new DateTime();
                this.getDbLayer().getSession().beginTransaction();
                for (int i = 0; i < totalSize; ++i) {
                    boolean syncCompleted;
                    ++counterTotal;
                    DBItemSchedulerHistoryOrderStepReporting step = result.get(i);
                    if (step.getOrderHistoryId() == null && step.getOrderId() == null && step.getOrderStartTime() == null) {
                        ++counterSkip;
                        if (!isDebugEnabled) continue;
                        LOGGER.debug(String.format("[%s][%s][scheduler][orderStep][skip][order object is null]step=%s, historyId=%s ", method, counterTotal, step.getStepState(), step.getStepHistoryId()));
                        continue;
                    }
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s][scheduler][orderStep][%s][%s][%s]%s", method, counterTotal, step.getOrderJobChain(), step.getOrderId(), step.getStepStep(), SOSString.toString((Object)step)));
                    }
                    DBItemReportTask reportTask = null;
                    if (step.getTaskId() == null && step.getTaskJobName() == null && step.getTaskCause() == null) {
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][scheduler][orderStep][%s][%s][%s]task object is null", method, counterTotal, step.getOrderJobChain(), step.getOrderId(), step.getStepStep()));
                        }
                        if ((reportTask = this.getDbLayer().getTask(step.getOrderSchedulerId(), step.getStepTaskId())) == null || reportTask.getBasename().equals("UnknownJob")) {
                            List<Map<String, String>> infos = null;
                            try {
                                infos = this.getDbLayer().getInventoryJobInfoByJobChain(this.schedulerId, this.options.current_scheduler_hostname.getValue(), this.options.current_scheduler_http_port.value(), step.getOrderJobChain(), step.getStepState());
                            }
                            catch (Exception e) {
                                throw new Exception(String.format("error on getInventoryJobInfoByJobChain: %s", e.toString()), e);
                            }
                            InventoryInfo taskInventoryInfo = this.getInventoryInfo(method, infos);
                            if (reportTask == null) {
                                try {
                                    reportTask = this.getDbLayer().insertTaskByOrderStep(step, taskInventoryInfo, false, this.processTransferHistory(step, counterTransferHistory));
                                    if (isDebugEnabled) {
                                        LOGGER.debug(String.format("[%s][%s][task][%s][%s][%s][inserted by order step]%s", method, counterTotal, reportTask.getId(), reportTask.getHistoryId(), reportTask.getName(), SOSString.toString((Object)reportTask)));
                                    }
                                }
                                catch (Exception e) {
                                    throw new SOSReportingConcurrencyException(e);
                                }
                                ++counterInsertedTasks;
                            } else {
                                if (isDebugEnabled) {
                                    LOGGER.debug(String.format("[%s][%s][task][%s][%s][%s]already exists.  try to find the correct name ...", method, counterTotal, reportTask.getId(), reportTask.getHistoryId(), reportTask.getName()));
                                }
                                if (taskInventoryInfo != null && taskInventoryInfo.getName() != null) {
                                    reportTask.setFolder(ReportUtil.getFolderFromName(taskInventoryInfo.getName()));
                                    reportTask.setName(taskInventoryInfo.getName());
                                    reportTask.setBasename(ReportUtil.getBasenameFromName(taskInventoryInfo.getName()));
                                    reportTask.setTitle(taskInventoryInfo.getTitle());
                                    reportTask.setCriticality(taskInventoryInfo.getCriticality());
                                    reportTask.setModified(ReportUtil.getCurrentDateTime());
                                    reportTask = this.processTransferHistory(reportTask, step, counterTransferHistory);
                                    this.getDbLayer().getSession().update((Object)reportTask);
                                    if (isDebugEnabled) {
                                        LOGGER.debug(String.format("[%s][%s][task][%s][%s][%s][updated from inventory]%s", method, counterTotal, reportTask.getId(), reportTask.getHistoryId(), reportTask.getName(), SOSString.toString((Object)reportTask)));
                                    }
                                }
                            }
                        } else if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][task][%s][%s][%s][already exist]%s", method, counterTotal, reportTask.getId(), reportTask.getHistoryId(), reportTask.getName(), SOSString.toString((Object)reportTask)));
                        }
                        step.setTaskId(reportTask.getHistoryId());
                        step.setTaskStartTime(reportTask.getStartTime());
                        step.setTaskJobName(reportTask.getName());
                        step.setTaskClusterMemberId(reportTask.getClusterMemberId());
                        step.setTaskAgentUrl(reportTask.getAgentUrl());
                        step.setTaskCause(reportTask.getCause());
                        this.checkReduceEventTaskStartedHistoryIds(method, counterTotal, reportTask.getHistoryId(), reportTask.getName());
                    }
                    DBItemReportTrigger rt = null;
                    if (triggerObjects.containsKey(step.getOrderHistoryId())) {
                        rt = (DBItemReportTrigger)triggerObjects.get(step.getOrderHistoryId());
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][use trigger][%s][%s]", method, counterTotal, rt.getId(), rt.getName()));
                        }
                    } else {
                        boolean syncCompleted2 = this.calculateIsSyncCompleted(this.orderHistoryMaxUncompletedAge, step.getOrderStartTime(), step.getOrderEndTime(), dateToAsMinutes);
                        rt = this.getDbLayer().getTrigger(step.getOrderSchedulerId(), step.getOrderHistoryId());
                        if (rt == null) {
                            String inventoryStartCause;
                            List<Map<String, String>> infos = null;
                            try {
                                infos = this.getDbLayer().getInventoryOrderInfoByJobChain(step.getOrderSchedulerId(), this.options.current_scheduler_hostname.getValue(), this.options.current_scheduler_http_port.value(), step.getOrderId(), step.getOrderJobChain());
                            }
                            catch (Exception e) {
                                throw new Exception(String.format("error on getInventoryOrderInfoByJobChain: %s", e.toString()), e);
                            }
                            InventoryInfo triggerInventoryInfo = this.getInventoryInfo(method, infos);
                            String startCause = step.getTaskCause();
                            if (startCause.equals(EStartCauses.ORDER.value()) && !SOSString.isEmpty((String)(inventoryStartCause = this.getDbLayer().getInventoryJobChainStartCause(step.getOrderSchedulerId(), this.options.current_scheduler_hostname.getValue(), this.options.current_scheduler_http_port.value(), ReportUtil.normalizeDbItemPath(step.getOrderJobChain()))))) {
                                startCause = inventoryStartCause;
                            }
                            try {
                                rt = this.getDbLayer().insertTrigger(step, triggerInventoryInfo, startCause, syncCompleted2);
                            }
                            catch (Exception e) {
                                throw new Exception(String.format("error on insertTrigger: %s", e.toString()), e);
                            }
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("[%s][%s][trigger][inserted]%s", method, counterTotal, SOSString.toString((Object)rt)));
                            }
                            ++counterInsertedTriggers;
                        } else if (rt.getSyncCompleted() != syncCompleted2 || step.getOrderEndTime() != null) {
                            try {
                                rt = this.getDbLayer().updateTrigger(rt, step, syncCompleted2);
                            }
                            catch (Exception e) {
                                throw new Exception(String.format("error on updateTrigger: %s", e.toString()), e);
                            }
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("[%s][%s][trigger][updated]%s", method, counterTotal, SOSString.toString((Object)rt)));
                            }
                            ++counterUpdatedTriggers;
                        }
                        triggerObjects.put(step.getOrderHistoryId(), rt);
                    }
                    boolean selectExecution = true;
                    DBItemReportExecution re = null;
                    if (step.getStepStep() != null && rt.getResultSteps() != null) {
                        if (step.getStepStep() < rt.getResultSteps()) {
                            ++counterSkip;
                            if (!isDebugEnabled) continue;
                            LOGGER.debug(String.format("[%s][%s][skip][trigger][step %s < %s]%s", method, counterTotal, step.getStepStep(), rt.getResultSteps(), SOSString.toString((Object)rt)));
                            continue;
                        }
                        if (step.getStepStep() == rt.getResultSteps() && (re = this.getDbLayer().getExecution(step.getOrderSchedulerId(), step.getStepTaskId(), rt.getId(), step.getStepStep())) != null) {
                            Integer sec;
                            selectExecution = false;
                            if (re.getSyncCompleted()) {
                                if (this.endedOrderTasks4notification.containsKey(re.getHistoryId())) {
                                    this.endedOrderTasks4notification.remove(re.getHistoryId());
                                    if (isDebugEnabled) {
                                        LOGGER.debug(String.format("[%s][%s][execution][%s][syncCompleted=true][step %s=%s][should be updated due task closed]%s", method, counterTotal, re.getId(), step.getStepStep(), rt.getResultSteps(), SOSString.toString((Object)re)));
                                    }
                                } else {
                                    ++counterSkip;
                                    if (isDebugEnabled) {
                                        LOGGER.debug(String.format("[%s][%s][skip][execution][%s][syncCompleted=true][step %s=%s]%s", method, counterTotal, re.getId(), step.getStepStep(), rt.getResultSteps(), SOSString.toString((Object)re)));
                                    }
                                    if (orderSync.equals((Object)OrderSync.UNCOMPLETED) && this.uncompletedTaskHistoryIds.contains(step.getStepTaskId())) {
                                        this.uncompletedTaskHistoryIds.remove(step.getStepTaskId());
                                        if (isDebugEnabled) {
                                            LOGGER.debug(String.format("[%s][%s][task][%s][not founded]removed from memory. notFounded size=%s", method, counterTotal, step.getStepTaskId(), this.uncompletedTaskHistoryIds.size()));
                                        }
                                    }
                                    if (rt.getEndTime() == null) continue;
                                    this.pluginSetOrderEndTime(rt);
                                    continue;
                                }
                            }
                            boolean syncCompleted3 = this.calculateIsSyncCompleted(this.taskHistoryMaxUncompletedAge, step.getStepStartTime(), step.getStepEndTime(), dateToAsMinutes);
                            boolean agentChanged = re.getAgentUrl() == null && step.getTaskAgentUrl() != null;
                            boolean cmChanged = re.getClusterMemberId() == null && step.getTaskClusterMemberId() != null;
                            Integer n = sec = step.getTaskExitCode() == null ? new Integer(0) : step.getTaskExitCode();
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("[%s][%s][check][execution][%s][step %s=%s][syncCompleted=%s][name %s=%s][error %s=%s][exitCode %s=%s][agentChanged=%s][clusterMemberChanged=%s]", method, counterTotal, re.getId(), step.getStepStep(), rt.getResultSteps(), syncCompleted3, re.getName(), re.normalizePath(step.getTaskJobName()), re.getError(), step.isStepError(), re.getExitCode(), sec, agentChanged, cmChanged));
                            }
                            if (!syncCompleted3 && re.getName().equals(re.normalizePath(step.getTaskJobName())) && re.getError() == step.isStepError() && sec.equals(re.getExitCode()) && !agentChanged && !cmChanged) {
                                ++counterSkip;
                                if (isDebugEnabled) {
                                    LOGGER.debug(String.format("[%s][%s][skip][execution][%s][not changed]%s", method, counterTotal, re.getId(), SOSString.toString((Object)re)));
                                }
                                if (!orderSync.equals((Object)OrderSync.UNCOMPLETED) || !this.uncompletedTaskHistoryIds.contains(step.getStepTaskId())) continue;
                                this.uncompletedTaskHistoryIds.remove(step.getStepTaskId());
                                if (!isDebugEnabled) continue;
                                LOGGER.debug(String.format("[%s][%s][task][%s][not founded]removed from memory. notFounded size=%s", method, counterTotal, step.getStepTaskId(), this.uncompletedTaskHistoryIds.size()));
                                continue;
                            }
                        }
                    }
                    if (selectExecution) {
                        re = this.getDbLayer().getExecution(step.getOrderSchedulerId(), step.getStepTaskId(), rt.getId(), step.getStepStep());
                    }
                    if (re == null) {
                        if (reportTask == null && (reportTask = this.getDbLayer().getTask(step.getOrderSchedulerId(), step.getStepTaskId())) == null) {
                            List<Map<String, String>> infos = null;
                            try {
                                infos = this.getDbLayer().getInventoryJobInfoByJobName(this.schedulerId, this.options.current_scheduler_hostname.getValue(), this.options.current_scheduler_http_port.value(), ReportUtil.normalizeDbItemPath(step.getTaskJobName()));
                            }
                            catch (Exception e) {
                                throw new Exception(String.format("error on getInventoryJobInfoByJobName: %s", e.toString()), e);
                            }
                            InventoryInfo inventoryInfo = this.getInventoryInfo(method, infos);
                            boolean syncCompleted4 = this.calculateIsSyncCompleted(this.taskHistoryMaxUncompletedAge, step.getTaskStartTime(), step.getTaskEndTime(), dateToAsMinutes);
                            try {
                                reportTask = this.getDbLayer().insertTaskByOrderStep(step, inventoryInfo, syncCompleted4, this.processTransferHistory(step, counterTransferHistory));
                            }
                            catch (Exception e) {
                                throw new SOSReportingConcurrencyException(e);
                            }
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("[%s][%s][reportTask][inserted]%s", method, counterTotal, SOSString.toString((Object)reportTask)));
                            }
                            ++counterInsertedTasks;
                        }
                        try {
                            syncCompleted = this.calculateIsSyncCompleted(this.taskHistoryMaxUncompletedAge, step.getStepStartTime(), step.getStepEndTime(), dateToAsMinutes);
                            re = this.getDbLayer().insertExecution(step, rt, reportTask, syncCompleted);
                        }
                        catch (Exception e) {
                            throw new Exception(String.format("error on insertExecution: %s", e.toString()), e);
                        }
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][execution][%s][inserted]%s", method, counterTotal, re.getId(), SOSString.toString((Object)re)));
                        }
                        ++counterInsertedExecutions;
                    } else {
                        try {
                            syncCompleted = this.calculateIsSyncCompleted(this.taskHistoryMaxUncompletedAge, step.getStepStartTime(), step.getStepEndTime(), dateToAsMinutes);
                            re = this.getDbLayer().updateExecution(re, step, syncCompleted);
                        }
                        catch (Exception e) {
                            throw new Exception(String.format("error on updateExecution: %s", e.toString()));
                        }
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][execution][%s][updated]%s", method, counterTotal, re.getId(), SOSString.toString((Object)re)));
                        }
                        ++counterUpdatedExecutions;
                    }
                    re.setTaskStartTime(step.getTaskStartTime());
                    re.setTaskEndTime(step.getTaskEndTime());
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s][trigger][%s]step=%s, resultSteps=%s", method, counterTotal, rt.getId(), step.getStepStep(), rt.getResultSteps()));
                    }
                    if (step.getStepStep() >= rt.getResultSteps()) {
                        try {
                            rt = this.getDbLayer().updateTriggerResults(rt, re, step);
                        }
                        catch (Exception e) {
                            throw new Exception(String.format("error on updateTriggerResults: %s", e.toString()), e);
                        }
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][trigger][%s][result updated]%s", method, counterTotal, rt.getId(), SOSString.toString((Object)rt)));
                        }
                        triggerObjects.put(step.getOrderHistoryId(), rt);
                        ++counterUpdatedTriggers;
                    }
                    if (rt.getSyncCompleted() && reportTask != null && this.uncompletedTaskHistoryIds.contains(reportTask.getHistoryId()) && reportTask.getEndTime() == null && !reportTask.getSyncCompleted()) {
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][task][%s][%s][not founded]remove from memory und set syncCompleted=1. notFounded size=%s", method, counterTotal, reportTask.getId(), reportTask.getHistoryId(), this.uncompletedTaskHistoryIds.size()));
                        }
                        if (!reportTask.getError()) {
                            reportTask.setError(re.getError());
                            reportTask.setErrorCode(re.getErrorCode());
                            reportTask.setErrorText(re.getErrorText());
                        }
                        reportTask.setSyncCompleted(true);
                        reportTask.setModified(ReportUtil.getCurrentDateTime());
                        reportTask = this.processTransferHistory(reportTask, step, counterTransferHistory);
                        this.getDbLayer().getSession().update((Object)reportTask);
                        this.uncompletedTaskHistoryIds.remove(reportTask.getHistoryId());
                        ++counterUpdatedTasks;
                    }
                    this.pluginOnProcess(rt, re, true);
                    if (counterTotal % this.options.log_info_step.value() != 0) continue;
                    LOGGER.info(String.format("[%s]%s of %s history steps processed ...", method, counterTotal, totalSize));
                    triggerObjects = null;
                    triggerObjects = new HashMap();
                    triggerObjects.put(step.getOrderHistoryId(), rt);
                }
                this.getDbLayer().getSession().commit();
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s]duration=%s", method, ReportUtil.getDuration(start, new DateTime())));
                }
            }
            counter.setTotal(counterTotal);
            counter.setSkip(counterSkip);
            counter.setInsertedTriggers(counterInsertedTriggers);
            counter.setUpdatedTriggers(counterUpdatedTriggers);
            counter.setInsertedExecutions(counterInsertedExecutions);
            counter.setUpdatedExecutions(counterUpdatedExecutions);
            counter.setInsertedTasks(counterInsertedTasks);
            counter.setUpdatedTasks(counterUpdatedTasks);
            counter.setTransferHistory(counterTransferHistory);
        }
        catch (Exception e) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[%s]rollback %s", method, ex.toString()), (Throwable)ex);
            }
            throw e;
        }
        return counter;
    }

    private synchronized void synchronizeNotFounded(Long dateToAsMinutes) throws Exception {
        String method = "synchronizeNotFounded";
        this.counterTaskSyncNotFounded = new CounterSynchronize();
        int count = 0;
        boolean run = true;
        while (run) {
            ++count;
            try {
                this.counterTaskSyncNotFounded = this.synchronizeNotFoundedTasks(dateToAsMinutes);
                run = false;
            }
            catch (Exception e) {
                this.handleException(method, e, count);
            }
        }
    }

    private void checkReduceEventTaskStartedHistoryIds(String caller, int counter, Long taskHistoryId, String jobName) {
        if (this.eventTaskStartedHistoryIds.containsKey(taskHistoryId)) {
            this.eventTaskStartedHistoryIds.remove(taskHistoryId);
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][scheduler][task][%s][%s]removed from memory. TaskStarted size=%s", caller, counter, taskHistoryId, jobName, this.eventTaskStartedHistoryIds.size()));
            }
        }
    }

    private CounterSynchronize synchronizeNotFoundedTasks(Long dateToAsMinutes) throws Exception {
        String method = "synchronizeNotFoundedTasks";
        CounterSynchronize counter = new CounterSynchronize();
        int size = this.uncompletedTaskHistoryIds.size();
        int counterUpdatedTasks = 0;
        int counterUpdatedExecutions = 0;
        int counterSkip = 0;
        int counterTotal = 0;
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]size=%s", method, size));
        }
        if (size > 0) {
            try {
                this.getDbLayer().getSession().beginTransaction();
                for (Long historyId : this.uncompletedTaskHistoryIds) {
                    ++counterTotal;
                    DBItemReportTask reportTask = this.getDbLayer().getTask(this.schedulerId, historyId);
                    if (reportTask == null) {
                        if (!isDebugEnabled) continue;
                        LOGGER.debug(String.format("[%s]not found reportTasks for schedulerId=%s, historyId=%s", method, this.schedulerId, historyId));
                        continue;
                    }
                    this.checkReduceEventTaskStartedHistoryIds(method, counterTotal, reportTask.getHistoryId(), reportTask.getName());
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s][%s]%s", method, reportTask.getId(), reportTask.getName(), SOSString.toString((Object)reportTask)));
                    }
                    if (reportTask.getIsOrder()) {
                        List<DBItemReportExecution> executions = this.getDbLayer().getExecutionsByTask(reportTask.getId());
                        if (executions == null || executions.size() == 0) {
                            if (!isDebugEnabled) continue;
                            LOGGER.debug(String.format("[%s][%s][%s]not found executions", method, reportTask.getId(), reportTask.getName()));
                            continue;
                        }
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][%s]found %s executions", method, reportTask.getId(), reportTask.getName(), executions.size()));
                        }
                        boolean doUpdate = false;
                        if (reportTask.getBasename().equals("UnknownJob")) {
                            DBItemReportExecution firstExecution = executions.get(0);
                            List<Map<String, String>> infos = null;
                            try {
                                infos = this.getDbLayer().getInventoryJobInfoByJobChain(this.schedulerId, this.options.current_scheduler_hostname.getValue(), this.options.current_scheduler_http_port.value(), firstExecution.getFolder(), firstExecution.getState());
                            }
                            catch (Exception e) {
                                throw new Exception(String.format("error on getInventoryJobInfoByJobChain: %s", e.toString()), e);
                            }
                            InventoryInfo taskInventoryInfo = this.getInventoryInfo(method, infos);
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("[%s][%s][%s]%s", method, reportTask.getId(), reportTask.getName(), SOSString.toString((Object)taskInventoryInfo)));
                            }
                            if (taskInventoryInfo != null && taskInventoryInfo.getName() != null) {
                                reportTask.setFolder(ReportUtil.getFolderFromName(taskInventoryInfo.getName()));
                                reportTask.setName(taskInventoryInfo.getName());
                                reportTask.setBasename(ReportUtil.getBasenameFromName(taskInventoryInfo.getName()));
                                reportTask.setTitle(taskInventoryInfo.getTitle());
                                reportTask.setCriticality(taskInventoryInfo.getCriticality());
                                doUpdate = true;
                            }
                        }
                        DBItemReportExecution lastExecutionWithEndTime = null;
                        Date endTime = reportTask.getEndTime();
                        boolean syncCompleted = false;
                        for (DBItemReportExecution execution : executions) {
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("[%s][%s][%s]%s", method, reportTask.getId(), reportTask.getName(), SOSString.toString((Object)execution)));
                            }
                            if (execution.getSyncCompleted()) {
                                syncCompleted = true;
                            }
                            if (execution.getEndTime() != null) {
                                if (endTime == null) {
                                    lastExecutionWithEndTime = execution;
                                } else if (execution.getEndTime().getTime() > endTime.getTime()) {
                                    lastExecutionWithEndTime = execution;
                                }
                            }
                            if (!execution.getBasename().equals("UnknownJob") || !doUpdate) continue;
                            execution.setFolder(reportTask.getFolder());
                            execution.setName(reportTask.getName());
                            execution.setBasename(reportTask.getBasename());
                            execution.setTitle(reportTask.getTitle());
                            execution.setModified(ReportUtil.getCurrentDateTime());
                            this.getDbLayer().getSession().update((Object)execution);
                            ++counterUpdatedExecutions;
                            execution.setTaskStartTime(reportTask.getStartTime());
                            execution.setTaskEndTime(reportTask.getEndTime());
                            this.pluginOnProcess(null, execution, true);
                        }
                        if (syncCompleted && this.calculateIsSyncCompleted(this.taskHistoryMaxUncompletedAge, reportTask.getStartTime(), null, dateToAsMinutes)) {
                            reportTask.setSyncCompleted(true);
                            doUpdate = true;
                        }
                        if (lastExecutionWithEndTime != null) {
                            DBItemReportTrigger trigger = this.getDbLayer().getTrigger(lastExecutionWithEndTime.getTriggerId());
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("[%s][%s][%s][last execution with endTime]%s", method, reportTask.getId(), reportTask.getName(), SOSString.toString((Object)lastExecutionWithEndTime)));
                                LOGGER.debug(String.format("[%s][%s][%s][last execution with endTime trigger]%s", method, reportTask.getId(), reportTask.getName(), SOSString.toString((Object)trigger)));
                            }
                            if (trigger != null && trigger.getSyncCompleted()) {
                                reportTask.setEndTime(lastExecutionWithEndTime.getEndTime());
                                reportTask.setSyncCompleted(true);
                                LOGGER.debug(String.format("[%s][%s][%s]set syncCompleted=1 due task not founded in the scheduler db and order is completed", method, reportTask.getId(), reportTask.getName()));
                            } else if (this.calculateIsSyncCompleted(this.taskHistoryMaxUncompletedAge, lastExecutionWithEndTime.getStartTime(), null, dateToAsMinutes)) {
                                reportTask.setEndTime(lastExecutionWithEndTime.getEndTime());
                                reportTask.setSyncCompleted(true);
                                LOGGER.debug(String.format("[%s][%s][%s]set syncCompleted=1 due task not founded in the scheduler db and calculateIsSyncCompleted=true", method, reportTask.getId(), reportTask.getName()));
                            }
                            if (!reportTask.getError()) {
                                reportTask.setError(lastExecutionWithEndTime.getError());
                                reportTask.setErrorCode(lastExecutionWithEndTime.getErrorCode());
                                reportTask.setErrorText(lastExecutionWithEndTime.getErrorText());
                            }
                            lastExecutionWithEndTime.setTaskStartTime(reportTask.getStartTime());
                            lastExecutionWithEndTime.setTaskEndTime(reportTask.getEndTime());
                            doUpdate = true;
                        }
                        if (doUpdate) {
                            reportTask.setModified(ReportUtil.getCurrentDateTime());
                            this.getDbLayer().getSession().update((Object)reportTask);
                            ++counterUpdatedTasks;
                            continue;
                        }
                        ++counterSkip;
                        continue;
                    }
                    reportTask.setSyncCompleted(true);
                    reportTask.setModified(ReportUtil.getCurrentDateTime());
                    this.getDbLayer().getSession().update((Object)reportTask);
                    ++counterUpdatedTasks;
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][isOrder=0][set syncCompleted=1]%s", method, SOSString.toString((Object)reportTask)));
                }
                this.getDbLayer().getSession().commit();
            }
            catch (Exception e) {
                try {
                    this.getDbLayer().getSession().rollback();
                }
                catch (Exception ex) {
                    LOGGER.warn(String.format("[%s]rollback %s", method, ex.toString()), (Throwable)ex);
                }
                throw e;
            }
        }
        counter.setTotal(size);
        counter.setSkip(counterSkip);
        counter.setUpdatedTasks(counterUpdatedTasks);
        counter.setUpdatedExecutions(counterUpdatedExecutions);
        return counter;
    }

    private synchronized void updateNotificationRest() throws Exception {
        String method = "updateNotificationRest";
        if (this.notificationPlugin == null) {
            return;
        }
        if (this.notificationPlugin.skipExecuteChecks()) {
            this.notificationPlugin = null;
            return;
        }
        if (this.endedOrderTasks4notification.size() == 0) {
            LOGGER.debug(String.format("[%s][skip]size=0", method));
            return;
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]size=%s", method, this.endedOrderTasks4notification.size()));
        }
        int count = 0;
        boolean run = true;
        while (run) {
            ++count;
            try {
                this.updateNotificationTaskData();
                run = false;
            }
            catch (Exception e) {
                this.handleException(method, e, count);
            }
        }
    }

    private void updateNotificationTaskData() throws Exception {
        String method = "updateNotificationTaskData";
        try {
            this.getDbLayer().getSession().beginTransaction();
            for (DBItemReportTask task : this.endedOrderTasks4notification.values()) {
                List<DBItemReportExecution> executions = this.getDbLayer().getExecutionsByTask(task.getId());
                if (executions == null || executions.size() == 0) {
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][skip]not found executions for taskId=%s", method, task.getId()));
                    continue;
                }
                for (DBItemReportExecution execution : executions) {
                    if (execution.getAgentUrl() == null) {
                        execution.setAgentUrl(task.getAgentUrl());
                    }
                    if (execution.getClusterMemberId() == null) {
                        execution.setClusterMemberId(task.getClusterMemberId());
                    }
                    if (!execution.getError() && task.getError()) {
                        execution.setError(task.getError());
                        execution.setErrorCode(task.getErrorCode());
                        execution.setErrorText(task.getErrorText());
                    }
                    if (execution.getError() && execution.getEndTime() == null) {
                        execution.setEndTime(task.getEndTime());
                    }
                    execution.setExitCode(task.getExitCode());
                    execution.setTaskStartTime(task.getStartTime());
                    execution.setTaskEndTime(task.getEndTime());
                    this.getDbLayer().getSession().update((Object)execution);
                    this.pluginOnProcess(null, execution, false);
                }
            }
            this.getDbLayer().getSession().commit();
        }
        catch (Exception e) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[%s]rollback %s", method, ex.toString()), (Throwable)ex);
            }
            throw e;
        }
    }

    private InventoryInfo getInventoryInfo(String caller, List<Map<String, String>> infos) {
        String method = "getInventoryInfo";
        InventoryInfo item = new InventoryInfo();
        item.setSchedulerId(this.schedulerId);
        item.setHostname(this.options.current_scheduler_hostname.getValue());
        item.setPort(this.options.current_scheduler_http_port.value());
        item.setName(null);
        item.setTitle(null);
        item.setIsRuntimeDefined(false);
        item.setIsOrderJob(false);
        item.setClusterType(null);
        item.setUrl(null);
        item.setCriticality(null);
        item.setOrdering(new Integer(0));
        if (infos != null && infos.size() > 0) {
            try {
                for (int i = 0; i < infos.size(); ++i) {
                    Map<String, String> row = infos.get(i);
                    if (isTraceEnabled) {
                        LOGGER.trace(String.format("[%s][%s][%s]%s", caller, method, i + 1, row));
                    }
                    item.setName(SOSString.isEmpty((String)row.get("name")) ? null : row.get("name"));
                    item.setTitle(SOSString.isEmpty((String)row.get("title")) ? null : row.get("title"));
                    item.setIsRuntimeDefined(row.get("is_runtime_defined").equals("1"));
                    item.setCriticality(row.get("criticality"));
                    if (row.size() <= 4) continue;
                    if (row.containsKey("is_order_job")) {
                        item.setIsOrderJob(row.get("is_order_job").equals("1"));
                    }
                    if (row.size() <= 5) continue;
                    if (row.containsKey("cluster_type")) {
                        item.setClusterType(SOSString.isEmpty((String)row.get("cluster_type")) ? null : row.get("cluster_type"));
                    }
                    if (row.containsKey("url")) {
                        item.setUrl(SOSString.isEmpty((String)row.get("url")) ? null : row.get("url"));
                    }
                    if (row.containsKey("ordering")) {
                        item.setOrdering(SOSString.isEmpty((String)row.get("ordering")) ? null : Integer.valueOf(Integer.parseInt(row.get("ordering"))));
                    }
                    if (item.getOrdering() == null || !item.getOrdering().equals(new Integer(1))) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("can't create InventoryInfo object: %s", ex.toString()));
            }
        }
        return item;
    }

    private void initCounters() throws Exception {
        this.counterOrderSync = new CounterSynchronize();
        this.counterOrderSyncUncompleted = new CounterSynchronize();
        this.counterTaskSync = new CounterSynchronize();
        this.counterTaskSyncUncompleted = new CounterSynchronize();
        this.counterTaskSyncEvent = new CounterSynchronize();
        this.counterTaskSyncNotFounded = new CounterSynchronize();
        this.counterTaskStartedEventsInserted = 0L;
        this.endedOrderTasks4notification = new HashMap();
        this.eventTaskClosedHistoryIds = new ArrayList<Long>();
    }

    private void setChangedSummary() throws Exception {
        this.isChanged = false;
        this.isOrdersChanged = false;
        this.isTasksChanged = false;
        if (this.counterOrderSync.getInsertedTriggers() > 0 || this.counterOrderSync.getUpdatedTriggers() > 0 || this.counterOrderSync.getInsertedExecutions() > 0 || this.counterOrderSync.getUpdatedExecutions() > 0 || this.counterOrderSyncUncompleted.getInsertedTriggers() > 0 || this.counterOrderSyncUncompleted.getUpdatedTriggers() > 0 || this.counterOrderSyncUncompleted.getInsertedExecutions() > 0 || this.counterOrderSyncUncompleted.getUpdatedExecutions() > 0 || this.counterTaskSyncNotFounded.getUpdatedExecutions() > 0) {
            this.isOrdersChanged = true;
            this.isChanged = true;
        }
        if (this.counterOrderSync.getInsertedTasks() > 0 || this.counterOrderSyncUncompleted.getInsertedTasks() > 0 || this.counterTaskSync.getInsertedTasks() > 0 || this.counterTaskSync.getUpdatedTasks() > 0 || this.counterTaskSyncUncompleted.getInsertedTasks() > 0 || this.counterTaskSyncUncompleted.getUpdatedTasks() > 0 || this.counterTaskSyncNotFounded.getUpdatedTasks() > 0 || this.counterTaskSyncEvent.getInsertedTasks() > 0 || this.counterTaskSyncEvent.getUpdatedTasks() > 0 || this.counterTaskStartedEventsInserted > 0L) {
            this.isTasksChanged = true;
            this.isChanged = true;
        }
    }

    private void logSummary(String from, String to, DateTime start) throws Exception {
        String method = "logSummary";
        if (this.isChanged) {
            String range = "task";
            if (this.isTasksChanged) {
                LOGGER.info(String.format("[%s to %s UTC][%s][new]tasks=%s,tasks(inserted=%s,updated=%s,transfer_history=%s),skip=%s[old]total=%s,tasks(inserted=%s,updated=%s,transfer_history=%s),skip=%s[event TaskClose]total=%s,tasks(inserted=%s,updated=%s),skip=%s[event TaskStarted]inserted=%s[not founded]total=%s,tasks(updated=%s),skip=%s", from, to, range, this.counterTaskSync.getTotal(), this.counterTaskSync.getInsertedTasks(), this.counterTaskSync.getUpdatedTasks(), this.counterTaskSync.getTransferHistory(), this.counterTaskSync.getSkip(), this.counterTaskSyncUncompleted.getTotal(), this.counterTaskSyncUncompleted.getInsertedTasks(), this.counterTaskSyncUncompleted.getUpdatedTasks(), this.counterTaskSyncUncompleted.getTransferHistory(), this.counterTaskSyncUncompleted.getSkip(), this.counterTaskSyncEvent.getTotal(), this.counterTaskSyncEvent.getInsertedTasks(), this.counterTaskSyncEvent.getUpdatedTasks(), this.counterTaskSyncEvent.getSkip(), this.counterTaskStartedEventsInserted, this.counterTaskSyncNotFounded.getTotal(), this.counterTaskSyncNotFounded.getUpdatedTasks(), this.counterTaskSyncNotFounded.getSkip()));
            } else {
                LOGGER.info(String.format("[%s to %s UTC][%s] 0 changes", from, to, range));
            }
            range = "order";
            if (this.isOrdersChanged) {
                LOGGER.info(String.format("[%s to %s UTC][%s][new]steps=%s,triggers(inserted=%s,updated=%s),executions(inserted=%s,updated=%s),tasks(inserted=%s,transfer_history=%s),skip=%s[old]total=%s,triggers(inserted=%s,updated=%s),executions(inserted=%s,updated=%s),tasks(inserted=%s,transfer_history=%s),skip=%s", from, to, range, this.counterOrderSync.getTotal(), this.counterOrderSync.getInsertedTriggers(), this.counterOrderSync.getUpdatedTriggers(), this.counterOrderSync.getInsertedExecutions(), this.counterOrderSync.getUpdatedExecutions(), this.counterOrderSync.getInsertedTasks(), this.counterOrderSync.getTransferHistory(), this.counterOrderSync.getSkip(), this.counterOrderSyncUncompleted.getTotal(), this.counterOrderSyncUncompleted.getInsertedTriggers(), this.counterOrderSyncUncompleted.getUpdatedTriggers(), this.counterOrderSyncUncompleted.getInsertedExecutions(), this.counterOrderSyncUncompleted.getUpdatedExecutions(), this.counterOrderSyncUncompleted.getInsertedTasks(), this.counterOrderSyncUncompleted.getTransferHistory(), this.counterOrderSyncUncompleted.getSkip()));
            } else {
                LOGGER.info(String.format("[%s to %s UTC][%s] 0 changes", from, to, range));
            }
        } else {
            LOGGER.info(String.format("[%s to %s UTC] 0 changes", from, to));
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]duration=%s", method, ReportUtil.getDuration(start, new DateTime())));
        }
    }

    private Date getDateFrom(DBItemReportVariable reportingVariable, Date dateTo, String dateToAsString) throws Exception {
        String method = "getDateFrom";
        Long currentMaxAge = new Long(this.maxHistoryAge);
        Date storedDateFrom = ReportUtil.getDateFromString(this.getWithoutLocked(reportingVariable.getTextValue()));
        Date dateFrom = null;
        if (this.options.force_max_history_age.value()) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][set dateFrom=null]force_max_history_age=true", method));
            }
            dateFrom = null;
        } else {
            Long dateFromAsMinutes = ReportUtil.getDateAsMinutes(storedDateFrom);
            Long dateToAsMinutes = ReportUtil.getDateAsMinutes(dateTo);
            Long diffMinutes = dateToAsMinutes - dateFromAsMinutes;
            if (diffMinutes > currentMaxAge) {
                Long countHistoryTasks = this.getDbLayer().getCountSchedulerHistoryTasks(this.schedulerSession, this.schedulerId, storedDateFrom);
                if (countHistoryTasks > this.maxHistoryTasks) {
                    dateFrom = null;
                    LOGGER.info(String.format("[%s][set dateFrom=null]diffMinutes=%s > currentMaxAge=%sm and countHistoryTasks=%s > maxHistoryTasks=%s", method, diffMinutes, currentMaxAge, countHistoryTasks, this.maxHistoryTasks));
                } else {
                    dateFrom = storedDateFrom;
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][use storedDateFrom]diffMinutes=%s > currentMaxAge=%sm and countHistoryTasks=%s <= maxHistoryTasks=%s", method, diffMinutes, currentMaxAge, countHistoryTasks, this.maxHistoryTasks));
                    }
                }
            } else {
                dateFrom = storedDateFrom;
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][use storedDateFrom]diffMinutes=%s(dateTo=%s-dateFrom=%s) <= currentMaxAge=%sm", method, diffMinutes, dateToAsString, ReportUtil.getDateAsString(dateFrom), currentMaxAge));
                }
            }
        }
        if (dateFrom == null) {
            dateFrom = ReportUtil.getDateTimeMinusMinutes(dateTo, currentMaxAge);
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][set dateFrom from null]dateFrom=%s (%s-%s)", method, ReportUtil.getDateAsString(dateFrom), dateToAsString, currentMaxAge));
            }
        }
        return dateFrom;
    }

    private boolean processTransferHistory(DBItemSchedulerHistory task, int counter) throws SOSHibernateException {
        boolean result = this.transferHistory.process(this.getDbLayer().getSession(), task);
        if (result) {
            ++counter;
        }
        return result;
    }

    private DBItemReportTask processTransferHistory(DBItemReportTask reportTask, DBItemSchedulerHistory task, int counter) throws SOSHibernateException {
        if (reportTask.getTransferHistory()) {
            return reportTask;
        }
        if (this.processTransferHistory(task, counter)) {
            reportTask.setTransferHistory(true);
        }
        return reportTask;
    }

    private boolean processTransferHistory(DBItemSchedulerHistoryOrderStepReporting step, int counter) throws SOSHibernateException {
        if (SOSString.isEmpty((String)step.getTaskTransferHistory())) {
            return false;
        }
        DBItemSchedulerHistory tmp = new DBItemSchedulerHistory();
        tmp.setSpoolerId(step.getOrderSchedulerId());
        tmp.setJobName(step.getTaskJobName());
        tmp.setId(step.getTaskId());
        tmp.setTransferHistory(step.getTaskTransferHistory());
        boolean result = this.transferHistory.process(this.getDbLayer().getSession(), tmp);
        if (result) {
            ++counter;
        }
        return result;
    }

    private DBItemReportTask processTransferHistory(DBItemReportTask reportTask, DBItemSchedulerHistoryOrderStepReporting step, int counter) throws SOSHibernateException {
        if (reportTask.getTransferHistory()) {
            return reportTask;
        }
        if (this.processTransferHistory(step, counter)) {
            reportTask.setTransferHistory(true);
        }
        return reportTask;
    }

    private void registerPlugin() {
        if (this.options.execute_notification_plugin.value()) {
            this.notificationPlugin = new FactNotificationPlugin();
        }
    }

    private void pluginOnInit(Notifier notifier, Path configDirectory) {
        if (this.notificationPlugin != null) {
            this.notificationPlugin.init(this.getDbLayer().getSession(), notifier, configDirectory);
        }
    }

    private void pluginSetOrderEndTime(DBItemReportTrigger trigger) {
        String method = "pluginSetOrderEndTime";
        if (this.notificationPlugin == null || trigger == null) {
            return;
        }
        if (this.notificationPlugin.skipExecuteChecks()) {
            this.notificationPlugin = null;
            return;
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]%s", method, SOSString.toString((Object)trigger)));
        }
        this.notificationPlugin.setOrderEndTime(trigger.getSchedulerId(), trigger.getHistoryId(), trigger.getEndTime());
    }

    private void pluginOnProcess(DBItemReportTrigger trigger, DBItemReportExecution execution, boolean reduceList4Notifications) {
        String method = "pluginOnProcess";
        if (this.notificationPlugin == null || execution == null) {
            return;
        }
        if (this.notificationPlugin.skipExecuteChecks()) {
            this.notificationPlugin = null;
            return;
        }
        if (trigger == null) {
            try {
                trigger = this.getDbLayer().getTrigger(execution.getTriggerId());
            }
            catch (SOSHibernateException e) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][cannot get trigger for the given triggerId]%s[exception]%s", method, SOSString.toString((Object)execution), e.toString()));
                }
                return;
            }
            if (trigger == null) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][not found trigger with the given triggerId]%s", method, SOSString.toString((Object)execution)));
                }
                return;
            }
        }
        if (reduceList4Notifications && this.endedOrderTasks4notification.containsKey(execution.getHistoryId())) {
            this.endedOrderTasks4notification.remove(execution.getHistoryId());
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[pluginOnProcess][endedOrderTasks4notification][removed][task history id=%s]%s", execution.getHistoryId(), SOSString.toString((Object)execution)));
            }
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]%s", method, SOSString.toString((Object)trigger)));
            LOGGER.debug(String.format("[%s]%s", method, SOSString.toString((Object)execution)));
        }
        this.notificationPlugin.process(this.notificationPlugin.convert2OrderExecution(trigger, execution), true, true);
    }

    private void pluginOnProcess(DBItemReportTask task) {
        if (this.notificationPlugin == null || task == null) {
            return;
        }
        if (this.notificationPlugin.skipExecuteChecks()) {
            this.notificationPlugin = null;
            return;
        }
        if (task.getIsOrder()) {
            if (task.getEndTime() != null && !this.endedOrderTasks4notification.containsKey(task.getHistoryId())) {
                this.endedOrderTasks4notification.put(task.getHistoryId(), task);
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[pluginOnProcess][endedOrderTasks4notification][added][task history id=%s]%s", task.getHistoryId(), SOSString.toString((Object)task)));
                }
            }
            return;
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[pluginOnProcess]%s", SOSString.toString((Object)task)));
        }
        this.notificationPlugin.process(this.notificationPlugin.convert2StandaloneExecution(task), false, true);
    }

    private void pluginOnExit() {
        if (this.notificationPlugin != null) {
            this.notificationPlugin = null;
        }
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isTasksChanged() {
        return this.isTasksChanged;
    }

    public boolean isOrdersChanged() {
        return this.isOrdersChanged;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public TransferHistoryHandler getTransferHistory() {
        return this.transferHistory;
    }

    public static enum OrderSync {
        UNCOMPLETED,
        PERIOD;

    }

    public static enum TaskSync {
        EVENT,
        UNCOMPLETED,
        PERIOD;

    }
}

