/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.plugin;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.eventhandler.plugin.notifier.Notifier;
import com.sos.jitl.notification.db.DBLayerSchedulerMon;
import com.sos.jitl.notification.helper.NotificationReportExecution;
import com.sos.jitl.notification.jobs.history.CheckHistoryJobOptions;
import com.sos.jitl.notification.model.history.CheckHistoryModel;
import com.sos.jitl.reporting.db.DBItemReportExecution;
import com.sos.jitl.reporting.db.DBItemReportTask;
import com.sos.jitl.reporting.db.DBItemReportTrigger;
import com.sos.jitl.reporting.helper.ReportUtil;
import java.nio.file.Path;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class FactNotificationPlugin {
    private static Logger LOGGER = LoggerFactory.getLogger(FactNotificationPlugin.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private CheckHistoryModel model;
    private Notifier notifier = null;
    private SOSHibernateSession session = null;
    private CheckHistoryJobOptions options = null;
    private boolean skipExecuteChecks = false;

    public void init(SOSHibernateSession sess, Notifier pluginNotifier, Path configDir) {
        CheckHistoryJobOptions opt = new CheckHistoryJobOptions();
        opt.configuration_dir.setValue(configDir.toString());
        this.notifier = pluginNotifier;
        this.session = sess;
        this.options = opt;
    }

    public void process(NotificationReportExecution item, boolean checkJobChains, boolean checkJobs) {
        block10: {
            String method = "process";
            if (this.skipExecuteChecks) {
                return;
            }
            if (item.getJobName() != null && item.getJobName().equals("scheduler_file_order_sink")) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[skip][%s]%s", "scheduler_file_order_sink", SOSString.toString((Object)item)));
                }
                return;
            }
            if (this.model == null) {
                try {
                    this.skipExecuteChecks = false;
                    this.model = new CheckHistoryModel(this.session, this.options);
                    this.model.init();
                }
                catch (Exception e) {
                    this.skipExecuteChecks = true;
                    Exception ex = new Exception(String.format("skip notification processing due errors: %s", e.toString()), e);
                    LOGGER.error(String.format("%s.%s %s", FactNotificationPlugin.class.getSimpleName(), method, ex.toString()), (Throwable)e);
                    if (this.notifier != null) {
                        this.notifier.smartNotifyOnError(this.getClass(), ex);
                    }
                    return;
                }
            }
            if (!this.model.executeChecks()) {
                this.skipExecuteChecks = true;
                return;
            }
            try {
                this.model.process(item, checkJobChains, checkJobs);
            }
            catch (Exception e) {
                LOGGER.error(String.format("[%s]%s", method, e.toString()), (Throwable)e);
                if (this.notifier == null) break block10;
                this.notifier.smartNotifyOnError(this.getClass(), e);
            }
        }
    }

    public int setOrderEndTime(String schedulerId, Long orderHistoryId, Date orderEndTime) {
        int result;
        block4: {
            String method = "setOrderEndTime";
            result = -1;
            if (this.skipExecuteChecks || orderEndTime == null) {
                return result;
            }
            DBLayerSchedulerMon dbLayer = this.model == null ? new DBLayerSchedulerMon(this.session) : this.model.getDbLayer();
            try {
                result = dbLayer.setNotificationsOrderEndTime(schedulerId, orderHistoryId, orderEndTime);
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s][%s][%s]updated=%s", method, schedulerId, orderHistoryId, ReportUtil.getDateAsString(orderEndTime), result));
                }
            }
            catch (Exception ex) {
                LOGGER.error(String.format("[%s]%s", method, ex.toString()), (Throwable)ex);
                if (this.notifier == null) break block4;
                this.notifier.smartNotifyOnError(this.getClass(), ex);
            }
        }
        return result;
    }

    public NotificationReportExecution convert2OrderExecution(DBItemReportTrigger rt, DBItemReportExecution re) {
        NotificationReportExecution item = new NotificationReportExecution();
        item.setSchedulerId(re.getSchedulerId());
        item.setStandalone(false);
        item.setTaskId(re.getHistoryId());
        item.setStep(re.getStep());
        item.setOrderHistoryId(rt.getHistoryId());
        item.setJobChainName(CheckHistoryModel.normalizePath(rt.getParentName()));
        item.setJobChainTitle(rt.getParentTitle());
        item.setOrderId(rt.getName());
        item.setOrderTitle(rt.getTitle());
        item.setOrderStartTime(rt.getStartTime());
        item.setOrderEndTime(rt.getEndTime());
        item.setOrderStepState(re.getState());
        item.setOrderStepStartTime(re.getStartTime());
        item.setOrderStepEndTime(re.getEndTime());
        item.setJobName(CheckHistoryModel.normalizePath(re.getName()));
        item.setJobTitle(re.getTitle());
        item.setTaskStartTime(re.getTaskStartTime());
        item.setTaskEndTime(re.getTaskEndTime());
        item.setReturnCode(re.getExitCode() == null ? null : new Long(re.getExitCode().intValue()));
        item.setAgentUrl(re.getAgentUrl());
        item.setClusterMemberId(re.getClusterMemberId());
        item.setCriticality(re.getCriticality());
        item.setError(re.getError());
        item.setErrorCode(re.getErrorCode());
        item.setErrorText(re.getErrorText());
        return item;
    }

    public NotificationReportExecution convert2StandaloneExecution(DBItemReportTask task) {
        NotificationReportExecution item = new NotificationReportExecution();
        item.setSchedulerId(task.getSchedulerId());
        item.setStandalone(true);
        item.setTaskId(task.getHistoryId());
        item.setStep(new Long(1L));
        item.setOrderHistoryId(new Long(0L));
        item.setJobChainName("*");
        item.setJobChainTitle(null);
        item.setOrderId("*");
        item.setOrderTitle(null);
        item.setOrderStartTime(null);
        item.setOrderEndTime(null);
        item.setOrderStepState("*");
        item.setOrderStepStartTime(null);
        item.setOrderStepEndTime(null);
        item.setJobName(CheckHistoryModel.normalizePath(task.getName()));
        item.setJobTitle(task.getTitle());
        item.setTaskStartTime(task.getStartTime());
        item.setTaskEndTime(task.getEndTime());
        item.setReturnCode(task.getExitCode() == null ? null : new Long(task.getExitCode().intValue()));
        item.setAgentUrl(task.getAgentUrl());
        item.setClusterMemberId(task.getClusterMemberId());
        item.setCriticality(task.getCriticality());
        item.setError(task.getError());
        item.setErrorCode(task.getErrorCode());
        item.setErrorText(task.getErrorText());
        return item;
    }

    public boolean skipExecuteChecks() {
        return this.skipExecuteChecks;
    }
}

