/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.restclient;

import com.sos.exception.SOSException;
import com.sos.exception.SOSMissingDataException;
import com.sos.exception.SOSSSLException;
import com.sos.jitl.restclient.JobSchedulerRestApiClient;
import com.sos.jitl.restclient.WebserviceCredentials;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiAccessToken {
    private static final String NOT_VALID = "not-valid";
    private JobSchedulerRestApiClient jobSchedulerRestApiClient;
    private String jocUrl;
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiAccessToken.class);

    public ApiAccessToken(String jocUrl) {
        this.jocUrl = jocUrl;
    }

    private void addSSLContext(WebserviceCredentials webserviceCredentials) throws SOSSSLException, SOSMissingDataException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        LOGGER.debug("add SSLContext to REST api client");
        this.jobSchedulerRestApiClient.setKeyPass(webserviceCredentials.getKeyPassword());
        this.jobSchedulerRestApiClient.setKeystoreType(webserviceCredentials.getKeyStoreType());
        this.jobSchedulerRestApiClient.setKeystorePass(webserviceCredentials.getKeyStorePassword());
        this.jobSchedulerRestApiClient.setTruststorePass(webserviceCredentials.getTrustStorePassword());
        this.jobSchedulerRestApiClient.setTruststoreType(webserviceCredentials.getTrustStoreType());
        this.jobSchedulerRestApiClient.setTrustStore(webserviceCredentials.getTrustStorePath());
        this.jobSchedulerRestApiClient.setKeyStore(webserviceCredentials.getKeyStorePath());
        this.jobSchedulerRestApiClient.setSSLContext();
    }

    private void createRestApiClient(WebserviceCredentials webserviceCredentials) {
        if (this.jobSchedulerRestApiClient == null) {
            this.jobSchedulerRestApiClient = new JobSchedulerRestApiClient();
            this.jobSchedulerRestApiClient.addHeader("Content-Type", "application/json");
            this.jobSchedulerRestApiClient.addHeader("Accept", "application/json");
            try {
                this.addSSLContext(webserviceCredentials);
            }
            catch (SOSMissingDataException | SOSSSLException | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                e.printStackTrace();
            }
        }
    }

    private JsonObject jsonFromString(String jsonObjectStr) {
        if ("".equals(jsonObjectStr) || jsonObjectStr == null) {
            jsonObjectStr = "{}";
        }
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonObjectStr));
        JsonObject object = jsonReader.readObject();
        jsonReader.close();
        return object;
    }

    private boolean isValid(JsonObject jsonAnswer) {
        return jsonAnswer.get((Object)"accessToken") != null && !jsonAnswer.getString("accessToken").isEmpty() && !NOT_VALID.equals(jsonAnswer.getString("accessToken"));
    }

    public boolean isValidUserAccount(String userAccount, WebserviceCredentials webserviceCredentials) throws SOSException, URISyntaxException {
        this.createRestApiClient(webserviceCredentials);
        String user = this.jobSchedulerRestApiClient.addAuthorizationHeader(userAccount);
        String s = this.jocUrl + "/security/userbyname";
        LOGGER.debug("uri:" + s);
        LOGGER.debug("user:" + user);
        String answer = this.jobSchedulerRestApiClient.postRestService(new URI(s), user);
        LOGGER.debug("answer:" + answer);
        JsonObject userByNameAnswer = this.jsonFromString(answer);
        return this.isValid(userByNameAnswer);
    }

    public boolean isValidAccessToken(String xAccessToken, WebserviceCredentials webserviceCredentials) throws SOSException, URISyntaxException {
        boolean valid = false;
        if (xAccessToken == null || xAccessToken.isEmpty() || this.jocUrl == null || this.jocUrl.isEmpty()) {
            LOGGER.debug("Empty Access-Token or empty jocUrl");
            return false;
        }
        this.createRestApiClient(webserviceCredentials);
        this.jobSchedulerRestApiClient.addHeader("X-Access-Token", xAccessToken);
        String s = this.jocUrl + "/security/userbytoken";
        LOGGER.debug("uri:" + s);
        String answer = this.jobSchedulerRestApiClient.postRestService(new URI(s), "");
        LOGGER.debug("answer:" + answer);
        JsonObject userByTokenAnswer = this.jsonFromString(answer);
        valid = this.isValid(userByTokenAnswer);
        if (valid) {
            s = this.jocUrl + "/jobscheduler/ids";
            LOGGER.debug("uri:" + s);
            answer = this.jobSchedulerRestApiClient.postRestService(new URI(s), "");
            LOGGER.debug("answer:" + answer);
            JsonObject schedulerIds = this.jsonFromString(answer);
            valid = schedulerIds.get((Object)"error") == null;
        }
        return valid;
    }

    public String login(WebserviceCredentials webserviceCredentials) throws SOSException, URISyntaxException {
        this.createRestApiClient(webserviceCredentials);
        this.jobSchedulerRestApiClient.addAuthorizationHeader(webserviceCredentials.getUserDecodedAccount());
        String s = this.jocUrl + "/security/login";
        LOGGER.debug("uri:" + s);
        String answer = this.jobSchedulerRestApiClient.postRestService(new URI(s), "");
        LOGGER.debug("answer:" + answer);
        JsonObject login = this.jsonFromString(answer);
        if (login.get((Object)"accessToken") != null) {
            return login.getString("accessToken");
        }
        LOGGER.error(login.toString());
        return "";
    }

    public void setJocUrl(String jocUrl) {
        this.jocUrl = jocUrl;
    }
}

