/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.restclient;

import com.sos.exception.SOSException;
import com.sos.exception.SOSMissingDataException;
import com.sos.exception.SOSSSLException;
import com.sos.jitl.restclient.JobSchedulerRestApiClient;
import com.sos.jitl.restclient.WebserviceCredentials;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebserviceExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebserviceExecuter.class);
    protected String accessToken = "";
    protected JobSchedulerRestApiClient jobSchedulerRestApiClient = new JobSchedulerRestApiClient();
    protected String schedulerId;
    protected WebserviceCredentials webserviceCredentials;

    public WebserviceExecuter(WebserviceCredentials webserviceCredentials) {
        this.webserviceCredentials = webserviceCredentials;
        try {
            this.addSSLContext();
        }
        catch (SOSMissingDataException | SOSSSLException | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            e.printStackTrace();
        }
    }

    private void addSSLContext() throws SOSSSLException, SOSMissingDataException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (this.webserviceCredentials != null) {
            LOGGER.debug("add SSLContext to REST api client");
            this.jobSchedulerRestApiClient.setKeyPass(this.webserviceCredentials.getKeyPassword());
            this.jobSchedulerRestApiClient.setKeystoreType(this.webserviceCredentials.getKeyStoreType());
            this.jobSchedulerRestApiClient.setKeystorePass(this.webserviceCredentials.getKeyStorePassword());
            this.jobSchedulerRestApiClient.setTruststorePass(this.webserviceCredentials.getTrustStorePassword());
            this.jobSchedulerRestApiClient.setTruststoreType(this.webserviceCredentials.getTrustStoreType());
            this.jobSchedulerRestApiClient.setTrustStore(this.webserviceCredentials.getTrustStorePath());
            this.jobSchedulerRestApiClient.setKeyStore(this.webserviceCredentials.getKeyStorePath());
            this.jobSchedulerRestApiClient.setSSLContext();
        }
    }

    protected BigInteger string2BigInteger(String s) {
        try {
            return new BigInteger(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected Integer string2Integer(String s) {
        try {
            return new Integer(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected Date string2Date(String s) {
        Date date;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            date = format.parse(s);
        }
        catch (ParseException e) {
            return null;
        }
        return date;
    }

    protected JsonObject jsonFromString(String jsonObjectStr) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonObjectStr));
        JsonObject object = jsonReader.readObject();
        jsonReader.close();
        return object;
    }

    public void login() throws SOSException, URISyntaxException {
        this.jobSchedulerRestApiClient.addHeader("Content-Type", "application/json");
        this.jobSchedulerRestApiClient.addHeader("Accept", "application/json");
        this.jobSchedulerRestApiClient.addAuthorizationHeader(this.webserviceCredentials.getUserDecodedAccount());
        String answer = this.jobSchedulerRestApiClient.postRestService(new URI(this.webserviceCredentials.getJocUrl() + "/security/login"), "");
        JsonObject login = this.jsonFromString(answer);
        if (login.get((Object)"accessToken") != null) {
            this.accessToken = login.getString("accessToken");
            this.jobSchedulerRestApiClient.addHeader("X-Access-Token", this.accessToken);
        }
    }

    public void login(String xAccessToken) throws SOSException, URISyntaxException {
        if (xAccessToken != null && !xAccessToken.isEmpty()) {
            this.jobSchedulerRestApiClient.addHeader("Content-Type", "application/json");
            this.jobSchedulerRestApiClient.addHeader("Accept", "application/json");
            this.accessToken = xAccessToken;
            this.jobSchedulerRestApiClient.addHeader("X-Access-Token", xAccessToken);
        } else {
            this.login();
        }
    }

    public void setSchedulerId(String schedulerId) {
        this.schedulerId = schedulerId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }
}

