/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.schedulerhistory;

import com.sos.hibernate.classes.DbItem;
import com.sos.hibernate.classes.SOSHibernateIntervalFilter;
import com.sos.hibernate.classes.SOSSearchFilterData;
import com.sos.hibernate.interfaces.ISOSHibernateFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerHistoryFilter
extends SOSHibernateIntervalFilter
implements ISOSHibernateFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerHistoryFilter.class);
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private Date executedFrom;
    private Date executedTo;
    private Date startTime;
    private Date endTime;
    private String schedulerId = "";
    private boolean showWithError = false;
    private boolean showRunning = false;
    private boolean showSuccessfull = false;
    private String executedFromIso = null;
    private String executedToIso = null;
    private boolean showJobs = true;
    private boolean showJobChains = true;
    private SOSSearchFilterData sosSearchFilterData = new SOSSearchFilterData();

    public boolean isShowJobs() {
        return this.showJobs;
    }

    public void setShowJobs(boolean showJobs) {
        this.showJobs = showJobs;
    }

    public boolean isShowJobChains() {
        return this.showJobChains;
    }

    public void setShowJobChains(boolean showJobChains) {
        this.showJobChains = showJobChains;
    }

    public String getExecutedFromIso() {
        return this.executedFromIso;
    }

    public void setExecutedFromIso(String executedFromIso) {
        this.executedFromIso = executedFromIso;
    }

    public String getExecutedToIso() {
        return this.executedToIso;
    }

    public void setExecutedToIso(String executedToIso) {
        this.executedToIso = executedToIso;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Date getExecutedUtcFrom() {
        if (this.executedFrom == null) {
            return null;
        }
        return this.convertFromTimeZoneToUtc(this.executedFrom);
    }

    public void setExecutedFrom(String executedFrom) throws ParseException {
        if ("".equals(executedFrom)) {
            this.executedFrom = null;
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat(this.dateFormat);
            this.setExecutedFrom(formatter.parse(executedFrom));
        }
    }

    public Date getExecutedUtcTo() {
        if (this.executedTo == null) {
            return null;
        }
        return this.convertFromTimeZoneToUtc(this.executedTo);
    }

    public void setExecutedTo(String executedTo) throws ParseException {
        if ("".equals(executedTo)) {
            this.executedTo = null;
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat(this.dateFormat);
            this.setExecutedTo(formatter.parse(executedTo));
        }
    }

    public String getSchedulerId() {
        return this.schedulerId;
    }

    public void setSchedulerId(String schedulerId) {
        this.schedulerId = schedulerId;
    }

    public void setExecutedFrom(Date from) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        String d = formatter.format(from);
        try {
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.executedFrom = formatter.parse(d);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.executedFromIso = formatter.format(from);
    }

    public void setExecutedTo(Date to) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        String d = formatter.format(to);
        try {
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.executedTo = formatter.parse(d);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.executedToIso = formatter.format(to);
    }

    public void setStartTime(Date start) {
        this.startTime = start;
    }

    public void setEndTime(Date end) {
        this.endTime = end;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isFiltered(DbItem h) {
        return false;
    }

    public void setShowWithError(boolean showWithError) {
        this.showWithError = showWithError;
    }

    public boolean isShowWithError() {
        return this.showWithError;
    }

    public void setIntervalFromDate(Date d) {
        this.executedFrom = d;
    }

    public void setIntervalToDate(Date d) {
        this.executedTo = d;
    }

    public void setIntervalFromDateIso(String s) {
        this.executedFromIso = s;
    }

    public void setIntervalToDateIso(String s) {
        this.executedToIso = s;
    }

    public void setShowRunning(boolean showRunning) {
        this.showRunning = showRunning;
    }

    public boolean isShowRunning() {
        return this.showRunning;
    }

    public boolean isShowSuccessfull() {
        return this.showSuccessfull;
    }

    public void setShowSuccessfull(boolean showSuccessfull) {
        this.showSuccessfull = showSuccessfull;
    }

    public SOSSearchFilterData getSosSearchFilterData() {
        return this.sosSearchFilterData;
    }

    public void setSosSearchFilterData(SOSSearchFilterData sosSearchFilterData) {
        this.sosSearchFilterData = sosSearchFilterData;
    }

    public String getTitle() {
        return "";
    }
}

