/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.schedulerhistory;

import com.sos.hibernate.classes.DbItem;
import com.sos.hibernate.classes.SOSHibernateIntervalFilter;
import com.sos.hibernate.interfaces.ISOSHibernateFilter;
import com.sos.jitl.schedulerhistory.db.SchedulerOrderStepHistoryDBItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SchedulerOrderStepHistoryFilter
extends SOSHibernateIntervalFilter
implements ISOSHibernateFilter {
    private Long historyId = null;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private Date executedFrom;
    private Date executedTo;
    private Date startTime;
    private Date endTime;
    private String status = "";
    private String executedFromIso = null;
    private String executedToIso = null;

    public String getExecutedFromIso() {
        return this.executedFromIso;
    }

    public void setExecutedFromIso(String executedFromIso) {
        this.executedFromIso = executedFromIso;
    }

    public String getExecutedToIso() {
        return this.executedToIso;
    }

    public void setExecutedToIso(String executedToIso) {
        this.executedToIso = executedToIso;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Date getExecutedFromUtc() {
        return this.convertFromTimeZoneToUtc(this.executedFrom);
    }

    public void setExecutedFrom(String executedFrom) throws ParseException {
        if ("".equals(executedFrom)) {
            this.executedFrom = null;
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat(this.dateFormat);
            Date d = formatter.parse(executedFrom);
            this.setExecutedFrom(d);
        }
    }

    public Date getExecutedToUtc() {
        return this.convertFromTimeZoneToUtc(this.executedTo);
    }

    public void setExecutedTo(String executedTo) throws ParseException {
        if ("".equals(executedTo)) {
            this.executedTo = null;
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat(this.dateFormat);
            Date d = formatter.parse(executedTo);
            this.setExecutedTo(d);
        }
    }

    public boolean isFiltered(DbItem dbitem) {
        SchedulerOrderStepHistoryDBItem h = (SchedulerOrderStepHistoryDBItem)dbitem;
        return false;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setExecutedFrom(Date from) {
        this.executedFrom = from;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        this.executedFromIso = formatter.format(from);
    }

    public void setExecutedTo(Date to) {
        this.executedTo = to;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        this.executedToIso = formatter.format(to);
    }

    public void setStartTime(Date start) {
        this.startTime = start;
    }

    public void setEndTime(Date end) {
        this.endTime = end;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getTitle() {
        String s = "";
        if (this.executedFrom != null) {
            s = s + String.format("from: %s ", this.date2Iso(this.executedFrom));
        }
        if (this.executedTo != null) {
            s = s + String.format("to: %s ", this.date2Iso(this.executedTo));
        }
        return s;
    }

    public Long getHistoryId() {
        return this.historyId;
    }

    public void setHistoryId(long historyId) {
        this.historyId = historyId;
    }

    public void setIntervalFromDate(Date d) {
        this.executedFrom = d;
    }

    public void setIntervalToDate(Date d) {
        this.executedTo = d;
    }

    public void setIntervalFromDateIso(String s) {
        this.executedFromIso = s;
    }

    public void setIntervalToDateIso(String s) {
        this.executedToIso = s;
    }
}

