/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.schedulerhistory.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.layer.SOSHibernateIntervalDBLayer;
import com.sos.jitl.schedulerhistory.SchedulerOrderHistoryFilter;
import com.sos.jitl.schedulerhistory.db.SchedulerOrderHistoryDBItem;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.TemporalType;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerOrderHistoryDBLayer
extends SOSHibernateIntervalDBLayer<SchedulerOrderHistoryDBItem> {
    protected SchedulerOrderHistoryFilter filter = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerOrderHistoryDBLayer.class);
    private String lastQuery = "";

    public SchedulerOrderHistoryDBLayer(File configurationFile_) throws SOSHibernateException {
        this.setConfigurationFileName(configurationFile_.getAbsolutePath());
        this.createStatelessConnection(configurationFile_.getAbsolutePath());
        this.resetFilter();
    }

    public SchedulerOrderHistoryDBLayer(SOSHibernateSession session) {
        this.setConfigurationFileName(((Path)session.getFactory().getConfigFile().get()).toFile().getAbsolutePath());
        this.sosHibernateSession = session;
        this.resetFilter();
    }

    public SchedulerOrderHistoryDBItem get(Long id) throws SOSHibernateException {
        if (id == null) {
            return null;
        }
        this.createStatelessConnection(this.getConfigurationFileName());
        try {
            return (SchedulerOrderHistoryDBItem)((Object)this.getSession().get(SchedulerOrderHistoryDBItem.class, (Serializable)id));
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    protected String getWhere() {
        String where = "";
        String and = "";
        if (this.filter.getSchedulerOrderHistoryId() != null) {
            where = where + and + " schedulerOrderHistoryId=:schedulerOrderHistoryId";
            and = " and ";
        } else {
            if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
                where = where + and + " spoolerId=:schedulerId";
                and = " and ";
            }
            if (this.filter.getJobchain() != null && !"".equals(this.filter.getJobchain())) {
                where = where + and + " jobChain=:jobChain";
                and = " and ";
            }
            if (this.filter.getOrderid() != null && !"".equals(this.filter.getOrderid())) {
                where = where + and + " orderId=:orderId";
                and = " and ";
            }
            if (this.filter.getStartTime() != null) {
                where = where + and + " startTime>= :startTime";
                and = " and ";
            }
            if (this.filter.getEndTime() != null) {
                where = where + and + " endTime <= :endTime ";
                and = " and ";
            }
            if (!"".equals(where.trim())) {
                where = "where " + where;
            }
        }
        return where;
    }

    protected String getWhereFromTo() {
        String where = "";
        String and = "";
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            where = where + and + " spoolerId=:schedulerId";
            and = " and ";
        }
        if (this.filter.getJobchain() != null && !"".equals(this.filter.getJobchain())) {
            where = this.filter.getJobchain().contains("%") ? where + and + " jobChain like :jobChain" : where + and + " jobChain=:jobChain";
            and = " and ";
        }
        if (this.filter.getOrderid() != null && !"".equals(this.filter.getOrderid())) {
            where = this.filter.getOrderid().contains("%") ? where + and + " orderId like :orderId" : where + and + " orderId=:orderId";
            and = " and ";
        }
        if (!this.filter.isShowJobChains()) {
            where = where + and + " 1=0";
            and = " and ";
        }
        if (this.filter.getExecutedUtcFrom() != null) {
            where = where + and + " startTime>= :startTimeFrom";
            and = " and ";
        }
        if (this.filter.getExecutedUtcTo() != null) {
            where = where + and + " startTime <= :startTimeTo ";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    protected String getWhereFromToStep() {
        String where = "";
        String and = "";
        if (this.filter.getExecutedUtcFrom() != null) {
            where = where + and + " startTime>= :startTimeFrom";
            and = " and ";
        }
        if (this.filter.getExecutedUtcTo() != null) {
            where = where + and + " startTime <= :startTimeTo ";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    public void onAfterDeleting(SchedulerOrderHistoryDBItem h) throws SOSHibernateException {
        String q = "delete from SchedulerOrderStepHistoryDBItem where id.historyId=" + h.getHistoryId();
        Query query = this.sosHibernateSession.createQuery(q);
        int row = this.sosHibernateSession.executeUpdate(query);
        LOGGER.debug(String.format("%s steps deleted", row));
    }

    public int delete() throws SOSHibernateException {
        String q = "delete from SchedulerOrderStepHistoryDBItem e where e.schedulerOrderHistoryDBItem.historyId IN (select historyId from SchedulerOrderHistoryDBItem " + this.getWhereFromTo() + ")";
        Query query = this.sosHibernateSession.createQuery(q);
        if (this.filter.getExecutedUtcFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedUtcFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedUtcTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedUtcTo(), TemporalType.TIMESTAMP);
        }
        int row = query.executeUpdate();
        String hql = "delete from SchedulerOrderHistoryDBItem " + this.getWhereFromTo();
        query = this.sosHibernateSession.createQuery(hql);
        if (this.filter.getExecutedUtcFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedUtcFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedUtcTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedUtcTo(), TemporalType.TIMESTAMP);
        }
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public SchedulerOrderHistoryFilter getFilter() {
        return this.filter;
    }

    public void resetFilter() {
        this.filter = new SchedulerOrderHistoryFilter();
        this.filter.setDateFormat("yyyy-MM-dd HH:mm:ss");
        this.filter.setOrderCriteria("startTime");
        this.filter.setSortMode("desc");
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public List<SchedulerOrderHistoryDBItem> getListOfItemsToDelete() throws SOSHibernateException {
        TimeZone.setDefault(TimeZone.getTimeZone("Etc/UTC"));
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery("from SchedulerOrderHistoryDBItem " + this.getWhereFromTo() + this.filter.getOrderCriteria() + this.filter.getSortMode());
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getExecutedUtcFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedUtcFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedUtcTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedUtcTo(), TemporalType.TIMESTAMP);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public long deleteInterval() throws SOSHibernateException {
        return this.delete();
    }
}

