/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.schedulerhistory.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.schedulerhistory.classes.SOSStreamUnzip;
import java.io.IOException;
import java.nio.file.Path;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="SCHEDULER_ORDER_HISTORY")
public class SchedulerOrderHistoryLogDBItemPostgres
extends DbItem {
    private byte[] log;
    private String spoolerId;
    private Long historyId;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="[HISTORY_ID]", nullable=false)
    public Long getHistoryId() {
        return this.historyId;
    }

    @Column(name="[HISTORY_ID]", nullable=false)
    public void setHistoryId(Long id) {
        this.historyId = id;
    }

    @Column(name="[SPOOLER_ID]", nullable=false)
    public String getSpoolerId() {
        return this.spoolerId;
    }

    @Column(name="[SPOOLER_ID]", nullable=false)
    public void setSpoolerId(String spoolerId) {
        this.spoolerId = spoolerId;
    }

    @Column(name="[LOG]", nullable=true)
    public byte[] getLog() {
        return this.log;
    }

    @Column(name="[LOG]", nullable=true)
    public void setLog(byte[] log) {
        this.log = log;
    }

    @Transient
    public String getLogAsString() throws IOException {
        if (this.log == null) {
            return null;
        }
        return SOSStreamUnzip.unzip2String(this.log);
    }

    @Transient
    public byte[] getLogAsByteArray() throws IOException {
        if (this.log == null) {
            return null;
        }
        return SOSStreamUnzip.unzip(this.log);
    }

    @Transient
    public Path writeLogFile(String prefix) throws IOException {
        if (this.log == null) {
            return null;
        }
        return SOSStreamUnzip.unzipToFile(this.log, prefix);
    }

    @Transient
    public Path writeGzipLogFile(String prefix) throws IOException {
        if (this.log == null) {
            return null;
        }
        return SOSStreamUnzip.zippedToFile(this.log, prefix);
    }

    @Transient
    public String getSchedulerId() {
        return this.getSpoolerId();
    }
}

