/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.schedulerhistory.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.schedulerhistory.db.SchedulerOrderHistoryDBItem;
import com.sos.jitl.schedulerhistory.db.SchedulerOrderStepHistoryCompoundKey;
import com.sos.jitl.schedulerhistory.db.SchedulerTaskHistoryDBItem;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="SCHEDULER_ORDER_STEP_HISTORY")
public class SchedulerOrderStepHistoryDBItem
extends DbItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SchedulerOrderStepHistoryCompoundKey id;
    private Long taskId;
    private String state;
    private Date startTime;
    private Date endTime;
    private Boolean error;
    private String errorText;
    private String errorCode;
    private SchedulerOrderHistoryDBItem schedulerOrderHistoryDBItem;
    private SchedulerTaskHistoryDBItem schedulerTaskHistoryDBItem;

    @ManyToOne(optional=true)
    @JoinColumn(name="`HISTORY_ID`", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    public SchedulerOrderHistoryDBItem getSchedulerOrderHistoryDBItem() {
        return this.schedulerOrderHistoryDBItem;
    }

    public void setSchedulerOrderHistoryDBItem(SchedulerOrderHistoryDBItem schedulerOrderHistoryDBItem) {
        this.schedulerOrderHistoryDBItem = schedulerOrderHistoryDBItem;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="`TASK_ID`", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    public SchedulerTaskHistoryDBItem getSchedulerTaskHistoryDBItem() {
        return this.schedulerTaskHistoryDBItem;
    }

    public void setSchedulerTaskHistoryDBItem(SchedulerTaskHistoryDBItem schedulerTaskHistoryDBItem) {
        this.schedulerTaskHistoryDBItem = schedulerTaskHistoryDBItem;
    }

    @Id
    public SchedulerOrderStepHistoryCompoundKey getId() {
        return this.id;
    }

    public void setId(SchedulerOrderStepHistoryCompoundKey id) {
        this.id = id;
    }

    @Column(name="[TASK_ID]", nullable=false)
    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    @Column(name="[TASK_ID]", nullable=false)
    public Long getTaskId() {
        return this.taskId;
    }

    @Column(name="[STATE]", nullable=true)
    public void setState(String state) {
        this.state = state;
    }

    @Column(name="[STATE]", nullable=true)
    public String getState() {
        return this.state;
    }

    @Column(name="[START_TIME]", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getStartTime() {
        return this.startTime;
    }

    @Column(name="[START_TIME]", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Column(name="[END_TIME]", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getEndTime() {
        return this.endTime;
    }

    @Column(name="[END_TIME]", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Column(name="[ERROR]", nullable=true)
    public Boolean isError() {
        return this.error;
    }

    @Column(name="[ERROR]", nullable=true)
    public void setError(Boolean error) {
        this.error = error;
    }

    @Column(name="[ERROR_CODE]", nullable=true)
    public String getErrorCode() {
        return this.errorCode;
    }

    @Column(name="[ERROR_CODE]", nullable=true)
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Column(name="[ERROR_TEXT]", nullable=true)
    public String getErrorText() {
        return this.errorText;
    }

    @Column(name="[ERROR_TEXT]", nullable=true)
    public void setErrorText(String errorText) {
        this.errorText = errorText;
    }

    @Transient
    public String getStartTimeIso() {
        if (this.getStartTime() == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return formatter.format(this.getStartTime());
    }

    @Transient
    public String getEndTimeIso() {
        if (this.getEndTime() == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return formatter.format(this.getEndTime());
    }

    @Transient
    public String getStartTimeFormated() {
        return this.getDateFormatted(this.getStartTime());
    }

    @Transient
    public String getEndTimeFormated() {
        return this.getDateFormatted(this.getEndTime());
    }

    @Transient
    public String getDurationFormated() {
        return this.getDateDiff(this.getStartTime(), this.getEndTime());
    }

    @Transient
    public String getExecResult() {
        if (this.schedulerTaskHistoryDBItem == null) {
            return "";
        }
        return String.valueOf(this.schedulerTaskHistoryDBItem.getExecResult());
    }

    @Transient
    public boolean haveError() {
        if (this.schedulerTaskHistoryDBItem == null) {
            return false;
        }
        return this.schedulerTaskHistoryDBItem.haveError();
    }

    @Transient
    public Long getLogId() {
        return this.getTaskId();
    }

    @Transient
    public boolean isStandalone() {
        return true;
    }

    @Transient
    public String getTitle() {
        if (this.schedulerOrderHistoryDBItem == null) {
            return String.format("%s:%s (%s)", this.getState(), "", "");
        }
        return String.format("%s:%s (%s)", this.getState(), this.schedulerOrderHistoryDBItem.getJobChain(), this.schedulerOrderHistoryDBItem.getOrderId());
    }

    @Transient
    public String getIdentifier() {
        return this.getTitle() + this.getLogId().toString();
    }
}

