/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.schedulerhistory.db;

import com.sos.jitl.schedulerhistory.db.SchedulerHistoryLogDBItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="SCHEDULER_HISTORY")
public class SchedulerTaskHistoryDBItem
extends SchedulerHistoryLogDBItem {
    private Long id;
    private String spoolerId;
    private String clusterMemberId;
    private String jobName;
    private Date startTime;
    private Date endTime;
    private String cause;
    private Integer steps;
    private Integer exitCode;
    private Boolean error;
    private String errorText;
    private String errorCode;
    private Integer pid;
    private String agentUrl;
    private String transferHistory;
    private boolean assignToDaysScheduler = false;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="[ID]")
    public Long getId() {
        return this.id;
    }

    @Column(name="[ID]")
    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="[SPOOLER_ID]")
    public String getSpoolerId() {
        return this.spoolerId;
    }

    @Column(name="[SPOOLER_ID]")
    public void setSpoolerId(String spoolerId) {
        this.spoolerId = spoolerId;
    }

    @Column(name="[CLUSTER_MEMBER_ID]", nullable=true)
    public String getClusterMemberId() {
        return this.clusterMemberId;
    }

    @Column(name="[CLUSTER_MEMBER_ID]", nullable=true)
    public void setClusterMemberId(String clusterMemberId) {
        this.clusterMemberId = clusterMemberId;
    }

    @Column(name="[JOB_NAME]")
    public String getJobName() {
        return this.jobName;
    }

    @Column(name="[JOB_NAME]")
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Column(name="[START_TIME]", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getStartTime() {
        return this.startTime;
    }

    @Column(name="[START_TIME]", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Column(name="[END_TIME]", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getEndTime() {
        return this.endTime;
    }

    @Column(name="[END_TIME]", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Column(name="[CAUSE]", nullable=true)
    public String getCause() {
        return this.cause;
    }

    @Column(name="[CAUSE]", nullable=true)
    public void setCause(String cause) {
        this.cause = cause;
    }

    @Column(name="[STEPS]", nullable=true)
    public Integer getSteps() {
        return this.steps;
    }

    @Column(name="[STEPS]", nullable=true)
    public void setSteps(Integer steps) {
        this.steps = steps;
    }

    @Column(name="[EXIT_CODE]", nullable=true)
    public Integer getExitCode() {
        if (this.exitCode == null) {
            return 0;
        }
        return this.exitCode;
    }

    @Column(name="[EXIT_CODE]", nullable=true)
    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    @Column(name="[ERROR]", nullable=true)
    public Boolean isError() {
        return this.error;
    }

    @Column(name="[ERROR]", nullable=true)
    public void setError(Boolean error) {
        this.error = error;
    }

    @Column(name="[ERROR_CODE]", nullable=true)
    public String getErrorCode() {
        return this.errorCode;
    }

    @Column(name="[ERROR_CODE]", nullable=true)
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Column(name="[ERROR_TEXT]", nullable=true)
    public String getErrorText() {
        return this.errorText;
    }

    @Column(name="[ERROR_TEXT]", nullable=true)
    public void setErrorText(String errorText) {
        this.errorText = errorText;
    }

    @Column(name="[PID]")
    public Integer getPid() {
        return this.pid;
    }

    @Column(name="[PID]")
    public void setPid(Integer pid) {
        this.pid = pid;
    }

    @Column(name="[AGENT_URL]", nullable=true)
    public String getAgentUrl() {
        return this.agentUrl;
    }

    @Column(name="[AGENT_URL]", nullable=true)
    public void setAgentUrl(String val) {
        this.agentUrl = val;
    }

    @Column(name="[TRANSFER_HISTORY]", nullable=true)
    public String getTransferHistory() {
        return this.transferHistory;
    }

    @Column(name="[TRANSFER_HISTORY]", nullable=true)
    public void setTransferHistory(String val) {
        this.transferHistory = val;
    }

    @Transient
    public String getStartTimeIso() {
        if (this.getStartTime() == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return formatter.format(this.getStartTime());
    }

    @Transient
    public String getEndTimeIso() {
        if (this.getEndTime() == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return formatter.format(this.getEndTime());
    }

    @Transient
    public String getDurationFormated() {
        return this.getDateDiff(this.getStartTime(), this.getEndTime());
    }

    @Transient
    public String getJobOrJobchain() {
        return this.null2Blank(this.getJob());
    }

    @Transient
    public boolean isAssignToDaysScheduler() {
        return this.assignToDaysScheduler;
    }

    @Transient
    public void setAssignToDaysScheduler(boolean assignToDaysScheduler) {
        this.assignToDaysScheduler = assignToDaysScheduler;
    }

    @Transient
    public Long getLogId() {
        return this.getId();
    }

    @Transient
    public String getTitle() {
        return this.getJobName();
    }

    @Transient
    public boolean isStandalone() {
        return true;
    }

    @Transient
    public String getIdentifier() {
        return this.getTitle() + this.getLogId().toString();
    }

    @Transient
    public String getSchedulerId() {
        return this.getSpoolerId();
    }

    @Transient
    public String getJob() {
        return this.getJobName();
    }

    @Transient
    public String getStartTimeFormated() {
        return this.getDateFormatted(this.getStartTime());
    }

    @Transient
    public String getEndTimeFormated() {
        return this.getDateFormatted(this.getEndTime());
    }

    @Transient
    public String getExecResult() {
        return String.valueOf(this.getExitCode());
    }

    @Transient
    public boolean haveError() {
        return this.getExitCode() != 0;
    }

    @Transient
    public boolean equals(Object h) {
        return ((SchedulerTaskHistoryDBItem)((Object)h)).getJobName().equals(this.getJobName());
    }

    @Transient
    public int hashCode() {
        return this.id.intValue();
    }
}

