/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.sync;

import com.sos.jitl.sync.SyncNode;
import com.sos.jitl.sync.SyncNodeList;
import com.sos.jitl.sync.SyncNodeWaitingOrder;
import com.sos.jitl.sync.SyncXmlReader;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncNodeContainer {
    private static final String JOBCHAIN_STATE_RUNNING = "running";
    private static final String ATTRIBUTE_SUSPENDED = "suspended";
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncNodeContainer.class);
    private static final String XPATH_CURRENT_JOB_CHAIN = "//order[@id = '%s'][@job_chain = '%s']/payload/params/param[@name='sync_session_id']";
    private static final String XPATH_CURRENT_JOB_CHAIN_CONTEXT = "//order[@id = '%s'][@job_chain = '%s']/payload/params/param[@name='job_chain_name2synchronize']";
    private static final String XPATH_CURRENT_JOB_CHAIN_STATE_CONTEXT = "//order[@id = '%s'][@job_chain = '%s']/payload/params/param[@name='job_chain_state2synchronize']";
    private static final String ATTRIBUTE_PARAMETER_VALUE = "value";
    private static final String ATTRIBUTE_JOB_CHAIN = "job_chain";
    private static final String ATTRIBUTE_ORDER_ID = "id";
    private static final String ATTRIBUTE_STATE = "state";
    private static final String ATTRIBUTE_END_STATE = "end_state";
    private static final String XPATH_FOR_ORDERS = "//order_queue/order";
    private static final String XPATH_FOR_ORDERS_JOB_CHAIN = "//order_queue/order[@job_chain = '%s']";
    private static final String XPATH_FOR_ORDERS_JOB_CHAIN_STATE = "//order_queue/order[@job_chain = '%s' and @state = '%s']";
    private static final String XPATH_FOR_ALL_JOB_CHAINS = "//job_chains/job_chain/job_chain_node[@job = '%s']";
    private static final String XPATH_FOR_ONE_JOB_CHAIN = "//job_chains/job_chain[@path = '%s']/job_chain_node[@job = '%s']";
    private static final String XPATH_FOR_ONE_JOB_CHAIN_STATE = "//job_chains/job_chain[@path = '%s']/job_chain_node[@job = '%s' and @state='%s']";
    private String jobpath;
    private String syncNodeContext = "";
    private String syncNodeContextJobChain = "";
    private String syncNodeContextState = "";
    private boolean ignoreStoppedJobChains = false;
    private SyncNodeList listOfSyncNodes;

    public void getNodes(String xml) throws Exception {
        this.listOfSyncNodes = new SyncNodeList();
        SyncXmlReader xmlReader = null;
        if ("".equals(this.syncNodeContext)) {
            LOGGER.debug("looking for sync nodes in all jobchains");
            xmlReader = new SyncXmlReader(xml, String.format(XPATH_FOR_ALL_JOB_CHAINS, this.jobpath));
        } else if ("".equals(this.syncNodeContextState)) {
            LOGGER.debug(String.format("looking for sync nodes in jobchain: %s", this.syncNodeContextJobChain));
            LOGGER.debug(String.format(XPATH_FOR_ONE_JOB_CHAIN, this.syncNodeContextJobChain, this.jobpath));
            xmlReader = new SyncXmlReader(xml, String.format(XPATH_FOR_ONE_JOB_CHAIN, this.syncNodeContextJobChain, this.jobpath));
        } else {
            LOGGER.debug(String.format("looking for sync node in jobchain: %s in state %s", this.syncNodeContextJobChain, this.syncNodeContextState));
            LOGGER.debug(String.format(XPATH_FOR_ONE_JOB_CHAIN_STATE, this.syncNodeContextJobChain, this.jobpath, this.syncNodeContextState));
            xmlReader = new SyncXmlReader(xml, String.format(XPATH_FOR_ONE_JOB_CHAIN_STATE, this.syncNodeContextJobChain, this.jobpath, this.syncNodeContextState));
        }
        while (!xmlReader.eof()) {
            LOGGER.debug("reading next node");
            xmlReader.getNext();
            if (!this.ignoreStoppedJobChains || JOBCHAIN_STATE_RUNNING.equals(xmlReader.getAttributeValueFromParent(ATTRIBUTE_STATE))) {
                SyncNode sn = new SyncNode();
                sn.setSyncNodeJobchainName(xmlReader.getAttributeValueFromParent("name"));
                sn.setSyncNodeJobchainPath(xmlReader.getAttributeValueFromParent("path"));
                sn.setSyncNodeState(xmlReader.getAttributeValue(ATTRIBUTE_STATE));
                LOGGER.debug(String.format("adding node chain: %s state: %s", sn.getSyncNodeJobchainPath(), sn.getSyncNodeState()));
                this.listOfSyncNodes.addNode(sn);
                continue;
            }
            LOGGER.debug(String.format("%s will be ignored. Job-chain is stopped", xmlReader.getAttributeValueFromParent("path")));
        }
    }

    public void getOrders(String jobChain, String orderId, String syncId, String xml) throws Exception {
        LOGGER.debug("xml in getOrders = " + xml);
        SyncXmlReader xmlReader = null;
        if ("".equals(this.syncNodeContext)) {
            LOGGER.debug("looking for waiting orders in all jobchains");
            xmlReader = new SyncXmlReader(xml, XPATH_FOR_ORDERS);
        } else if ("".equals(this.syncNodeContextState)) {
            LOGGER.debug(String.format("looking for waiting order in jobchain: %s", this.syncNodeContextJobChain));
            LOGGER.debug(String.format(XPATH_FOR_ORDERS_JOB_CHAIN, this.syncNodeContextJobChain));
            xmlReader = new SyncXmlReader(xml, String.format(XPATH_FOR_ORDERS_JOB_CHAIN, this.syncNodeContextJobChain));
        } else {
            LOGGER.debug(String.format("looking for waiting orders in jobchain: %s in state %s", this.syncNodeContextJobChain, this.syncNodeContextState));
            LOGGER.debug(String.format(XPATH_FOR_ORDERS_JOB_CHAIN_STATE, this.syncNodeContextJobChain, this.syncNodeContextState));
            xmlReader = new SyncXmlReader(xml, String.format(XPATH_FOR_ORDERS_JOB_CHAIN_STATE, this.syncNodeContextJobChain, this.syncNodeContextState));
        }
        while (!xmlReader.eof()) {
            xmlReader.getNext();
            String id = xmlReader.getAttributeValue(ATTRIBUTE_ORDER_ID);
            String chain = xmlReader.getAttributeValue(ATTRIBUTE_JOB_CHAIN);
            String state = xmlReader.getAttributeValue(ATTRIBUTE_STATE);
            String orderSyncId = xmlReader.getAttributeValueFromXpath(String.format(XPATH_CURRENT_JOB_CHAIN, id, chain), ATTRIBUTE_PARAMETER_VALUE);
            boolean isSuspended = false;
            if (xmlReader.getAttributeValue(ATTRIBUTE_SUSPENDED) != null && !xmlReader.getAttributeValue(ATTRIBUTE_SUSPENDED).isEmpty()) {
                isSuspended = "yes".equals(xmlReader.getAttributeValue(ATTRIBUTE_SUSPENDED)) || "1".equals(xmlReader.getAttributeValue(ATTRIBUTE_SUSPENDED)) || "true".equals(xmlReader.getAttributeValue(ATTRIBUTE_SUSPENDED));
            }
            String orderContextJobchain = xmlReader.getAttributeValueFromXpath(String.format(XPATH_CURRENT_JOB_CHAIN_CONTEXT, id, chain), ATTRIBUTE_PARAMETER_VALUE);
            String orderContextJobchainState = xmlReader.getAttributeValueFromXpath(String.format(XPATH_CURRENT_JOB_CHAIN_STATE_CONTEXT, id, chain), ATTRIBUTE_PARAMETER_VALUE);
            orderContextJobchain = this.normalizeContext(orderContextJobchain);
            LOGGER.debug(String.format("have the order: %s,chain: %s state: %s isSuspended: %s for order %s", id, chain, state, isSuspended, jobChain + "(" + orderId + ")"));
            LOGGER.debug(String.format("orderContextJobchain: %s,%s --- syncNodeContext: %s", orderContextJobchain, orderContextJobchainState, this.syncNodeContext));
            LOGGER.debug(String.format("syncId: %s --- OrderSyncId: %s", syncId, orderSyncId));
            if (!isSuspended && (!chain.equals(jobChain) || !orderId.equals(id)) || !"".equals(this.syncNodeContext) && (!orderContextJobchain.equals(this.syncNodeContextJobChain) || !this.syncNodeContextState.isEmpty() && !orderContextJobchainState.equals(this.syncNodeContextState)) || syncId != null && !syncId.isEmpty() && !syncId.equals(orderSyncId)) continue;
            LOGGER.debug("...adding");
            SyncNodeWaitingOrder o = new SyncNodeWaitingOrder(id, orderSyncId);
            o.setEndState(xmlReader.getAttributeValue(ATTRIBUTE_END_STATE));
            LOGGER.debug(String.format("...Adding waiting order %s", id));
            this.listOfSyncNodes.addOrder(o, chain, state);
        }
    }

    public void setJobpath(String jobpath) {
        this.jobpath = jobpath;
    }

    public SyncNodeList getListOfSyncNodes() {
        return this.listOfSyncNodes;
    }

    public SyncNode getNode(String jobChain, String state) {
        return this.listOfSyncNodes.getNode(jobChain, state);
    }

    public SyncNode getFirstNotReleasedNode() {
        return this.listOfSyncNodes.getFirstNotReleasedNode();
    }

    public int getNumberOfWaitingNodes() {
        return this.listOfSyncNodes.getNumberOfWaitingNodes();
    }

    public boolean isReleased() {
        return this.listOfSyncNodes.isReleased();
    }

    public void setRequiredOrders(HashMap<String, String> schedulerParameters) {
        Iterator<String> ii = schedulerParameters.keySet().iterator();
        if (schedulerParameters.get("required_orders") != null) {
            String requiredOrders = schedulerParameters.get("required_orders");
            try {
                this.listOfSyncNodes.setRequired(Integer.parseInt(requiredOrders));
            }
            catch (NumberFormatException e) {
                LOGGER.warn(String.format("Could not convert %s to int", requiredOrders));
            }
        }
        while (ii.hasNext()) {
            String key = ii.next();
            if (!key.contains("_required_orders")) continue;
            LOGGER.debug(String.format("key = %s, setting %s", key, key + schedulerParameters.get(key)));
            this.listOfSyncNodes.setRequired(key + schedulerParameters.get(key));
        }
    }

    public boolean eof() {
        return this.getListOfSyncNodes().eof();
    }

    public SyncNode getNextSyncNode() {
        return this.getListOfSyncNodes().getNextSyncNode();
    }

    private String normalizeContext(String s) {
        if (!(s = s.trim()).startsWith("/") && !s.isEmpty()) {
            s = "/" + s;
        }
        return s;
    }

    public void setSyncNodeContext(String job_chain_path, String job_chain_state) {
        this.syncNodeContext = this.normalizeContext(job_chain_path);
        this.syncNodeContext = this.normalizeContext(job_chain_path);
        if (!job_chain_state.isEmpty()) {
            this.syncNodeContext = this.syncNodeContext + "," + job_chain_state;
        }
        this.syncNodeContextJobChain = this.normalizeContext(job_chain_path);
        this.syncNodeContextState = job_chain_state;
    }

    public String getShortSyncNodeContext() {
        String s = this.syncNodeContext;
        if (!"".equals(this.syncNodeContext)) {
            File f = new File(this.syncNodeContext);
            if (!this.syncNodeContext.equals(f.getName())) {
                s = "..." + f.getName();
            }
            s = s + ":";
        }
        return s;
    }

    public void setIgnoreStoppedJobChains(boolean ignoreStoppedJobChains) {
        this.ignoreStoppedJobChains = ignoreStoppedJobChains;
    }
}

