/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.sync;

import com.sos.jitl.sync.SyncNode;
import com.sos.jitl.sync.SyncNodeWaitingOrder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncNodeList {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncNodeList.class);
    private List<SyncNode> listOfNodes = new ArrayList<SyncNode>();
    private int nodeIndex = 0;
    private int numberOfWaitingNodes = -1;
    public static final String CHAIN_ORDER_DELIMITER = ",";
    public static final String CONST_PARAM_REQUIRED_ORDERS = "required_orders";
    public static final String CONST_PARAM_PART_REQUIRED_ORDERS = "_required_orders";

    public void addNode(SyncNode sn) {
        if (this.listOfNodes == null) {
            this.listOfNodes = new ArrayList<SyncNode>();
        }
        this.listOfNodes.add(sn);
    }

    public SyncNode getNode(String jobChain, String state) {
        for (SyncNode sn : this.listOfNodes) {
            if (!sn.getSyncNodeState().equals(state) || !sn.getSyncNodeJobchain().equals(jobChain)) continue;
            return sn;
        }
        return null;
    }

    public boolean isReleased() {
        boolean erg = true;
        for (SyncNode sn : this.listOfNodes) {
            erg = erg && sn.isReleased();
        }
        return erg;
    }

    public SyncNode getFirstNotReleasedNode() {
        SyncNode snResult = null;
        this.numberOfWaitingNodes = 0;
        for (SyncNode sn : this.listOfNodes) {
            if (sn.isReleased()) continue;
            ++this.numberOfWaitingNodes;
            if (snResult != null) continue;
            snResult = sn;
        }
        return snResult;
    }

    public int getCount() {
        return this.listOfNodes.size();
    }

    public void setRequired(String job_chain_required) {
        LOGGER.debug("checking " + job_chain_required);
        for (SyncNode sn : this.listOfNodes) {
            String prefix = sn.getSyncNodeJobchain();
            LOGGER.debug(String.format("Prefix=%s, job_chain_required=%s", prefix, job_chain_required));
            if (job_chain_required.startsWith(prefix + CONST_PARAM_PART_REQUIRED_ORDERS)) {
                sn.setRequired(this.getRequiredFromPrefix(prefix, job_chain_required));
                LOGGER.debug(String.format("--> %s", this.getRequiredFromPrefix(prefix, job_chain_required)));
            }
            prefix = prefix + CHAIN_ORDER_DELIMITER + sn.getSyncNodeState();
            LOGGER.debug(String.format("Prefix=%s, job_chain_required=%s", prefix, job_chain_required));
            if (!job_chain_required.startsWith(prefix + CONST_PARAM_PART_REQUIRED_ORDERS)) continue;
            sn.setRequired(this.getRequiredFromPrefix(prefix, job_chain_required));
            LOGGER.debug(String.format("--> %s", this.getRequiredFromPrefix(prefix, job_chain_required)));
        }
    }

    public String getRequiredFromPrefix(String jobchain_name, String jobchain_required) {
        return jobchain_required.replaceAll("^" + jobchain_name + CONST_PARAM_PART_REQUIRED_ORDERS + "_?", "");
    }

    public void setRequired(int required) {
        for (SyncNode sn : this.listOfNodes) {
            if (sn.getClass() == null) continue;
            sn.setRequired(required);
        }
    }

    public void addOrder(SyncNodeWaitingOrder order, String jobchain, String state) {
        LOGGER.debug(String.format("Adding order: %s.%s", jobchain, order.getId()));
        for (SyncNode sn : this.listOfNodes) {
            if (!sn.getSyncNodeState().equals(state) || !sn.getSyncNodeJobchainPath().equals(jobchain)) continue;
            LOGGER.debug("---->" + sn.getSyncNodeJobchainPath() + ":" + sn.getSyncNodeState());
            sn.addOrder(order);
        }
    }

    public List<SyncNode> getListOfNodes() {
        return this.listOfNodes;
    }

    public boolean eof() {
        return this.nodeIndex >= this.getCount();
    }

    public SyncNode getNextSyncNode() {
        SyncNode sn = this.getListOfNodes().get(this.nodeIndex);
        ++this.nodeIndex;
        return sn;
    }

    public int getNumberOfWaitingNodes() {
        if (this.numberOfWaitingNodes == -1) {
            this.getFirstNotReleasedNode();
        }
        return this.numberOfWaitingNodes;
    }
}

